#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "textrsc.h"

#include <QDebug>
#include <QTextCodec>

int RandomNumber(int min, int max)
{
    return min + (int)(qrand() * (max - min + 1.0) / (1.0 + RAND_MAX));
}

int GenerateRandomNumbers(int *data, int len)
{
    int i, j, rnd;
    int tmp;

    QTime midnight(0,0,0);
    qsrand(midnight.secsTo(QTime::currentTime()));

    j = len - 1;
    for (i = 0; i < (len - 1); i++, j--) {
        rnd = RandomNumber(0, j);
        tmp = data[j];
        data[j] = data[rnd];
        data[rnd] = tmp;
    }
    return i;
}


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

//    QTextCodec::setCodecForTr(QTextCodec::codecForLocale());
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8")); // source codec is UTF-8

    ui->Slct_Mode->addItem(tr("自動"));
    ui->Slct_Mode->addItem(tr("手動"));

    ui->Slct_FudaMuki->addItem(tr("標準"));
    ui->Slct_FudaMuki->addItem(tr("逆"));
    ui->Slct_FudaMuki->addItem(tr("ランダム"));
    ui->label_5->setEnabled(false);

//    qDebug() << QCoreApplication::applicationDirPath();
//    qDebug() << QCoreApplication::applicationFilePath();
    AppPath = QCoreApplication::applicationDirPath();

    pixmapItem = NULL;

    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(TimeoutDone()));

    retryOK = false;
    execflag = false;
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::UpdateFuda()
{
    // Image View from Imgfile
    QString Imgfilepath;
//    Imgfilepath = AppPath + "/FUDA/" + QString("FUDA_%1.bmp").arg((fuda[fudaindex])+1, 3, 10, QChar('0'));
    Imgfilepath = ":/images/FUDA/" + QString("FUDA_%1.png").arg((fuda[fudaindex])+1, 3, 10, QChar('0'));
    // Display Image to GraphicsView
    pixmap.load(Imgfilepath);
    if (NULL==pixmapItem) {
        pixmapItem = scene.addPixmap(pixmap);
    } else {
        pixmapItem->setPixmap( pixmap );
    }
    ui->gView_Fuda->resetTransform(); // 向きを戻す
    if (muki == 1) {
        ui->gView_Fuda->rotate(180);
    } else if (muki == 2) {
        // random muki
        if (fuda[RandomNumber(0,99)] % 2) {
            ui->gView_Fuda->rotate(180);
        }
    }
    ui->gView_Fuda->setScene(&scene);
    ui->LineEdit_State->setText(QString("%1 / %2").arg(fudaindex + 1).arg(maisu));
    if (ui->checkBox_DispKaminoku->checkState()) {
        ui->TextEdit_Kaminoku->setPlainText(tr(kaminoku[fuda[fudaindex]]));
    }
}

void MainWindow::EndingFuda()
{
    if (NULL!=pixmapItem) {
        scene.removeItem(pixmapItem);
        pixmapItem = NULL;
    }
    ui->TextEdit_Kaminoku->setPlainText(tr(""));

    ui->Btn_Start->setEnabled(true);
    ui->Btn_Stop->setEnabled(false);

    ui->Slct_Mode->setEnabled(true);
    ui->Num_Count->setEnabled(true);
    ui->Num_WaitTime->setEnabled(true);
    ui->Slct_FudaMuki->setEnabled(true);
    if (retryOK) {
        ui->Btn_Restart->setEnabled(true);
    }
}

void MainWindow::TimeoutDone()
{
    if (execflag) {
        UpdateFuda();
        fudaindex++;
        if (fudaindex >= maisu) {
            if (mode == 0) timer->stop();
            execflag = false;
            EndingFuda();
        }
    }
}

void MainWindow::on_Btn_Start_clicked()
{
//    int mode; // モード自動(0)/手動(1)
//    int maisu; // 枚数
//    int waittime; // 待ち時間
//    int muki;   // 札の向き 0=普通, 1=逆, 2=ランダム

    if (execflag) return; // すでに実行中

    ui->Btn_Start->setEnabled(false);
    ui->Btn_Restart->setEnabled(false);
    ui->Btn_Stop->setEnabled(true);

    ui->Slct_Mode->setEnabled(false);
    ui->Num_Count->setEnabled(false);
    ui->Num_WaitTime->setEnabled(false);
    ui->Slct_FudaMuki->setEnabled(false);

    // Get Parameter from Panel Widget
    mode = ui->Slct_Mode->currentIndex();
    maisu = ui->Num_Count->value();
    waittime = (int)(ui->Num_WaitTime->value() * 1000);
    muki = ui->Slct_FudaMuki->currentIndex();
    QString msg = QString("mode is %1, maisu is %2, waittime is %3, muki is %4").arg(mode).arg(maisu).arg(waittime).arg(muki);
    qDebug() << msg;

    // Generate Random Datas
    for (int i = 0; i < 100; i++) {
        fuda[i] = i;
    }
    GenerateRandomNumbers(&fuda[0], 100);

    retryOK = true; // もう一度が有効になった(データができたから）

    execflag = true;
    fudaindex = 0;

    // Update FudaImage
    this->UpdateFuda();
    fudaindex++;
    if (fudaindex >= maisu) {
//        if (mode == 0) timer->stop();
        execflag = false;
        EndingFuda();
    } else {
        if (mode == 0) timer->start(waittime);
    }
}

void MainWindow::on_Btn_Restart_clicked()
{
    if (execflag) return; // すでに実行中

    ui->Btn_Start->setEnabled(false);
    ui->Btn_Restart->setEnabled(false);
    ui->Btn_Stop->setEnabled(true);

    ui->Slct_Mode->setEnabled(false);
    ui->Num_Count->setEnabled(false);
    ui->Num_WaitTime->setEnabled(false);
    ui->Slct_FudaMuki->setEnabled(false);

    // Get Parameter from Panel Widget
    mode = ui->Slct_Mode->currentIndex();
    maisu = ui->Num_Count->value();
    waittime = (int)(ui->Num_WaitTime->value() * 1000 + 1);
    muki = ui->Slct_FudaMuki->currentIndex();
    QString msg = QString("mode is %1, maisu is %2, waittime is %3, muki is %4").arg(mode).arg(maisu).arg(waittime).arg(muki);
    qDebug() << msg;

    execflag = true;
    fudaindex = 0;

    this->UpdateFuda();
    fudaindex++;
    if (fudaindex >= maisu) {
//        if (mode == 0) timer->stop();
        execflag = false;
        EndingFuda();
    } else {
        if (mode == 0) timer->start(waittime);
    }
}

void MainWindow::on_Btn_Stop_clicked()
{
    if (execflag) {
        EndingFuda();
        if (mode == 0) timer->stop();
        execflag = false;
    }
}

void MainWindow::on_Slct_Mode_currentIndexChanged(int index)
{
//    QString msg = QString("Mode index is %1").arg(index);
//    qDebug() << msg;

    if (index) {
        ui->Btn_Fuda->setEnabled(true);
        ui->label_5->setEnabled(true);
    } else {
        ui->Btn_Fuda->setEnabled(false);
        ui->label_5->setEnabled(false);
    }
}

void MainWindow::on_Slct_FudaMuki_currentIndexChanged(int index)
{
//    QString msg = QString("FudaMuki index is %1").arg(index);
//    qDebug() << msg;
    ;
}

void MainWindow::on_actionExit_triggered()
{
    close();
}

void MainWindow::on_actionAbout_triggered()
{
    QMessageBox::about(this, "About", tr("流しの練習 v0.2"));
}

void MainWindow::on_actionAbout_Qt_triggered()
{
    QApplication::aboutQt();
}

void MainWindow::on_Btn_Fuda_clicked()
{
    // Update FudaImage
    if (execflag && mode == 1) {
        fudaindex++;
        if (fudaindex >= maisu) {
//            if (mode == 0) timer->stop();
            execflag = false;
            EndingFuda();
        } else {
            UpdateFuda();
        }
    }
}

void MainWindow::on_checkBox_DispKaminoku_stateChanged(int chk)
{
    if (chk) {
        ui->TextEdit_Kaminoku->setEnabled(true);
    } else {
        ui->TextEdit_Kaminoku->setEnabled(false);
        ui->TextEdit_Kaminoku->setPlainText(tr(""));
    }
}

// eof
