#include <QDebug>

#include "daqthread.h"

#define DAQmxErrChk(functionCall) if( DAQmxFailed(error=(functionCall)) ) goto Error; else

DAQThread::DAQThread(QObject *parent) :
    QThread(parent)
{
    stopped = false;

    // cannot Init (create) DAQmxTask, when Constructer
}

DAQThread::~DAQThread()
{
    ;
}

void DAQThread::stop()
{
    stopped = true;
}

void DAQThread::run()
{
    int32       error = 0;
    char        errBuff[2048] = { '\0' };
    char        devname[128] = "Dev1/ai0";

    taskHandle = 0;

    /*********************************************/
    // DAQmx Configure Code
    /*********************************************/
    DAQmxErrChk (DAQmxBaseCreateTask("", &taskHandle));
    DAQmxErrChk (DAQmxBaseCreateAIVoltageChan(taskHandle, devname, "", DAQmx_Val_RSE,-10.0,10.0,DAQmx_Val_Volts,NULL));
//    DAQmxErrChk (DAQmxBaseCreateAIVoltageChan(taskHandle,"Dev1/ai0","",DAQmx_Val_Cfg_Default,-10.0,10.0,DAQmx_Val_Volts,NULL));
//    DAQmxErrChk (DAQmxCfgSampClkTiming(taskHandle,"",10000.0,DAQmx_Val_Rising,DAQmx_Val_FiniteSamps,1000));

    int32       read;
    float64     data;

    /*********************************************/
    // DAQmx Start Code
    /*********************************************/
    DAQmxBaseStartTask(taskHandle);

    while(!stopped) {
    //    DAQmxErrChk (DAQmxReadAnalogF64(taskHandle,1000,10.0,DAQmx_Val_GroupByChannel,data,1000,&read,NULL));
        DAQmxBaseReadAnalogF64(taskHandle,1,10.0,DAQmx_Val_GroupByChannel,&data,1,&read,NULL);
//        qDebug() << QString("data is %1").arg(data);
        // if (noerr)
        emit GetData(data);

        msleep(100);
    }

Error:
    if( DAQmxFailed(error) ) {
        DAQmxBaseGetExtendedErrorInfo(errBuff,2048);
        qDebug() << errBuff;
    }
    if( taskHandle!=0 )  {
        /*********************************************/
        // DAQmx Stop Code
        /*********************************************/
        DAQmxBaseStopTask(taskHandle);
        DAQmxBaseClearTask(taskHandle);
    }
}
