#include <QDebug>

#include "daqthread.h"

#define DAQmxErrChk(functionCall) if( DAQmxFailed(error=(functionCall)) ) goto Error; else

DAQThread::DAQThread(QObject *parent) :
    QThread(parent)
{
    stopped = false;

    state = State_IDLE;
    EvtQue = new QQueue<int>();

    // cannot Init (create) DAQmxTask, when Constructer
}

DAQThread::~DAQThread()
{
    delete EvtQue;
}

void DAQThread::stop()
{
    stopped = true;
}

void DAQThread::startPulseOutput(float freq, float duty)
{
    pulse_freq = freq;
    pulse_duty = (float64)(duty / 100.0);
    qDebug() << QString("freq = %1, ducy = %2").arg(pulse_freq).arg(pulse_duty);
    EvtQue->enqueue(Ev_Start);
}

void DAQThread::stopPulseOutput()
{
    EvtQue->enqueue(Ev_Stop);
}

void DAQThread::changePulseOutput(float freq, float duty)
{
    pulse_freq = freq;
    pulse_duty = (float64)(duty / 100.0);
    qDebug() << QString("freq = %1, ducy = %2").arg(pulse_freq).arg(pulse_duty);
    EvtQue->enqueue(Ev_ChgPulse);
}

void DAQThread::run()
{
    int32       error = 0;
    char        errBuff[2048] = { '\0' };
    char        ctrname[128] = "Dev1/ctr0";

    taskHandle = 0;
    pulse_freq = (float64)1000.0;
    pulse_duty = (float64)0.50; // 0.50 is 50%
    int event = 0;
    state = State_IDLE;

    uInt32 serialnumber;
    DAQmxBaseGetDevSerialNum("Dev1", &serialnumber);
    qDebug() << QString("%1 SerialNumber is 0x%2").arg("Dev1").arg(serialnumber, 8, 16, QChar('0'));

    // signal - daqmxbase ready
    emit daqmxbase_ready();

#if 0
    /*********************************************/
    // DAQmx Configure Code
    /*********************************************/
    DAQmxErrChk (DAQmxBaseCreateTask("", &taskHandle));
    //    int32 DAQmxBaseCreateCOPulseChanFreq (TaskHandle taskHandle, const char counter[ ], const char nameToAssignToChannel[ ], int32 units, int32 idleState, float64 initialDelay, float64 freq, float64 dutyCycle);
    DAQmxErrChk (DAQmxBaseCreateCOPulseChanFreq (taskHandle, ctrname, "", DAQmx_Val_Hz, DAQmx_Val_Low, (float64)0.0, pulse_freq, pulse_ducy));

    //    int32 DAQmxBaseCfgImplicitTiming (TaskHandle taskHandle, int32 sampleMode, uInt64 sampsPerChanToAcquire);
    DAQmxErrChk (DAQmxBaseCfgImplicitTiming (taskHandle, DAQmx_Val_ContSamps, (uInt64)0));
    /*********************************************/
    // DAQmx Start Code
    /*********************************************/
    DAQmxBaseStartTask(taskHandle);
#endif

    while(!stopped) {
        if (EvtQue->isEmpty()) {
            msleep(100);
            continue;  // Jump to Next Loop
        }

        event = EvtQue->dequeue();
        switch (state) {
        case State_IDLE:
            if (event == Ev_Start) {
//                qDebug() << "start pulse output."; // start Pulse output
                qDebug() << QString("start pulse output: freq = %1, ducy = %2").arg(pulse_freq).arg(pulse_duty);
                //    int32 DAQmxBaseCreateCOPulseChanFreq (TaskHandle taskHandle, const char counter[ ], const char nameToAssignToChannel[ ], int32 units, int32 idleState, float64 initialDelay, float64 freq, float64 dutyCycle);
                DAQmxErrChk (DAQmxBaseCreateTask("", &taskHandle));
                DAQmxErrChk (DAQmxBaseCreateCOPulseChanFreq (taskHandle, ctrname, "", DAQmx_Val_Hz, DAQmx_Val_Low, (float64)0.0, pulse_freq, pulse_duty));
                //    int32 DAQmxBaseCfgImplicitTiming (TaskHandle taskHandle, int32 sampleMode, uInt64 sampsPerChanToAcquire);
                DAQmxErrChk (DAQmxBaseCfgImplicitTiming (taskHandle, DAQmx_Val_ContSamps, (uInt64)0));
                // msleep(100);
                DAQmxErrChk (DAQmxBaseStartTask (taskHandle));
                state = State_OUTPUT;
            }
            break;
        case State_OUTPUT:
            if (event == Ev_Stop) {
                qDebug() << "stop pulse output.";; // stop Pulse
                DAQmxErrChk (DAQmxBaseStopTask (taskHandle));
                DAQmxErrChk (DAQmxBaseClearTask (taskHandle));
                state = State_IDLE;
            } else if (event == Ev_ChgPulse) {
                qDebug() << "change pulse freq, ducy.";; // change Pulse Freq, Ducy
                DAQmxErrChk (DAQmxBaseStopTask (taskHandle));
                DAQmxErrChk (DAQmxBaseClearTask (taskHandle));
//                msleep(100);
                DAQmxErrChk (DAQmxBaseCreateTask("", &taskHandle));
                //    int32 DAQmxBaseCreateCOPulseChanFreq (TaskHandle taskHandle, const char counter[ ], const char nameToAssignToChannel[ ], int32 units, int32 idleState, float64 initialDelay, float64 freq, float64 dutyCycle);
                DAQmxErrChk (DAQmxBaseCreateCOPulseChanFreq (taskHandle, ctrname, "", DAQmx_Val_Hz, DAQmx_Val_Low, (float64)0.0, pulse_freq, pulse_duty));
                //    int32 DAQmxBaseCfgImplicitTiming (TaskHandle taskHandle, int32 sampleMode, uInt64 sampsPerChanToAcquire);
                DAQmxErrChk (DAQmxBaseCfgImplicitTiming (taskHandle, DAQmx_Val_FiniteSamps, (uInt64)0));
                DAQmxErrChk (DAQmxBaseStartTask (taskHandle));
            }
            break;
        default:
            break;
        }
        msleep(100);
    }

Error:
    if( DAQmxFailed(error) ) {
        DAQmxBaseGetExtendedErrorInfo(errBuff,2048);
        qDebug() << errBuff;
        emit daqmxbase_error(QString(errBuff));
    }
    if( taskHandle!=0 )  {
        /*********************************************/
        // DAQmx Stop Code
        /*********************************************/
        DAQmxBaseStopTask(taskHandle);
        DAQmxBaseClearTask(taskHandle);
        emit daqmxbase_final();
    }
}
