#ifndef DAQTHREAD_H
#define DAQTHREAD_H

#include <QThread>
#include <QQueue>
#include <QString>

#include "NIDAQmxBase.h"

class DAQThread : public QThread
{
    Q_OBJECT
public:
    explicit DAQThread(QObject *parent = 0);
    ~DAQThread();
    void stop();

    void startPulseOutput(float freq, float duty);
    void stopPulseOutput();
    void changePulseOutput(float freq, float duty);

public slots:

signals:
    void daqmxbase_ready();
    void daqmxbase_final();
    void daqmxbase_error(QString errmsg);

protected:
    void run();

private:
    volatile bool stopped;

    TaskHandle  taskHandle; // Daqmxbase task handle
    float64 pulse_freq;
    float64 pulse_duty;

    // State Machine, state Id
    enum { State_IDLE = 0,
           State_OUTPUT // Pulse Output
         } state;
    // State Machine, event Id
    enum { Ev_Nop = 0,
           Ev_Start, // start pulse output
           Ev_Stop,  // stop pulse
           Ev_ChgPulse // chg pulse freq, duty
         };

    QQueue<int> *EvtQue; // EventQue

};

#endif // DAQTHREAD_H
