#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QMessageBox>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    flag_output_status = false;
    ui->pushButton_Output->setEnabled(false);
    ui->pushButton_Output->setText("ON");

    // Init & Start DAQ Thread
    DaqTh = new DAQThread(this);
    // connect signals
    connect(DaqTh, SIGNAL(daqmxbase_ready()),
                this, SLOT(daqmxbase_ready()));
    connect(DaqTh, SIGNAL(daqmxbase_final()),
                this, SLOT(daqmxbase_final()));
    connect(DaqTh, SIGNAL(daqmxbase_error(QString)),
                this, SLOT(daqmxbase_error(QString)));
    // DaqTh start
    DaqTh->start();
}

MainWindow::~MainWindow()
{
    // Final DaqTh
    DaqTh->stop();
    DaqTh->wait();
    delete DaqTh;

    delete ui;
}

void MainWindow::on_pushButton_Output_clicked()
{
    if (flag_output_status) {
        DaqTh->stopPulseOutput();
        ui->pushButton_Output->setText("ON");
        flag_output_status = false;
    } else {
        DaqTh->startPulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
        ui->pushButton_Output->setText("OFF");
        flag_output_status = true;
    }
}

void MainWindow::on_doubleSpinBox_Freq_valueChanged(double arg1)
{
    DaqTh->changePulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
}


void MainWindow::on_doubleSpinBox_Duty_valueChanged(double arg1)
{
    DaqTh->changePulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
}

void MainWindow::daqmxbase_ready()
{
    ui->pushButton_Output->setEnabled(true);
}

void MainWindow::daqmxbase_final()
{
    ui->pushButton_Output->setEnabled(false);
}

void MainWindow::daqmxbase_error(QString ErrMsg)
{
    // Dialog
    QMessageBox::critical(this, "DaqmxBase Error", ErrMsg);
}
