#ifndef IMAGEVIEW_H
#define IMAGEVIEW_H
// ------------------------------------------------------------------------------------------------

#include <QtGui/QMainWindow>
#include <QtGui/QGraphicsView>
#include <QtGui/QPixmap>
#include <QtGui/QGraphicsPixmapItem>
#include <QtGui/QFileDialog>
#include <QTimer>

#include "ImageCapture.h"
// #include "OtToolBar.h"

// ------------------------------------------------------------------------------------------------
class ImageView : public QGraphicsView
{
	Q_OBJECT
public:
	ImageView( QWidget *parent = 0 );
	~ImageView();

	ImageCapture* imageCapture;			// 画像撮り込みクラス
	QImage image;						// 表示画像を保存しておく場所
	QGraphicsPixmapItem* pixmapItem;	// QGraphicsView 上に表示させるための準備
	QGraphicsScene scene;				// QGraphicsView 上に表示させるための準備
	QTimer timer;						// タイマー
	double captureInterval;				// 画像撮り込み間隔[sec]
	double scaleValue;

	void setCapture( ImageCapture* _capture );
    void saveCurrentImage(QString filepath, QString overlay_text);

#if 0
	OtToolBar* getToolBar( QWidget* parent );
#endif

public slots:
	void grab();
	void load();
	void save();
	void startTimer();
	void stopTimer();
	void zoomIn();
	void zoomOut();

private:
	void showQImage( QImage* qimage );
	void scaleXY( double d );

    CvFont dfont;
};
// ------------------------------------------------------------------------------------------------

#endif // IMAGEVIEW_H
