<?php

// Start of intl v.1.1.0

class Collator  {
	const DEFAULT_VALUE = -1;
	const PRIMARY = 0;
	const SECONDARY = 1;
	const TERTIARY = 2;
	const DEFAULT_STRENGTH = 2;
	const QUATERNARY = 3;
	const IDENTICAL = 15;
	const OFF = 16;
	const ON = 17;
	const SHIFTED = 20;
	const NON_IGNORABLE = 21;
	const LOWER_FIRST = 24;
	const UPPER_FIRST = 25;
	const FRENCH_COLLATION = 0;
	const ALTERNATE_HANDLING = 1;
	const CASE_FIRST = 2;
	const CASE_LEVEL = 3;
	const NORMALIZATION_MODE = 4;
	const STRENGTH = 5;
	const HIRAGANA_QUATERNARY_MODE = 6;
	const NUMERIC_COLLATION = 7;
	const SORT_REGULAR = 0;
	const SORT_STRING = 1;
	const SORT_NUMERIC = 2;


	/**
	 * collator を作成する
	 * @link http://www.php.net/manual/ja/collator.construct.php
	 * @param arg1
	 */
	public function __construct ($arg1) {}

	/**
	 * collator を作成する
	 * @link http://www.php.net/manual/ja/collator.create.php
	 * @param locale string <p>
	 * 照合規則を使用するロケール。特殊な場合として、
	 * null を渡した場合はデフォルトのロケールの照合規則を使用します。
	 * また、空文字列 ("") や "root" を渡した場合は UCA の規則を使用します。
	 * </p>
	 * @return Collator 新しい Collator オブジェクトのインスタンス、
	 * あるいはエラー時に NULL を返します。
	 */
	public static function create ($locale) {}

	/**
	 * ふたつの Unicode 文字列を比較する
	 * @link http://www.php.net/manual/ja/collator.compare.php
	 * @param str1 string <p>
	 * 最初の文字列。
	 * </p>
	 * @param str2 string <p>
	 * 2 番目の文字列。
	 * </p>
	 * @return int 比較結果を返します。</p>
	 * <p>
	 * <p>
	 * str1 が str2 より
	 * 大きい ときは 1
	 * </p>
	 * <p>
	 * str1 と str2 が
	 * 等しい ときは 0
	 * </p>
	 * <p>
	 * str1 が str2 より
	 * 小さい ときは -1
	 * </p>
	 * エラー時には
	 * boolean
	 * FALSE
	 * を返します。
	 */
	public function compare ($str1, $str2) {}

	/**
	 * 指定した collator で配列を並べ替える
	 * @link http://www.php.net/manual/ja/collator.sort.php
	 * @param arr array <p>
	 * 並べ替えたい文字列の配列。
	 * </p>
	 * @param sort_flag int[optional] <p>
	 * オプションの並べ替え方式。以下のいずれか。
	 * </p>
	 * <p>
	 * <p>
	 * Collator::SORT_REGULAR
	 * - 通常の比較 (型を変更しない)
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function sort (array &$arr, $sort_flag = null) {}

	/**
	 * 指定した collator とキーで配列を並べ替える
	 * @link http://www.php.net/manual/ja/collator.sortwithsortkeys.php
	 * @param arr array <p>並べ替えたい文字列の配列。</p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function sortWithSortKeys (array &$arr) {}

	/**
	 * インデックスの情報を保持しつつ配列を並べ替える
	 * @link http://www.php.net/manual/ja/collator.asort.php
	 * @param arr array <p>並べ替えたい文字列の配列。</p>
	 * @param sort_flag int[optional] <p>
	 * オプションの並べ替え方式。以下のいずれか。
	 * <p>
	 * Collator::SORT_REGULAR
	 * - 通常の比較 (型を変更しない)
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function asort (array &$arr, $sort_flag = null) {}

	/**
	 * 照合用の属性の値を取得する
	 * @link http://www.php.net/manual/ja/collator.getattribute.php
	 * @param attr int <p>
	 * 値を取得したい属性。
	 * </p>
	 * @return int 属性の値、あるいはエラー時に boolean FALSE を返します。
	 */
	public function getAttribute ($attr) {}

	/**
	 * 照合用の属性を設定する
	 * @link http://www.php.net/manual/ja/collator.setattribute.php
	 * @param attr int <p>属性。</p>
	 * @param val int <p>
	 * 属性の値。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setAttribute ($attr, $val) {}

	/**
	 * 現在の照合強度を取得する
	 * @link http://www.php.net/manual/ja/collator.getstrength.php
	 * @return int 現在の照合強度、あるいはエラー時に boolean FALSE を返します。
	 */
	public function getStrength () {}

	/**
	 * 照合強度を設定する
	 * @link http://www.php.net/manual/ja/collator.setstrength.php
	 * @param strength int <p>設定する強度。</p>
	 * <p>
	 * 以下のいずれかです。
	 * <p>
	 * Collator::PRIMARY
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setStrength ($strength) {}

	/**
	 * collator のロケール名を取得する
	 * @link http://www.php.net/manual/ja/collator.getlocale.php
	 * @param type int[optional] <p>
	 * 妥当なロケールか実際のロケール (それぞれ
	 * Locale::VALID_LOCALE および
	 * Locale::ACTUAL_LOCALE)。
	 * デフォルトは実際のロケールです。
	 * </p>
	 * @return string 照合データの実際のロケール名を返します。ルールベースの collator
	 * のインスタンスの場合やエラーが発生した場合は
	 * boolean FALSE を返します。
	 */
	public function getLocale ($type = null) {}

	/**
	 * collator の直近のエラーコードを取得する
	 * @link http://www.php.net/manual/ja/collator.geterrorcode.php
	 * @return int 直近の Collator API 関数コールが返したエラーコードを返します。
	 */
	public function getErrorCode () {}

	/**
	 * collator の直近のエラーコードのテキストを取得する
	 * @link http://www.php.net/manual/ja/collator.geterrormessage.php
	 * @return string 直近の Collator API 関数コールで発生したエラーの説明を返します。
	 */
	public function getErrorMessage () {}

	/**
	 * 文字列のソート用のキーを取得する
	 * @link http://www.php.net/manual/ja/collator.getsortkey.php
	 * @param str string <p>
	 * キーの生成元となる文字列。
	 * </p>
	 * @return string 文字列の照合キーを返します。照合キーを、文字列のかわりに直接比較することができます。
	 */
	public function getSortKey ($str) {}

}

class NumberFormatter  {
	const PATTERN_DECIMAL = 0;
	const DECIMAL = 1;
	const CURRENCY = 2;
	const PERCENT = 3;
	const SCIENTIFIC = 4;
	const SPELLOUT = 5;
	const ORDINAL = 6;
	const DURATION = 7;
	const PATTERN_RULEBASED = 9;
	const IGNORE = 0;
	const DEFAULT_STYLE = 1;
	const ROUND_CEILING = 0;
	const ROUND_FLOOR = 1;
	const ROUND_DOWN = 2;
	const ROUND_UP = 3;
	const ROUND_HALFEVEN = 4;
	const ROUND_HALFDOWN = 5;
	const ROUND_HALFUP = 6;
	const PAD_BEFORE_PREFIX = 0;
	const PAD_AFTER_PREFIX = 1;
	const PAD_BEFORE_SUFFIX = 2;
	const PAD_AFTER_SUFFIX = 3;
	const PARSE_INT_ONLY = 0;
	const GROUPING_USED = 1;
	const DECIMAL_ALWAYS_SHOWN = 2;
	const MAX_INTEGER_DIGITS = 3;
	const MIN_INTEGER_DIGITS = 4;
	const INTEGER_DIGITS = 5;
	const MAX_FRACTION_DIGITS = 6;
	const MIN_FRACTION_DIGITS = 7;
	const FRACTION_DIGITS = 8;
	const MULTIPLIER = 9;
	const GROUPING_SIZE = 10;
	const ROUNDING_MODE = 11;
	const ROUNDING_INCREMENT = 12;
	const FORMAT_WIDTH = 13;
	const PADDING_POSITION = 14;
	const SECONDARY_GROUPING_SIZE = 15;
	const SIGNIFICANT_DIGITS_USED = 16;
	const MIN_SIGNIFICANT_DIGITS = 17;
	const MAX_SIGNIFICANT_DIGITS = 18;
	const LENIENT_PARSE = 19;
	const POSITIVE_PREFIX = 0;
	const POSITIVE_SUFFIX = 1;
	const NEGATIVE_PREFIX = 2;
	const NEGATIVE_SUFFIX = 3;
	const PADDING_CHARACTER = 4;
	const CURRENCY_CODE = 5;
	const DEFAULT_RULESET = 6;
	const PUBLIC_RULESETS = 7;
	const DECIMAL_SEPARATOR_SYMBOL = 0;
	const GROUPING_SEPARATOR_SYMBOL = 1;
	const PATTERN_SEPARATOR_SYMBOL = 2;
	const PERCENT_SYMBOL = 3;
	const ZERO_DIGIT_SYMBOL = 4;
	const DIGIT_SYMBOL = 5;
	const MINUS_SIGN_SYMBOL = 6;
	const PLUS_SIGN_SYMBOL = 7;
	const CURRENCY_SYMBOL = 8;
	const INTL_CURRENCY_SYMBOL = 9;
	const MONETARY_SEPARATOR_SYMBOL = 10;
	const EXPONENTIAL_SYMBOL = 11;
	const PERMILL_SYMBOL = 12;
	const PAD_ESCAPE_SYMBOL = 13;
	const INFINITY_SYMBOL = 14;
	const NAN_SYMBOL = 15;
	const SIGNIFICANT_DIGIT_SYMBOL = 16;
	const MONETARY_GROUPING_SEPARATOR_SYMBOL = 17;
	const TYPE_DEFAULT = 0;
	const TYPE_INT32 = 1;
	const TYPE_INT64 = 2;
	const TYPE_DOUBLE = 3;
	const TYPE_CURRENCY = 4;


	/**
	 * @param locale
	 * @param style
	 * @param pattern[optional]
	 */
	public function __construct ($locale, $style, $pattern) {}

	/**
	 * 数値フォーマッタを作成する
	 * @link http://www.php.net/manual/ja/numberformatter.create.php
	 * @param locale string <p>
	 * 数値フォーマットするロケール (ロケール名。たとえば en_CA)。
	 * </p>
	 * @param style int <p>
	 * フォーマットの形式。
	 * フォーマット形式 定数のいずれか。
	 * NumberFormatter::PATTERN_DECIMAL
	 * あるいは NumberFormatter::PATTERN_RULEBASED
	 * を指定した場合は指定したパターンの数値フォーマットをオープンします。
	 * これは、それぞれ
	 * ICU DecimalFormat
	 * ドキュメント あるいは
	 * ICU RuleBasedNumberFormat
	 * ドキュメント で述べられている構文を満たす必要があります。
	 * </p>
	 * @param pattern string[optional] <p>
	 * 選択した形式がパターンを要求するものである場合のパターン文字列。
	 * </p>
	 * @return NumberFormatter NumberFormatter オブジェクト、
	 * あるいはエラー時に FALSE を返します。
	 */
	public static function create ($locale, $style, $pattern = null) {}

	/**
	 * 数値をフォーマットする
	 * @link http://www.php.net/manual/ja/numberformatter.format.php
	 * @param value number <p>
	 * フォーマットする値。integer あるいは float
	 * で指定します。その他の型は数値に変換されます。
	 * </p>
	 * @param type int[optional] <p>
	 * 使用する
	 * フォーマット形式。
	 * </p>
	 * @return string フォーマットした値を文字列で返します。
	 * エラー時には FALSE を返します。
	 */
	public function format ($value, $type = null) {}

	/**
	 * 数値をパースする
	 * @link http://www.php.net/manual/ja/numberformatter.parse.php
	 * @param value string 
	 * @param type int[optional] <p>
	 * 使用する
	 * フォーマット形式。デフォルトでは
	 * NumberFormatter::TYPE_DOUBLE を使用します。
	 * </p>
	 * @param position int[optional] <p>
	 * 文字列中でパースを開始する位置のオフセット。
	 * 結果を返す際に、この値はパース終了時のオフセットを保持します。
	 * </p>
	 * @return mixed パースした数値、あるいはエラー時に FALSE を返します。
	 */
	public function parse ($value, $type = null, &$position = null) {}

	/**
	 * 通貨の値をフォーマットする
	 * @link http://www.php.net/manual/ja/numberformatter.formatcurrency.php
	 * @param value float <p>
	 * 通貨の値。
	 * </p>
	 * @param currency string <p>
	 * 使用する通貨を表す、3 文字の ISO 4217 通貨コード。
	 * </p>
	 * @return string 通貨の値をフォーマットした文字列を返します。
	 */
	public function formatCurrency ($value, $currency) {}

	/**
	 * 通貨をパースする
	 * @link http://www.php.net/manual/ja/numberformatter.parsecurrency.php
	 * @param value string 
	 * @param currency string <p>
	 * 通貨名 (3 文字の ISO 4217 通貨コード) を受け取るパラメータ。
	 * </p>
	 * @param position int[optional] <p>
	 * 文字列中でパースを開始する位置のオフセット。
	 * 結果を返す際に、この値はパース終了時のオフセットを保持します。
	 * </p>
	 * @return float パースした数値、あるいはエラー時に FALSE を返します。
	 */
	public function parseCurrency ($value, &$currency, &$position = null) {}

	/**
	 * 属性を設定する
	 * @link http://www.php.net/manual/ja/numberformatter.setattribute.php
	 * @param attr int <p>
	 * 属性指定子。
	 * 数値属性 定数のいずれか。
	 * </p>
	 * @param value int <p>
	 * 属性の値。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setAttribute ($attr, $value) {}

	/**
	 * 属性を取得する
	 * @link http://www.php.net/manual/ja/numberformatter.getattribute.php
	 * @param attr int <p>
	 * 属性指定子。
	 * 数値属性 定数のいずれか。
	 * </p>
	 * @return int 成功した場合に属性の値、エラー時に FALSE を返します。
	 */
	public function getAttribute ($attr) {}

	/**
	 * テキスト属性を設定する
	 * @link http://www.php.net/manual/ja/numberformatter.settextattribute.php
	 * @param attr int <p>
	 * 属性指定子。
	 * テキスト属性
	 * 定数のいずれか。
	 * </p>
	 * @param value string <p>
	 * 属性の値を表すテキスト。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setTextAttribute ($attr, $value) {}

	/**
	 * テキストの属性を取得する
	 * @link http://www.php.net/manual/ja/numberformatter.gettextattribute.php
	 * @param attr int <p>
	 * 属性指定子。
	 * テキスト属性 定数のいずれか。
	 * </p>
	 * @return string 成功した場合に属性の値、あるいはエラー時に FALSE を返します。
	 */
	public function getTextAttribute ($attr) {}

	/**
	 * 記号の値を設定する
	 * @link http://www.php.net/manual/ja/numberformatter.setsymbol.php
	 * @param attr int <p>
	 * 記号指定子。
	 * フォーマット記号 定数のいずれか。
	 * </p>
	 * @param value string <p>
	 * その記号に対応するテキスト。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setSymbol ($attr, $value) {}

	/**
	 * 記号を取得する
	 * @link http://www.php.net/manual/ja/numberformatter.getsymbol.php
	 * @param attr int <p>
	 * 記号指定子。
	 * フォーマット記号 定数のいずれか。
	 * </p>
	 * @return string 記号文字列、あるいはエラー時に FALSE を返します。
	 */
	public function getSymbol ($attr) {}

	/**
	 * フォーマッタのパターンを設定する
	 * @link http://www.php.net/manual/ja/numberformatter.setpattern.php
	 * @param pattern string <p>
	 * ICU DecimalFormat
	 * ドキュメント で述べられている構文によるパターン。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setPattern ($pattern) {}

	/**
	 * フォーマッタのパターンを取得する
	 * @link http://www.php.net/manual/ja/numberformatter.getpattern.php
	 * @return string このフォーマッタが使用するパターン文字列、
	 * あるいはエラー発生時に FALSE を返します。
	 */
	public function getPattern () {}

	/**
	 * フォーマッタのロケールを取得する
	 * @link http://www.php.net/manual/ja/numberformatter.getlocale.php
	 * @param type int[optional] <p>
	 * 妥当なロケールあるいは正確なロケールのいずれか (
	 * Locale::VALID_LOCALE,
	 * Locale::ACTUAL_LOCALE,
	 * respectively) を選択します。デフォルトは実際のロケールです。
	 * </p>
	 * @return string フォーマッタの作成時に使用したロケールを返します。
	 */
	public function getLocale ($type = null) {}

	/**
	 * フォーマッタの直近のエラーコードを取得する
	 * @link http://www.php.net/manual/ja/numberformatter.geterrorcode.php
	 * @return int 直近の関数コールのエラーコードを返します。
	 */
	public function getErrorCode () {}

	/**
	 * フォーマッタの直近のエラーメッセージを取得する
	 * @link http://www.php.net/manual/ja/numberformatter.geterrormessage.php
	 * @return string 直近の関数コールのエラーメッセージを返します。
	 */
	public function getErrorMessage () {}

}

class Normalizer  {
	const NONE = 1;
	const FORM_D = 2;
	const NFD = 2;
	const FORM_KD = 3;
	const NFKD = 3;
	const FORM_C = 4;
	const NFC = 4;
	const FORM_KC = 5;
	const NFKC = 5;


	/**
	 * 渡された入力を正規化し、正規化後の文字列を返す
	 * @link http://www.php.net/manual/ja/normalizer.normalize.php
	 * @param input string <p>正規化する入力文字列。</p>
	 * @param form string[optional] <p>正規化方式のいずれか。</p>
	 * @return string 正規化後の文字列、あるいはエラーが発生した場合に NULL を返します。
	 */
	public static function normalize ($input, $form = null) {}

	/**
	 * 渡された文字列が、指定した正規化を適用済みかどうかを調べる
	 * @link http://www.php.net/manual/ja/normalizer.isnormalized.php
	 * @param input string <p>正規化する入力文字列。</p>
	 * @param form string[optional] <p>
	 * 正規化方式のいずれか。
	 * </p>
	 * @return bool 正規化されている場合に TRUE、正規化されていない場合やエラーが発生した場合に FALSE を返します。
	 */
	public static function isNormalized ($input, $form = null) {}

}

class Locale  {
	const ACTUAL_LOCALE = 0;
	const VALID_LOCALE = 1;
	const DEFAULT_LOCALE = null;
	const LANG_TAG = "language";
	const EXTLANG_TAG = "extlang";
	const SCRIPT_TAG = "script";
	const REGION_TAG = "region";
	const VARIANT_TAG = "variant";
	const GRANDFATHERED_LANG_TAG = "grandfathered";
	const PRIVATE_TAG = "private";


	/**
	 * INTL のグローバル 'default_locale' からデフォルトのロケールを取得する
	 * @link http://www.php.net/manual/ja/locale.getdefault.php
	 * @return string 現在の実行時ロケールを返します。
	 */
	public static function getDefault () {}

	/**
	 * デフォルトの実行時ロケールを設定する
	 * @link http://www.php.net/manual/ja/locale.setdefault.php
	 * @param locale string <p>
	 * BCP 47 準拠の言語タグ。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public static function setDefault ($locale) {}

	/**
	 * 入力ロケールのプライマリ言語を取得する
	 * @link http://www.php.net/manual/ja/locale.getprimarylanguage.php
	 * @param locale string <p>
	 * プライマリ言語コードを取り出したいロケール。
	 * </p>
	 * @return string このロケールの言語コード、あるいはエラー時に NULL を返します。
	 */
	public static function getPrimaryLanguage ($locale) {}

	/**
	 * 入力ロケールの文字を取得する
	 * @link http://www.php.net/manual/ja/locale.getscript.php
	 * @param locale string <p>
	 * 文字を取り出したいロケール。
	 * </p>
	 * @return string このロケールの文字サブタグ、あるいは存在しない場合に NULL を返します。
	 */
	public static function getScript ($locale) {}

	/**
	 * 入力ロケールの地域を取得する
	 * @link http://www.php.net/manual/ja/locale.getregion.php
	 * @param locale string <p>
	 * 地域コードを取り出したいロケール。
	 * </p>
	 * @return string このロケールの地域サブタグ、あるいは存在しない場合に NULL を返します。
	 */
	public static function getRegion ($locale) {}

	/**
	 * 入力ロケールのキーワードを取得する
	 * @link http://www.php.net/manual/ja/locale.getkeywords.php
	 * @param locale string <p>
	 * キーワードを取り出したいロケール。
	 * </p>
	 * @return array このロケールのキーワードと値のペアを連想配列で返します。
	 */
	public static function getKeywords ($locale) {}

	/**
	 * 入力ロケールの文字の表示名を、適切に地域化して返す
	 * @link http://www.php.net/manual/ja/locale.getdisplayscript.php
	 * @param locale string <p>
	 * 表示文字を返したいロケール。
	 * </p>
	 * @param in_locale string[optional] <p>
	 * オプションのフォーマットロケール。
	 * 文字名の表示に使用します。
	 * </p>
	 * @return string $locale に対応する文字の表示名を、
	 * $in_locale にあわせた形式で返します。
	 */
	public static function getDisplayScript ($locale, $in_locale = null) {}

	/**
	 * 入力ロケールの地域の表示名を、適切に地域化して返す
	 * @link http://www.php.net/manual/ja/locale.getdisplayregion.php
	 * @param locale string <p>
	 * 表示地域を返したいロケール。
	 * </p>
	 * @param in_locale string[optional] <p>
	 * オプションのフォーマットロケール。
	 * 地域名の表示に使用します。
	 * </p>
	 * @return string $locale に対応する地域の表示名を、
	 * $in_locale にあわせた形式で返します。
	 */
	public static function getDisplayRegion ($locale, $in_locale = null) {}

	/**
	 * 入力ロケールの表示名を、適切に地域化して返す
	 * @link http://www.php.net/manual/ja/locale.getdisplayname.php
	 * @param locale string <p>
	 * 表示名を返したいロケール。
	 * </p>
	 * @param in_locale string[optional] <p>オプションのフォーマットロケール。</p>
	 * @return string ロケールの表示名を、
	 * $in_locale にあわせた形式で返します。
	 */
	public static function getDisplayName ($locale, $in_locale = null) {}

	/**
	 * 入力ロケールの言語の表示名を、適切に地域化して返す
	 * @link http://www.php.net/manual/ja/locale.getdisplaylanguage.php
	 * @param locale string <p>
	 * 表示言語を返したいロケール。
	 * </p>
	 * @param in_locale string[optional] <p>
	 * オプションのフォーマットロケール。
	 * 言語名の表示に使用します。
	 * </p>
	 * @return string $locale に対応する言語の表示名を、
	 * $in_locale にあわせた形式で返します。
	 */
	public static function getDisplayLanguage ($locale, $in_locale = null) {}

	/**
	 * 入力ロケールの変化形の表示名を、適切に地域化して返す
	 * @link http://www.php.net/manual/ja/locale.getdisplayvariant.php
	 * @param locale string <p>
	 * 表示変化形を返したいロケール。
	 * </p>
	 * @param in_locale string[optional] <p>
	 * オプションのフォーマットロケール。
	 * 変化形の表示に使用します。
	 * </p>
	 * @return string $locale に対応する変化形の表示名を、
	 * $in_locale にあわせた形式で返します。
	 */
	public static function getDisplayVariant ($locale, $in_locale = null) {}

	/**
	 * 正しく並べ替えて区切られたロケール ID を返す
	 * @link http://www.php.net/manual/ja/locale.composelocale.php
	 * @param subtags array <p>
	 * キーと値のペアを含む配列。
	 * キーには特定のロケール ID サブタグを指定し、
	 * そのサブタグの値を関連付けます。
	 * <p>
	 * サブタグ 'variant' と 'private' には最大で 15 の値を指定できますが、
	 * 'extlang' には最大で 3 つの値しか指定できません。
	 * variant には 0 から 14 までのサフィックスをつけることができ、
	 * 配列のキーは variant0, variant1, ...,variant14 となります。
	 * 返されるロケール ID において、このサブタグは
	 * variant0、variant1、variant2、……の順に並びます。
	 * </p>
	 * <p>
	 * 'variant'、'private' および 'extlang' で複数の値を指定するには、
	 * そのキー (例 'variant') の値に配列を指定するか、数字つきの複数のキー
	 * (例 'variant0'、'variant1' など) を使用します。
	 * </p>
	 * </p>
	 * @return string 対応するロケール識別子を返します。
	 */
	public static function composeLocale (array $subtags) {}

	/**
	 * ロケール ID のサブタグ要素を連想配列で返す
	 * @link http://www.php.net/manual/ja/locale.parselocale.php
	 * @param locale string <p>
	 * サブタグの配列を取り出したいロケール。
	 * 注意: サブタグ 'variant' と 'private' には最大で 15 の値を指定できますが、
	 * 'extlang' には最大で 3 つの値しか指定できません。
	 * </p>
	 * @return array 連想配列を返します。キーがロケール ID サブタグを表し、
	 * そのサブタグの値が関連付けられています。
	 * この配列の並び順はロケール ID サブタグの順となります。変化形が
	 * '-varX-varY-varZ' の場合、返される配列は
	 * variant0=&gt;varX , variant1=&gt;varY ,
	 * variant2=&gt;varZ のようになります。
	 */
	public static function parseLocale ($locale) {}

	/**
	 * 入力ロケールの変化系を取得する
	 * @link http://www.php.net/manual/ja/locale.getallvariants.php
	 * @param locale string <p>
	 * 変化系を取得したいロケール。
	 * </p>
	 * @return array そのロケールのすべての variant サブタグを含む配列、あるいは存在しない場合に
	 * NULL を返します。
	 */
	public static function getAllVariants ($locale) {}

	/**
	 * 言語タグフィルタがロケールにマッチするかどうかを調べる
	 * @link http://www.php.net/manual/ja/locale.filtermatches.php
	 * @param langtag string <p>
	 * 調べたい言語タグ。
	 * </p>
	 * @param locale string <p>
	 * 調べる対象となる言語の範囲。
	 * </p>
	 * @param canonicalize bool[optional] <p>
	 * true の場合は、引数を正式な形式に変換してからマッチを行います。
	 * </p>
	 * @return bool $locale が $langtag にマッチする場合に TRUE、
	 * それ以外の場合に FALSE を返します。
	 */
	public static function filterMatches ($langtag, $locale, $canonicalize = null) {}

	/**
	 * その言語にマッチする言語タグの一覧を検索する
	 * @link http://www.php.net/manual/ja/locale.lookup.php
	 * @param langtag array <p>
	 * locale と比較したい言語タグの一覧を含む配列。
	 * 最大で 100 件まで指定できます。
	 * </p>
	 * @param locale string <p>
	 * 調べる対象となる言語の範囲として使用するロケール。
	 * </p>
	 * @param canonicalize bool[optional] <p>
	 * true の場合は、引数を正式な形式に変換してからマッチを行います。
	 * </p>
	 * @param default string[optional] <p>
	 * マッチしなかったときに使用するロケール。
	 * </p>
	 * @return string 最も近い言語タグ、あるいはデフォルトの値を返します。
	 */
	public static function lookup (array $langtag, $locale, $canonicalize = null, $default = null) {}

	/**
	 * @param arg1
	 */
	public static function canonicalize ($arg1) {}

	/**
	 * 最もあてはまるロケールを HTTP "Accept-Language" ヘッダにもとづいて探す
	 * @link http://www.php.net/manual/ja/locale.acceptfromhttp.php
	 * @param header string <p>
	 * "Accept-Language" ヘッダを含む文字列。RFC 2616 形式。
	 * </p>
	 * @return string 対応するロケール ID を返します。
	 */
	public static function acceptFromHttp ($header) {}

}

class MessageFormatter  {

	/**
	 * @param locale
	 * @param pattern
	 */
	public function __construct ($locale, $pattern) {}

	/**
	 * 新しいメッセージフォーマッタを作成する
	 * @link http://www.php.net/manual/ja/messageformatter.create.php
	 * @param locale string <p>
	 * 引数のフォーマットに用いるロケール。
	 * </p>
	 * @param pattern string <p>
	 * 引数を埋め込むパターン文字列。
	 * パターンには、'アポストロフィに優しい' 構文を使用します。
	 * umsg_autoQuoteApostrophe 
	 * を通してから解釈が行われます。
	 * </p>
	 * @return MessageFormatter フォーマッタオブジェクトを返します。
	 */
	public static function create ($locale, $pattern) {}

	/**
	 * メッセージをフォーマットする
	 * @link http://www.php.net/manual/ja/messageformatter.format.php
	 * @param args array <p>
	 * フォーマット文字列に埋め込む引数。
	 * </p>
	 * @return string フォーマットした文字列を返します。
	 * あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function format (array $args) {}

	/**
	 * 手早くメッセージをフォーマットする
	 * @link http://www.php.net/manual/ja/messageformatter.formatmessage.php
	 * @param locale string <p>
	 * ロケールに依存する部分をフォーマットする際に使用するロケール。
	 * </p>
	 * @param pattern string <p>
	 * 使用するパターン文字列。
	 * パターンには、'アポストロフィに優しい' 構文を使用します。
	 * umsg_autoQuoteApostrophe 
	 * を通してから解釈が行われます。
	 * </p>
	 * @param args array <p>
	 * フォーマット文字列に埋め込む値の配列。
	 * </p>
	 * @return string フォーマットしたパターン文字列を返します。
	 * エラーが発生した場合は FALSE を返します。
	 */
	public static function formatMessage ($locale, $pattern, array $args) {}

	/**
	 * パターンを使用して入力文字列をパースする
	 * @link http://www.php.net/manual/ja/messageformatter.parse.php
	 * @param value string <p>
	 * パースする文字列。
	 * </p>
	 * @return array 取り出した項目を含む配列を返します。
	 * エラーが発生した場合は FALSE を返します。
	 */
	public function parse ($value) {}

	/**
	 * 手早く入力文字列をパースする
	 * @link http://www.php.net/manual/ja/messageformatter.parsemessage.php
	 * @param locale string <p>
	 * ロケールに依存する部分をパースする際に使用するロケール。
	 * </p>
	 * @param pattern string <p>
	 * value のパースに使うパターン。
	 * </p>
	 * @param source string <p>
	 * パースする文字列。pattern を満たします。
	 * </p>
	 * @return array 取り出した項目を含む配列を返します。
	 * エラーが発生した場合は FALSE を返します。
	 */
	public static function parseMessage ($locale, $pattern, $source) {}

	/**
	 * フォーマッタが使用するパターンを設定する
	 * @link http://www.php.net/manual/ja/messageformatter.setpattern.php
	 * @param pattern string <p>
	 * このメッセージフォーマッタで使用するパターン文字列。
	 * パターンには、'アポストロフィに優しい' 構文を使用します。
	 * umsg_autoQuoteApostrophe 
	 * を通してから解釈が行われます。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setPattern ($pattern) {}

	/**
	 * フォーマッタが使用するパターンを取得する
	 * @link http://www.php.net/manual/ja/messageformatter.getpattern.php
	 * @return string このメッセージフォーマッタのパターン文字列を返します。
	 */
	public function getPattern () {}

	/**
	 * フォーマッタを作成した際のロケールを取得する
	 * @link http://www.php.net/manual/ja/messageformatter.getlocale.php
	 * @return string ロケール名を返します。
	 */
	public function getLocale () {}

	/**
	 * 直近の操作のエラーコードを取得する
	 * @link http://www.php.net/manual/ja/messageformatter.geterrorcode.php
	 * @return int エラーコードを返します。UErrorCode の値のいずれかです。
	 * 初期値は U_ZERO_ERROR となります。
	 */
	public function getErrorCode () {}

	/**
	 * 直近の操作のエラーテキストを取得する
	 * @link http://www.php.net/manual/ja/messageformatter.geterrormessage.php
	 * @return string 直近のエラーの説明を返します。
	 */
	public function getErrorMessage () {}

}

class IntlDateFormatter  {
	const FULL = 0;
	const LONG = 1;
	const MEDIUM = 2;
	const SHORT = 3;
	const NONE = -1;
	const GREGORIAN = 1;
	const TRADITIONAL = 0;


	/**
	 * @param locale
	 * @param datetype
	 * @param timetype
	 * @param timezone[optional]
	 * @param calendar[optional]
	 * @param pattern[optional]
	 */
	public function __construct ($locale, $datetype, $timetype, $timezone, $calendar, $pattern) {}

	/**
	 * Date Formatter を作成する
	 * @link http://www.php.net/manual/ja/intldateformatter.create.php
	 * @param locale string <p>
	 * フォーマットやパースの際に使用するロケール。
	 * </p>
	 * @param datetype int <p>
	 * 使用する日付の形式 (none, 
	 * short, medium, 
	 * long, full)。
	 * IntlDateFormatter の定数
	 * のいずれかとなります。
	 * </p>
	 * @param timetype int <p>
	 * 使用する時刻の形式 (none, 
	 * short, medium, 
	 * long, full)。
	 * IntlDateFormatter の定数
	 * のいずれかとなります。
	 * </p>
	 * @param timezone string[optional] <p>
	 * タイムゾーン ID。デフォルトはシステムの設定となります。
	 * </p>
	 * @param calendar int[optional] <p>
	 * フォーマットやパースの際に使用するカレンダー。デフォルトは Gregorian
	 * (グレゴリオ暦) です。これは
	 * IntlDateFormatter のカレンダー定数
	 * のいずれかとなります。
	 * </p>
	 * @param pattern string[optional] <p>
	 * フォーマットやパースの際に使用するオプションのパターン。
	 * 使えるパターンについては http://userguide.icu-project.org/formatparse/datetime
	 * を参照ください。
	 * </p>
	 * @return IntlDateFormatter 
	 */
	public static function create ($locale, $datetype, $timetype, $timezone = null, $calendar = null, $pattern = null) {}

	/**
	 * IntlDateFormatter が使用する日付形式を取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.getdatetype.php
	 * @return int Formatter の現在の 日付形式
	 * の値を返します。
	 */
	public function getDateType () {}

	/**
	 * IntlDateFormatter が使用する時刻形式を取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.gettimetype.php
	 * @return int Formatter の現在の 日付形式
	 * の値を返します。
	 */
	public function getTimeType () {}

	/**
	 * IntlDateFormatter が使用するカレンダーを取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.getcalendar.php
	 * @return int Formatter が使用するカレンダーを返します。
	 */
	public function getCalendar () {}

	/**
	 * Formatter が使うカレンダーを設定する
	 * @link http://www.php.net/manual/ja/intldateformatter.setcalendar.php
	 * @param which int <p>
	 * 使用する カレンダー。
	 * デフォルトは IntlDateFormatter::GREGORIAN です。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setCalendar ($which) {}

	/**
	 * IntlDateFormatter が使用するタイムゾーン ID を取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.gettimezoneid.php
	 * @return string この Formatter が使用するタイムゾーンの ID 文字列を返します。
	 */
	public function getTimeZoneId () {}

	/**
	 * 使用するタイムゾーンを設定する
	 * @link http://www.php.net/manual/ja/intldateformatter.settimezoneid.php
	 * @param zone string <p>
	 * 使用するタイムゾーンのゾーン ID 文字列。
	 * NULL あるいは空文字列を指定すると、
	 * 実行時のデフォルトタイムゾーンを使用します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setTimeZoneId ($zone) {}

	/**
	 * IntlDateFormatter が使用するパターンを設定する
	 * @link http://www.php.net/manual/ja/intldateformatter.setpattern.php
	 * @param pattern string <p>
	 * 使用するパターン文字列。
	 * 使えるパターンについては http://userguide.icu-project.org/formatparse/datetime
	 * を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * 間違ったフォーマット文字列を指定すると、失敗します。
	 */
	public function setPattern ($pattern) {}

	/**
	 * IntlDateFormatter が使用するパターンを取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.getpattern.php
	 * @return string フォーマット/パース 時に使用するパターン文字列を返します。
	 */
	public function getPattern () {}

	/**
	 * Formatter が使用するロケールを取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.getlocale.php
	 * @param which int[optional] 
	 * @return string この Formatter のロケール、あるいはエラーの場合は 'false' を返します。
	 */
	public function getLocale ($which = null) {}

	/**
	 * パーサの寛大さを設定する
	 * @link http://www.php.net/manual/ja/intldateformatter.setlenient.php
	 * @param lenient bool <p>
	 * パーサを寛大なものにするかどうか。デフォルトは TRUE (寛大) です。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setLenient ($lenient) {}

	/**
	 * IntlDateFormatter で使用する寛大さを取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.islenient.php
	 * @return bool 寛大なパーサの場合は TRUE、厳格なパーサの場合は FALSE 返します。
	 * デフォルトのパーサは寛大なパーサです。
	 */
	public function isLenient () {}

	/**
	 * 日付/時刻 の値を文字列としてフォーマットする
	 * @link http://www.php.net/manual/ja/intldateformatter.format.php
	 * @param value mixed <p>
	 * フォーマットする値。DateTime オブジェクト、
	 * Unix タイムスタンプ (epoch からの経過秒数、UTC)
	 * を表す整数値、あるいは localtime 用の配列となります。
	 * </p>
	 * @return string フォーマットされた文字列、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function format ($value) {}

	/**
	 * 文字列をパースしてタイムスタンプにする
	 * @link http://www.php.net/manual/ja/intldateformatter.parse.php
	 * @param value string <p>
	 * 時間に変換する文字列。
	 * </p>
	 * @param position int[optional] <p>
	 * $value のパースを開始する位置 (ゼロから数えます)。
	 * $value を処理する前にエラーが発生していない場合は
	 * $parse_pos は -1 となります。それ以外の場合はパースが終了した位置となります
	 * (そしてエラーが発生します)。
	 * この変数には、パースが失敗した場合にその終了位置が含まれます。
	 * $parse_pos > strlen($value) の場合、パースは即時に失敗します。
	 * </p>
	 * @return int タイムスタンプとしてパースされた値を返します。
	 */
	public function parse ($value, &$position = null) {}

	/**
	 * 文字列をパースして、フィールドベースの時刻値にする
	 * @link http://www.php.net/manual/ja/intldateformatter.localtime.php
	 * @param value string <p>
	 * 時間に変換する文字列。
	 * </p>
	 * @param position int[optional] <p>
	 * $value のパースを開始する位置 (ゼロから数えます)。
	 * $value を処理する前にエラーが発生していない場合は
	 * $parse_pos は -1 となります。それ以外の場合はパースが終了した位置となります
	 * (そしてエラーが発生します)。
	 * この変数には、パースが失敗した場合にその終了位置が含まれます。
	 * $parse_pos > strlen($value) の場合、パースは即時に失敗します。
	 * </p>
	 * @return array Localtime 互換の、整数値の配列を返します。
	 * tm_hour フィールド内の、24 時間制の時刻の値を含みます。
	 */
	public function localtime ($value, &$position = null) {}

	/**
	 * 直近の操作のエラーコードを取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.geterrorcode.php
	 * @return int エラーコードを返します。UErrorCode のいずれかの値となります。初期値は U_ZERO_ERROR です。
	 */
	public function getErrorCode () {}

	/**
	 * 直近の操作のエラーテキストを取得する
	 * @link http://www.php.net/manual/ja/intldateformatter.geterrormessage.php
	 * @return string 直近のエラーの説明を返します。
	 */
	public function getErrorMessage () {}

}

class ResourceBundle implements Traversable {

	/**
	 * @param locale
	 * @param bundlename
	 * @param fallback[optional]
	 */
	public function __construct ($locale, $bundlename, $fallback) {}

	/**
	 * リソースバンドルを作成する
	 * @link http://www.php.net/manual/ja/resourcebundle.create.php
	 * @param locale string <p>
	 * リソースバンドルを読み込むロケール (en_CA などのロケール名)。
	 * </p>
	 * @param bundlename string <p>
	 * データが格納されているディレクトリ、あるいは .dat ファイル名。
	 * </p>
	 * @param fallback bool[optional] <p>
	 * ロケールを完全一致とするか、あるいは代替として親ロケールを使うことを許可するか。
	 * </p>
	 * @return ResourceBundle ResourceBundle オブジェクト、あるいはエラー時に FALSE を返します。
	 */
	public static function create ($locale, $bundlename, $fallback = null) {}

	/**
	 * バンドルからデータを取得する
	 * @link http://www.php.net/manual/ja/resourcebundle.get.php
	 * @param index string|int <p>
	 * データのインデックス。文字列あるいは整数値となります。
	 * </p>
	 * @return mixed 指定したインデックスのデータ、あるいはエラー時に NULL を返します。
	 * 文字列、整数値、バイナリデータ文字列は、それぞれに対応する PHP の型として返します。
	 * 整数の配列は PHP の配列として返します。複雑な型は
	 * ResourceBundle オブジェクトとして返します。
	 */
	public function get ($index) {}

	/**
	 * バンドル内の要素数を取得する
	 * @link http://www.php.net/manual/ja/resourcebundle.count.php
	 * @return int バンドル内の要素数を返します。
	 */
	public function count () {}

	/**
	 * サポートするロケールを取得する
	 * @link http://www.php.net/manual/ja/resourcebundle.locales.php
	 * @param bundlename string <p>
	 * ロケールを取得したい ResourceBundle のパス、あるいは
	 * 空文字列を指定するとデフォルトのロケール一覧を取得できます。
	 * </p>
	 * @return array このバンドルがサポートするロケールの一覧を返します。
	 */
	public static function getLocales ($bundlename) {}

	/**
	 * バンドルの直近のエラーコードを取得する
	 * @link http://www.php.net/manual/ja/resourcebundle.geterrorcode.php
	 * @return int バンドルオブジェクトの最後の関数コールからのエラーコードを返します。
	 */
	public function getErrorCode () {}

	/**
	 * バンドルの直近のエラーメッセージを取得する
	 * @link http://www.php.net/manual/ja/resourcebundle.geterrormessage.php
	 * @return string バンドルオブジェクトの最後の関数コールからのエラーメッセージを返します。
	 */
	public function getErrorMessage () {}

}

/**
 * @param arg1
 */
function collator_create ($arg1) {}

/**
 * @param object Collator
 * @param arg1
 * @param arg2
 */
function collator_compare (Collator $object, $arg1, $arg2) {}

/**
 * @param object Collator
 * @param arg1
 */
function collator_get_attribute (Collator $object, $arg1) {}

/**
 * @param object Collator
 * @param arg1
 * @param arg2
 */
function collator_set_attribute (Collator $object, $arg1, $arg2) {}

/**
 * @param object Collator
 */
function collator_get_strength (Collator $object) {}

/**
 * @param object Collator
 * @param arg1
 */
function collator_set_strength (Collator $object, $arg1) {}

/**
 * @param object Collator
 * @param arr
 * @param sort_flags[optional]
 */
function collator_sort (Collator $objectarray , &$arr, $sort_flags) {}

/**
 * @param object Collator
 * @param arr
 * @param sort_flags[optional]
 */
function collator_sort_with_sort_keys (Collator $objectarray , &$arr, $sort_flags) {}

/**
 * @param object Collator
 * @param arr
 * @param sort_flags[optional]
 */
function collator_asort (Collator $objectarray , &$arr, $sort_flags) {}

/**
 * @param object Collator
 * @param arg1
 */
function collator_get_locale (Collator $object, $arg1) {}

/**
 * @param object Collator
 */
function collator_get_error_code (Collator $object) {}

/**
 * @param object Collator
 */
function collator_get_error_message (Collator $object) {}

/**
 * @param object Collator
 * @param arg1
 * @param arg2
 */
function collator_get_sort_key (Collator $object, $arg1, $arg2) {}

/**
 * @param locale
 * @param style
 * @param pattern[optional]
 */
function numfmt_create ($locale, $style, $pattern) {}

/**
 * @param nf
 * @param num
 * @param type[optional]
 */
function numfmt_format ($nf, $num, $type) {}

/**
 * @param formatter
 * @param string
 * @param type[optional]
 * @param position[optional]
 */
function numfmt_parse ($formatter, $string, $type, &$position) {}

/**
 * @param nf
 * @param num
 * @param currency
 */
function numfmt_format_currency ($nf, $num, $currency) {}

/**
 * @param formatter
 * @param string
 * @param currency
 * @param position[optional]
 */
function numfmt_parse_currency ($formatter, $string, &$currency, &$position) {}

/**
 * @param nf
 * @param attr
 * @param value
 */
function numfmt_set_attribute ($nf, $attr, $value) {}

/**
 * @param nf
 * @param attr
 */
function numfmt_get_attribute ($nf, $attr) {}

/**
 * @param nf
 * @param attr
 * @param value
 */
function numfmt_set_text_attribute ($nf, $attr, $value) {}

/**
 * @param nf
 * @param attr
 */
function numfmt_get_text_attribute ($nf, $attr) {}

/**
 * @param nf
 * @param attr
 * @param symbol
 */
function numfmt_set_symbol ($nf, $attr, $symbol) {}

/**
 * @param nf
 * @param attr
 */
function numfmt_get_symbol ($nf, $attr) {}

/**
 * @param nf
 * @param pattern
 */
function numfmt_set_pattern ($nf, $pattern) {}

/**
 * @param nf
 */
function numfmt_get_pattern ($nf) {}

/**
 * @param nf
 * @param type[optional]
 */
function numfmt_get_locale ($nf, $type) {}

/**
 * @param nf
 */
function numfmt_get_error_code ($nf) {}

/**
 * @param nf
 */
function numfmt_get_error_message ($nf) {}

/**
 * @param input
 * @param form[optional]
 */
function normalizer_normalize ($input, $form) {}

/**
 * @param input
 * @param form[optional]
 */
function normalizer_is_normalized ($input, $form) {}

/**
 * デフォルトのロケールを取得する
 * @link http://www.php.net/manual/ja/function.locale-get-default.php
 * @return string 現在のロケールを表す文字列を返します。
 */
function locale_get_default () {}

/**
 * デフォルトのロケールを設定する
 * @link http://www.php.net/manual/ja/function.locale-set-default.php
 * @param name string <p>
 * 新しいロケール名。サポートされるロケールの一覧は
 * にあります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function locale_set_default ($name) {}

/**
 * @param arg1
 */
function locale_get_primary_language ($arg1) {}

/**
 * @param arg1
 */
function locale_get_script ($arg1) {}

/**
 * @param arg1
 */
function locale_get_region ($arg1) {}

/**
 * @param arg1
 */
function locale_get_keywords ($arg1) {}

/**
 * @param arg1
 * @param arg2
 */
function locale_get_display_script ($arg1, $arg2) {}

/**
 * @param arg1
 * @param arg2
 */
function locale_get_display_region ($arg1, $arg2) {}

/**
 * @param arg1
 * @param arg2
 */
function locale_get_display_name ($arg1, $arg2) {}

/**
 * @param arg1
 * @param arg2
 */
function locale_get_display_language ($arg1, $arg2) {}

/**
 * @param arg1
 * @param arg2
 */
function locale_get_display_variant ($arg1, $arg2) {}

/**
 * @param arg1
 */
function locale_compose ($arg1) {}

/**
 * @param arg1
 */
function locale_parse ($arg1) {}

/**
 * @param arg1
 */
function locale_get_all_variants ($arg1) {}

/**
 * @param arg1
 * @param arg2
 * @param arg3
 */
function locale_filter_matches ($arg1, $arg2, $arg3) {}

/**
 * @param arg1
 */
function locale_canonicalize ($arg1) {}

/**
 * @param arg1
 * @param arg2
 * @param arg3
 * @param arg4
 */
function locale_lookup ($arg1, $arg2, $arg3, $arg4) {}

/**
 * @param arg1
 */
function locale_accept_from_http ($arg1) {}

/**
 * @param locale
 * @param pattern
 */
function msgfmt_create ($locale, $pattern) {}

/**
 * @param nf
 * @param args
 */
function msgfmt_format ($nf, $args) {}

/**
 * @param locale
 * @param pattern
 * @param args
 */
function msgfmt_format_message ($locale, $pattern, $args) {}

/**
 * @param nf
 * @param source
 */
function msgfmt_parse ($nf, $source) {}

/**
 * @param locale
 * @param pattern
 * @param source
 */
function msgfmt_parse_message ($locale, $pattern, $source) {}

/**
 * @param mf
 * @param pattern
 */
function msgfmt_set_pattern ($mf, $pattern) {}

/**
 * @param mf
 */
function msgfmt_get_pattern ($mf) {}

/**
 * @param mf
 */
function msgfmt_get_locale ($mf) {}

/**
 * @param nf
 */
function msgfmt_get_error_code ($nf) {}

/**
 * @param coll
 */
function msgfmt_get_error_message ($coll) {}

/**
 * @param locale
 * @param date_type
 * @param time_type
 * @param timezone_str[optional]
 * @param calendar[optional]
 * @param pattern[optional]
 */
function datefmt_create ($locale, $date_type, $time_type, $timezone_str, $calendar, $pattern) {}

/**
 * @param mf
 */
function datefmt_get_datetype ($mf) {}

/**
 * @param mf
 */
function datefmt_get_timetype ($mf) {}

/**
 * @param mf
 */
function datefmt_get_calendar ($mf) {}

/**
 * @param mf
 * @param calendar
 */
function datefmt_set_calendar ($mf, $calendar) {}

/**
 * @param mf
 */
function datefmt_get_locale ($mf) {}

/**
 * @param mf
 */
function datefmt_get_timezone_id ($mf) {}

/**
 * @param mf
 */
function datefmt_set_timezone_id ($mf) {}

/**
 * @param mf
 */
function datefmt_get_pattern ($mf) {}

/**
 * @param mf
 * @param pattern
 */
function datefmt_set_pattern ($mf, $pattern) {}

/**
 * @param mf
 */
function datefmt_is_lenient ($mf) {}

/**
 * @param mf
 */
function datefmt_set_lenient ($mf) {}

/**
 * @param args[optional]
 * @param array[optional]
 */
function datefmt_format ($args, $array) {}

/**
 * @param formatter
 * @param string
 * @param position[optional]
 */
function datefmt_parse ($formatter, $string, &$position) {}

/**
 * @param formatter
 * @param string
 * @param position[optional]
 */
function datefmt_localtime ($formatter, $string, &$position) {}

/**
 * @param nf
 */
function datefmt_get_error_code ($nf) {}

/**
 * @param coll
 */
function datefmt_get_error_message ($coll) {}

/**
 * 書記素単位で文字列の長さを取得する
 * @link http://www.php.net/manual/ja/function.grapheme-strlen.php
 * @param input string <p>
 * 長さを調べたい文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @return int 成功した場合に文字列の長さ。文字列が空の場合に 0 を返します。
 */
function grapheme_strlen ($input) {}

/**
 * 文字列内で最初にあらわれる場所の (書記素単位の) 位置を見つける
 * @link http://www.php.net/manual/ja/function.grapheme-strpos.php
 * @param haystack string <p>
 * 探す対象となる文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param needle string <p>
 * 探したい文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param offset int[optional] <p>
 * オプションの $offset パラメータで、$haystack
 * のどの位置 (バイト数や文字数ではなく、書記素単位) から探し始めるのかを指定します。
 * $offset の値にかかわらず、返される値は常に haystack
 * の先頭からの位置になります。
 * </p>
 * @return int 位置を表す整数値を返します。needle が見つからない場合は
 * strpos() は FALSE を返します。
 */
function grapheme_strpos ($haystack, $needle, $offset = null) {}

/**
 * 大文字小文字を区別せず、文字列内で最初にあらわれる場所の (書記素単位の) 位置を見つける
 * @link http://www.php.net/manual/ja/function.grapheme-stripos.php
 * @param haystack string <p>
 * 探す対象となる文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param needle string <p>
 * 探したい文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param offset int[optional] <p>
 * オプションの $offset パラメータで、$haystack
 * のどの位置 (バイト数や文字数ではなく、書記素単位) から探し始めるのかを指定します。
 * $offset の値にかかわらず、返される値は常に haystack
 * の先頭からの位置になります。
 * </p>
 * @return int 位置を表す整数値を返します。needle が見つからない場合は
 * grapheme_stripos() は FALSE を返します。
 */
function grapheme_stripos ($haystack, $needle, $offset = null) {}

/**
 * 文字列内で最後にあらわれる場所の (書記素単位の) 位置を見つける
 * @link http://www.php.net/manual/ja/function.grapheme-strrpos.php
 * @param haystack string <p>
 * 探す対象となる文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param needle string <p>
 * 探したい文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param offset int[optional] <p>
 * オプションの $offset パラメータで、$haystack
 * のどの位置 (バイト数や文字数ではなく、書記素単位) から探し始めるのかを指定します。
 * $offset の値にかかわらず、返される値は常に haystack
 * の先頭からの位置になります。
 * </p>
 * @return int 位置を表す整数値を返します。needle が見つからない場合は
 * grapheme_strrpos() は FALSE を返します。
 */
function grapheme_strrpos ($haystack, $needle, $offset = null) {}

/**
 * 大文字小文字を区別せず、文字列内で最後にあらわれる場所の (書記素単位の) 位置を見つける
 * @link http://www.php.net/manual/ja/function.grapheme-strripos.php
 * @param haystack string <p>
 * 探す対象となる文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param needle string <p>
 * 探したい文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param offset int[optional] <p>
 * オプションの $offset パラメータで、$haystack
 * のどの位置 (バイト数や文字数ではなく、書記素単位) から探し始めるのかを指定します。
 * $offset の値にかかわらず、返される値は常に haystack
 * の先頭からの位置になります。
 * </p>
 * @return int 位置を表す整数値を返します。needle が見つからない場合は
 * grapheme_strripos() は FALSE を返します。
 */
function grapheme_strripos ($haystack, $needle, $offset = null) {}

/**
 * 部分文字列を返す
 * @link http://www.php.net/manual/ja/function.grapheme-substr.php
 * @param string string <p>
 * 入力文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param start int <p>
 * デフォルトの書記素単位での開始位置。
 * $start がゼロ以上である場合は、$string の
 * $start 番目の位置から始まる文字列を返します。位置はゼロから数え始めます。
 * $start が負の場合は、文字列の末尾から数えて
 * $start 番目 (書記素単位) の位置以降の文字列を返します。
 * </p>
 * @param length int[optional] <p>
 * 長さを書記素単位で指定します。
 * $length が正の値の場合は、$start から数えて最大
 * $length 文字までの文字列を返します (文字列全体の長さによって変わります)。
 * $length が負の値の場合は、文字列の末尾から多くの書記素が削除されます
 * (start が負の場合にはまず開始位置を算出してから行います)。
 * $start がこの削除された場所以降になる場合は、FALSE を返します。
 * </p>
 * @return int $string の部分文字列を返します。
 */
function grapheme_substr ($string, $start, $length = null) {}

/**
 * haystack 文字列の中で、needle が最初に登場した場所以降の部分文字列を返す
 * @link http://www.php.net/manual/ja/function.grapheme-strstr.php
 * @param haystack string <p>
 * 入力文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param needle string <p>
 * 探したい文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param before_needle bool[optional] <p>
 * TRUE の場合、grapheme_strstr()
 * は needle が最初に登場した場所より前の部分文字列を返します (needle は含めません)。
 * </p>
 * @return string 部分文字列、あるいは needle が見つからなかった場合に FALSE を返します。
 */
function grapheme_strstr ($haystack, $needle, $before_needle = null) {}

/**
 * 大文字小文字を区別せず、haystack 文字列の中で needle が最初に登場した場所以降の部分文字列を返す
 * @link http://www.php.net/manual/ja/function.grapheme-stristr.php
 * @param haystack string <p>
 * 入力文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param needle string <p>
 * 探したい文字列。正しい形式の UTF-8 でなければなりません。
 * </p>
 * @param before_needle bool[optional] <p>
 * TRUE の場合、grapheme_strstr()
 * は needle が最初に登場した場所より前の部分文字列を返します (needle は含めません)。
 * </p>
 * @return string $haystack の部分文字列、あるいは $needle が見つからなかった場合に FALSE を返します。
 */
function grapheme_stristr ($haystack, $needle, $before_needle = null) {}

/**
 * デフォルトの書記素クラスタシーケンスをテキストバッファから取り出す関数。
   テキストは UTF-8 でエンコードされている必要があります
 * @link http://www.php.net/manual/ja/function.grapheme-extract.php
 * @param haystack string <p>
 * 検索する文字列。
 * </p>
 * @param size int <p>
 * 返す項目 ($extract_type に基づく) の最大数。
 * </p>
 * @param extract_type int[optional] <p>
 * $size パラメータの単位の形式を指定します。
 * </p>
 * <p>
 * GRAPHEME_EXTR_COUNT (default) - $size は、
 * 抽出するデフォルト書記素クラスタの数です。
 * GRAPHEME_EXTR_MAXBYTES - $size は、返すバイト数の最大値です。
 * GRAPHEME_EXTR_MAXCHARS - $size は、返す UTF-8 文字数の最大値です。
 * </p>
 * @param start int[optional] <p>
 * $haystack 内での開始位置をバイト数で指定します。
 * 指定する場合は、0 から $haystack のバイト数までの値でなければなりません。
 * $start が指す位置が UTF-8 文字の先頭バイトでない場合は、
 * その次の文字の先頭から開始します。
 * </p>
 * @param next int[optional] <p>
 * 次の開始位置への参照が設定されます。
 * この関数をコールすると、文字列の最後の部分の先頭バイトを指すことになります。
 * </p>
 * @return string オフセット $start から始まり、
 * 指定した $size と $extract_type を満たす、
 * デフォルトの書記素クラスタバウンダリで終わる文字列を返します。
 */
function grapheme_extract ($haystack, $size, $extract_type = null, $start = null, &$next = null) {}

/**
 * ドメイン名をIDNAのASCII形式に変換する
 * @link http://www.php.net/manual/ja/function.idn-to-ascii.php
 * @param utf8_domain string <p>
 * UTF-8 エンコードされたドメイン名。
 * <p>
 * たとえば ISO-8859-1 (Western Europe latin1) エンコードの文字列を渡したりすると、
 * ACE エンコードされた "xn--" 文字列に変換されます。
 * しかし、これはきっとお望みのものではないでしょう!
 * </p>
 * </p>
 * @param errorcode int[optional] <p>
 * IDNA エラーコードが設定されます。
 * </p>
 * @param domain string <p>
 * 変換するドメイン名 PHP5 では、UTF-8にエンコードされている必要があります。
 * </p>
 * @param options int[optional] <p>
 * 変換オプション - IDNA_ ではじまる定数
 * (IDNA_ERROR_* 定数を除く) の組み合わせです。
 * </p>
 * @param variant int[optional] <p>
 * IDNA 2003 の場合は INTL_IDNA_VARIANT_2003、あるいは
 * UTS #46 の場合は INTL_IDNA_VARIANT_UTS46。
 * </p>
 * @param idna_info array[optional] <p>
 * このパラメータを使うのは、variant が
 * INTL_IDNA_VARIANT_UTS46 の場合だけです。
 * このとき、このパラメータには 'result'、
 * 'isTransitionalDifferent'、そして
 * 'errors' の三つのキーを含む配列が入ります。
 * 'result' にはおそらく不正だと考えられる変換結果、
 * 'isTransitionalDifferent' には
 * UTS #46 の非移行的な機能を使って結果を変更したかどうかをあらわす boolean 値、そして
 * 'errors' はエラー定数 IDNA_ERROR_*
 * のビットセットを表します。
 * </p>
 * @return string IDNA のASCII形式でエンコードされたドメイン名。失敗した場合に FALSE を返します
 */
function idn_to_ascii ($utf8_domain, &$errorcode = null, $domain, $options = null, $variant = null, array &$idna_info = null) {}

/**
 * IDNAのASCII方式でエンコードされたドメイン名をUnicodeに変換する
 * @link http://www.php.net/manual/ja/function.idn-to-utf8.php
 * @param ascii_domain string <p>
 * ASCII エンコードされたドメイン名。非 ASCII 文字が含まれていた場合は "xn--..." のようになります。
 * </p>
 * @param errorcode int[optional] <p>
 * IDNA エラーコードが設定されます。
 * </p>
 * @param domain string <p>
 * IDNAのASCII方式でエンコードされた、変換対象のドメイン名
 * </p>
 * @param options int[optional] <p>
 * 変換オプション - IDNA_ ではじまる定数
 * (IDNA_ERROR_* 定数を除く) の組み合わせです
 * </p>
 * @param variant int[optional] <p>
 * IDNA 2003 の場合は INTL_IDNA_VARIANT_2003、あるいは
 * UTS #46 の場合は INTL_IDNA_VARIANT_UTS46。
 * </p>
 * @param idna_info array[optional] <p>
 * このパラメータを使うのは、variant が
 * INTL_IDNA_VARIANT_UTS46 の場合だけです。
 * このとき、このパラメータには 'result'、
 * 'isTransitionalDifferent'、そして
 * 'errors' の三つのキーを含む配列が入ります。
 * 'result' にはおそらく不正だと考えられる変換結果、
 * 'isTransitionalDifferent' には
 * UTS #46 の非移行的な機能を使って結果を変更したかどうかをあらわす boolean 値、そして
 * 'errors' はエラー定数 IDNA_ERROR_*
 * のビットセットを表します。
 * </p>
 * @return string Unicodeのドメイン名。UTF-8 にエンコードされています。失敗した場合に FALSE を返します
 */
function idn_to_utf8 ($ascii_domain, &$errorcode = null, $domain, $options = null, $variant = null, array &$idna_info = null) {}

/**
 * @param locale
 * @param bundlename
 * @param fallback[optional]
 */
function resourcebundle_create ($locale, $bundlename, $fallback) {}

/**
 * @param bundle
 * @param index
 * @param fallback[optional]
 */
function resourcebundle_get ($bundle, $index, $fallback) {}

/**
 * @param bundle
 */
function resourcebundle_count ($bundle) {}

/**
 * @param bundlename
 */
function resourcebundle_locales ($bundlename) {}

/**
 * @param bundle
 */
function resourcebundle_get_error_code ($bundle) {}

/**
 * @param bundle
 */
function resourcebundle_get_error_message ($bundle) {}

/**
 * 直近のエラーコードを取得する
 * @link http://www.php.net/manual/ja/function.intl-get-error-code.php
 * @return int 直近の API 関数のコールが返すエラーコードを返します。
 */
function intl_get_error_code () {}

/**
 * 直近のエラーの説明を取得する
 * @link http://www.php.net/manual/ja/function.intl-get-error-message.php
 * @return string 直近の API 関数のコールで発生したエラーの説明を返します。
 */
function intl_get_error_message () {}

/**
 * 指定したエラーコードが失敗を表すかどうかを調べる
 * @link http://www.php.net/manual/ja/function.intl-is-failure.php
 * @param error_code int <p>
 * intl_get_error_code や
 * collator_get_error_code
 * が返す値。
 * </p>
 * @return bool そのコードが何らかの失敗を意味する場合に TRUE、
 * 成功あるいは警告を意味する場合に FALSE
 * を返します。
 */
function intl_is_failure ($error_code) {}

/**
 * 指定したエラーコードに対応する名前を取得する
 * @link http://www.php.net/manual/ja/function.intl-error-name.php
 * @param error_code int <p>
 * ICU のエラーコード。
 * </p>
 * @return string エラーコード定数と同じ名前の文字列を返します。
 */
function intl_error_name ($error_code) {}


/**
 * ロケール名の長さの制限。PHP コード内では 80 文字までに制限されており、
 * それより長いロケール名は使用できません。
 * @link http://www.php.net/manual/ja/intl.constants.php
 */
define ('INTL_MAX_LOCALE_LEN', 80);
define ('INTL_ICU_VERSION', "49.1.2");
define ('INTL_ICU_DATA_VERSION', "49.1.2");
define ('ULOC_ACTUAL_LOCALE', 0);
define ('ULOC_VALID_LOCALE', 1);
define ('GRAPHEME_EXTR_COUNT', 0);
define ('GRAPHEME_EXTR_MAXBYTES', 1);
define ('GRAPHEME_EXTR_MAXCHARS', 2);
define ('U_USING_FALLBACK_WARNING', -128);
define ('U_ERROR_WARNING_START', -128);
define ('U_USING_DEFAULT_WARNING', -127);
define ('U_SAFECLONE_ALLOCATED_WARNING', -126);
define ('U_STATE_OLD_WARNING', -125);
define ('U_STRING_NOT_TERMINATED_WARNING', -124);
define ('U_SORT_KEY_TOO_SHORT_WARNING', -123);
define ('U_AMBIGUOUS_ALIAS_WARNING', -122);
define ('U_DIFFERENT_UCA_VERSION', -121);
define ('U_ERROR_WARNING_LIMIT', -119);
define ('U_ZERO_ERROR', 0);
define ('U_ILLEGAL_ARGUMENT_ERROR', 1);
define ('U_MISSING_RESOURCE_ERROR', 2);
define ('U_INVALID_FORMAT_ERROR', 3);
define ('U_FILE_ACCESS_ERROR', 4);
define ('U_INTERNAL_PROGRAM_ERROR', 5);
define ('U_MESSAGE_PARSE_ERROR', 6);
define ('U_MEMORY_ALLOCATION_ERROR', 7);
define ('U_INDEX_OUTOFBOUNDS_ERROR', 8);
define ('U_PARSE_ERROR', 9);
define ('U_INVALID_CHAR_FOUND', 10);
define ('U_TRUNCATED_CHAR_FOUND', 11);
define ('U_ILLEGAL_CHAR_FOUND', 12);
define ('U_INVALID_TABLE_FORMAT', 13);
define ('U_INVALID_TABLE_FILE', 14);
define ('U_BUFFER_OVERFLOW_ERROR', 15);
define ('U_UNSUPPORTED_ERROR', 16);
define ('U_RESOURCE_TYPE_MISMATCH', 17);
define ('U_ILLEGAL_ESCAPE_SEQUENCE', 18);
define ('U_UNSUPPORTED_ESCAPE_SEQUENCE', 19);
define ('U_NO_SPACE_AVAILABLE', 20);
define ('U_CE_NOT_FOUND_ERROR', 21);
define ('U_PRIMARY_TOO_LONG_ERROR', 22);
define ('U_STATE_TOO_OLD_ERROR', 23);
define ('U_TOO_MANY_ALIASES_ERROR', 24);
define ('U_ENUM_OUT_OF_SYNC_ERROR', 25);
define ('U_INVARIANT_CONVERSION_ERROR', 26);
define ('U_INVALID_STATE_ERROR', 27);
define ('U_COLLATOR_VERSION_MISMATCH', 28);
define ('U_USELESS_COLLATOR_ERROR', 29);
define ('U_NO_WRITE_PERMISSION', 30);
define ('U_STANDARD_ERROR_LIMIT', 31);
define ('U_BAD_VARIABLE_DEFINITION', 65536);
define ('U_PARSE_ERROR_START', 65536);
define ('U_MALFORMED_RULE', 65537);
define ('U_MALFORMED_SET', 65538);
define ('U_MALFORMED_SYMBOL_REFERENCE', 65539);
define ('U_MALFORMED_UNICODE_ESCAPE', 65540);
define ('U_MALFORMED_VARIABLE_DEFINITION', 65541);
define ('U_MALFORMED_VARIABLE_REFERENCE', 65542);
define ('U_MISMATCHED_SEGMENT_DELIMITERS', 65543);
define ('U_MISPLACED_ANCHOR_START', 65544);
define ('U_MISPLACED_CURSOR_OFFSET', 65545);
define ('U_MISPLACED_QUANTIFIER', 65546);
define ('U_MISSING_OPERATOR', 65547);
define ('U_MISSING_SEGMENT_CLOSE', 65548);
define ('U_MULTIPLE_ANTE_CONTEXTS', 65549);
define ('U_MULTIPLE_CURSORS', 65550);
define ('U_MULTIPLE_POST_CONTEXTS', 65551);
define ('U_TRAILING_BACKSLASH', 65552);
define ('U_UNDEFINED_SEGMENT_REFERENCE', 65553);
define ('U_UNDEFINED_VARIABLE', 65554);
define ('U_UNQUOTED_SPECIAL', 65555);
define ('U_UNTERMINATED_QUOTE', 65556);
define ('U_RULE_MASK_ERROR', 65557);
define ('U_MISPLACED_COMPOUND_FILTER', 65558);
define ('U_MULTIPLE_COMPOUND_FILTERS', 65559);
define ('U_INVALID_RBT_SYNTAX', 65560);
define ('U_INVALID_PROPERTY_PATTERN', 65561);
define ('U_MALFORMED_PRAGMA', 65562);
define ('U_UNCLOSED_SEGMENT', 65563);
define ('U_ILLEGAL_CHAR_IN_SEGMENT', 65564);
define ('U_VARIABLE_RANGE_EXHAUSTED', 65565);
define ('U_VARIABLE_RANGE_OVERLAP', 65566);
define ('U_ILLEGAL_CHARACTER', 65567);
define ('U_INTERNAL_TRANSLITERATOR_ERROR', 65568);
define ('U_INVALID_ID', 65569);
define ('U_INVALID_FUNCTION', 65570);
define ('U_PARSE_ERROR_LIMIT', 65571);
define ('U_UNEXPECTED_TOKEN', 65792);
define ('U_FMT_PARSE_ERROR_START', 65792);
define ('U_MULTIPLE_DECIMAL_SEPARATORS', 65793);
define ('U_MULTIPLE_DECIMAL_SEPERATORS', 65793);
define ('U_MULTIPLE_EXPONENTIAL_SYMBOLS', 65794);
define ('U_MALFORMED_EXPONENTIAL_PATTERN', 65795);
define ('U_MULTIPLE_PERCENT_SYMBOLS', 65796);
define ('U_MULTIPLE_PERMILL_SYMBOLS', 65797);
define ('U_MULTIPLE_PAD_SPECIFIERS', 65798);
define ('U_PATTERN_SYNTAX_ERROR', 65799);
define ('U_ILLEGAL_PAD_POSITION', 65800);
define ('U_UNMATCHED_BRACES', 65801);
define ('U_UNSUPPORTED_PROPERTY', 65802);
define ('U_UNSUPPORTED_ATTRIBUTE', 65803);
define ('U_FMT_PARSE_ERROR_LIMIT', 65810);
define ('U_BRK_INTERNAL_ERROR', 66048);
define ('U_BRK_ERROR_START', 66048);
define ('U_BRK_HEX_DIGITS_EXPECTED', 66049);
define ('U_BRK_SEMICOLON_EXPECTED', 66050);
define ('U_BRK_RULE_SYNTAX', 66051);
define ('U_BRK_UNCLOSED_SET', 66052);
define ('U_BRK_ASSIGN_ERROR', 66053);
define ('U_BRK_VARIABLE_REDFINITION', 66054);
define ('U_BRK_MISMATCHED_PAREN', 66055);
define ('U_BRK_NEW_LINE_IN_QUOTED_STRING', 66056);
define ('U_BRK_UNDEFINED_VARIABLE', 66057);
define ('U_BRK_INIT_ERROR', 66058);
define ('U_BRK_RULE_EMPTY_SET', 66059);
define ('U_BRK_UNRECOGNIZED_OPTION', 66060);
define ('U_BRK_MALFORMED_RULE_TAG', 66061);
define ('U_BRK_ERROR_LIMIT', 66062);
define ('U_REGEX_INTERNAL_ERROR', 66304);
define ('U_REGEX_ERROR_START', 66304);
define ('U_REGEX_RULE_SYNTAX', 66305);
define ('U_REGEX_INVALID_STATE', 66306);
define ('U_REGEX_BAD_ESCAPE_SEQUENCE', 66307);
define ('U_REGEX_PROPERTY_SYNTAX', 66308);
define ('U_REGEX_UNIMPLEMENTED', 66309);
define ('U_REGEX_MISMATCHED_PAREN', 66310);
define ('U_REGEX_NUMBER_TOO_BIG', 66311);
define ('U_REGEX_BAD_INTERVAL', 66312);
define ('U_REGEX_MAX_LT_MIN', 66313);
define ('U_REGEX_INVALID_BACK_REF', 66314);
define ('U_REGEX_INVALID_FLAG', 66315);
define ('U_REGEX_LOOK_BEHIND_LIMIT', 66316);
define ('U_REGEX_SET_CONTAINS_STRING', 66317);
define ('U_REGEX_ERROR_LIMIT', 66324);
define ('U_STRINGPREP_PROHIBITED_ERROR', 66560);
define ('U_STRINGPREP_UNASSIGNED_ERROR', 66561);
define ('U_STRINGPREP_CHECK_BIDI_ERROR', 66562);
define ('U_ERROR_LIMIT', 66818);

/**
 * IDN 関数の入力で、アサインされていないコードポイントの処理を拒否し、
 * 入力がドメイン名 ASCII 規則を満たすかどうかをチェックしません。
 * @link http://www.php.net/manual/ja/intl.constants.php
 */
define ('IDNA_DEFAULT', 0);

/**
 * IDN 関数の入力で、アサインされていないコードポイントの処理を許可します。
 * @link http://www.php.net/manual/ja/intl.constants.php
 */
define ('IDNA_ALLOW_UNASSIGNED', 1);

/**
 * IDN 関数の入力がドメイン名 ASCII 規則を満たすかどうかをチェックします。
 * @link http://www.php.net/manual/ja/intl.constants.php
 */
define ('IDNA_USE_STD3_RULES', 2);

// End of intl v.1.1.0
?>
