<?php

// Start of openssl v.

/**
 * 秘密鍵を開放する
 * @link http://www.php.net/manual/ja/function.openssl-pkey-free.php
 * @param key resource <p>
 * キーを保持するリソース。
 * </p>
 * @return void 値を返しません。
 */
function openssl_pkey_free ($key) {}

/**
 * 新規に秘密鍵を生成する
 * @link http://www.php.net/manual/ja/function.openssl-pkey-new.php
 * @param configargs array[optional] <p>
 * 鍵の作成方法の詳細（ビット数など）を指定するには、
 * configargs を使用します。
 * configargs の詳細な情報については
 * openssl_csr_new を参照ください。
 * </p>
 * @return resource 成功した場合に秘密鍵のリソース ID、
 * エラー時に FALSE を返します。
 */
function openssl_pkey_new (array $configargs = null) {}

/**
 * エクスポート可能な形式で、キーを文字列に取得する
 * @link http://www.php.net/manual/ja/function.openssl-pkey-export.php
 * @param key mixed <p>
 * </p>
 * @param out string <p>
 * </p>
 * @param passphrase string[optional] <p>
 * オプションで passphrase
 * を使用してキーを保護することが可能です。
 * </p>
 * @param configargs array[optional] <p>
 * configargs により openssl 設定ファイルの設定を
 * 追加したり上書きしたりすることで、エクスポート処理の詳細設定が可能です。
 * configargs についての詳細な情報は
 * openssl_csr_new を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkey_export ($key, &$out, $passphrase = null, array $configargs = null) {}

/**
 * エクスポート可能な形式で、キーをファイルに取得する
 * @link http://www.php.net/manual/ja/function.openssl-pkey-export-to-file.php
 * @param key mixed <p>
 * </p>
 * @param outfilename string <p>
 * 出力ファイルへのパス。
 * </p>
 * @param passphrase string[optional] <p>
 * オプションで
 * passphrase を使用してキーを保護することが可能です。
 * </p>
 * @param configargs array[optional] <p>
 * configargs により openssl 設定ファイルの設定を
 * 追加したり上書きしたりすることで、エクスポート処理の詳細設定が可能です。
 * configargs についての詳細な情報は
 * openssl_csr_new を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkey_export_to_file ($key, $outfilename, $passphrase = null, array $configargs = null) {}

/**
 * 秘密鍵を取得する
 * @link http://www.php.net/manual/ja/function.openssl-pkey-get-private.php
 * @param key mixed <p>
 * key は以下のいずれかです。
 * file://path/to/file.pem 形式の文字列。
 * このファイルは、PEM エンコードされた証明書/秘密鍵である必要が
 * あります（両方を含むことも可能です）。
 * @param passphrase string[optional] <p>
 * 指定されたキーが（パスフレーズを用いて）暗号化されている場合は、
 * オプションのパラメータ passphrase を使用する必要があります。
 * </p>
 * @return resource 成功した場合に正のキーリソース ID、エラー時に FALSE を返します。
 */
function openssl_pkey_get_private ($key, $passphrase = null) {}

/**
 * 証明書から公開鍵を抽出し、使用できるようにする
 * @link http://www.php.net/manual/ja/function.openssl-pkey-get-public.php
 * @param certificate mixed <p>
 * certificate は以下のいずれかです。
 * an X.509 証明書リソース
 * @return resource 成功した場合に正のキーリソース ID、エラー時に FALSE を返します。
 */
function openssl_pkey_get_public ($certificate) {}

/**
 * キーの詳細の配列を返す
 * @link http://www.php.net/manual/ja/function.openssl-pkey-get-details.php
 * @param key resource <p>
 * キーを保持する配列。
 * </p>
 * @return array 成功した場合にキーの詳細を含む配列、失敗した場合に FALSE を返します。
 * 返される配列のキーは bits (ビット数)、
 * key (公開鍵を表す文字列) および
 * type (キーの種類。
 * OPENSSL_KEYTYPE_RSA、
 * OPENSSL_KEYTYPE_DSA、
 * OPENSSL_KEYTYPE_DH、
 * OPENSSL_KEYTYPE_EC のいずれか。あるいは不明な場合は -1)
 * となります。
 * </p>
 * <p>
 * 使っているキーの型によって、さらに詳細が返されます。
 * 常に存在するわけではない要素もあることに注意しましょう。
 */
function openssl_pkey_get_details ($key) {}

/**
 * キーリソースを開放する
 * @link http://www.php.net/manual/ja/function.openssl-free-key.php
 * @param key_identifier resource <p>
 * </p>
 * @return void 値を返しません。
 */
function openssl_free_key ($key_identifier) {}

/**
 * <function>openssl_pkey_get_private</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.openssl-get-privatekey.php
 * @param key
 * @param passphrase[optional]
 */
function openssl_get_privatekey ($key, $passphrase) {}

/**
 * <function>openssl_pkey_get_public</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.openssl-get-publickey.php
 * @param cert
 */
function openssl_get_publickey ($cert) {}

/**
 * X.509 証明書をパースし、リソース ID を返す
 * @link http://www.php.net/manual/ja/function.openssl-x509-read.php
 * @param x509certdata mixed <p>
 * </p>
 * @return resource 成功した場合にリソース ID、失敗した場合に FALSE を返します。
 */
function openssl_x509_read ($x509certdata) {}

/**
 * 証明書リソースを開放する
 * @link http://www.php.net/manual/ja/function.openssl-x509-free.php
 * @param x509cert resource <p>
 * </p>
 * @return void 値を返しません。
 */
function openssl_x509_free ($x509cert) {}

/**
 * X509 証明書をパースし、配列として情報を返す
 * @link http://www.php.net/manual/ja/function.openssl-x509-parse.php
 * @param x509cert mixed <p>
 * </p>
 * @param shortnames bool[optional] <p>
 * shortnames は、配列中でのデータの添字付けの
 * 方法を設定します。shortnames が TRUE の場合
 * (デフォルト)、フィールドは短縮型で添字が付けられます。そうでない場合、
 * 長い名前が使用されます。例えば、CN は commonName の短縮型です。
 * </p>
 * @return array 返されるデータの構造については（わざと）まだ文書化していません。
 * これは、今後もデータの構造が変更される可能性があるためです。
 */
function openssl_x509_parse ($x509cert, $shortnames = null) {}

/**
 * 証明書が特定の目的に使用可能かどうか確認する
 * @link http://www.php.net/manual/ja/function.openssl-x509-checkpurpose.php
 * @param x509cert mixed <p>
 * 調べたい証明書。
 * </p>
 * @param purpose int <p>
 * <table>
 * openssl_x509_checkpurpose の目的
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SSL_CLIENT</td>
 * <td>
 * この証明書を SSL 接続のクライアント側で使用できるか?
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SSL_SERVER</td>
 * <td>
 * この証明書を SSL 接続のサーバー側で使用できるか?
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_NS_SSL_SERVER</td>
 * <td>この証明書を Netscape SSL サーバーで使用できるか?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SMIME_SIGN</td>
 * <td>この証明書を S/MIME email で使用できるか?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SMIME_ENCRYPT</td>
 * <td>この証明書を S/MIME email の暗号化で使用できるか?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_CRL_SIGN</td>
 * <td>
 * この証明書を証明書取消リスト(CRL)にサインをする際に使用できるか?
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_ANY</td>
 * <td>この証明書をあらゆる用途に使用できるか?</td>
 * </tr>
 * </table>
 * これらのオプションはビットフィールドではありません。
 * 指定できるのは一つだけです!
 * </p>
 * @param cainfo array[optional] <p>
 * cainfo は、証明書の認証
 * で説明したような信頼できる CA ファイル/ディレクトリの配列です。
 * </p>
 * @param untrustedfile string[optional] <p>
 * 指定した場合は、これが証明書を含むPEMエンコードされたファイルの名前になります。
 * この証明書は、検証と証明を簡単化するために使用されます。
 * そのファイル内にある証明書は、信頼されない(untrusted)証明書とみなされます。
 * </p>
 * @return int 証明書が意図した目的に使用可能である場合に TRUE、使用できない場合に
 * FALSE 、エラーの場合に -1 を返します。
 */
function openssl_x509_checkpurpose ($x509cert, $purpose, array $cainfo = null, $untrustedfile = null) {}

/**
 * 秘密鍵が証明書に対応するかを確認する
 * @link http://www.php.net/manual/ja/function.openssl-x509-check-private-key.php
 * @param cert mixed <p>
 * 証明書。
 * </p>
 * @param key mixed <p>
 * 秘密鍵。
 * </p>
 * @return bool key が
 * cert に対応する秘密鍵の場合に
 * TRUE、それ以外の場合に FALSE を返します。
 */
function openssl_x509_check_private_key ($cert, $key) {}

/**
 * 証明書を文字列としてエクスポートする
 * @link http://www.php.net/manual/ja/function.openssl-x509-export.php
 * @param x509 mixed <p>
 * 使用できる値の一覧は
 * キー/証明書パラメータ を参照ください。
 * </p>
 * @param output string <p>
 * 成功した場合に、ここに PEM が格納されます。
 * </p>
 * @param notext bool[optional] オプションのパラメータ notext
 * を設定すると、出力内容の冗長性が変化します。FALSE を指定すると、
 * 人間が読むための追加情報が出力に含まれるようになります。
 * notext のデフォルト値は TRUE です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_x509_export ($x509, &$output, $notext = null) {}

/**
 * 証明書をファイルにエクスポートする
 * @link http://www.php.net/manual/ja/function.openssl-x509-export-to-file.php
 * @param x509 mixed <p>
 * 使用できる値の一覧は
 * キー/証明書パラメータ を参照ください。
 * </p>
 * @param outfilename string <p>
 * 出力ファイルへのパス。
 * </p>
 * @param notext bool[optional] オプションのパラメータ notext
 * を設定すると、出力内容の冗長性が変化します。FALSE を指定すると、
 * 人間が読むための追加情報が出力に含まれるようになります。
 * notext のデフォルト値は TRUE です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_x509_export_to_file ($x509, $outfilename, $notext = null) {}

/**
 * PKCS#12 互換の証明書保存ファイルを変数にエクスポートする
 * @link http://www.php.net/manual/ja/function.openssl-pkcs12-export.php
 * @param x509 mixed <p>
 * 使用できる値の一覧は
 * キー/証明書パラメータ を参照ください。
 * </p>
 * @param out string <p>
 * 成功した場合に、ここに PKCS#12 が保存されます。
 * </p>
 * @param priv_key mixed <p>
 * PKCS#12 ファイルのプライベートキーコンポーネント。
 * </p>
 * @param pass string <p>
 * PKCS#12 ファイルのロックを解除するためのパスワード。
 * </p>
 * @param args array[optional] <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkcs12_export ($x509, &$out, $priv_key, $pass, array $args = null) {}

/**
 * PKCS#12 互換の証明書保存ファイルをエクスポートする
 * @link http://www.php.net/manual/ja/function.openssl-pkcs12-export-to-file.php
 * @param x509 mixed <p>
 * 使用できる値の一覧は
 * キー/証明書パラメータ を参照ください。
 * </p>
 * @param filename string <p>
 * 出力ファイルへのパス。
 * </p>
 * @param priv_key mixed <p>
 * PKCS#12 ファイルのプライベートキーコンポーネント。
 * </p>
 * @param pass string <p>
 * PKCS#12 ファイルのロックを解除するためのパスワード。
 * </p>
 * @param args array[optional] <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkcs12_export_to_file ($x509, $filename, $priv_key, $pass, array $args = null) {}

/**
 * PKCS#12 認証ストアをパースして配列形式にする
 * @link http://www.php.net/manual/ja/function.openssl-pkcs12-read.php
 * @param pkcs12 string <p>
 * </p>
 * @param certs array <p>
 * 成功した場合に、ここに認証ストアデータが格納されます。
 * </p>
 * @param pass string <p>
 * PKCS#12 ファイルのロックを解除するためのパスワード。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkcs12_read ($pkcs12, array &$certs, $pass) {}

/**
 * CSR を作成する
 * @link http://www.php.net/manual/ja/function.openssl-csr-new.php
 * @param dn array <p>
 * 証明書で使用される識別名。
 * </p>
 * @param privkey resource <p>
 * privkey には、事前に openssl_pkey_new
 * （あるいはその他の openssl_pkey 系の関数）で作成した秘密鍵を設定します。
 * これに対応する公開鍵が、CSR への署名に使用されます。
 * </p>
 * @param configargs array[optional] <p>
 * デフォルトでは、システムの openssl.conf の設定に
 * したがってリクエストが初期化されます。configargs
 * のキー config_section_section を設定することで、この
 * デフォルト項目を変更することが可能です。また、キー config
 * に別の openssl 設定ファイルを指定することで別の設定を使用することも可能です。
 * もし configargs に以下の表のキーが存在すれば、それらは
 * openssl.conf の対応する項目と同じ働きをします。
 * <table>
 * 設定の上書き
 * <tr valign="top">
 * <td>configargs のキー</td>
 * <td>型</td>
 * <td>openssl.conf で同等の意味を持つ項目</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>digest_alg</td>
 * <td>string</td>
 * <td>default_md</td>
 * <td>使用するダイジェストメソッドを選択します</td>
 * </tr>
 * <tr valign="top">
 * <td>x509_extensions</td>
 * <td>string</td>
 * <td>x509_extensions</td>
 * <td>x509 証明書を作成する際に使用する拡張モジュールを選択します</td>
 * </tr>
 * <tr valign="top">
 * <td>req_extensions</td>
 * <td>string</td>
 * <td>req_extensions</td>
 * <td>CSR を作成する際に使用する拡張モジュールを選択します</td>
 * </tr>
 * <tr valign="top">
 * <td>private_key_bits</td>
 * <td>integer</td>
 * <td>default_bits</td>
 * <td>秘密鍵を作成する際に使用するビット数を指定します</td>
 * </tr>
 * <tr valign="top">
 * <td>private_key_type</td>
 * <td>integer</td>
 * <td>none</td>
 * <td>作成する秘密鍵の型を指定します。以下の定数
 * OPENSSL_KEYTYPE_DSA、
 * OPENSSL_KEYTYPE_DH あるいは
 * OPENSSL_KEYTYPE_RSA からひとつ選択します。
 * デフォルト値は OPENSSL_KEYTYPE_RSA で、
 * 現時点でサポートしているのはこの型のみです。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>encrypt_key</td>
 * <td>boolean</td>
 * <td>encrypt_key</td>
 * <td>（パスフレーズとともに）エクスポートされるキーを暗号化するか?</td>
 * </tr>
 * <tr valign="top">
 * <td>encrypt_key_cipher</td>
 * <td>integer</td>
 * <td>none</td>
 * <td>
 * 暗号定数のうちの一つ。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param extraattribs array[optional] <p>
 * extraattribs は、CSR に関する追加の設定情報を
 * 設定するために使用します。dn および
 * extraattribs はどちらも連想配列で、それらの
 * キーが OID に変換されたうえでリクエストの関連する部分に適用されます。
 * </p>
 * @return mixed CSR を返します。
 */
function openssl_csr_new (array $dn, &$privkey, array $configargs = null, array $extraattribs = null) {}

/**
 * CSR を文字列としてエクスポートする
 * @link http://www.php.net/manual/ja/function.openssl-csr-export.php
 * @param csr resource <p>
 * </p>
 * @param out string <p>
 * </p>
 * @param notext bool[optional] オプションのパラメータ notext
 * を設定すると、出力内容の冗長性が変化します。FALSE を指定すると、
 * 人間が読むための追加情報が出力に含まれるようになります。
 * notext のデフォルト値は TRUE です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_csr_export ($csr, &$out, $notext = null) {}

/**
 * CSR をファイルにエクスポートする
 * @link http://www.php.net/manual/ja/function.openssl-csr-export-to-file.php
 * @param csr resource <p>
 * </p>
 * @param outfilename string <p>
 * 出力ファイルへのパス。
 * </p>
 * @param notext bool[optional] オプションのパラメータ notext
 * を設定すると、出力内容の冗長性が変化します。FALSE を指定すると、
 * 人間が読むための追加情報が出力に含まれるようになります。
 * notext のデフォルト値は TRUE です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_csr_export_to_file ($csr, $outfilename, $notext = null) {}

/**
 * 他の CERT（あるいは自分自身）で証明書をサインする
 * @link http://www.php.net/manual/ja/function.openssl-csr-sign.php
 * @param csr mixed <p>
 * openssl_csr_new で作成した CSR。
 * file://path/to/csr 、あるいは
 * openssl_csr_export で生成した文字列で指定した場合は
 * PEM エンコードされた CSR も使用可能です。
 * </p>
 * @param cacert mixed <p>
 * 作成された証明書は cacert で署名されます。
 * cacert が NULL の場合は、自己署名の証明書となります。
 * </p>
 * @param priv_key mixed <p>
 * priv_key は
 * cacert に対応する秘密鍵です。
 * </p>
 * @param days int <p>
 * days は、作成された証明書の有効期限を日数で指定します。
 * </p>
 * @param configargs array[optional] <p>
 * configargs で証明書の詳細設定が可能です。
 * configargs についての詳細な情報は
 * openssl_csr_new を参照ください。
 * </p>
 * @param serial int[optional] <p>
 * 発行される証明書のシリアル番号を、オプションで指定します。
 * 省略した場合のデフォルトは 0 です。
 * </p>
 * @return resource 成功した場合に x509 証明書リソース、失敗した場合に FALSE を返します。
 */
function openssl_csr_sign ($csr, $cacert, $priv_key, $days, array $configargs = null, $serial = null) {}

/**
 * CERT の subject を返す
 * @link http://www.php.net/manual/ja/function.openssl-csr-get-subject.php
 * @param csr mixed 
 * @param use_shortnames bool[optional] 
 * @return array 
 */
function openssl_csr_get_subject ($csr, $use_shortnames = null) {}

/**
 * CERT の公開鍵を返す
 * @link http://www.php.net/manual/ja/function.openssl-csr-get-public-key.php
 * @param csr mixed 
 * @param use_shortnames bool[optional] 
 * @return resource 
 */
function openssl_csr_get_public_key ($csr, $use_shortnames = null) {}

/**
 * ダイジェストを計算
 * @link http://www.php.net/manual/ja/function.openssl-digest.php
 * @param data string <p>
 * データ
 * </p>
 * @param method string <p>
 * ダイジェスト・メソッド
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE に設定すると未加工の出力データとして返します。
 * そうでなければ binhex エンコードされた値を返します。
 * </p>
 * @return string 成功した場合ダイジェスト・ハッシュ値、失敗した場合に FALSE を返します。
 */
function openssl_digest ($data, $method, $raw_output = null) {}

/**
 * データを暗号化
 * @link http://www.php.net/manual/ja/function.openssl-encrypt.php
 * @param data string <p>
 * データ
 * </p>
 * @param method string <p>
 * 暗号メソッド
 * </p>
 * @param password string <p>
 * パスワード
 * </p>
 * @param options int[optional] <p>
 * OPENSSL_RAW_DATA あるいは
 * OPENSSL_ZERO_PADDING のいずれか。
 * </p>
 * @param iv string[optional] <p>
 * NULL ではない初期化ベクター。
 * </p>
 * @return string 成功した場合暗号化された文字列、失敗した場合に FALSE を返します。
 */
function openssl_encrypt ($data, $method, $password, $options = null, $iv = null) {}

/**
 * データを復号
 * @link http://www.php.net/manual/ja/function.openssl-decrypt.php
 * @param data string <p>
 * データ
 * </p>
 * @param method string <p>
 * 暗号メソッド
 * </p>
 * @param password string <p>
 * パスワード
 * </p>
 * @param options int[optional] <p>
 * OPENSSL_RAW_DATA あるいは
 * OPENSSL_ZERO_PADDING のいずれか。
 * </p>
 * @param iv string[optional] <p>
 * NULL ではない初期化ベクター。
 * </p>
 * @return string 成功した場合復号された文字列、失敗した場合に FALSE を返します。
 */
function openssl_decrypt ($data, $method, $password, $options = null, $iv = null) {}

/**
 * 暗号 iv の長さを取得
 * @link http://www.php.net/manual/ja/function.openssl-cipher-iv-length.php
 * @param method string <p>
 * メソッド。
 * </p>
 * @return int 成功した場合は暗号の長さ、失敗した場合には FALSE を返します。
 */
function openssl_cipher_iv_length ($method) {}

/**
 * 署名を生成する
 * @link http://www.php.net/manual/ja/function.openssl-sign.php
 * @param data string <p>
 * </p>
 * @param signature string <p>
 * 成功した場合、署名が signature に格納されます。
 * </p>
 * @param priv_key_id mixed <p>
 * </p>
 * @param signature_alg int[optional] <p>
 * 詳細な情報は、
 * 署名アルゴリズム
 * の一覧を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_sign ($data, &$signature, $priv_key_id, $signature_alg = null) {}

/**
 * 署名を検証する
 * @link http://www.php.net/manual/ja/function.openssl-verify.php
 * @param data string <p>
 * </p>
 * @param signature string <p>
 * </p>
 * @param pub_key_id mixed <p>
 * </p>
 * @param signature_alg int[optional] <p>
 * 詳細な情報は、
 * 署名アルゴリズム
 * の一覧を参照ください。
 * </p>
 * @return int 署名 (signature) が正しい場合に 1、正しくない場合に 0、
 * エラーの場合に -1 を返します。
 */
function openssl_verify ($data, $signature, $pub_key_id, $signature_alg = null) {}

/**
 * データをシール(暗号化)する
 * @link http://www.php.net/manual/ja/function.openssl-seal.php
 * @param data string <p>
 * </p>
 * @param sealed_data string <p>
 * </p>
 * @param env_keys array <p>
 * </p>
 * @param pub_key_ids array <p>
 * </p>
 * @param method string[optional] 
 * @return int 成功時にシール(暗号化)されたデータの長さ、エラー時に FALSE
 * を返します。成功時には、暗号化されたデータが
 * sealed_data に、エンベロープキーが
 * env_keys に返されます。
 */
function openssl_seal ($data, &$sealed_data, array &$env_keys, array $pub_key_ids, $method = null) {}

/**
 * シール(暗号化)されたデータをオープン(復号)する
 * @link http://www.php.net/manual/ja/function.openssl-open.php
 * @param sealed_data string <p>
 * </p>
 * @param open_data string <p>
 * 成功した場合、オープンしたデータをここに返します。
 * </p>
 * @param env_key string <p>
 * </p>
 * @param priv_key_id mixed <p>
 * </p>
 * @param method string[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_open ($sealed_data, &$open_data, $env_key, $priv_key_id, $method = null) {}

/**
 * S/MIME でサインされたメッセージの署名を検証する
 * @link http://www.php.net/manual/ja/function.openssl-pkcs7-verify.php
 * @param filename string <p>
 * メッセージへのパス。
 * </p>
 * @param flags int <p>
 * flags により署名の検証方法を指定することが可能です。
 * 詳細については、PKCS7 定数 を参照ください。
 * </p>
 * @param outfilename string[optional] <p>
 * outfilename を指定する場合、
 * メッセージに署名した人の証明書が PEM
 * 形式で保存されたファイルの名前をこの変数に指定する必要があります。
 * </p>
 * @param cainfo array[optional] <p>
 * cainfo が指定された場合、
 * 検証処理で使用するために認証済みの
 * CA 証明書に関する情報を保持する必要があります。
 * このパラメータに関するより詳細な情報については、
 * 証明書の検証
 * を参照ください。
 * </p>
 * @param extracerts string[optional] <p>
 * extracerts が指定された場合、
 * これは未認証の CA として一連の証明書を使用するためのファイルの名前となります。
 * </p>
 * @param content string[optional] <p>
 * ファイル名とともに content
 * を指定すると、検証したデータがここに格納されます。
 * 格納する際に、署名情報は除去されます。
 * </p>
 * @return mixed 署名が検証された場合は TRUE、正しくない場合
 * (メッセージが改暫されたか署名に用いられた証明書が無効) は FALSE、
 * エラーの場合に -1 を返します。
 */
function openssl_pkcs7_verify ($filename, $flags, $outfilename = null, array $cainfo = null, $extracerts = null, $content = null) {}

/**
 * S/MIME 暗号化されたメッセージを復号する
 * @link http://www.php.net/manual/ja/function.openssl-pkcs7-decrypt.php
 * @param infilename string <p>
 * </p>
 * @param outfilename string <p>
 * 復号したメッセージは、outfilename
 * で指定したファイルに出力されます。
 * </p>
 * @param recipcert mixed <p>
 * </p>
 * @param recipkey mixed[optional] <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkcs7_decrypt ($infilename, $outfilename, $recipcert, $recipkey = null) {}

/**
 * S/MIME メッセージにサインする
 * @link http://www.php.net/manual/ja/function.openssl-pkcs7-sign.php
 * @param infilename string <p>
 * </p>
 * @param outfilename string <p>
 * </p>
 * @param signcert mixed <p>
 * </p>
 * @param privkey mixed <p>
 * </p>
 * @param headers array <p>
 * headers は、ヘッダの配列です。このヘッダは、
 * サインされた後でデータの前に付加されます (このパラメータの形式の詳細については
 * openssl_pkcs7_encrypt を参照ください)。
 * </p>
 * @param flags int[optional] <p>
 * flags を出力を変更するために使用することが可能です。
 * PKCS7 定数
 * を参照ください。
 * </p>
 * @param extracerts string[optional] <p>
 * extracerts には、
 * サインに含めるための他の一連の証明書を記述したファイル名を指定します。
 * これは、例えば送信者が使用した証明書を受信者が検証しやすくするために使用することが可能です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkcs7_sign ($infilename, $outfilename, $signcert, $privkey, array $headers, $flags = null, $extracerts = null) {}

/**
 * S/MIME メッセージを暗号化する
 * @link http://www.php.net/manual/ja/function.openssl-pkcs7-encrypt.php
 * @param infile string <p>
 * </p>
 * @param outfile string <p>
 * </p>
 * @param recipcerts mixed <p>
 * X.509 証明書または X.509 証明書の配列。
 * </p>
 * @param headers array <p>
 * headers は、
 * 暗号化された後にデータの前に付加されるヘッダの配列です。
 * </p>
 * <p>
 * headers
 * はヘッダ名をキーとする連想配列または添字配列であり、
 * 各要素には、各ヘッダ行が一行ずつ含まれています。
 * </p>
 * @param flags int[optional] <p>
 * flags は
 * オプションとして使用可能であり、エンコード処理を変更するために指定します。
 * PKCS7 定数 を参照ください。
 * </p>
 * @param cipherid int[optional] <p>
 * 暗号定数のうちの一つ。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_pkcs7_encrypt ($infile, $outfile, $recipcerts, array $headers, $flags = null, $cipherid = null) {}

/**
 * 秘密鍵でデータを暗号化する
 * @link http://www.php.net/manual/ja/function.openssl-private-encrypt.php
 * @param data string <p>
 * </p>
 * @param crypted string <p>
 * </p>
 * @param key mixed <p>
 * </p>
 * @param padding int[optional] <p>
 * padding には
 * OPENSSL_PKCS1_PADDING あるいは
 * OPENSSL_NO_PADDING が指定可能です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_private_encrypt ($data, &$crypted, $key, $padding = null) {}

/**
 * 秘密鍵でデータを復号する
 * @link http://www.php.net/manual/ja/function.openssl-private-decrypt.php
 * @param data string <p>
 * </p>
 * @param decrypted string <p>
 * </p>
 * @param key mixed <p>
 * key は、
 * データの暗号化に使用したものに対応する秘密鍵である必要があります。
 * </p>
 * @param padding int[optional] <p>
 * padding には、
 * OPENSSL_PKCS1_PADDING、
 * OPENSSL_SSLV23_PADDING、
 * OPENSSL_PKCS1_OAEP_PADDING、
 * OPENSSL_NO_PADDING が指定可能です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_private_decrypt ($data, &$decrypted, $key, $padding = null) {}

/**
 * 公開鍵でデータを暗号化する
 * @link http://www.php.net/manual/ja/function.openssl-public-encrypt.php
 * @param data string <p>
 * </p>
 * @param crypted string <p>
 * 暗号化した結果がここに格納されます。
 * </p>
 * @param key mixed <p>
 * 公開鍵。
 * </p>
 * @param padding int[optional] <p>
 * padding には
 * OPENSSL_PKCS1_PADDING、
 * OPENSSL_SSLV23_PADDING、
 * OPENSSL_PKCS1_OAEP_PADDING、
 * OPENSSL_NO_PADDING が指定可能です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_public_encrypt ($data, &$crypted, $key, $padding = null) {}

/**
 * 公開鍵でデータを復号する
 * @link http://www.php.net/manual/ja/function.openssl-public-decrypt.php
 * @param data string <p>
 * </p>
 * @param decrypted string <p>
 * </p>
 * @param key mixed <p>
 * key は、
 * データの暗号化に使用したものに対応する公開鍵である必要があります。
 * </p>
 * @param padding int[optional] <p>
 * padding には
 * OPENSSL_PKCS1_PADDING あるいは
 * OPENSSL_NO_PADDING が指定可能です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openssl_public_decrypt ($data, &$decrypted, $key, $padding = null) {}

/**
 * 利用可能なダイジェスト・メソッドを取得
 * @link http://www.php.net/manual/ja/function.openssl-get-md-methods.php
 * @param aliases bool[optional] <p>
 * 返される array にダイジェストのエイリアスを含めるべき場合、
 * TRUE に設定します
 * </p>
 * @return array 利用可能なダイジェスト・メソッドの array
 */
function openssl_get_md_methods ($aliases = null) {}

/**
 * 利用可能な暗号メソッドを取得
 * @link http://www.php.net/manual/ja/function.openssl-get-cipher-methods.php
 * @param aliases bool[optional] <p>
 * 返される array に暗号のエイリアスを含めるべき場合、
 * TRUE に設定します
 * </p>
 * @return array 利用可能な暗号メソッドの array
 */
function openssl_get_cipher_methods ($aliases = null) {}

/**
 * リモート DH キー及びローカル DH キーの公開値に関して、共有される秘密を計算
 * @link http://www.php.net/manual/ja/function.openssl-dh-compute-key.php
 * @param pub_key string <p>
 * 公開鍵
 * </p>
 * @param dh_key resource <p>
 * DH キー
 * </p>
 * @return string 成功した場合計算されたキー、失敗した場合に FALSE を返します。
 */
function openssl_dh_compute_key ($pub_key, $dh_key) {}

/**
 * 疑似乱数のバイト文字列を生成する
 * @link http://www.php.net/manual/ja/function.openssl-random-pseudo-bytes.php
 * @param length int <p>
 * 希望するバイト長。正の整数でなければなりません。PHP は、
 * このパラメータを非 null の整数値にキャストして利用します。
 * </p>
 * @param crypto_strong bool[optional] <p>
 * これを渡しておくと、使ったアルゴリズムが暗号学的に強いものであるかどうかを表す
 * boolean 値が格納されます。「強い」とは、
 * GPG やパスワードなどに使っても安全であるという意味です。強い場合は
 * TRUE、そうでない場合は FALSE となります。
 * </p>
 * @return string 成功した場合は指定したバイト長の string を返します。失敗した場合に FALSE を返します。
 */
function openssl_random_pseudo_bytes ($length, &$crypto_strong = null) {}

/**
 * OpenSSL エラーメッセージを返す
 * @link http://www.php.net/manual/ja/function.openssl-error-string.php
 * @return string エラーメッセージ文字列を返します。
 * エラーメッセージがもうない場合は、FALSE を返します。
 */
function openssl_error_string () {}

define ('OPENSSL_VERSION_TEXT', "OpenSSL 0.9.8y 5 Feb 2013");
define ('OPENSSL_VERSION_NUMBER', 9470367);
define ('X509_PURPOSE_SSL_CLIENT', 1);
define ('X509_PURPOSE_SSL_SERVER', 2);
define ('X509_PURPOSE_NS_SSL_SERVER', 3);
define ('X509_PURPOSE_SMIME_SIGN', 4);
define ('X509_PURPOSE_SMIME_ENCRYPT', 5);
define ('X509_PURPOSE_CRL_SIGN', 6);
define ('X509_PURPOSE_ANY', 7);

/**
 * openssl_sign および
 * openssl_verify
 * のデフォルトアルゴリズムとして用いられます。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('OPENSSL_ALGO_SHA1', 1);
define ('OPENSSL_ALGO_MD5', 2);
define ('OPENSSL_ALGO_MD4', 3);
define ('OPENSSL_ALGO_DSS1', 5);

/**
 * メッセージにサインをする際、MIME型 "multipart/signed"
 * を指定してクリアテキストでサインを行います。これは、
 * openssl_pkcs7_sign において
 * フラグを指定しなかった場合の flags
 * パラメータのデフォルトです。このオプションをオフにした場合、
 * メッセージは不透明なサインによりサインされます。これは、
 * メールリレイによる変換に対してより耐性がありますが、S/MIME を
 * サポートしないメールエージェントでは読むことはできません。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_DETACHED', 64);

/**
 * text/plain content type ヘッダを暗号化/署名されたメッセージに
 * 追加します。復号化または認証を行う際には、このヘッダは出力から
 * 取り除かれます。復号化または認証されたメッセージがMIME
 * 型 text/plain でない場合、エラーとなります。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_TEXT', 1);

/**
 * メッセージを認証する際に、通常、メッセージに含まれる証明書が
 * 証明書にサインする際に検索されます。
 * このオプションでは、
 * openssl_pkcs7_verify の
 * extracerts パラメータで指定した証明書
 * のみが使用されます。しかし、指定された証明書を信頼されていな
 * い CA として使用することも可能です。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_NOINTERN', 16);

/**
 * サインつきメッセージをサインした証明書の署名について
 * 検証しません。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_NOVERIFY', 32);

/**
 * サインを行った側の証明書の認証の連鎖を行いません。
 * この場合、サイン付きのメッセージにある証明書を未認証の CA
 * として使用しません。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_NOCHAIN', 8);

/**
 * メッセージにサインする際、通常はサインをする人の証明書が挿入
 * されますが、このオプションを指定した場合はそうなりません。これに
 * よりサイン付きのメッセージのサイズは小さくなりますが、認証
 * 側が（例えば、openssl_pkcs7_verify の
 * extracerts を用いて渡すことにより）
 * サインをした人の証明書のコピーをローカルに用意する必要があります。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_NOCERTS', 2);

/**
 * 通常、メッセージがサインされる時、サインした時間やサポートされる
 * 対象アルゴリズムを含む一連の属性が付加されます。このオプションを
 * 指定した場合、それらの属性は付加されません。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_NOATTR', 256);

/**
 * 通常は、入力されたメッセージは CR および LF を行端として使用した
 * 「正規化」された形式に変換されます。こらは、S/MIME の規格に
 * 基づくものです。このオプションが指定された場合、変換は行われません。
 * この機能は、MIME 形式でないバイナリデータを処理する際に
 * 便利です。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_BINARY', 128);

/**
 * メッセージにサインや認証を試みません。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('PKCS7_NOSIGS', 4);
define ('OPENSSL_PKCS1_PADDING', 1);
define ('OPENSSL_SSLV23_PADDING', 2);
define ('OPENSSL_NO_PADDING', 3);
define ('OPENSSL_PKCS1_OAEP_PADDING', 4);
define ('OPENSSL_CIPHER_RC2_40', 0);
define ('OPENSSL_CIPHER_RC2_128', 1);
define ('OPENSSL_CIPHER_RC2_64', 2);
define ('OPENSSL_CIPHER_DES', 3);
define ('OPENSSL_CIPHER_3DES', 4);
define ('OPENSSL_KEYTYPE_RSA', 0);
define ('OPENSSL_KEYTYPE_DSA', 1);
define ('OPENSSL_KEYTYPE_DH', 2);

/**
 * この定数が使えるのは、PHP をコンパイルする際に OpenSSL 0.9.8 以降を使ったときだけです。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('OPENSSL_KEYTYPE_EC', 3);

/**
 * SNI サポートが有効か否か。
 * @link http://www.php.net/manual/ja/openssl.constants.php
 */
define ('OPENSSL_TLSEXT_SERVER_NAME', 1);

// End of openssl v.
?>
