<?php

// Start of dom v.20031129

class DOMException extends Exception  {
	protected $message;
	protected $file;
	protected $line;
	public $code;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class DOMStringList  {

	/**
	 * @param index
	 */
	public function item ($index) {}

}

class DOMNameList  {

	/**
	 * @param index
	 */
	public function getName ($index) {}

	/**
	 * @param index
	 */
	public function getNamespaceURI ($index) {}

}

class DOMImplementationList  {

	/**
	 * @param index
	 */
	public function item ($index) {}

}

class DOMImplementationSource  {

	/**
	 * @param features
	 */
	public function getDomimplementation ($features) {}

	/**
	 * @param features
	 */
	public function getDomimplementations ($features) {}

}

class DOMImplementation  {

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * DOM 実装が、指定した機能を実装しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domimplementation.hasfeature.php
	 * @param feature string <p>
	 * 調べる機能。
	 * </p>
	 * @param version string <p>
	 * 調べる feature のバージョン番号。
	 * DOM level 2 においては、これは 2.0 あるいは
	 * 1.0 のいずれかです。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasFeature ($feature, $version) {}

	/**
	 * 空の DOMDocumentType オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domimplementation.createdocumenttype.php
	 * @param qualifiedName string[optional] <p>
	 * 作成されるドキュメント型の修飾名。
	 * </p>
	 * @param publicId string[optional] <p>
	 * 外部サブセットの公開 ID。
	 * </p>
	 * @param systemId string[optional] <p>
	 * 外部サブセットのシステム ID。
	 * </p>
	 * @return DOMDocumentType ownerDocument を NULL に設定した
	 * 新しい DOMDocumentType ノードを返します。
	 */
	public function createDocumentType ($qualifiedName = null, $publicId = null, $systemId = null) {}

	/**
	 * 指定した型とドキュメント要素の DOMDocument オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domimplementation.createdocument.php
	 * @param namespaceURI string[optional] <p>
	 * 作成するドキュメント要素の名前空間 URI。
	 * </p>
	 * @param qualifiedName string[optional] <p>
	 * 作成するドキュメント要素の修飾名。
	 * </p>
	 * @param doctype DOMDocumentType[optional] <p>
	 * 作成するドキュメントの型、あるいは NULL。
	 * </p>
	 * @return DOMDocument 新しい DOMDocument オブジェクトを返します。
	 * namespaceURI、qualifiedName
	 * および doctype が null の場合は、
	 * ドキュメント要素を含まない空の DOMDocument
	 * を返します。
	 */
	public function createDocument ($namespaceURI = null, $qualifiedName = null, DOMDocumentType $doctype = null) {}

}

class DOMNode  {

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMNameSpaceNode  {
}

class DOMDocumentFragment extends DOMNode  {

	public function __construct () {}

	/**
	 * 生の XML データを追加する
	 * @link http://www.php.net/manual/ja/domdocumentfragment.appendxml.php
	 * @param data string <p>
	 * 追加する XML。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function appendXML ($data) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMDocument extends DOMNode  {

	/**
	 * 新しい要素ノードを作成する
	 * @link http://www.php.net/manual/ja/domdocument.createelement.php
	 * @param name string <p>
	 * 要素のタグ名。
	 * </p>
	 * @param value string[optional] <p>
	 * 要素の値。デフォルトでは、空の要素が作成されます。
	 * その後に DOMElement::$nodeValue
	 * で値を設定することも可能です。
	 * </p>
	 * @return DOMElement 新しい DOMElement クラスの新しいインスタンス、
	 * あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function createElement ($name, $value = null) {}

	/**
	 * 新しい文書片を作成する
	 * @link http://www.php.net/manual/ja/domdocument.createdocumentfragment.php
	 * @return DOMDocumentFragment 新しい DOMDocumentFragment、あるいはエラーが発生した場合は
	 * FALSE を返します。
	 */
	public function createDocumentFragment () {}

	/**
	 * 新しいテキストノードを作成する
	 * @link http://www.php.net/manual/ja/domdocument.createtextnode.php
	 * @param content string <p>
	 * テキストの内容。
	 * </p>
	 * @return DOMText 新しい DOMText、
	 * あるいがエラーが発生した場合には FALSE を返します。
	 */
	public function createTextNode ($content) {}

	/**
	 * 新しい comment ノードを作成する
	 * @link http://www.php.net/manual/ja/domdocument.createcomment.php
	 * @param data string <p>
	 * コメントの内容。
	 * </p>
	 * @return DOMComment 新しい DOMComment、あるいはエラーが発生した場合は
	 * FALSE を返します。
	 */
	public function createComment ($data) {}

	/**
	 * 新しい cdata ノードを作成する
	 * @link http://www.php.net/manual/ja/domdocument.createcdatasection.php
	 * @param data string <p>
	 * cdata の内容。
	 * </p>
	 * @return DOMCDATASection 新しい DOMCDATASection、あるいはエラーが発生した場合は
	 * FALSE を返します。
	 */
	public function createCDATASection ($data) {}

	/**
	 * 新しい PI ノードを作成する
	 * @link http://www.php.net/manual/ja/domdocument.createprocessinginstruction.php
	 * @param target string <p>
	 * 処理命令の対象。
	 * </p>
	 * @param data string[optional] <p>
	 * 処理命令の内容。
	 * </p>
	 * @return DOMProcessingInstruction 新しい DOMProcessingInstruction、
	 * あるいはエラーが発生した場合には FALSE を返します。
	 */
	public function createProcessingInstruction ($target, $data = null) {}

	/**
	 * 新しい属性を作成する
	 * @link http://www.php.net/manual/ja/domdocument.createattribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @return DOMAttr 新しい DOMAttr、あるいはエラーが発生した場合は
	 * FALSE を返します。
	 */
	public function createAttribute ($name) {}

	/**
	 * 新しいエンティティ参照ノードを作成する
	 * @link http://www.php.net/manual/ja/domdocument.createentityreference.php
	 * @param name string <p>
	 * エンティティ参照の内容、つまり、エンティティ参照から
	 * 先頭の &amp; および末尾の
	 * ; を取り除いたもの。
	 * </p>
	 * @return DOMEntityReference 新しい DOMEntityReference、
	 * あるいはエラーが発生した場合には FALSE を返します。
	 */
	public function createEntityReference ($name) {}

	/**
	 * 指定したローカルタグ名に対応するすべての要素を検索する
	 * @link http://www.php.net/manual/ja/domdocument.getelementsbytagname.php
	 * @param name string <p>
	 * タグのローカル名 (名前空間を除いたもの) に一致する名前。* はすべてのタグに一致します。
	 * </p>
	 * @return DOMNodeList 一致するすべての要素を含む、新しい DOMNodeList
	 * オブジェクトを返します。
	 */
	public function getElementsByTagName ($name) {}

	/**
	 * 現在のドキュメントにノードをインポートする
	 * @link http://www.php.net/manual/ja/domdocument.importnode.php
	 * @param importedNode DOMNode <p>
	 * インポートするノード。
	 * </p>
	 * @param deep bool[optional] <p>
	 * TRUE の場合、このメソッドは importedNode
	 * 以下のサブツリーも再帰的にインポートします。
	 * </p>
	 * <p>
	 * ノードの属性をコピーするには deep を TRUE に設定しなければなりません。
	 * </p>
	 * @return DOMNode コピーされたノードを返します。
	 * コピーできなかった場合は FALSE を返します。
	 */
	public function importNode (DOMNode $importedNode, $deep = null) {}

	/**
	 * 関連付けられた名前空間に新しい要素を作成する
	 * @link http://www.php.net/manual/ja/domdocument.createelementns.php
	 * @param namespaceURI string <p>
	 * 名前空間の URI。
	 * </p>
	 * @param qualifiedName string <p>
	 * 要素名を、prefix:tagname
	 * のような形式で指定する。
	 * </p>
	 * @param value string[optional] <p>
	 * 要素の値。デフォルトでは、空の要素が作成されます。
	 * その後に DOMElement::$nodeValue
	 * で値を設定することも可能です。
	 * </p>
	 * @return DOMElement 新しい DOMElement、
	 * あるいはエラーが発生した場合には FALSE を返します。
	 */
	public function createElementNS ($namespaceURI, $qualifiedName, $value = null) {}

	/**
	 * 関連付けられた名前空間に新しい属性を作成する
	 * @link http://www.php.net/manual/ja/domdocument.createattributens.php
	 * @param namespaceURI string <p>
	 * 名前空間の URI。
	 * </p>
	 * @param qualifiedName string <p>
	 * 属性のタグ名とプレフィックスを、prefix:tagname
	 * のような形式で指定する。
	 * </p>
	 * @return DOMAttr 新しい DOMAttr、あるいはエラーが発生した場合は
	 * FALSE を返します。
	 */
	public function createAttributeNS ($namespaceURI, $qualifiedName) {}

	/**
	 * 指定した名前空間で、タグ名に対応するすべての要素を検索する
	 * @link http://www.php.net/manual/ja/domdocument.getelementsbytagnamens.php
	 * @param namespaceURI string <p>
	 * 条件に一致する要素の名前空間 URI。
	 * * はすべての名前空間に一致します。
	 * </p>
	 * @param localName string <p>
	 * 条件に一致する要素のローカル名。
	 * * はすべてのローカル名に一致します。
	 * </p>
	 * @return DOMNodeList 一致するすべての要素を含む、新しい DOMNodeList
	 * オブジェクトを返します。
	 */
	public function getElementsByTagNameNS ($namespaceURI, $localName) {}

	/**
	 * id に対応する要素を検索する
	 * @link http://www.php.net/manual/ja/domdocument.getelementbyid.php
	 * @param elementId string <p>
	 * 要素の ID。
	 * </p>
	 * @return DOMElement DOMElement、
	 * あるいは要素が見つからなかった場合は NULL を返します。
	 */
	public function getElementById ($elementId) {}

	/**
	 * @param source DOMNode
	 */
	public function adoptNode (DOMNode $source) {}

	/**
	 * ドキュメントを正規化する
	 * @link http://www.php.net/manual/ja/domdocument.normalizedocument.php
	 * @return void 値を返しません。
	 */
	public function normalizeDocument () {}

	/**
	 * @param node DOMNode
	 * @param namespaceURI
	 * @param qualifiedName
	 */
	public function renameNode (DOMNode $node, $namespaceURI, $qualifiedName) {}

	/**
	 * ファイルから XML を読み込む
	 * @link http://www.php.net/manual/ja/domdocument.load.php
	 * @param filename string <p>
	 * XML ドキュメントへのパス。
	 * </p>
	 * @param options int[optional] <p>
	 * libxml オプション定数
	 * を
	 * ビット OR
	 * で連結したもの。
	 * </p>
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * 静的にコールされた場合には DOMDocument を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function load ($filename, $options = null) {}

	/**
	 * 内部の XML ツリーをファイルに出力する
	 * @link http://www.php.net/manual/ja/domdocument.save.php
	 * @param filename string <p>
	 * 保存された XML ドキュメントへのパス。
	 * </p>
	 * @param options int[optional] <p>
	 * 追加のオプション。現在は LIBXML_NOEMPTYTAG のみが
	 * サポートされています。
	 * </p>
	 * @return int 書き込んだバイト数、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function save ($filename, $options = null) {}

	/**
	 * 文字列から XML を読み込む
	 * @link http://www.php.net/manual/ja/domdocument.loadxml.php
	 * @param source string <p>
	 * XML を含む文字列。
	 * </p>
	 * @param options int[optional] <p>
	 * libxml オプション定数
	 * を
	 * ビット OR
	 * で連結したもの。
	 * </p>
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * 静的にコールされた場合には DOMDocument を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function loadXML ($source, $options = null) {}

	/**
	 * 内部の XML ツリーを文字列として出力する
	 * @link http://www.php.net/manual/ja/domdocument.savexml.php
	 * @param node DOMNode[optional] <p>
	 * ドキュメント全体ではなく、XML 宣言以外の特定のノードだけを
	 * 出力したい場合にこのパラメータを使用します。
	 * </p>
	 * @param options int[optional] <p>
	 * 追加のオプション。現在は LIBXML_NOEMPTYTAG のみが
	 * サポートされています。
	 * </p>
	 * @return string XML、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function saveXML (DOMNode $node = null, $options = null) {}

	/**
	 * 新しい DOMDocument オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domdocument.construct.php
	 * @param version[optional]
	 * @param encoding[optional]
	 */
	public function __construct ($version, $encoding) {}

	/**
	 * DTD に基づいてドキュメントを検証する
	 * @link http://www.php.net/manual/ja/domdocument.validate.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * ドキュメントに DTD が添付されていない場合は、このメソッドは FALSE を返します。
	 */
	public function validate () {}

	/**
	 * DomDocument オブジェクトにおける XIncludes の代替
	 * @link http://www.php.net/manual/ja/function.domdocument-xinclude.php
	 * @param options int[optional] <p>
	 * libxml のパラメータ。
	 * PHP 5.1.0 および Libxml 2.6.7 以降で使用可能です。
	 * </p>
	 * @return int ドキュメント内の XIncludes の数を返します。
	 * 何かの処理に失敗した場合は -1、
	 * 置換が発生しなかった場合は FALSE を返します。
	 */
	public function xinclude ($options = null) {}

	/**
	 * 文字列から HTML を読み込む
	 * @link http://www.php.net/manual/ja/domdocument.loadhtml.php
	 * @param source string <p>
	 * HTML 文字列。
	 * </p>
	 * @param options int[optional] <p>
	 * PHP 5.1.0 と Libxml 2.6.0 以降では、
	 * options パラメータで Libxml の追加パラメータ
	 * を指定できます。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * 静的にコールされた場合には DOMDocument を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function loadHTML ($source, $options = null) {}

	/**
	 * ファイルから HTML を読み込む
	 * @link http://www.php.net/manual/ja/domdocument.loadhtmlfile.php
	 * @param filename string <p>
	 * HTML ファイルへのパス。
	 * </p>
	 * @param options int[optional] <p>
	 * PHP 5.1.0 と Libxml 2.6.0 以降では、
	 * options パラメータで Libxml の追加パラメータ
	 * を指定できます。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * 静的にコールされた場合には DOMDocument を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function loadHTMLFile ($filename, $options = null) {}

	/**
	 * 内部のドキュメントを HTML 形式の文字列として出力する
	 * @link http://www.php.net/manual/ja/domdocument.savehtml.php
	 * @param node DOMNode[optional] <p>
	 * ドキュメントのサブセットを出力するオプションのパラメータ。
	 * </p>
	 * @return string HTML、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function saveHTML (DOMNode $node = null) {}

	/**
	 * 内部のドキュメントを HTML 形式でファイルに出力する
	 * @link http://www.php.net/manual/ja/domdocument.savehtmlfile.php
	 * @param filename string <p>
	 * 保存された HTML ドキュメントへのパス。
	 * </p>
	 * @return int 書き込んだバイト数、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function saveHTMLFile ($filename) {}

	/**
	 * スキーマに基づいてドキュメントを検証する
	 * @link http://www.php.net/manual/ja/domdocument.schemavalidate.php
	 * @param filename string <p>
	 * スキーマへのパス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function schemaValidate ($filename) {}

	/**
	 * スキーマに基づいてドキュメントを検証する
	 * @link http://www.php.net/manual/ja/domdocument.schemavalidatesource.php
	 * @param source string <p>
	 * スキーマを含む文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function schemaValidateSource ($source) {}

	/**
	 * ドキュメントを relaxNG で検証する
	 * @link http://www.php.net/manual/ja/domdocument.relaxngvalidate.php
	 * @param filename string <p>
	 * RNG ファイル。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function relaxNGValidate ($filename) {}

	/**
	 * ドキュメントを relaxNG で検証する
	 * @link http://www.php.net/manual/ja/domdocument.relaxngvalidatesource.php
	 * @param source string <p>
	 * RNG スキーマを含む文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function relaxNGValidateSource ($source) {}

	/**
	 * 基底ノード型を作成する際に使用する拡張クラスを登録する
	 * @link http://www.php.net/manual/ja/domdocument.registernodeclass.php
	 * @param baseclass string <p>
	 * 拡張したい DOM クラス。クラス名の一覧は、
	 * この章の導入部にあります。
	 * </p>
	 * @param extendedclass string <p>
	 * 拡張したクラスの名前。NULL を渡した場合は、
	 * それまでに baseclass
	 * を拡張して作成したすべてのクラスが削除されます。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function registerNodeClass ($baseclass, $extendedclass) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMNodeList implements Traversable {

	/**
	 * インデックスで指定したノードを取得する
	 * @link http://www.php.net/manual/ja/domnodelist.item.php
	 * @param index int <p>
	 * コレクション内のノードのインデックス。
	 * </p>
	 * @return DOMNode DOMNodeList 内の index
	 * 番目の位置にあるノード、あるいはインデックスが不正な形式の場合は
	 * NULL を返します。
	 */
	public function item ($index) {}

}

class DOMNamedNodeMap implements Traversable {

	/**
	 * 名前で指定されたノードを取得する
	 * @link http://www.php.net/manual/ja/domnamednodemap.getnameditem.php
	 * @param name string <p>
	 * 取得するノードの名前。
	 * </p>
	 * @return DOMNode 指定した (任意の型の) nodeName のノード、
	 * あるいはノードが見つからなかった場合には NULL を返します。
	 */
	public function getNamedItem ($name) {}

	/**
	 * @param arg DOMNode
	 */
	public function setNamedItem (DOMNode $arg) {}

	/**
	 * @param name[optional]
	 */
	public function removeNamedItem ($name) {}

	/**
	 * インデックスで指定したノードを取得する
	 * @link http://www.php.net/manual/ja/domnamednodemap.item.php
	 * @param index int <p>
	 * マップ内のインデックス。
	 * </p>
	 * @return DOMNode マップ内の index 番目の位置にあるノード、
	 * あるいはインデックスが不正な形式 (マップ内の要素数以上) の場合は
	 * NULL を返します。
	 */
	public function item ($index) {}

	/**
	 * ローカル名および名前空間 URI で指定したノードを取得する
	 * @link http://www.php.net/manual/ja/domnamednodemap.getnameditemns.php
	 * @param namespaceURI string <p>
	 * 取得するノードの名前空間 URI。
	 * </p>
	 * @param localName string <p>
	 * 取得するノードのローカル名。
	 * </p>
	 * @return DOMNode 指定した (任意の型の) ローカル名および名前空間 URI のノード、
	 * あるいはノードが見つからなかった場合には NULL を返します。
	 */
	public function getNamedItemNS ($namespaceURI, $localName) {}

	/**
	 * @param arg DOMNode[optional]
	 */
	public function setNamedItemNS (DOMNode $arg) {}

	/**
	 * @param namespaceURI[optional]
	 * @param localName[optional]
	 */
	public function removeNamedItemNS ($namespaceURI, $localName) {}

}

class DOMCharacterData extends DOMNode  {

	/**
	 * ノードから指定した範囲のデータを抽出する
	 * @link http://www.php.net/manual/ja/domcharacterdata.substringdata.php
	 * @param offset int <p>
	 * 部分文字列の抽出開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 抽出する文字数。
	 * </p>
	 * @return string 指定された部分文字列を返します。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データの末尾までのすべての
	 * 16 ビット単位が返されます。
	 */
	public function substringData ($offset, $count) {}

	/**
	 * ノードの文字データの最後に文字列を追加する
	 * @link http://www.php.net/manual/ja/domcharacterdata.appenddata.php
	 * @param data string <p>
	 * 追加する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function appendData ($data) {}

	/**
	 * 指定した 16 ビット単位のオフセットに、文字列を挿入する
	 * @link http://www.php.net/manual/ja/domcharacterdata.insertdata.php
	 * @param offset int <p>
	 * 挿入する場所の文字オフセット。
	 * </p>
	 * @param data string <p>
	 * 挿入する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function insertData ($offset, $data) {}

	/**
	 * 指定した範囲の文字列をノードから削除する
	 * @link http://www.php.net/manual/ja/domcharacterdata.deletedata.php
	 * @param offset int <p>
	 * 削除開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 削除する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが削除されます。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function deleteData ($offset, $count) {}

	/**
	 * DOMCharacterData ノードの文字列の一部を置換する
	 * @link http://www.php.net/manual/ja/domcharacterdata.replacedata.php
	 * @param offset int <p>
	 * 置換開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 置換する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが置換されます。
	 * </p>
	 * @param data string <p>
	 * 置換する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function replaceData ($offset, $count, $data) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMAttr extends DOMNode  {

	/**
	 * 属性が定義済みの ID かどうかを調べる
	 * @link http://www.php.net/manual/ja/domattr.isid.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isId () {}

	/**
	 * 新しい <classname>DOMAttr</classname> オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domattr.construct.php
	 * @param name
	 * @param value[optional]
	 */
	public function __construct ($name, $value) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMElement extends DOMNode  {

	/**
	 * 属性の値を返す
	 * @link http://www.php.net/manual/ja/domelement.getattribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @return string 属性の値、あるいは name に対応する属性が
	 * 見つからなかった場合には空の文字列を返します。
	 */
	public function getAttribute ($name) {}

	/**
	 * 新しい属性を追加する
	 * @link http://www.php.net/manual/ja/domelement.setattribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @param value string <p>
	 * 属性の値。
	 * </p>
	 * @return DOMAttr 新しい DOMAttr、
	 * あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function setAttribute ($name, $value) {}

	/**
	 * 属性を削除する
	 * @link http://www.php.net/manual/ja/domelement.removeattribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function removeAttribute ($name) {}

	/**
	 * 属性ノードを返す
	 * @link http://www.php.net/manual/ja/domelement.getattributenode.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @return DOMAttr 属性ノードを返します。
	 */
	public function getAttributeNode ($name) {}

	/**
	 * 新しい属性ノードを要素に追加する
	 * @link http://www.php.net/manual/ja/domelement.setattributenode.php
	 * @param attr DOMAttr <p>
	 * 属性ノード。
	 * </p>
	 * @return DOMAttr 属性が置換された場合は置換前のノード、そうでない場合は NULL
	 * を返します。
	 */
	public function setAttributeNode (DOMAttr $attr) {}

	/**
	 * 属性を削除する
	 * @link http://www.php.net/manual/ja/domelement.removeattributenode.php
	 * @param oldnode DOMAttr <p>
	 * 属性ノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function removeAttributeNode (DOMAttr $oldnode) {}

	/**
	 * タグ名から要素を取得する
	 * @link http://www.php.net/manual/ja/domelement.getelementsbytagname.php
	 * @param name string <p>
	 * タグ名。ツリー内のすべての要素を返すには
	 * * を使用します。
	 * </p>
	 * @return DOMNodeList この関数は、一致したすべての要素からなる
	 * DOMNodeList クラスのインスタンスを返します。
	 */
	public function getElementsByTagName ($name) {}

	/**
	 * 属性の値を返す
	 * @link http://www.php.net/manual/ja/domelement.getattributens.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param localName string <p>
	 * ローカル名。
	 * </p>
	 * @return string 属性の値、あるいは localName および
	 * namespaceURI に対応する属性が
	 * 見つからなかった場合には空の文字列を返します。
	 */
	public function getAttributeNS ($namespaceURI, $localName) {}

	/**
	 * 新しい属性を追加する
	 * @link http://www.php.net/manual/ja/domelement.setattributens.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param qualifiedName string <p>
	 * prefix:tagname 形式で表した属性名。
	 * </p>
	 * @param value string <p>
	 * 属性の値。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setAttributeNS ($namespaceURI, $qualifiedName, $value) {}

	/**
	 * 属性を削除する
	 * @link http://www.php.net/manual/ja/domelement.removeattributens.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param localName string <p>
	 * ローカル名。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function removeAttributeNS ($namespaceURI, $localName) {}

	/**
	 * 属性ノードを返す
	 * @link http://www.php.net/manual/ja/domelement.getattributenodens.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param localName string <p>
	 * ローカル名。
	 * </p>
	 * @return DOMAttr 属性ノードを返します。
	 */
	public function getAttributeNodeNS ($namespaceURI, $localName) {}

	/**
	 * 新しい属性ノードを要素に追加する
	 * @link http://www.php.net/manual/ja/domelement.setattributenodens.php
	 * @param attr DOMAttr <p>
	 * 属性ノード。
	 * </p>
	 * @return DOMAttr 属性が置換された場合は置換前のノードを返します。
	 */
	public function setAttributeNodeNS (DOMAttr $attr) {}

	/**
	 * 名前空間 URI とローカル名から要素を取得する
	 * @link http://www.php.net/manual/ja/domelement.getelementsbytagnamens.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param localName string <p>
	 * ローカル名。ツリー内のすべての要素を返すには *
	 * を使用します。
	 * </p>
	 * @return DOMNodeList この関数は、一致したすべての要素からなる
	 * DOMNodeList クラスのインスタンスを返します。
	 * 各要素は、ツリー内の探索時に見つかった順で並べられます。
	 */
	public function getElementsByTagNameNS ($namespaceURI, $localName) {}

	/**
	 * 属性が存在するかどうかを調べる
	 * @link http://www.php.net/manual/ja/domelement.hasattribute.php
	 * @param name string <p>
	 * 要素名。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttribute ($name) {}

	/**
	 * 属性が存在するかどうかを調べる
	 * @link http://www.php.net/manual/ja/domelement.hasattributens.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param localName string <p>
	 * ローカル名。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributeNS ($namespaceURI, $localName) {}

	/**
	 * ID 型の属性を名前で宣言する
	 * @link http://www.php.net/manual/ja/domelement.setidattribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @param isId bool <p>
	 * name を ID 型にしたい場合に TRUE、
	 * それ以外の場合に FALSE を設定します。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setIdAttribute ($name, $isId) {}

	/**
	 * ID 型の属性をローカル名および名前空間 URI で宣言する
	 * @link http://www.php.net/manual/ja/domelement.setidattributens.php
	 * @param namespaceURI string <p>
	 * 属性の名前空間 URI。
	 * </p>
	 * @param localName string <p>
	 * 属性のローカル名。prefix:tagname 形式。
	 * </p>
	 * @param isId bool <p>
	 * name を ID 型にしたい場合に TRUE、
	 * それ以外の場合に FALSE を設定します。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setIdAttributeNS ($namespaceURI, $localName, $isId) {}

	/**
	 * ID 型の属性をノードで宣言する
	 * @link http://www.php.net/manual/ja/domelement.setidattributenode.php
	 * @param attr DOMAttr <p>
	 * 属性ノード。
	 * </p>
	 * @param isId bool <p>
	 * name を ID 型にしたい場合に TRUE、
	 * それ以外の場合に FALSE を設定します。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setIdAttributeNode (DOMAttr $attr, $isId) {}

	/**
	 * 新しい DOMElement オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domelement.construct.php
	 * @param name
	 * @param value[optional]
	 * @param uri[optional]
	 */
	public function __construct ($name, $value, $uri) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMText extends DOMCharacterData  {

	/**
	 * 指定したオフセットでノードを 2 つに分割する
	 * @link http://www.php.net/manual/ja/domtext.splittext.php
	 * @param offset int <p>
	 * 分割する位置を示すオフセット。0 から始まります。
	 * </p>
	 * @return DOMText 同じ型の新しいノードを返します。offset
	 * 以降の内容をデータとして保持します。
	 */
	public function splitText ($offset) {}

	/**
	 * このテキストノードが空白を含むかどうかを示す
	 * @link http://www.php.net/manual/ja/domtext.iswhitespaceinelementcontent.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isWhitespaceInElementContent () {}

	public function isElementContentWhitespace () {}

	/**
	 * @param content
	 */
	public function replaceWholeText ($content) {}

	/**
	 * 新しい <classname>DOMText</classname> オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domtext.construct.php
	 * @param value[optional]
	 */
	public function __construct ($value) {}

	/**
	 * ノードから指定した範囲のデータを抽出する
	 * @link http://www.php.net/manual/ja/domcharacterdata.substringdata.php
	 * @param offset int <p>
	 * 部分文字列の抽出開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 抽出する文字数。
	 * </p>
	 * @return string 指定された部分文字列を返します。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データの末尾までのすべての
	 * 16 ビット単位が返されます。
	 */
	public function substringData ($offset, $count) {}

	/**
	 * ノードの文字データの最後に文字列を追加する
	 * @link http://www.php.net/manual/ja/domcharacterdata.appenddata.php
	 * @param data string <p>
	 * 追加する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function appendData ($data) {}

	/**
	 * 指定した 16 ビット単位のオフセットに、文字列を挿入する
	 * @link http://www.php.net/manual/ja/domcharacterdata.insertdata.php
	 * @param offset int <p>
	 * 挿入する場所の文字オフセット。
	 * </p>
	 * @param data string <p>
	 * 挿入する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function insertData ($offset, $data) {}

	/**
	 * 指定した範囲の文字列をノードから削除する
	 * @link http://www.php.net/manual/ja/domcharacterdata.deletedata.php
	 * @param offset int <p>
	 * 削除開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 削除する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが削除されます。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function deleteData ($offset, $count) {}

	/**
	 * DOMCharacterData ノードの文字列の一部を置換する
	 * @link http://www.php.net/manual/ja/domcharacterdata.replacedata.php
	 * @param offset int <p>
	 * 置換開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 置換する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが置換されます。
	 * </p>
	 * @param data string <p>
	 * 置換する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function replaceData ($offset, $count, $data) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMComment extends DOMCharacterData  {

	/**
	 * 新しい DOMComment オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domcomment.construct.php
	 * @param value[optional]
	 */
	public function __construct ($value) {}

	/**
	 * ノードから指定した範囲のデータを抽出する
	 * @link http://www.php.net/manual/ja/domcharacterdata.substringdata.php
	 * @param offset int <p>
	 * 部分文字列の抽出開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 抽出する文字数。
	 * </p>
	 * @return string 指定された部分文字列を返します。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データの末尾までのすべての
	 * 16 ビット単位が返されます。
	 */
	public function substringData ($offset, $count) {}

	/**
	 * ノードの文字データの最後に文字列を追加する
	 * @link http://www.php.net/manual/ja/domcharacterdata.appenddata.php
	 * @param data string <p>
	 * 追加する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function appendData ($data) {}

	/**
	 * 指定した 16 ビット単位のオフセットに、文字列を挿入する
	 * @link http://www.php.net/manual/ja/domcharacterdata.insertdata.php
	 * @param offset int <p>
	 * 挿入する場所の文字オフセット。
	 * </p>
	 * @param data string <p>
	 * 挿入する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function insertData ($offset, $data) {}

	/**
	 * 指定した範囲の文字列をノードから削除する
	 * @link http://www.php.net/manual/ja/domcharacterdata.deletedata.php
	 * @param offset int <p>
	 * 削除開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 削除する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが削除されます。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function deleteData ($offset, $count) {}

	/**
	 * DOMCharacterData ノードの文字列の一部を置換する
	 * @link http://www.php.net/manual/ja/domcharacterdata.replacedata.php
	 * @param offset int <p>
	 * 置換開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 置換する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが置換されます。
	 * </p>
	 * @param data string <p>
	 * 置換する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function replaceData ($offset, $count, $data) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMTypeinfo  {
}

class DOMUserDataHandler  {

	public function handle () {}

}

class DOMDomError  {
}

class DOMErrorHandler  {

	/**
	 * @param error DOMDomError
	 */
	public function handleError (DOMDomError $error) {}

}

class DOMLocator  {
}

class DOMConfiguration  {

	/**
	 * @param name
	 * @param value
	 */
	public function setParameter ($name, $value) {}

	/**
	 * @param name[optional]
	 */
	public function getParameter ($name) {}

	/**
	 * @param name[optional]
	 * @param value[optional]
	 */
	public function canSetParameter ($name, $value) {}

}

class DOMCdataSection extends DOMText  {

	/**
	 * 新しい DOMCdataSection オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domcdatasection.construct.php
	 * @param value
	 */
	public function __construct ($value) {}

	/**
	 * 指定したオフセットでノードを 2 つに分割する
	 * @link http://www.php.net/manual/ja/domtext.splittext.php
	 * @param offset int <p>
	 * 分割する位置を示すオフセット。0 から始まります。
	 * </p>
	 * @return DOMText 同じ型の新しいノードを返します。offset
	 * 以降の内容をデータとして保持します。
	 */
	public function splitText ($offset) {}

	/**
	 * このテキストノードが空白を含むかどうかを示す
	 * @link http://www.php.net/manual/ja/domtext.iswhitespaceinelementcontent.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isWhitespaceInElementContent () {}

	public function isElementContentWhitespace () {}

	/**
	 * @param content
	 */
	public function replaceWholeText ($content) {}

	/**
	 * ノードから指定した範囲のデータを抽出する
	 * @link http://www.php.net/manual/ja/domcharacterdata.substringdata.php
	 * @param offset int <p>
	 * 部分文字列の抽出開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 抽出する文字数。
	 * </p>
	 * @return string 指定された部分文字列を返します。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データの末尾までのすべての
	 * 16 ビット単位が返されます。
	 */
	public function substringData ($offset, $count) {}

	/**
	 * ノードの文字データの最後に文字列を追加する
	 * @link http://www.php.net/manual/ja/domcharacterdata.appenddata.php
	 * @param data string <p>
	 * 追加する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function appendData ($data) {}

	/**
	 * 指定した 16 ビット単位のオフセットに、文字列を挿入する
	 * @link http://www.php.net/manual/ja/domcharacterdata.insertdata.php
	 * @param offset int <p>
	 * 挿入する場所の文字オフセット。
	 * </p>
	 * @param data string <p>
	 * 挿入する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function insertData ($offset, $data) {}

	/**
	 * 指定した範囲の文字列をノードから削除する
	 * @link http://www.php.net/manual/ja/domcharacterdata.deletedata.php
	 * @param offset int <p>
	 * 削除開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 削除する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが削除されます。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function deleteData ($offset, $count) {}

	/**
	 * DOMCharacterData ノードの文字列の一部を置換する
	 * @link http://www.php.net/manual/ja/domcharacterdata.replacedata.php
	 * @param offset int <p>
	 * 置換開始位置のオフセット。
	 * </p>
	 * @param count int <p>
	 * 置換する文字の数。
	 * offset と count
	 * の和が文字列の長さをこえている場合、データ末尾までのすべての
	 * データが置換されます。
	 * </p>
	 * @param data string <p>
	 * 置換する文字列。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function replaceData ($offset, $count, $data) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMDocumentType extends DOMNode  {

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMNotation extends DOMNode  {

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMEntity extends DOMNode  {

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMEntityReference extends DOMNode  {

	/**
	 * 新しい DOMEntityReference オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domentityreference.construct.php
	 * @param name
	 */
	public function __construct ($name) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMProcessingInstruction extends DOMNode  {

	/**
	 * 新しい <classname>DOMProcessingInstruction</classname> オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domprocessinginstruction.construct.php
	 * @param name
	 * @param value[optional]
	 */
	public function __construct ($name, $value) {}

	/**
	 * 参照しているノードの前に新しい子を追加する
	 * @link http://www.php.net/manual/ja/domnode.insertbefore.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。
	 * </p>
	 * @param refnode DOMNode[optional] <p>
	 * 参照ノード。指定されなかった場合は、newnode
	 * が子要素として追加されます。
	 * </p>
	 * @return DOMNode 挿入されたノードを返します。
	 */
	public function insertBefore (DOMNode $newnode, DOMNode $refnode = null) {}

	/**
	 * 子を置き換える
	 * @link http://www.php.net/manual/ja/domnode.replacechild.php
	 * @param newnode DOMNode <p>
	 * 新しいノード。対象ドキュメントのメンバ、
	 * すなわち、DOMDocument->createXXX() メソッドのひとつで作成されたものか
	 * で
	 * ドキュメントにインポートされたものである必要があります。
	 * </p>
	 * @param oldnode DOMNode <p>
	 * 古いノード。
	 * </p>
	 * @return DOMNode 古いノード、あるいはエラーが発生した場合は FALSE を返します。
	 */
	public function replaceChild (DOMNode $newnode, DOMNode $oldnode) {}

	/**
	 * 子要素群から子要素を削除する
	 * @link http://www.php.net/manual/ja/domnode.removechild.php
	 * @param oldnode DOMNode <p>
	 * 削除する子要素。
	 * </p>
	 * @return DOMNode 子要素の削除に成功した場合に、削除した要素を返します。
	 */
	public function removeChild (DOMNode $oldnode) {}

	/**
	 * 子要素群の最後に新しい子要素を追加する
	 * @link http://www.php.net/manual/ja/domnode.appendchild.php
	 * @param newnode DOMNode <p>
	 * 追加する子要素。
	 * </p>
	 * @return DOMNode 追加したノードを返します。
	 */
	public function appendChild (DOMNode $newnode) {}

	/**
	 * ノードが子を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.haschildnodes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasChildNodes () {}

	/**
	 * ノードを複製する
	 * @link http://www.php.net/manual/ja/domnode.clonenode.php
	 * @param deep bool[optional] <p>
	 * 子孫要素を含めてコピーするかどうかを指定します。
	 * このパラメータのデフォルト値は FALSE です。
	 * </p>
	 * @return DOMNode 複製されたノードを返します。
	 */
	public function cloneNode ($deep = null) {}

	/**
	 * ノードを正規化する
	 * @link http://www.php.net/manual/ja/domnode.normalize.php
	 * @return void 値を返しません。
	 */
	public function normalize () {}

	/**
	 * 指定したバージョンで機能がサポートされているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issupported.php
	 * @param feature string <p>
	 * 調べる機能。機能の一覧については
	 * DOMImplementation::hasFeature
	 * の例を参照ください。
	 * </p>
	 * @param version string <p>
	 * 調べる機能 feature のバージョン番号。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSupported ($feature, $version) {}

	/**
	 * ノードが属性を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.hasattributes.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasAttributes () {}

	/**
	 * @param other DOMNode
	 */
	public function compareDocumentPosition (DOMNode $other) {}

	/**
	 * 2 つのノードが等しいかどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.issamenode.php
	 * @param node DOMNode <p>
	 * 比較対象となるノード。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSameNode (DOMNode $node) {}

	/**
	 * 名前空間 URI に基づいて、ノードの名前空間プレフィックスを取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupprefix.php
	 * @param namespaceURI string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return string 名前空間のプレフィックスを返します。
	 */
	public function lookupPrefix ($namespaceURI) {}

	/**
	 * 指定した namespaceURI がデフォルトの名前空間かどうかを調べる
	 * @link http://www.php.net/manual/ja/domnode.isdefaultnamespace.php
	 * @param namespaceURI string <p>
	 * 調べる名前空間 URI。
	 * </p>
	 * @return bool namespaceURI がデフォルトの名前空間である場合に
	 * TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultNamespace ($namespaceURI) {}

	/**
	 * プレフィックスに基づいて、ノードの名前空間 URI を取得する
	 * @link http://www.php.net/manual/ja/domnode.lookupnamespaceuri.php
	 * @param prefix string <p>
	 * 名前空間のプレフィックス。
	 * </p>
	 * @return string ノードの名前空間 URI を返します。
	 */
	public function lookupNamespaceUri ($prefix) {}

	/**
	 * @param arg DOMNode
	 */
	public function isEqualNode (DOMNode $arg) {}

	/**
	 * @param feature
	 * @param version
	 */
	public function getFeature ($feature, $version) {}

	/**
	 * @param key
	 * @param data
	 * @param handler
	 */
	public function setUserData ($key, $data, $handler) {}

	/**
	 * @param key
	 */
	public function getUserData ($key) {}

	/**
	 * ノードの XPath を取得する
	 * @link http://www.php.net/manual/ja/domnode.getnodepath.php
	 * @return string XPath を含む文字列、あるいはエラー時に NULL を返します。
	 */
	public function getNodePath () {}

	/**
	 * ノードが存在する行の番号を取得します。
	 * @link http://www.php.net/manual/ja/domnode.getlineno.php
	 * @return int 常にノードが定義された行の番号を返します。
	 */
	public function getLineNo () {}

	/**
	 * ノードを文字列に正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14n.php
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return string 正規化したノードを文字列で返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14N ($exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

	/**
	 * ノードをファイルに正規化する
	 * @link http://www.php.net/manual/ja/domnode.c14nfile.php
	 * @param uri string <p>
	 * 出力を書き出すパス。
	 * </p>
	 * @param exclusive bool[optional] <p>
	 * 指定した xpath あるいは名前空間プレフィックスにマッチするノードだけを対象としたパースを有効にする。
	 * </p>
	 * @param with_comments bool[optional] <p>
	 * コメントを残して出力する。
	 * </p>
	 * @param xpath array[optional] <p>
	 * ノードを絞り込むための xpath の配列。
	 * </p>
	 * @param ns_prefixes array[optional] <p>
	 * ノードを絞り込むための名前空間プレフィックスの配列。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 * 失敗した場合に FALSE を返します
	 */
	public function C14NFile ($uri, $exclusive = null, $with_comments = null, array $xpath = null, array $ns_prefixes = null) {}

}

class DOMStringExtend  {

	/**
	 * @param offset32
	 */
	public function findOffset16 ($offset32) {}

	/**
	 * @param offset16
	 */
	public function findOffset32 ($offset16) {}

}

class DOMXPath  {

	/**
	 * 新しい <classname>DOMXPath</classname> オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/domxpath.construct.php
	 * @param doc DOMDocument
	 */
	public function __construct (DOMDocument $doc) {}

	/**
	 * <classname>DOMXPath</classname> オブジェクトの名前空間を登録する
	 * @link http://www.php.net/manual/ja/domxpath.registernamespace.php
	 * @param prefix string <p>
	 * プレフィックス。
	 * </p>
	 * @param namespaceURI string <p>
	 * 名前空間の URI。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function registerNamespace ($prefix, $namespaceURI) {}

	/**
	 * 与えられた XPath 式を評価する
	 * @link http://www.php.net/manual/ja/domxpath.query.php
	 * @param expression string <p>
	 * 実行する XPath 式。
	 * </p>
	 * @param contextnode DOMNode[optional] <p>
	 * 相対 XPath クエリを実行する場合に、オプションで基準ノードを指定することが可能です。
	 * デフォルトでは、クエリは root 要素に対する相対パスとなります。
	 * </p>
	 * @param registerNodeNS bool[optional] <p>
	 * オプションの registerNodeNS で、
	 * コンテキストノードの自動登録を無効にすることができます。
	 * </p>
	 * @return DOMNodeList 与えられた XPath 式 expression にマッチする
	 * すべてのノードを含む DOMNodeList を返します。
	 * ノードを返さない式の場合は、空の DOMNodeList
	 * を返します。
	 * </p>
	 * <p>
	 * expression が不正な形式な場合や
	 * contextnode が無効な場合は、
	 * DOMXPath::query は FALSE を返します。
	 */
	public function query ($expression, DOMNode $contextnode = null, $registerNodeNS = null) {}

	/**
	 * 与えられた XPath 式を評価し、可能であれば結果を返す
	 * @link http://www.php.net/manual/ja/domxpath.evaluate.php
	 * @param expression string <p>
	 * 実行する XPath 式。
	 * </p>
	 * @param contextnode DOMNode[optional] <p>
	 * 相対 XPath クエリを実行する場合に、オプションで基準ノードを指定することが可能です。
	 * デフォルトでは、クエリは root 要素に対する相対パスとなります。
	 * </p>
	 * @param registerNodeNS bool[optional] <p>
	 * オプションの registerNodeNS で、
	 * コンテキストノードの自動登録を無効にすることができます。
	 * </p>
	 * @return mixed 可能であれば型付けされた結果、あるいは指定された XPath 式
	 * expression にマッチするすべてのノードを含む
	 * DOMNodeList を返します。
	 * </p>
	 * <p>
	 * expression が不正な形式な場合や
	 * contextnode が無効な場合は、
	 * DOMXPath::evaluate は FALSE を返します。
	 */
	public function evaluate ($expression, DOMNode $contextnode = null, $registerNodeNS = null) {}

	/**
	 * PHP の関数を XPath 関数として登録する
	 * @link http://www.php.net/manual/ja/domxpath.registerphpfunctions.php
	 * @param restrict mixed[optional] <p>
	 * このパラメータを使って、特定の関数のみを XPath からコールできるように制限することができます。
	 * </p>
	 * <p>
	 * このパラメータには、文字列 (関数名) あるいは関数名の配列を指定します。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function registerPhpFunctions ($restrict = null) {}

}

/**
 * <classname>SimpleXMLElement</classname> オブジェクトから <classname>DOMElement</classname> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.dom-import-simplexml.php
 * @param node SimpleXMLElement <p>
 * SimpleXMLElement ノード。
 * </p>
 * @return DOMElement 追加された DOMElement ノード、あるいは
 * 何らかのエラーが発生した場合は FALSE を返します。
 */
function dom_import_simplexml (SimpleXMLElement $node) {}


/**
 * ノードは要素(element)である
 * @link http://www.php.net/manual/ja/domxml.constants.php
 */
define ('XML_ELEMENT_NODE', 1);

/**
 * ノードは属性(attribute)である
 * @link http://www.php.net/manual/ja/domxml.constants.php
 */
define ('XML_ATTRIBUTE_NODE', 2);

/**
 * ノードはテキストの一部である
 * @link http://www.php.net/manual/ja/domxml.constants.php
 */
define ('XML_TEXT_NODE', 3);
define ('XML_CDATA_SECTION_NODE', 4);
define ('XML_ENTITY_REF_NODE', 5);

/**
 * ノードは&amp;nbsp;のようなエンティティである
 * @link http://www.php.net/manual/ja/domxml.constants.php
 */
define ('XML_ENTITY_NODE', 6);

/**
 * ノードは処理命令(PI)である
 * @link http://www.php.net/manual/ja/domxml.constants.php
 */
define ('XML_PI_NODE', 7);

/**
 * ノードはコメントである
 * @link http://www.php.net/manual/ja/domxml.constants.php
 */
define ('XML_COMMENT_NODE', 8);

/**
 * ノードはドキュメントである
 * @link http://www.php.net/manual/ja/domxml.constants.php
 */
define ('XML_DOCUMENT_NODE', 9);
define ('XML_DOCUMENT_TYPE_NODE', 10);
define ('XML_DOCUMENT_FRAG_NODE', 11);
define ('XML_NOTATION_NODE', 12);
define ('XML_HTML_DOCUMENT_NODE', 13);
define ('XML_DTD_NODE', 14);
define ('XML_ELEMENT_DECL_NODE', 15);
define ('XML_ATTRIBUTE_DECL_NODE', 16);
define ('XML_ENTITY_DECL_NODE', 17);
define ('XML_NAMESPACE_DECL_NODE', 18);
define ('XML_LOCAL_NAMESPACE', 18);
define ('XML_ATTRIBUTE_CDATA', 1);
define ('XML_ATTRIBUTE_ID', 2);
define ('XML_ATTRIBUTE_IDREF', 3);
define ('XML_ATTRIBUTE_IDREFS', 4);
define ('XML_ATTRIBUTE_ENTITY', 6);
define ('XML_ATTRIBUTE_NMTOKEN', 7);
define ('XML_ATTRIBUTE_NMTOKENS', 8);
define ('XML_ATTRIBUTE_ENUMERATION', 9);
define ('XML_ATTRIBUTE_NOTATION', 10);

/**
 * DOM の仕様にないエラーコードです。PHP のエラーを意味します。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_PHP_ERR', 0);

/**
 * インデックスあるいはサイズが負です。または上限を超えています。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_INDEX_SIZE_ERR', 1);

/**
 * 指定したテキストは
 * DOMString 内に収まりません。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOMSTRING_SIZE_ERR', 2);

/**
 * そのノードが所属できない場所に挿入されました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_HIERARCHY_REQUEST_ERR', 3);

/**
 * ノードが、もともと作成されたのと別のドキュメントで使用されました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_WRONG_DOCUMENT_ERR', 4);

/**
 * 名前などで、不正な文字が指定されました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_INVALID_CHARACTER_ERR', 5);

/**
 * データをサポートしていないノードでデータが指定されました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_NO_DATA_ALLOWED_ERR', 6);

/**
 * 変更が許可されていないオブジェクトを変更しようとしました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_NO_MODIFICATION_ALLOWED_ERR', 7);

/**
 * 存在しないノードを参照しようとしました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_NOT_FOUND_ERR', 8);

/**
 * 指定した型のオブジェクトや操作は、この実装ではサポートしていません。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_NOT_SUPPORTED_ERR', 9);

/**
 * 別の場所で使用中の属性を追加しようとしました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_INUSE_ATTRIBUTE_ERR', 10);

/**
 * 現在使用できない、あるいは使用できなくなったオブジェクトを
 * 使用しようとしました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_INVALID_STATE_ERR', 11);

/**
 * 不正な文字列が指定されました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_SYNTAX_ERR', 12);

/**
 * 基底オブジェクトの型を変更しようとしました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_INVALID_MODIFICATION_ERR', 13);

/**
 * 名前空間に存在しないオブジェクトを作成または変更しようとしました。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_NAMESPACE_ERR', 14);

/**
 * パラメータや操作は基底オブジェクトではサポートされていません。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_INVALID_ACCESS_ERR', 15);

/**
 * insertBefore や removeChild のようなメソッドのコールによってノードの
 * 「部分的な妥当性」が満たされなくなった際にこの例外が発生し、操作は
 * 行われません。
 * @link http://www.php.net/manual/ja/dom.constants.php
 */
define ('DOM_VALIDATION_ERR', 16);

// End of dom v.20031129
?>
