<?php

// Start of iconv v.

/**
 * 文字列を指定した文字エンコーディングに変換する
 * @link http://www.php.net/manual/ja/function.iconv.php
 * @param in_charset string <p>
 * 入力文字セット。
 * </p>
 * @param out_charset string <p>
 * 出力文字セット。
 * </p>
 * <p>
 * 文字列 //TRANSLIT を out_charset
 * に追加すると、翻字機能が有効になります。これは、指定された文字集合で
 * 表せない文字を、見た目の似ている別の文字に置き換える機能です。
 * 文字列 //IGNORE を追加すると、指定された文字集合で
 * 表せない文字は黙って切り捨てられます。
 * それ以外の場合は、str の中に変換できない文字が
 * 出現した時点で変換が打ち切られ、E_NOTICE が発生します。
 * </p>
 * @param str string <p>
 * 変換する文字列。
 * </p>
 * @return string 変換された文字列、失敗した場合に FALSE を返します。
 */
function iconv ($in_charset, $out_charset, $str) {}

/**
 * iconv 拡張モジュールの内部設定変数を取得する
 * @link http://www.php.net/manual/ja/function.iconv-get-encoding.php
 * @param type string[optional] <p>
 * オプション type の値は以下のどれかとすることができます。
 * all
 * input_encoding
 * output_encoding
 * internal_encoding
 * </p>
 * @return mixed 成功時に内部設定変数の現在の設定、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * type が省略されるか、"all"が指定された場合、
 * iconv_get_encoding は上記変数全てを格納した
 * 配列を返します。
 */
function iconv_get_encoding ($type = null) {}

/**
 * 文字エンコーディング変換用の設定を行なう
 * @link http://www.php.net/manual/ja/function.iconv-set-encoding.php
 * @param type string <p>
 * type には以下の値のどれかを指定できます。
 * input_encoding
 * output_encoding
 * internal_encoding
 * </p>
 * @param charset string <p>
 * 文字セット。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function iconv_set_encoding ($type, $charset) {}

/**
 * 文字列の文字数を返す
 * @link http://www.php.net/manual/ja/function.iconv-strlen.php
 * @param str string <p>
 * 文字列。
 * </p>
 * @param charset string[optional] <p>
 * charset パラメータが指定されなかった場合、
 * str のエンコードは
 * iconv.internal_encoding
 * であると判断されます。
 * </p>
 * @return int str の文字数を返します。
 */
function iconv_strlen ($str, $charset = null) {}

/**
 * 文字列の一部を切り出す
 * @link http://www.php.net/manual/ja/function.iconv-substr.php
 * @param str string <p>
 * 元の文字列。
 * </p>
 * @param offset int <p>
 * start が負でない場合、
 * iconv_substr は
 * str の start
 * 番目の文字（ゼロから数えて）から切り出します。
 * </p>
 * <p>
 * start が負の場合、
 * iconv_substr は
 * str の最後から数えて
 * start 番目の文字から切り出します。
 * </p>
 * @param length int[optional] <p>
 * length が指定され、かつ正である場合、
 * 返される文字列は start
 * から数えて最大 length 文字数分となります
 * (string の長さに依存します)。
 * </p>
 * <p>
 * もし負の length が渡された場合に
 * iconv_substr が切り出す文字列は、
 * str の start
 * 番目の文字からはじまり、文字列の最後から数えて
 * length 文字分戻ったところまでとなります。
 * start も負の場合、開始位置は
 * 上で説明した方式で計算されます。
 * </p>
 * @param charset string[optional] <p>
 * charset が指定されなかった場合、文字セットは
 * ini 設定 iconv.internal_encoding
 * で定義された値とみなされます。
 * </p>
 * <p>
 * offset や length
 * のパラメータは、常に charset で定義された
 * 文字セットにおける文字数と判断されることに注意してください。
 * 一方、substr の場合はこれらの値を常に
 * バイト数として判断します。
 * </p>
 * @return string 文字列 str の、
 * offset と length
 * で指定された一部を返します。
 * </p>
 * <p>
 * もし str が start
 * の文字列長より短い場合は、FALSE が返されます。
 */
function iconv_substr ($str, $offset, $length = null, $charset = null) {}

/**
 * 文字列が最初に現れる場所を見つける
 * @link http://www.php.net/manual/ja/function.iconv-strpos.php
 * @param haystack string <p>
 * 文字列全体。
 * </p>
 * @param needle string <p>
 * 検索する文字列。
 * </p>
 * @param offset int[optional] <p>
 * オプションの offset パラメータは
 * 検索を開始する位置を指定します。
 * </p>
 * @param charset string[optional] <p>
 * charset パラメータが指定されなかった場合、
 * string のエンコードは
 * iconv.internal_encoding
 * であると判断されます。
 * </p>
 * @return int needle が
 * haystack の中で最初に現れる位置を探します。
 * </p>
 * <p>
 * もし needle が見つからなかった場合、
 * iconv_strpos は FALSE を返します。
 */
function iconv_strpos ($haystack, $needle, $offset = null, $charset = null) {}

/**
 * 文字列が最後に現れる場所を見つける
 * @link http://www.php.net/manual/ja/function.iconv-strrpos.php
 * @param haystack string <p>
 * 文字列全体。
 * </p>
 * @param needle string <p>
 * 検索する文字列。
 * </p>
 * @param charset string[optional] <p>
 * charset パラメータが指定されなかった場合、
 * string のエンコードは
 * iconv.internal_encoding
 * であると判断されます。
 * </p>
 * @return int 文字列 haystack の中で、
 * needle が最後に現れた位置を数字で返します。
 * </p>
 * <p>
 * もし needle が見つからなかった場合、
 * iconv_strrpos は FALSE を返します。
 */
function iconv_strrpos ($haystack, $needle, $charset = null) {}

/**
 * <literal>MIME</literal> ヘッダフィールドを作成する
 * @link http://www.php.net/manual/ja/function.iconv-mime-encode.php
 * @param field_name string <p>
 * フィールド名。
 * </p>
 * @param field_value string <p>
 * フィールドの値。
 * </p>
 * @param preferences array[optional] <p>
 * iconv_mime_encode の振る舞いを変更するには、
 * ここで設定項目を含む連想配列を指定します。
 * iconv_mime_encode でサポートされている項目は
 * 以下のとおりです。項目名の大文字・小文字は区別されることに注意してください。
 * <table>
 * iconv_mime_encode でサポートされる設定項目
 * <tr valign="top">
 * <td>項目</td>
 * <td>型</td>
 * <td>説明</td>
 * <td>デフォルト値</td>
 * <td>例</td>
 * </tr>
 * <tr valign="top">
 * <td>scheme</td>
 * <td>string</td>
 * <td>
 * フィールドの値のエンコード方法を指定します。"B" か "Q" の
 * どちらかを指定することになるでしょう。"B" は
 * base64 エンコードを、また "Q" は
 * quoted-printable エンコードを表します。
 * </td>
 * <td>B</td>
 * <td>B</td>
 * </tr>
 * <tr valign="top">
 * <td>input-charset</td>
 * <td>string</td>
 * <td>
 * 第 1 パラメータ field_name と第 2 パラメータ
 * field_value の文字セットを指定します。
 * 指定されなかった場合は、iconv_mime_encode
 * は ini 設定
 * iconv.internal_encoding
 * であると仮定します。
 * </td>
 * <td>
 * iconv.internal_encoding
 * </td>
 * <td>ISO-8859-1</td>
 * </tr>
 * <tr valign="top">
 * <td>output-charset</td>
 * <td>string</td>
 * <td>
 * MIME ヘッダを作成する文字セットを指定します。
 * </td>
 * <td>
 * iconv.internal_encoding
 * </td>
 * <td>UTF-8</td>
 * </tr>
 * <tr valign="top">
 * <td>line-length</td>
 * <td>integer</td>
 * <td>
 * ヘッダ行の長さの最大値を指定します。もし結果がこの値より
 * 長くなった場合は、
 * RFC2822 - Internet Message Format
 * に基づいてヘッダを "折りたたんで" 複数行に分割します。
 * 指定されなかった場合は、長さは 76 文字に限定されます。
 * </td>
 * <td>76</td>
 * <td>996</td>
 * </tr>
 * <tr valign="top">
 * <td>line-break-chars</td>
 * <td>string</td>
 * <td>
 * 長いヘッダフィールドに対して "折りたたみ" 処理が行われる場合に
 * 個々の行の後ろに付加される文字列を指定します。
 * 指定されなかった場合は、"\r\n"
 * （CR LF）が用いられます。
 * このパラメータは、input-charset の値にかかわらず
 * 常に ASCII 文字列として扱われることに注意してください。
 * </td>
 * <td>\r\n</td>
 * <td>\n</td>
 * </tr>
 * </table>
 * </p>
 * @return string 成功した場合はエンコードした MIME フィールド、
 * エンコード時にエラーが発生した場合は FALSE を返します。
 */
function iconv_mime_encode ($field_name, $field_value, array $preferences = null) {}

/**
 * <literal>MIME</literal> ヘッダフィールドをデコードする
 * @link http://www.php.net/manual/ja/function.iconv-mime-decode.php
 * @param encoded_header string <p>
 * エンコードされたヘッダを表す文字列。
 * </p>
 * @param mode int[optional] <p>
 * mode は、iconv_mime_decode
 * が不正な形式の MIME ヘッダフィールドに遭遇した場合の
 * 振る舞いを定義します。以下のビットマスクの組み合わせで指定が可能です。
 * <table>
 * iconv_mime_decode で指定できるビットマスク
 * <tr valign="top">
 * <td>値</td>
 * <td>定数名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>ICONV_MIME_DECODE_STRICT</td>
 * <td>
 * 指定すると、ヘッダは RFC2047
 * で定義されている標準に完全準拠する形式でデコードされます。
 * このオプションはデフォルトでは無効になっています。なぜなら、世の中には
 * おかしなメールソフトが多く存在し、それらは規格に従わずに間違った
 * MIME ヘッダを生成するからです。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>ICONV_MIME_DECODE_CONTINUE_ON_ERROR</td>
 * <td>
 * 指定すると、iconv_mime_decode_headers
 * は文法的なエラーを無視し、デコード作業を継続します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param charset string[optional] <p>
 * オプションの charset パラメータは、結果の
 * 文字セットを指定します。指定されなかった場合は
 * iconv.internal_encoding
 * が用いられます。
 * </p>
 * @return string 成功した場合はデコードされた MIME フィールドを、
 * デコード中にエラーが発生した場合は FALSE を返します。
 */
function iconv_mime_decode ($encoded_header, $mode = null, $charset = null) {}

/**
 * 複数の <literal>MIME</literal> ヘッダフィールドを一度にデコードする
 * @link http://www.php.net/manual/ja/function.iconv-mime-decode-headers.php
 * @param encoded_headers string <p>
 * エンコードされたヘッダを表す文字列。
 * </p>
 * @param mode int[optional] <p>
 * mode は、iconv_mime_decode_headers
 * が不正な形式の MIME ヘッダフィールドに遭遇した場合の
 * 振る舞いを定義します。以下のビットマスクの組み合わせで指定が可能です。
 * <table>
 * iconv_mime_decode_headers で指定できるビットマスク
 * <tr valign="top">
 * <td>値</td>
 * <td>定数名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>ICONV_MIME_DECODE_STRICT</td>
 * <td>
 * 指定すると、ヘッダは RFC2047
 * で定義されている標準に完全準拠する形式でデコードされます。
 * このオプションはデフォルトでは無効になっています。なぜなら、世の中には
 * おかしなメールソフトが多く存在し、それらは規格に従わずに間違った
 * MIME ヘッダを生成するからです。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>ICONV_MIME_DECODE_CONTINUE_ON_ERROR</td>
 * <td>
 * 指定すると、iconv_mime_decode_headers
 * は文法的なエラーを無視し、デコード作業を継続します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param charset string[optional] <p>
 * オプションの charset パラメータは、結果の
 * 文字セットを指定します。指定されなかった場合は
 * iconv.internal_encoding
 * が用いられます。
 * </p>
 * @return array 成功した場合は連想配列を返します。その中身には
 * encoded_headers で指定した
 * MIME ヘッダフィールドがすべて含まれています。
 * デコード中にエラーが発生した場合は FALSE を返します。
 * </p>
 * <p>
 * 連想配列の個々のキーがフィールド名を表し、対応する要素がフィールドの
 * 値を表します。同じ名前のフィールドが複数存在する場合は、
 * iconv_mime_decode_headers が自動的に連番つきの
 * 配列をつくり、出現順にその配列に入れられます。
 */
function iconv_mime_decode_headers ($encoded_headers, $mode = null, $charset = null) {}


/**
 * string
 * @link http://www.php.net/manual/ja/iconv.constants.php
 */
define ('ICONV_IMPL', "\"libiconv\"");

/**
 * string
 * @link http://www.php.net/manual/ja/iconv.constants.php
 */
define ('ICONV_VERSION', 1.14);

/**
 * integer
 * @link http://www.php.net/manual/ja/iconv.constants.php
 */
define ('ICONV_MIME_DECODE_STRICT', 1);

/**
 * integer
 * @link http://www.php.net/manual/ja/iconv.constants.php
 */
define ('ICONV_MIME_DECODE_CONTINUE_ON_ERROR', 2);

// End of iconv v.
?>
