<?php

// Start of Phar v.2.0.1

class PharException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class Phar extends RecursiveDirectoryIterator implements RecursiveIterator, SeekableIterator, Traversable, Iterator, Countable, ArrayAccess {
	const CURRENT_MODE_MASK = 240;
	const CURRENT_AS_PATHNAME = 32;
	const CURRENT_AS_FILEINFO = 0;
	const CURRENT_AS_SELF = 16;
	const KEY_MODE_MASK = 3840;
	const KEY_AS_PATHNAME = 0;
	const FOLLOW_SYMLINKS = 512;
	const KEY_AS_FILENAME = 256;
	const NEW_CURRENT_AND_KEY = 256;
	const OTHER_MODE_MASK = 12288;
	const SKIP_DOTS = 4096;
	const UNIX_PATHS = 8192;
	const BZ2 = 8192;
	const GZ = 4096;
	const NONE = 0;
	const PHAR = 1;
	const TAR = 2;
	const ZIP = 3;
	const COMPRESSED = 61440;
	const PHP = 0;
	const PHPS = 1;
	const MD5 = 1;
	const OPENSSL = 16;
	const SHA1 = 2;
	const SHA256 = 3;
	const SHA512 = 4;


	/**
	 * Phar アーカイブオブジェクトを作成する
	 * @link http://www.php.net/manual/ja/phar.construct.php
	 * @param filename
	 * @param flags[optional]
	 * @param alias[optional]
	 * @param fileformat[optional]
	 */
	public function __construct ($filename, $flags, $alias, $fileformat) {}

	public function __destruct () {}

	/**
	 * 空のディレクトリを phar アーカイブに追加する
	 * @link http://www.php.net/manual/ja/phar.addemptydir.php
	 * @param dirname string <p>
	 * phar アーカイブ内に作成する空のディレクトリの名前。
	 * </p>
	 * @return void 返り値はありません。失敗時には例外をスローします。
	 */
	public function addEmptyDir ($dirname) {}

	/**
	 * ファイルシステム上のファイルを phar アーカイブに追加する
	 * @link http://www.php.net/manual/ja/phar.addfile.php
	 * @param file string <p>
	 * phar アーカイブに追加したいディスク上のファイルへのフルパスあるいは相対パス。
	 * </p>
	 * @param localname string[optional] <p>
	 * ファイルをアーカイブ内に格納するときのパス。
	 * </p>
	 * @return void 返り値はありません。失敗時には例外をスローします。
	 */
	public function addFile ($file, $localname = null) {}

	/**
	 * ファイルシステム上のファイルを phar アーカイブに追加する
	 * @link http://www.php.net/manual/ja/phar.addfromstring.php
	 * @param localname string <p>
	 * ファイルをアーカイブ内に格納するときのパス。
	 * </p>
	 * @param contents string <p>
	 * ファイルに保存する内容。
	 * </p>
	 * @return void 返り値はありません。失敗時には例外をスローします。
	 */
	public function addFromString ($localname, $contents) {}

	/**
	 * ディレクトリ内のファイルから phar を作成する
	 * @link http://www.php.net/manual/ja/phar.buildfromdirectory.php
	 * @param base_dir string <p>
	 * アーカイブに追加するすべてのファイルを含むディレクトリへの
	 * フルパスあるいは相対パス。
	 * </p>
	 * @param regex string[optional] <p>
	 * オプションで指定する pcre 正規表現。
	 * これを使用してファイル一覧をフィルタリングします。
	 * 正規表現にマッチするファイルパスのみがアーカイブに追加されます。
	 * </p>
	 * @return array Phar::buildFromDirectory
	 * は、連想配列を返します。これは、
	 * ファイルの内部パスをファイルシステム上のフルパスを対応させたものです。
	 */
	public function buildFromDirectory ($base_dir, $regex = null) {}

	/**
	 * イテレータから phar アーカイブを作成する
	 * @link http://www.php.net/manual/ja/phar.buildfromiterator.php
	 * @param iter Iterator <p>
	 * phar ファイルと実際の場所の関連を返すイテレータ、
	 * あるいは SplFileInfo オブジェクトを返すイテレータ。
	 * </p>
	 * @param base_directory string[optional] <p>
	 * SplFileInfo オブジェクトを返すイテレータを指定した際、
	 * phar アーカイブへの追加時にフルパスから取り除く部分。
	 * </p>
	 * @return array Phar::buildFromIterator
	 * は連想配列を返します。
	 * これは、ファイルの内部パスとファイルシステム上のフルパスを対応させたものです。
	 */
	public function buildFromIterator ($iter, $base_directory = null) {}

	/**
	 * 現在の Phar アーカイブ内のすべてのファイルを圧縮する
	 * @link http://www.php.net/manual/ja/phar.compressfiles.php
	 * @param compression int <p>
	 * 圧縮を行う場合は Phar::GZ あるいは
	 * Phar::BZ2、圧縮を解除するためには Phar::NONE
	 * のいずれかを指定しなければなりません。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function compressFiles ($compression) {}

	/**
	 * 現在の Phar アーカイブ内のすべてのファイルの圧縮を解除する
	 * @link http://www.php.net/manual/ja/phar.decompressfiles.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function decompressFiles () {}

	/**
	 * Phar アーカイブ全体を Gzip あるいは Bzip2 で圧縮する
	 * @link http://www.php.net/manual/ja/phar.compress.php
	 * @param compression int <p>
	 * 圧縮を行う場合には Phar::GZ あるいは
	 * Phar::BZ2、圧縮を解除する場合には
	 * Phar::NONE を指定します。
	 * </p>
	 * @param extension string[optional] <p>
	 * デフォルトでは、phar 形式のアーカイブを圧縮する際の拡張子は
	 * .phar.gz あるいは .phar.bz2
	 * となり、tar 形式のアーカイブを圧縮する際の拡張子は
	 * .phar.tar.gz あるいは .phar.tar.bz2
	 * となります。伸長の際は、デフォルトの拡張子は
	 * .phar および .phar.tar となります。
	 * </p>
	 * @return object Phar オブジェクトを返します。
	 */
	public function compress ($compression, $extension = null) {}

	/**
	 * Phar アーカイブ全体の圧縮を解除する
	 * @link http://www.php.net/manual/ja/phar.decompress.php
	 * @param extension string[optional] <p>
	 * 圧縮を解除する場合、デフォルトのファイル拡張子は
	 * .phar および .phar.tar です。
	 * このパラメータを使用すると、別の拡張子を指定することができます。
	 * 実行可能な phar アーカイブは、ファイル名に必ず
	 * .phar を含まなければならないことに注意しましょう。
	 * </p>
	 * @return object Phar オブジェクトを返します。
	 */
	public function decompress ($extension = null) {}

	/**
	 * phar アーカイブを実行可能な別の phar アーカイブ形式に変換する
	 * @link http://www.php.net/manual/ja/phar.converttoexecutable.php
	 * @param format int[optional] <p>
	 * これは Phar::PHAR、Phar::TAR
	 * あるいは Phar::ZIP のいずれかとなります。
	 * NULL を指定すると、現在のファイル形式をそのまま保持します。
	 * </p>
	 * @param compression int[optional] <p>
	 * アーカイブ全体の圧縮を行わない場合は Phar::NONE、
	 * zlib による圧縮の場合は Phar::GZ、そして bzip による圧縮の場合は
	 * Phar::BZ2 のいずれかを指定します。
	 * </p>
	 * @param extension string[optional] <p>
	 * このパラメータは、変換後のアーカイブのデフォルトのファイル拡張子を変更します。
	 * 実行可能でない tar や zip アーカイブのファイル名としては
	 * .phar は使用できないことに注意しましょう。
	 * </p>
	 * <p>
	 * phar 形式のアーカイブに変換する場合、デフォルトの拡張子は圧縮形式によって
	 * .phar、.phar.gz あるいは .phar.bz2
	 * のいずれかとなります。tar 形式のアーカイブの場合、デフォルトの拡張子は
	 * .phar.tar、.phar.tar.gz
	 * および .phar.tar.bz2 です。zip 形式のアーカイブの場合、
	 * デフォルトの拡張子は .phar.zip となります。
	 * </p>
	 * @return Phar このメソッドは、成功した場合に Phar
	 * オブジェクトを返します。失敗した場合は例外をスローします。
	 */
	public function convertToExecutable ($format = null, $compression = null, $extension = null) {}

	/**
	 * phar アーカイブを実行可能でない tar あるいは zip ファイルに変換する
	 * @link http://www.php.net/manual/ja/phar.converttodata.php
	 * @param format int[optional] <p>
	 * これは Phar::TAR
	 * あるいは Phar::ZIP のいずれかとなります。
	 * NULL を指定すると、現在のファイル形式をそのまま保持します。
	 * </p>
	 * @param compression int[optional] <p>
	 * アーカイブ全体の圧縮を行わない場合は Phar::NONE、
	 * zlib による圧縮の場合は Phar::GZ、そして bzip による圧縮の場合は
	 * Phar::BZ2 のいずれかを指定します。
	 * </p>
	 * @param extension string[optional] <p>
	 * このパラメータは、変換後のアーカイブのデフォルトのファイル拡張子を変更します。
	 * 実行可能でない tar や zip アーカイブのファイル名としては
	 * .phar は使用できないことに注意しましょう。
	 * </p>
	 * <p>
	 * tar 形式の phar アーカイブの場合、デフォルトの拡張子は圧縮形式によって
	 * .tar、.tar.gz、
	 * .tar.bz2 のいずれかとなります。
	 * zip 形式のアーカイブの場合、デフォルトの拡張子は
	 * .zip となります。
	 * </p>
	 * @return PharData このメソッドは、成功した場合に PharData
	 * オブジェクトを返します。失敗した場合は例外をスローします。
	 */
	public function convertToData ($format = null, $compression = null, $extension = null) {}

	/**
	 * phar アーカイブ内のファイルを、phar 内で別の新しいファイルとしてコピーする
	 * @link http://www.php.net/manual/ja/phar.copy.php
	 * @param oldfile string <p>
	 * </p>
	 * @param newfile string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。しかし、より安全を期すなら
	 * try/catch ブロック内で使用して例外がスローされないことを確認するといいでしょう。
	 */
	public function copy ($oldfile, $newfile) {}

	/**
	 * Phar アーカイブ内のエントリ (ファイル) の数を返す
	 * @link http://www.php.net/manual/ja/phar.count.php
	 * @return int この phar ファイルに含まれるファイルの数を返します。
	 * 存在しない場合は 0 (数字のゼロ) を返します。
	 */
	public function count () {}

	/**
	 * phar アーカイブ内のファイルを削除する
	 * @link http://www.php.net/manual/ja/phar.delete.php
	 * @param entry string <p>
	 * 削除したいファイルの、アーカイブ内でのパス。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 * しかし、例外がスローされているかどうかを確認したうえで
	 * 例外がなければ成功とみなすほうがいいでしょう。
	 */
	public function delete ($entry) {}

	/**
	 * phar のグローバルメタデータを削除する
	 * @link http://www.php.net/manual/ja/phar.delmetadata.php
	 * @return bool 成功した場合に TRUE を返します。しかし、より安全を期すなら
	 * try/catch ブロック内で使用して例外がスローされないことを確認するといいでしょう。
	 */
	public function delMetadata () {}

	/**
	 * phar アーカイブの内容をディレクトリに展開する
	 * @link http://www.php.net/manual/ja/phar.extractto.php
	 * @param pathto string <p>
	 * アーカイブ内のファイルへのパス。
	 * </p>
	 * @param files string|array[optional] <p>
	 * 展開したいファイル名/ディレクトリ名、あるいはその配列。
	 * </p>
	 * @param overwrite bool[optional] <p>
	 * TRUE にすると既存のファイルを上書きします。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 * しかし、例外がスローされているかどうかを確認したうえで
	 * 例外がなければ成功とみなすほうがいいでしょう。
	 */
	public function extractTo ($pathto, $files = null, $overwrite = null) {}

	public function getAlias () {}

	public function getPath () {}

	/**
	 * phar アーカイブのメタデータを返す
	 * @link http://www.php.net/manual/ja/phar.getmetadata.php
	 * @return mixed Phar アーカイブのメタデータとして保存されている、シリアライズ可能な任意の PHP 変数を返します。
	 * メタデータが保存されていない場合は NULL を返します。
	 */
	public function getMetadata () {}

	/**
	 * phar が変更されているかどうかを返す
	 * @link http://www.php.net/manual/ja/phar.getmodified.php
	 * @return bool オープンした後でファイルが変更されている場合に TRUE、
	 * そうでない場合に FALSE を返します。
	 */
	public function getModified () {}

	/**
	 * Phar アーカイブの MD5/SHA1/SHA256/SHA512/OpenSSL シグネチャを返す
	 * @link http://www.php.net/manual/ja/phar.getsignature.php
	 * @return array 開いているアーカイブのシグネチャを配列で返します。
	 * キー hash にはシグネチャ自体を、そしてキー hash_type
	 * には MD5、SHA-1、
	 * SHA-256、SHA-512 あるいは OpenSSL
	 * を格納します。
	 * このシグネチャは phar の中身全体から計算したハッシュで、
	 * アーカイブの整合性を検証する際に使用します。
	 * INI 設定 phar.require_hash
	 * が true の場合は、すべての実行可能な phar が有効なシグネチャを持っている必要があります。
	 */
	public function getSignature () {}

	/**
	 * Phar アーカイブの PHP ローダーあるいは起動スタブを返す
	 * @link http://www.php.net/manual/ja/phar.getstub.php
	 * @return string 現在の Phar アーカイブの起動用ローダー (スタブ)
	 * の内容を文字列で返します。
	 */
	public function getStub () {}

	/**
	 * Phar アーカイブのバージョン情報を返す
	 * @link http://www.php.net/manual/ja/phar.getversion.php
	 * @return string オープンしたアーカイブの API バージョンを返します。
	 * これは、読み込んだ phar 拡張モジュールが新しい phar を作成する際に使用する
	 * API バージョンとは異なります。各 Phar アーカイブは、
	 * マニフェスト内に API バージョンをハードコードして保持しています。
	 * 詳細は Phar ファイルフォーマット
	 * のドキュメントを参照ください。
	 */
	public function getVersion () {}

	/**
	 * ファイルがグローバルなメタデータを持つかどうかを返す
	 * @link http://www.php.net/manual/ja/phar.hasmetadata.php
	 * @return bool メタデータが設定されている場合に TRUE、されていない場合に FALSE を返します。
	 */
	public function hasMetadata () {}

	/**
	 * Phar の書き込み操作がバッファリングされるか、あるいは直接ディスクに書き込まれるかを調べる
	 * @link http://www.php.net/manual/ja/phar.isbuffering.php
	 * @return bool 書込み操作がバッファリングされる場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isBuffering () {}

	/**
	 * phar アーカイブ全体が (.tar.gz/tar.bz などで) 圧縮されている場合に Phar::GZ あるいは PHAR::BZ2 を返す
	 * @link http://www.php.net/manual/ja/phar.iscompressed.php
	 * @return mixed Phar::GZ、Phar::BZ2
	 * あるいは FALSE を返します。
	 */
	public function isCompressed () {}

	/**
	 * phar アーカイブが、パラメータで指定した tar/phar/zip のいずれかの形式である場合に true を返す
	 * @link http://www.php.net/manual/ja/phar.isfileformat.php
	 * @param format int <p>
	 * Phar::PHAR、Phar::TAR
	 * あるいは Phar::ZIP で、アーカイブの形式を指定します。
	 * </p>
	 * @return bool phar アーカイブのファイル形式がパラメータで指定したものと一致する場合に TRUE
	 * を返します。
	 */
	public function isFileFormat ($format) {}

	/**
	 * phar アーカイブが変更可能な場合に true を返す
	 * @link http://www.php.net/manual/ja/phar.iswritable.php
	 * @return bool phar アーカイブが変更可能な場合に TRUE を返します。
	 */
	public function isWritable () {}

	/**
	 * ファイルが phar 内に存在するかどうかを調べる
	 * @link http://www.php.net/manual/ja/phar.offsetexists.php
	 * @param offset string <p>
	 * Phar 内で探すファイル名 (相対パス)。
	 * </p>
	 * @return bool ファイルが phar 内に存在する場合に TRUE、しない場合に FALSE
	 * を返します。
	 */
	public function offsetExists ($offset) {}

	/**
	 * 指定したファイルの <classname>PharFileInfo</classname> オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/phar.offsetget.php
	 * @param offset string <p>
	 * Phar 内で探すファイル名 (相対パス)。
	 * </p>
	 * @return int PharFileInfo オブジェクトを返します。
	 * これを使用して、ファイルの内容を順に処理したりファイルの情報を取得したりします。
	 */
	public function offsetGet ($offset) {}

	/**
	 * 内部ファイルに、外部ファイルの内容を設定する
	 * @link http://www.php.net/manual/ja/phar.offsetset.php
	 * @param offset string <p>
	 * Phar 内で変更するファイル名 (相対パス)。
	 * </p>
	 * @param value string <p>
	 * ファイルの内容。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function offsetSet ($offset, $value) {}

	/**
	 * ファイルを phar から削除する
	 * @link http://www.php.net/manual/ja/phar.offsetunset.php
	 * @param offset string <p>
	 * Phar 内で変更するファイル名 (相対パス)。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function offsetUnset ($offset) {}

	/**
	 * Phar アーカイブのエイリアスを設定する
	 * @link http://www.php.net/manual/ja/phar.setalias.php
	 * @param alias string <p>
	 * このアーカイブを指すときに使用する短い文字列。
	 * phar ストリームラッパーがアクセスする際にこれを使用します。
	 * </p>
	 * @return bool 
	 */
	public function setAlias ($alias) {}

	/**
	 * Phar アーカイブの PHP ローダー (起動スタブ) をデフォルトのローダーに設定する
	 * @link http://www.php.net/manual/ja/phar.setdefaultstub.php
	 * @param index string[optional] <p>
	 * コマンドラインからアクセスした場合に実行する、
	 * phar アーカイブ内の相対パス。
	 * </p>
	 * @param webindex string[optional] <p>
	 * ウェブブラウザからアクセスした場合に実行する、
	 * phar アーカイブ内の相対パス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setDefaultStub ($index = null, $webindex = null) {}

	/**
	 * phar アーカイブのメタデータを設定する
	 * @link http://www.php.net/manual/ja/phardata.setmetadata.php
	 * @param metadata mixed <p>
	 * phar アーカイブについての情報を含む、PHP の変数。
	 * </p>
	 * @param metadata mixed 
	 * @return void 値を返しません。
	 */
	public function setMetadata ($metadata, $metadata) {}

	/**
	 * phar のシグネチャのアルゴリズムを設定する
	 * @link http://www.php.net/manual/ja/phardata.setsignaturealgorithm.php
	 * @param sigtype int <p>
	 * Phar::MD5、
	 * Phar::SHA1、Phar::SHA256、
	 * Phar::SHA512 あるいは Phar::PGP
	 * のいずれか。
	 * </p>
	 * @param privatekey string[optional] <p>
	 * OpenSSL 秘密鍵の中身。証明書あるいは OpenSSL 鍵ファイルから取り出したもの。
	 * setSignatureAlgorithm(Phar::OPENSSL, $pkey);
	 * ?>
	 * ]]>
	 * 公開鍵ファイルの名前や置き場所については
	 * phar の導入 を参照ください。
	 * </p>
	 * @param sigtype int 
	 * @return void 値を返しません。
	 */
	public function setSignatureAlgorithm ($sigtype, $privatekey = null, $sigtype) {}

	/**
	 * Phar アーカイブの PHP ローダ (あるいは起動スタブ) を設定する
	 * @link http://www.php.net/manual/ja/phar.setstub.php
	 * @param stub string <p>
	 * 文字列あるいはオープンしたストリームハンドル。
	 * この phar アーカイブの実行スタブとして使用します。
	 * </p>
	 * @param len int[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setStub ($stub, $len = null) {}

	/**
	 * Phar の書き込み操作のバッファリングを開始するが、ディスク上の Phar オブジェクトは変更しない
	 * @link http://www.php.net/manual/ja/phar.startbuffering.php
	 * @return void 値を返しません。
	 */
	public function startBuffering () {}

	/**
	 * Phar アーカイブへの書き込みリクエストのバッファリングを終了し、変更内容をディスクに書き込む
	 * @link http://www.php.net/manual/ja/phar.stopbuffering.php
	 * @return void 値を返しません。
	 */
	public function stopBuffering () {}

	/**
	 * API のバージョンを返す
	 * @link http://www.php.net/manual/ja/phar.apiversion.php
	 * @return string API のバージョンを、&quot;1.0.0&quot;
	 * のような文字列で返します。
	 */
	final public static function apiVersion () {}

	/**
	 * phar 拡張モジュールが zlib あるいは bzip2 による圧縮をサポートしているかどうかを返す
	 * @link http://www.php.net/manual/ja/phar.cancompress.php
	 * @param type int[optional] <p>
	 * Phar::GZ あるいは Phar::BZ2
	 * のいずれかを指定し、指定した圧縮アルゴリズムでの圧縮が可能かどうかを調べます。
	 * </p>
	 * @return bool 圧縮/展開 が可能な場合に TRUE、そうでない場合に FALSE を返します。
	 */
	final public static function canCompress ($type = null) {}

	/**
	 * phar 拡張モジュールが phar の書き込みや作成をサポートしているかどうかを返す
	 * @link http://www.php.net/manual/ja/phar.canwrite.php
	 * @return bool 書き込みが可能な場合に TRUE、そうでない場合に FALSE を返します。
	 */
	final public static function canWrite () {}

	/**
	 * phar ファイルフォーマット用のスタブを作成する
	 * @link http://www.php.net/manual/ja/phar.createdefaultstub.php
	 * @param indexfile string[optional] 
	 * @param webindexfile string[optional] 
	 * @return string 独自の起動ローダー (スタブ) を文字列で返します。
	 * これを用いて作成した Phar アーカイブは、
	 * Phar 拡張モジュールが有効になっていない環境でも実行することができます。
	 */
	final public static function createDefaultStub ($indexfile = null, $webindexfile = null) {}

	/**
	 * サポートする圧縮アルゴリズムの配列を返す
	 * @link http://www.php.net/manual/ja/phar.getsupportedcompression.php
	 * @return array Phar::GZ あるいは
	 * Phar::BZ2 を含む配列を返します。
	 * これは、zlib 拡張モジュールと
	 * bz2 拡張モジュールが使用可能かどうかによって決まります。
	 */
	final public static function getSupportedCompression () {}

	/**
	 * サポートするシグネチャ型の配列を返す
	 * @link http://www.php.net/manual/ja/phar.getsupportedsignatures.php
	 * @return array MD5、SHA-1、
	 * SHA-256、SHA-512 あるいは OpenSSL
	 * を含む配列を返します。
	 */
	final public static function getSupportedSignatures () {}

	/**
	 * fopen、file_get_contents、opendir などの stat 関連の関数をすべて phar に横取りさせる
	 * @link http://www.php.net/manual/ja/phar.interceptfilefuncs.php
	 * @return void 
	 */
	final public static function interceptFileFuncs () {}

	/**
	 * 指定したファイル名が正しい形式の phar ファイルかどうかを返す
	 * @link http://www.php.net/manual/ja/phar.isvalidpharfilename.php
	 * @param filename string <p>
	 * まだ作成されていない phar アーカイブの名前あるいはフルパス。
	 * </p>
	 * @param executable bool[optional] <p>
	 * このパラメータは、指定した名前のファイルを phar
	 * の実行可能アーカイブとして扱うかデータのみの非実行可能アーカイブとして扱うかを指定します。
	 * </p>
	 * @return bool 正しい形式のファイルである場合に TRUE、そうでない場合に FALSE を返します。
	 */
	final public static function isValidPharFilename ($filename, $executable = null) {}

	/**
	 * 任意の phar アーカイブを、エイリアスを指定して読み込む
	 * @link http://www.php.net/manual/ja/phar.loadphar.php
	 * @param filename string <p>
	 * オープンする phar アーカイブへの完全パスあるいは相対パス。
	 * </p>
	 * @param alias string[optional] <p>
	 * この phar アーカイブをさす際に使用するエイリアス。
	 * 多くの場合は phar アーカイブ内で明示的なエイリアスを指定しており、
	 * このような場合に新しいエイリアスを指定すると、
	 * PharException がスローされます。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	final public static function loadPhar ($filename, $alias = null) {}

	/**
	 * 現在実行されている (phar 形式の) ファイルを読み込み、その内容を登録する
	 * @link http://www.php.net/manual/ja/phar.mapphar.php
	 * @param alias string[optional] <p>
	 * このアーカイブを参照する際にフルパスのかわりに使用する、
	 * phar:// 形式の URL。
	 * </p>
	 * @param dataoffset int[optional] <p>
	 * 未使用。PEAR の PHP_Archive との互換性のために用意しています。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	final public static function mapPhar ($alias = null, $dataoffset = null) {}

	/**
	 * 現在実行中の Phar アーカイブのフルパスあるいは完全な phar URL を返す
	 * @link http://www.php.net/manual/ja/phar.running.php
	 * @param retphar bool[optional] <p>
	 * FALSE の場合は
	 * phar アーカイブのディスク上でのフルパスを返します。
	 * TRUE の場合は完全な phar URL を返します。
	 * </p>
	 * @return string ファイル名が正しい形式の場合にファイル名、それ以外の場合に空文字列を返します。
	 */
	final public static function running ($retphar = null) {}

	/**
	 * 外部のパスあるいはファイルを phar アーカイブ内に仮想的にマウントする
	 * @link http://www.php.net/manual/ja/phar.mount.php
	 * @param pharpath string <p>
	 * マウントする場所として使用する phar アーカイブ内のパス。
	 * これは phar アーカイブ内の相対パスでなければならず、また、
	 * 既に存在するパスを指定することはできません。
	 * </p>
	 * @param externalpath string <p>
	 * phar アーカイブ内にマウントしたい外部ファイルあるいはディレクトリのパスあるいは URL。
	 * </p>
	 * @return void 返り値はありません。失敗した場合は PharException をスローします。
	 */
	final public static function mount ($pharpath, $externalpath) {}

	/**
	 * 最大 4 つまでの $_SERVER 変数を実行時に変更させる
	 * @link http://www.php.net/manual/ja/phar.mungserver.php
	 * @param munglist array <p>
	 * REQUEST_URI、PHP_SELF、
	 * SCRIPT_NAME および SCRIPT_FILENAME
	 * を含む配列。その他の値を指定した場合は例外が発生します。また
	 * Phar::mungServer は大文字小文字を区別します。
	 * </p>
	 * @return void 値を返しません。
	 */
	final public static function mungServer (array $munglist) {}

	/**
	 * phar アーカイブをディスクとメモリから完全に削除する
	 * @link http://www.php.net/manual/ja/phar.unlinkarchive.php
	 * @param archive string <p>
	 * ディスク上の phar アーカイブへのパス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	final public static function unlinkArchive ($archive) {}

	/**
	 * ウェブベースの phar で使用するフロントコントローラ
	 * @link http://www.php.net/manual/ja/phar.webphar.php
	 * @param alias string[optional] <p>
	 * phar:// URL でこのアーカイブを指す際に、
	 * フルパスの代わりに使用するエイリアス。
	 * </p>
	 * @param index string[optional] <p>
	 * phar の中でディレクトリインデックスとなるファイルの場所。
	 * </p>
	 * @param f404 string[optional] <p>
	 * ファイルが見つからないときに実行するスクリプトの場所。
	 * このスクリプトは HTTP 404 ヘッダを返さなければなりません。
	 * </p>
	 * @param mimetypes array[optional] <p>
	 * ファイルの拡張子と MIME タイプを関連付けた配列。
	 * デフォルトのマッピングで十分な場合は、空の配列を渡します。
	 * デフォルトで、これらの関連が定義されています。
	 * Phar::PHPS, // highlight_file() に渡します
	 * 'c' => 'text/plain',
	 * 'cc' => 'text/plain',
	 * 'cpp' => 'text/plain',
	 * 'c++' => 'text/plain',
	 * 'dtd' => 'text/plain',
	 * 'h' => 'text/plain',
	 * 'log' => 'text/plain',
	 * 'rng' => 'text/plain',
	 * 'txt' => 'text/plain',
	 * 'xsd' => 'text/plain',
	 * 'php' => Phar::PHP, // PHP としてパースします
	 * 'inc' => Phar::PHP, // PHP としてパースします
	 * 'avi' => 'video/avi',
	 * 'bmp' => 'image/bmp',
	 * 'css' => 'text/css',
	 * 'gif' => 'image/gif',
	 * 'htm' => 'text/html',
	 * 'html' => 'text/html',
	 * 'htmls' => 'text/html',
	 * 'ico' => 'image/x-ico',
	 * 'jpe' => 'image/jpeg',
	 * 'jpg' => 'image/jpeg',
	 * 'jpeg' => 'image/jpeg',
	 * 'js' => 'application/x-javascript',
	 * 'midi' => 'audio/midi',
	 * 'mid' => 'audio/midi',
	 * 'mod' => 'audio/mod',
	 * 'mov' => 'movie/quicktime',
	 * 'mp3' => 'audio/mp3',
	 * 'mpg' => 'video/mpeg',
	 * 'mpeg' => 'video/mpeg',
	 * 'pdf' => 'application/pdf',
	 * 'png' => 'image/png',
	 * 'swf' => 'application/shockwave-flash',
	 * 'tif' => 'image/tiff',
	 * 'tiff' => 'image/tiff',
	 * 'wav' => 'audio/wav',
	 * 'xbm' => 'image/xbm',
	 * 'xml' => 'text/xml',
	 * );
	 * ?>
	 * ]]>
	 * </p>
	 * @param rewrites callable[optional] <p>
	 * 書き換え関数は、唯一のパラメータとして文字列を受け取り、string あるいは FALSE
	 * を返さないといけません。
	 * </p>
	 * <p>
	 * fast-cgi あるいは cgi を使っている場合、この関数に渡されるパラメータは
	 * $_SERVER['PATH_INFO'] の値になります。
	 * それ以外の場合、この関数に渡されるパラメータは
	 * $_SERVER['REQUEST_URI'] の値になります。
	 * </p>
	 * <p>
	 * 文字列を返した場合は、内部的なファイルパスとして扱います。FALSE を返した場合は、
	 * webPhar() が HTTP 403 を送信します。
	 * </p>
	 * @return void 値を返しません。
	 */
	final public static function webPhar ($alias = null, $index = null, $f404 = null, array $mimetypes = null, $rewrites = null) {}

	/**
	 * 現在のエントリがディレクトリかつ '.' もしくは '..' でないかどうかを返す
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.haschildren.php
	 * @param allow_links bool[optional] <p>
	 * </p>
	 * @return bool 現在のエントリが ('.' や '..' 以外の) ディレクトリであるかどうかを返します。
	 */
	public function hasChildren ($allow_links = null) {}

	/**
	 * ディレクトリであれば、現在のエントリに対するイテレータを返す
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.getchildren.php
	 * @return mixed ファイル名、ファイル情報、あるいは $this のどれかを、
	 * 設定されているフラグによって返します。
	 * FilesystemIterator
	 * の定数 も参照ください。
	 */
	public function getChildren () {}

	/**
	 * サブパスを取得する
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.getsubpath.php
	 * @return string サブパス (サブディレクトリ) を返します。
	 */
	public function getSubPath () {}

	/**
	 * サブパスと名前を取得する
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.getsubpathname.php
	 * @return string サブパス (サブディレクトリ) とファイル名を返します。
	 */
	public function getSubPathname () {}

	/**
	 * 先頭に巻き戻す
	 * @link http://www.php.net/manual/ja/filesystemiterator.rewind.php
	 * @return void 値を返しません。
	 */
	public function rewind () {}

	/**
	 * 次のファイルに移動する
	 * @link http://www.php.net/manual/ja/filesystemiterator.next.php
	 * @return void 値を返しません。
	 */
	public function next () {}

	/**
	 * 現在のファイルのキーを取得する
	 * @link http://www.php.net/manual/ja/filesystemiterator.key.php
	 * @return string 設定されているフラグに応じてパス名あるいはファイル名を返します。
	 * FilesystemIterator の定数
	 * も参照ください。
	 */
	public function key () {}

	/**
	 * 現在のファイル
	 * @link http://www.php.net/manual/ja/filesystemiterator.current.php
	 * @return mixed 設定されているフラグに応じ、ファイル名、ファイル情報あるいは $this を返します。
	 * FilesystemIterator の定数
	 * を参照ください。
	 */
	public function current () {}

	/**
	 * 処理フラグを取得する
	 * @link http://www.php.net/manual/ja/filesystemiterator.getflags.php
	 * @return int 設定されているフラグの値を返します。
	 */
	public function getFlags () {}

	/**
	 * 処理フラグを設定する
	 * @link http://www.php.net/manual/ja/filesystemiterator.setflags.php
	 * @param flags int[optional] <p>
	 * 設定する処理フラグ。
	 * FilesystemIterator の定数
	 * も参照ください。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setFlags ($flags = null) {}

	/**
	 * 現在の DirectoryIterator アイテムのファイル名を返す
	 * @link http://www.php.net/manual/ja/directoryiterator.getfilename.php
	 * @return string 現在の DirectoryIterator アイテムのファイル名を返します。
	 */
	public function getFilename () {}

	/**
	 * ファイルの拡張子を取得する
	 * @link http://www.php.net/manual/ja/directoryiterator.getextension.php
	 * @return string ファイルの拡張子を文字列で返します。もし拡張しがない場合は空文字列を返します。
	 */
	public function getExtension () {}

	/**
	 * 現在の DirectoryIterator のアイテムのベース名を取得する
	 * @link http://www.php.net/manual/ja/directoryiterator.getbasename.php
	 * @param suffix string[optional] <p>
	 * ベース名が suffix で終わる場合は、これがカットされます。
	 * </p>
	 * @return string 現在の DirectoryIterator のアイテムのベース名を返します。
	 */
	public function getBasename ($suffix = null) {}

	/**
	 * 現在の DirectoryIterator アイテムが '.' もしくは '..' であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/directoryiterator.isdot.php
	 * @return bool エントリが . あるいは ..
	 * である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isDot () {}

	/**
	 * 現在の DirectoryIterator の位置が有効なファイルであるかどうかチェックする
	 * @link http://www.php.net/manual/ja/directoryiterator.valid.php
	 * @return bool 有効な位置である場合は TRUE、それ以外の場合は FALSE を返します。
	 */
	public function valid () {}

	/**
	 * DirectoryIterator のアイテムを移動する
	 * @link http://www.php.net/manual/ja/directoryiterator.seek.php
	 * @param position int <p>
	 * 異動先を表す、ゼロから始まる位置。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function seek ($position) {}

	/**
	 * ファイル名を文字列として取得する
	 * @link http://www.php.net/manual/ja/directoryiterator.tostring.php
	 * @return string 現在の DirectoryIterator のアイテムのファイル名を返します。
	 */
	public function __toString () {}

	/**
	 * ファイルへのパスを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getpathname.php
	 * @return string ファイルへのパスを返します。
	 */
	public function getPathname () {}

	/**
	 * ファイルのパーミッションを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getperms.php
	 * @return int ファイルのパーミッションを返します。
	 */
	public function getPerms () {}

	/**
	 * ファイルの inode を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getinode.php
	 * @return int ファイルシステムオブジェクトの inode 番号を返します。
	 */
	public function getInode () {}

	/**
	 * ファイルサイズを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getsize.php
	 * @return int ファイルサイズをバイト数で返します。
	 */
	public function getSize () {}

	/**
	 * ファイルの所有者を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getowner.php
	 * @return int オーナー ID を数値形式で返します。
	 */
	public function getOwner () {}

	/**
	 * ファイルのグループを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getgroup.php
	 * @return int グループ ID を数値形式で返します。
	 */
	public function getGroup () {}

	/**
	 * ファイルの最終アクセス時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getatime.php
	 * @return int ファイルに最後にアクセスがあった時刻を返します。
	 */
	public function getATime () {}

	/**
	 * 最終変更時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getmtime.php
	 * @return int ファイルの最終変更時刻を Unix タイムスタンプで返します。
	 */
	public function getMTime () {}

	/**
	 * inode 変更時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getctime.php
	 * @return int 最終変更時刻を Unix タイムスタンプで返します。
	 */
	public function getCTime () {}

	/**
	 * ファイルタイプを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.gettype.php
	 * @return string このエントリの型を文字列で返します。file、link
	 * あるいは dir のいずれかとなります。
	 */
	public function getType () {}

	/**
	 * ファイルが読み込み可能か調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isreadable.php
	 * @return bool 読み込み可能である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isReadable () {}

	/**
	 * ファイルが実行可能かどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isexecutable.php
	 * @return bool 実行可能である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isExecutable () {}

	/**
	 * オブジェクトの参照先が通常のファイルであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isfile.php
	 * @return bool ファイルが存在してかつ (リンクではない) 通常のファイルである場合に TRUE、
	 * そうでない場合に FALSE を返します。
	 */
	public function isFile () {}

	/**
	 * ファイルがディレクトリかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isdir.php
	 * @return bool ディレクトリである場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isDir () {}

	/**
	 * ファイルがリンクであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.islink.php
	 * @return bool ファイルがリンクである場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isLink () {}

	/**
	 * リンク先を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getlinktarget.php
	 * @return string ファイルシステムのリンク先を返します。
	 */
	public function getLinkTarget () {}

	/**
	 * ファイルへの絶対パスを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getrealpath.php
	 * @return string ファイルへのパスを返します。
	 */
	public function getRealPath () {}

	/**
	 * ファイルの SplFileInfo オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getfileinfo.php
	 * @param class_name string[optional] <p>
	 * 使用したい SplFileInfo 派生クラスの名前。
	 * </p>
	 * @return SplFileInfo そのファイル用に作成した SplFileInfo オブジェクトを返します。
	 */
	public function getFileInfo ($class_name = null) {}

	/**
	 * パスの SplFileInfo オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getpathinfo.php
	 * @param class_name string[optional] <p>
	 * 使用したい SplFileInfo 派生クラスの名前。
	 * </p>
	 * @return SplFileInfo ファイルの親のパスの SplFileInfo オブジェクトを返します。
	 */
	public function getPathInfo ($class_name = null) {}

	/**
	 * ファイルの SplFileObject オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.openfile.php
	 * @param open_mode string[optional] <p>
	 * ファイルを開く際のモード。使用できるモードについての説明は
	 * fopen のドキュメントを参照ください。
	 * デフォルトは読み込み専用となります。
	 * </p>
	 * @param use_include_path bool[optional] <p>
	 * TRUE に設定すると、このファイル名を
	 * include_path の中からも探します。
	 * </p>
	 * @param context resource[optional] <p>
	 * コンテキスト についての説明は、
	 * マニュアルの コンテキスト の節を参照ください。
	 * </p>
	 * @return SplFileObject オープンしたファイルを SplFileObject オブジェクトで返します。
	 */
	public function openFile ($open_mode = null, $use_include_path = null, $context = null) {}

	/**
	 * <methodname>SplFileInfo::openFile</methodname> で使用するクラス名を設定する
	 * @link http://www.php.net/manual/ja/splfileinfo.setfileclass.php
	 * @param class_name string[optional] <p>
	 * openFile() がコールされた際に使用するクラス名。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setFileClass ($class_name = null) {}

	/**
	 * getFileInfo および getPathInfo で使用するクラスを設定する
	 * @link http://www.php.net/manual/ja/splfileinfo.setinfoclass.php
	 * @param class_name string[optional] <p>
	 * 使用するクラス名。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setInfoClass ($class_name = null) {}

	final public function _bad_state_ex () {}

}

class PharData extends RecursiveDirectoryIterator implements RecursiveIterator, SeekableIterator, Traversable, Iterator, Countable, ArrayAccess {
	const CURRENT_MODE_MASK = 240;
	const CURRENT_AS_PATHNAME = 32;
	const CURRENT_AS_FILEINFO = 0;
	const CURRENT_AS_SELF = 16;
	const KEY_MODE_MASK = 3840;
	const KEY_AS_PATHNAME = 0;
	const FOLLOW_SYMLINKS = 512;
	const KEY_AS_FILENAME = 256;
	const NEW_CURRENT_AND_KEY = 256;
	const OTHER_MODE_MASK = 12288;
	const SKIP_DOTS = 4096;
	const UNIX_PATHS = 8192;


	/**
	 * 実行可能でない tar あるいは zip アーカイブオブジェクトを作成する
	 * @link http://www.php.net/manual/ja/phardata.construct.php
	 * @param filename
	 * @param flags[optional]
	 * @param alias[optional]
	 * @param fileformat[optional]
	 */
	public function __construct ($filename, $flags, $alias, $fileformat) {}

	public function __destruct () {}

	/**
	 * 空のディレクトリを tar/zip アーカイブに追加する
	 * @link http://www.php.net/manual/ja/phardata.addemptydir.php
	 * @param dirname string <p>
	 * phar アーカイブ内に作成する空のディレクトリの名前。
	 * </p>
	 * @return bool 返り値はありません。失敗時には例外をスローします。
	 */
	public function addEmptyDir ($dirname) {}

	/**
	 * ファイルシステム上のファイルを tar/zip アーカイブに追加する
	 * @link http://www.php.net/manual/ja/phardata.addfile.php
	 * @param file string <p>
	 * phar アーカイブに追加したいディスク上のファイルへのフルパスあるいは相対パス。
	 * </p>
	 * @param localname string[optional] <p>
	 * ファイルをアーカイブ内に格納するときのパス。
	 * </p>
	 * @return void 返り値はありません。失敗時には例外をスローします。
	 */
	public function addFile ($file, $localname = null) {}

	/**
	 * ファイルシステム上のファイルを tar/zip アーカイブに追加する
	 * @link http://www.php.net/manual/ja/phardata.addfromstring.php
	 * @param localname string <p>
	 * ファイルをアーカイブ内に格納するときのパス。
	 * </p>
	 * @param contents string <p>
	 * ファイルに保存する内容。
	 * </p>
	 * @return bool 返り値はありません。失敗時には例外をスローします。
	 */
	public function addFromString ($localname, $contents) {}

	/**
	 * ディレクトリ内のファイルから tar/zip アーカイブを作成する
	 * @link http://www.php.net/manual/ja/phardata.buildfromdirectory.php
	 * @param base_dir string <p>
	 * アーカイブに追加するすべてのファイルを含むディレクトリへの
	 * フルパスあるいは相対パス。
	 * </p>
	 * @param regex string[optional] <p>
	 * オプションで指定する pcre 正規表現。
	 * これを使用してファイル一覧をフィルタリングします。
	 * 正規表現にマッチするファイルパスのみがアーカイブに追加されます。
	 * </p>
	 * @return array Phar::buildFromDirectory
	 * は、連想配列を返します。これは、
	 * ファイルの内部パスをファイルシステム上のフルパスを対応させたものです。
	 */
	public function buildFromDirectory ($base_dir, $regex = null) {}

	/**
	 * イテレータから tar あるいは zip アーカイブを作成する
	 * @link http://www.php.net/manual/ja/phardata.buildfromiterator.php
	 * @param iter Iterator <p>
	 * phar ファイルと実際の場所の関連を返すイテレータ、
	 * あるいは SplFileInfo オブジェクトを返すイテレータ。
	 * </p>
	 * @param base_directory string[optional] <p>
	 * SplFileInfo オブジェクトを返すイテレータを指定した際、
	 * tar/zip アーカイブへの追加時にフルパスから取り除く部分。
	 * </p>
	 * @return array PharData::buildFromIterator
	 * は連想配列を返します。
	 * これは、ファイルの内部パスとファイルシステム上のフルパスを対応させたものです。
	 */
	public function buildFromIterator ($iter, $base_directory = null) {}

	/**
	 * 現在の tar/zip アーカイブ内のすべてのファイルを圧縮する
	 * @link http://www.php.net/manual/ja/phardata.compressfiles.php
	 * @param compression int <p>
	 * 圧縮を行う場合は Phar::GZ あるいは
	 * Phar::BZ2、圧縮を解除するためには Phar::NONE
	 * のいずれかを指定しなければなりません。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function compressFiles ($compression) {}

	/**
	 * 現在の zip アーカイブ内のすべてのファイルの圧縮を解除する
	 * @link http://www.php.net/manual/ja/phardata.decompressfiles.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function decompressFiles () {}

	/**
	 * tar/zip アーカイブ全体を Gzip あるいは Bzip2 で圧縮する
	 * @link http://www.php.net/manual/ja/phardata.compress.php
	 * @param compression int <p>
	 * 圧縮を行う場合には Phar::GZ あるいは
	 * Phar::BZ2、圧縮を解除する場合には
	 * Phar::NONE を指定します。
	 * </p>
	 * @param extension string[optional] <p>
	 * デフォルトでは、tar を圧縮する際の拡張子は .tar.gz
	 * あるいは .tar.bz2、伸長する際の拡張子は
	 * .tar となります。
	 * </p>
	 * @return object PharData オブジェクトを返します。
	 */
	public function compress ($compression, $extension = null) {}

	/**
	 * Phar アーカイブ全体の圧縮を解除する
	 * @link http://www.php.net/manual/ja/phardata.decompress.php
	 * @param extension string[optional] <p>
	 * 圧縮を解除する場合、デフォルトのファイル拡張子は
	 * .phar.tar です。
	 * このパラメータを使用すると、別の拡張子を指定することができます。
	 * 実行可能な phar アーカイブは、ファイル名に必ず
	 * .phar を含まなければならないことに注意しましょう。
	 * </p>
	 * @return object PharData オブジェクトを返します。
	 */
	public function decompress ($extension = null) {}

	/**
	 * 実行可能でない tar/zip アーカイブを実行可能な phar アーカイブ形式に変換する
	 * @link http://www.php.net/manual/ja/phardata.converttoexecutable.php
	 * @param format int[optional] <p>
	 * これは Phar::PHAR、Phar::TAR
	 * あるいは Phar::ZIP のいずれかとなります。
	 * NULL を指定すると、現在のファイル形式をそのまま保持します。
	 * </p>
	 * @param compression int[optional] <p>
	 * アーカイブ全体の圧縮を行わない場合は Phar::NONE、
	 * zlib による圧縮の場合は Phar::GZ、そして bzip による圧縮の場合は
	 * Phar::BZ2 のいずれかを指定します。
	 * </p>
	 * @param extension string[optional] <p>
	 * このパラメータは、変換後のアーカイブのデフォルトのファイル拡張子を変更します。
	 * 実行可能でない tar や zip アーカイブのファイル名としては
	 * .phar は使用できないことに注意しましょう。
	 * </p>
	 * <p>
	 * phar 形式のアーカイブに変換する場合、デフォルトの拡張子は圧縮形式によって
	 * .phar、.phar.gz あるいは .phar.bz2
	 * のいずれかとなります。tar 形式のアーカイブの場合、デフォルトの拡張子は
	 * .phar.tar、.phar.tar.gz
	 * および .phar.tar.bz2 です。zip 形式のアーカイブの場合、
	 * デフォルトの拡張子は .phar.zip となります。
	 * </p>
	 * @return Phar このメソッドは、成功した場合に Phar
	 * オブジェクトを返します。失敗した場合は例外をスローします。
	 */
	public function convertToExecutable ($format = null, $compression = null, $extension = null) {}

	/**
	 * phar アーカイブを実行可能でない tar あるいは zip ファイルに変換する
	 * @link http://www.php.net/manual/ja/phardata.converttodata.php
	 * @param format int[optional] <p>
	 * これは Phar::TAR
	 * あるいは Phar::ZIP のいずれかとなります。
	 * NULL を指定すると、現在のファイル形式をそのまま保持します。
	 * </p>
	 * @param compression int[optional] <p>
	 * アーカイブ全体の圧縮を行わない場合は Phar::NONE、
	 * zlib による圧縮の場合は Phar::GZ、そして bzip による圧縮の場合は
	 * Phar::BZ2 のいずれかを指定します。
	 * </p>
	 * @param extension string[optional] <p>
	 * このパラメータは、変換後のアーカイブのデフォルトのファイル拡張子を変更します。
	 * 実行可能でない tar や zip アーカイブのファイル名としては
	 * .phar は使用できないことに注意しましょう。
	 * </p>
	 * <p>
	 * tar 形式の phar アーカイブの場合、デフォルトの拡張子は圧縮形式によって
	 * .tar、.tar.gz、
	 * .tar.bz2 のいずれかとなります。
	 * zip 形式のアーカイブの場合、デフォルトの拡張子は
	 * .zip となります。
	 * </p>
	 * @return PharData このメソッドは、成功した場合に PharData
	 * オブジェクトを返します。失敗した場合は例外をスローします。
	 */
	public function convertToData ($format = null, $compression = null, $extension = null) {}

	/**
	 * phar アーカイブ内のファイルを、phar 内で別の新しいファイルとしてコピーする
	 * @link http://www.php.net/manual/ja/phardata.copy.php
	 * @param oldfile string <p>
	 * </p>
	 * @param newfile string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。しかし、より安全を期すなら
	 * try/catch ブロック内で使用して例外がスローされないことを確認するといいでしょう。
	 */
	public function copy ($oldfile, $newfile) {}

	public function count () {}

	/**
	 * tar/zip アーカイブ内のファイルを削除する
	 * @link http://www.php.net/manual/ja/phardata.delete.php
	 * @param entry string <p>
	 * 削除したいファイルの、アーカイブ内でのパス。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 * しかし、例外がスローされているかどうかを確認したうえで
	 * 例外がなければ成功とみなすほうがいいでしょう。
	 */
	public function delete ($entry) {}

	/**
	 * zip アーカイブのグローバルメタデータを削除する
	 * @link http://www.php.net/manual/ja/phardata.delmetadata.php
	 * @return bool 成功した場合に TRUE を返します。しかし、より安全を期すなら
	 * 例外がスローされないことを確認するといいでしょう。
	 */
	public function delMetadata () {}

	/**
	 * tar/zip アーカイブの内容をディレクトリに展開する
	 * @link http://www.php.net/manual/ja/phardata.extractto.php
	 * @param pathto string <p>
	 * アーカイブ内のファイルへのパス。
	 * </p>
	 * @param files string|array[optional] <p>
	 * 展開したいファイル名/ディレクトリ名、あるいはその配列。
	 * </p>
	 * @param overwrite bool[optional] <p>
	 * TRUE にすると既存のファイルを上書きします。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 * しかし、例外がスローされているかどうかを確認したうえで
	 * 例外がなければ成功とみなすほうがいいでしょう。
	 */
	public function extractTo ($pathto, $files = null, $overwrite = null) {}

	public function getAlias () {}

	public function getPath () {}

	public function getMetadata () {}

	public function getModified () {}

	public function getSignature () {}

	public function getStub () {}

	public function getVersion () {}

	public function hasMetadata () {}

	public function isBuffering () {}

	public function isCompressed () {}

	/**
	 * @param fileformat
	 */
	public function isFileFormat ($fileformat) {}

	/**
	 * tar/zip アーカイブが変更可能な場合に true を返す
	 * @link http://www.php.net/manual/ja/phardata.iswritable.php
	 * @return bool tar/zip アーカイブが変更可能な場合に TRUE を返します。
	 */
	public function isWritable () {}

	/**
	 * @param entry
	 */
	public function offsetExists ($entry) {}

	/**
	 * @param entry
	 */
	public function offsetGet ($entry) {}

	/**
	 * tar/zip の内部のファイルに、外部ファイルあるいは文字列の内容を設定する
	 * @link http://www.php.net/manual/ja/phardata.offsetset.php
	 * @param offset string <p>
	 * tar あるいは zip アーカイブ内で変更するファイル名 (相対パス)。
	 * </p>
	 * @param value string <p>
	 * ファイルの内容。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function offsetSet ($offset, $value) {}

	/**
	 * ファイルを tar/zip アーカイブから削除する
	 * @link http://www.php.net/manual/ja/phardata.offsetunset.php
	 * @param offset string <p>
	 * tar/zip アーカイブ内で変更するファイル名 (相対パス)。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function offsetUnset ($offset) {}

	/**
	 * ダミー関数 (Phar::setAlias は PharData では使用不能)
	 * @link http://www.php.net/manual/ja/phardata.setalias.php
	 * @param alias string <p>
	 * このアーカイブを指すときに使用する短い文字列。
	 * phar ストリームラッパーがアクセスする際にこれを使用します。
	 * このパラメータは無視されます。
	 * </p>
	 * @return bool 
	 */
	public function setAlias ($alias) {}

	/**
	 * ダミー関数 (Phar::setDefaultStub は PharData では無効)
	 * @link http://www.php.net/manual/ja/phardata.setdefaultstub.php
	 * @param index string[optional] <p>
	 * コマンドラインからアクセスした場合に実行する、
	 * phar アーカイブ内の相対パス。
	 * </p>
	 * @param webindex string[optional] <p>
	 * ウェブブラウザからアクセスした場合に実行する、
	 * phar アーカイブ内の相対パス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setDefaultStub ($index = null, $webindex = null) {}

	/**
	 * @param metadata
	 */
	public function setMetadata ($metadata) {}

	/**
	 * @param algorithm
	 * @param privatekey[optional]
	 */
	public function setSignatureAlgorithm ($algorithm, $privatekey) {}

	/**
	 * ダミー関数 (Phar::setStub は PharData では使用不能)
	 * @link http://www.php.net/manual/ja/phardata.setstub.php
	 * @param stub string <p>
	 * 文字列あるいはオープンしたストリームハンドル。
	 * この phar アーカイブの実行スタブとして使用します。
	 * このパラメータは無視されます。
	 * </p>
	 * @param len int[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setStub ($stub, $len = null) {}

	public function startBuffering () {}

	public function stopBuffering () {}

	final public static function apiVersion () {}

	/**
	 * @param method[optional]
	 */
	final public static function canCompress ($method) {}

	final public static function canWrite () {}

	/**
	 * @param index[optional]
	 * @param webindex[optional]
	 */
	final public static function createDefaultStub ($index, $webindex) {}

	final public static function getSupportedCompression () {}

	final public static function getSupportedSignatures () {}

	final public static function interceptFileFuncs () {}

	/**
	 * @param filename
	 * @param executable[optional]
	 */
	final public static function isValidPharFilename ($filename, $executable) {}

	/**
	 * @param filename
	 * @param alias[optional]
	 */
	final public static function loadPhar ($filename, $alias) {}

	/**
	 * @param alias[optional]
	 * @param offset[optional]
	 */
	final public static function mapPhar ($alias, $offset) {}

	/**
	 * @param retphar
	 */
	final public static function running ($retphar) {}

	/**
	 * @param inphar
	 * @param externalfile
	 */
	final public static function mount ($inphar, $externalfile) {}

	/**
	 * @param munglist
	 */
	final public static function mungServer ($munglist) {}

	/**
	 * @param archive
	 */
	final public static function unlinkArchive ($archive) {}

	/**
	 * @param alias[optional]
	 * @param index[optional]
	 * @param f404[optional]
	 * @param mimetypes[optional]
	 * @param rewrites[optional]
	 */
	final public static function webPhar ($alias, $index, $f404, $mimetypes, $rewrites) {}

	/**
	 * 現在のエントリがディレクトリかつ '.' もしくは '..' でないかどうかを返す
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.haschildren.php
	 * @param allow_links bool[optional] <p>
	 * </p>
	 * @return bool 現在のエントリが ('.' や '..' 以外の) ディレクトリであるかどうかを返します。
	 */
	public function hasChildren ($allow_links = null) {}

	/**
	 * ディレクトリであれば、現在のエントリに対するイテレータを返す
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.getchildren.php
	 * @return mixed ファイル名、ファイル情報、あるいは $this のどれかを、
	 * 設定されているフラグによって返します。
	 * FilesystemIterator
	 * の定数 も参照ください。
	 */
	public function getChildren () {}

	/**
	 * サブパスを取得する
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.getsubpath.php
	 * @return string サブパス (サブディレクトリ) を返します。
	 */
	public function getSubPath () {}

	/**
	 * サブパスと名前を取得する
	 * @link http://www.php.net/manual/ja/recursivedirectoryiterator.getsubpathname.php
	 * @return string サブパス (サブディレクトリ) とファイル名を返します。
	 */
	public function getSubPathname () {}

	/**
	 * 先頭に巻き戻す
	 * @link http://www.php.net/manual/ja/filesystemiterator.rewind.php
	 * @return void 値を返しません。
	 */
	public function rewind () {}

	/**
	 * 次のファイルに移動する
	 * @link http://www.php.net/manual/ja/filesystemiterator.next.php
	 * @return void 値を返しません。
	 */
	public function next () {}

	/**
	 * 現在のファイルのキーを取得する
	 * @link http://www.php.net/manual/ja/filesystemiterator.key.php
	 * @return string 設定されているフラグに応じてパス名あるいはファイル名を返します。
	 * FilesystemIterator の定数
	 * も参照ください。
	 */
	public function key () {}

	/**
	 * 現在のファイル
	 * @link http://www.php.net/manual/ja/filesystemiterator.current.php
	 * @return mixed 設定されているフラグに応じ、ファイル名、ファイル情報あるいは $this を返します。
	 * FilesystemIterator の定数
	 * を参照ください。
	 */
	public function current () {}

	/**
	 * 処理フラグを取得する
	 * @link http://www.php.net/manual/ja/filesystemiterator.getflags.php
	 * @return int 設定されているフラグの値を返します。
	 */
	public function getFlags () {}

	/**
	 * 処理フラグを設定する
	 * @link http://www.php.net/manual/ja/filesystemiterator.setflags.php
	 * @param flags int[optional] <p>
	 * 設定する処理フラグ。
	 * FilesystemIterator の定数
	 * も参照ください。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setFlags ($flags = null) {}

	/**
	 * 現在の DirectoryIterator アイテムのファイル名を返す
	 * @link http://www.php.net/manual/ja/directoryiterator.getfilename.php
	 * @return string 現在の DirectoryIterator アイテムのファイル名を返します。
	 */
	public function getFilename () {}

	/**
	 * ファイルの拡張子を取得する
	 * @link http://www.php.net/manual/ja/directoryiterator.getextension.php
	 * @return string ファイルの拡張子を文字列で返します。もし拡張しがない場合は空文字列を返します。
	 */
	public function getExtension () {}

	/**
	 * 現在の DirectoryIterator のアイテムのベース名を取得する
	 * @link http://www.php.net/manual/ja/directoryiterator.getbasename.php
	 * @param suffix string[optional] <p>
	 * ベース名が suffix で終わる場合は、これがカットされます。
	 * </p>
	 * @return string 現在の DirectoryIterator のアイテムのベース名を返します。
	 */
	public function getBasename ($suffix = null) {}

	/**
	 * 現在の DirectoryIterator アイテムが '.' もしくは '..' であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/directoryiterator.isdot.php
	 * @return bool エントリが . あるいは ..
	 * である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isDot () {}

	/**
	 * 現在の DirectoryIterator の位置が有効なファイルであるかどうかチェックする
	 * @link http://www.php.net/manual/ja/directoryiterator.valid.php
	 * @return bool 有効な位置である場合は TRUE、それ以外の場合は FALSE を返します。
	 */
	public function valid () {}

	/**
	 * DirectoryIterator のアイテムを移動する
	 * @link http://www.php.net/manual/ja/directoryiterator.seek.php
	 * @param position int <p>
	 * 異動先を表す、ゼロから始まる位置。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function seek ($position) {}

	/**
	 * ファイル名を文字列として取得する
	 * @link http://www.php.net/manual/ja/directoryiterator.tostring.php
	 * @return string 現在の DirectoryIterator のアイテムのファイル名を返します。
	 */
	public function __toString () {}

	/**
	 * ファイルへのパスを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getpathname.php
	 * @return string ファイルへのパスを返します。
	 */
	public function getPathname () {}

	/**
	 * ファイルのパーミッションを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getperms.php
	 * @return int ファイルのパーミッションを返します。
	 */
	public function getPerms () {}

	/**
	 * ファイルの inode を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getinode.php
	 * @return int ファイルシステムオブジェクトの inode 番号を返します。
	 */
	public function getInode () {}

	/**
	 * ファイルサイズを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getsize.php
	 * @return int ファイルサイズをバイト数で返します。
	 */
	public function getSize () {}

	/**
	 * ファイルの所有者を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getowner.php
	 * @return int オーナー ID を数値形式で返します。
	 */
	public function getOwner () {}

	/**
	 * ファイルのグループを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getgroup.php
	 * @return int グループ ID を数値形式で返します。
	 */
	public function getGroup () {}

	/**
	 * ファイルの最終アクセス時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getatime.php
	 * @return int ファイルに最後にアクセスがあった時刻を返します。
	 */
	public function getATime () {}

	/**
	 * 最終変更時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getmtime.php
	 * @return int ファイルの最終変更時刻を Unix タイムスタンプで返します。
	 */
	public function getMTime () {}

	/**
	 * inode 変更時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getctime.php
	 * @return int 最終変更時刻を Unix タイムスタンプで返します。
	 */
	public function getCTime () {}

	/**
	 * ファイルタイプを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.gettype.php
	 * @return string このエントリの型を文字列で返します。file、link
	 * あるいは dir のいずれかとなります。
	 */
	public function getType () {}

	/**
	 * ファイルが読み込み可能か調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isreadable.php
	 * @return bool 読み込み可能である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isReadable () {}

	/**
	 * ファイルが実行可能かどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isexecutable.php
	 * @return bool 実行可能である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isExecutable () {}

	/**
	 * オブジェクトの参照先が通常のファイルであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isfile.php
	 * @return bool ファイルが存在してかつ (リンクではない) 通常のファイルである場合に TRUE、
	 * そうでない場合に FALSE を返します。
	 */
	public function isFile () {}

	/**
	 * ファイルがディレクトリかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isdir.php
	 * @return bool ディレクトリである場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isDir () {}

	/**
	 * ファイルがリンクであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.islink.php
	 * @return bool ファイルがリンクである場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isLink () {}

	/**
	 * リンク先を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getlinktarget.php
	 * @return string ファイルシステムのリンク先を返します。
	 */
	public function getLinkTarget () {}

	/**
	 * ファイルへの絶対パスを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getrealpath.php
	 * @return string ファイルへのパスを返します。
	 */
	public function getRealPath () {}

	/**
	 * ファイルの SplFileInfo オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getfileinfo.php
	 * @param class_name string[optional] <p>
	 * 使用したい SplFileInfo 派生クラスの名前。
	 * </p>
	 * @return SplFileInfo そのファイル用に作成した SplFileInfo オブジェクトを返します。
	 */
	public function getFileInfo ($class_name = null) {}

	/**
	 * パスの SplFileInfo オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getpathinfo.php
	 * @param class_name string[optional] <p>
	 * 使用したい SplFileInfo 派生クラスの名前。
	 * </p>
	 * @return SplFileInfo ファイルの親のパスの SplFileInfo オブジェクトを返します。
	 */
	public function getPathInfo ($class_name = null) {}

	/**
	 * ファイルの SplFileObject オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.openfile.php
	 * @param open_mode string[optional] <p>
	 * ファイルを開く際のモード。使用できるモードについての説明は
	 * fopen のドキュメントを参照ください。
	 * デフォルトは読み込み専用となります。
	 * </p>
	 * @param use_include_path bool[optional] <p>
	 * TRUE に設定すると、このファイル名を
	 * include_path の中からも探します。
	 * </p>
	 * @param context resource[optional] <p>
	 * コンテキスト についての説明は、
	 * マニュアルの コンテキスト の節を参照ください。
	 * </p>
	 * @return SplFileObject オープンしたファイルを SplFileObject オブジェクトで返します。
	 */
	public function openFile ($open_mode = null, $use_include_path = null, $context = null) {}

	/**
	 * <methodname>SplFileInfo::openFile</methodname> で使用するクラス名を設定する
	 * @link http://www.php.net/manual/ja/splfileinfo.setfileclass.php
	 * @param class_name string[optional] <p>
	 * openFile() がコールされた際に使用するクラス名。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setFileClass ($class_name = null) {}

	/**
	 * getFileInfo および getPathInfo で使用するクラスを設定する
	 * @link http://www.php.net/manual/ja/splfileinfo.setinfoclass.php
	 * @param class_name string[optional] <p>
	 * 使用するクラス名。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setInfoClass ($class_name = null) {}

	final public function _bad_state_ex () {}

}

class PharFileInfo extends SplFileInfo  {

	/**
	 * Phar エントリオブジェクトを作成する
	 * @link http://www.php.net/manual/ja/pharfileinfo.construct.php
	 * @param filename
	 */
	public function __construct ($filename) {}

	public function __destruct () {}

	/**
	 * ファイル固有のパーミッションビットを設定する
	 * @link http://www.php.net/manual/ja/pharfileinfo.chmod.php
	 * @param permissions int <p>
	 * パーミッション (chmod を参照ください)。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function chmod ($permissions) {}

	/**
	 * 現在の Phar エントリを zlib あるいは bzip2 のいずれかで圧縮する
	 * @link http://www.php.net/manual/ja/pharfileinfo.compress.php
	 * @param compression int 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function compress ($compression) {}

	/**
	 * phar 内の現在の Phar エントリの圧縮を解除する
	 * @link http://www.php.net/manual/ja/pharfileinfo.decompress.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function decompress () {}

	/**
	 * エントリのメタデータを削除する
	 * @link http://www.php.net/manual/ja/pharfileinfo.delmetadata.php
	 * @return bool 成功した場合に TRUE を返します。
	 * エントリがメタデータを持っていない場合に FALSE を返します。
	 * この関数は phar の内容を変更するので、Phar
	 * アーカイブ内のファイルを操作するには INI 設定
	 * phar.readonly がオフでなければなりません。
	 * PharData アーカイブ内のファイルについては、この制約はありません。
	 */
	public function delMetadata () {}

	/**
	 * Phar アーカイブ内での実際のファイルの大きさ (圧縮された状態) を返す
	 * @link http://www.php.net/manual/ja/pharfileinfo.getcompressedsize.php
	 * @return int ディスク上の Phar アーカイブ内のファイルのバイト数を返します。
	 */
	public function getCompressedSize () {}

	/**
	 * CRC32 コードを返すか、CRC がチェックできない場合に例外をスローする
	 * @link http://www.php.net/manual/ja/pharfileinfo.getcrc32.php
	 * @return int Phar アーカイブ内のファイルの
	 * crc32 チェックサムを返します。
	 */
	public function getCRC32 () {}

	public function getContent () {}

	/**
	 * ファイルとともに保存されている、ファイル固有のメタデータを返す
	 * @link http://www.php.net/manual/ja/pharfileinfo.getmetadata.php
	 * @return mixed ファイルのメタデータとして保存されている、シリアライズ可能な任意の PHP 変数を返します。
	 * メタデータが保存されていない場合は NULL を返します。
	 */
	public function getMetadata () {}

	/**
	 * Phar ファイルエントリのフラグを返す
	 * @link http://www.php.net/manual/ja/pharfileinfo.getpharflags.php
	 * @return int Phar フラグを返します (現在の実装では、常に 0 となります)。
	 */
	public function getPharFlags () {}

	/**
	 * エントリのメタデータを返す
	 * @link http://www.php.net/manual/ja/pharfileinfo.hasmetadata.php
	 * @return bool メタデータが設定されていないかあるいは NULL が設定されている場合に FALSE、
	 * NULL 以外のメタデータが設定されている場合に TRUE を返します。
	 */
	public function hasMetadata () {}

	/**
	 * エントリが圧縮されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/pharfileinfo.iscompressed.php
	 * @param compression_type int[optional] <p>
	 * Phar::GZ あるいは Phar::BZ2
	 * のいずれか。デフォルトは任意の圧縮形式となります。
	 * </p>
	 * @return bool Phar アーカイブ内のファイルが圧縮されている場合に TRUE、
	 * そうでない場合に FALSE を返します。
	 */
	public function isCompressed ($compression_type = null) {}

	/**
	 * ファイルエントリの CRC が検証されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/pharfileinfo.iscrcchecked.php
	 * @return bool そのファイルの CRC が検証されている場合に TRUE、
	 * そうでない場合に FALSE を返します。
	 */
	public function isCRCChecked () {}

	/**
	 * ファイルとともに保存する、ファイル固有のメタデータを設定する
	 * @link http://www.php.net/manual/ja/pharfileinfo.setmetadata.php
	 * @param metadata mixed <p>
	 * ファイルとともに保存する情報を含む、PHP の変数。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setMetadata ($metadata) {}

	/**
	 * ファイル名を除いたパスを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getpath.php
	 * @return string ファイルへのパスを返します。
	 */
	public function getPath () {}

	/**
	 * ファイル名を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getfilename.php
	 * @return string ファイル名を返します。
	 */
	public function getFilename () {}

	/**
	 * ファイルの拡張子を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getextension.php
	 * @return string ファイルの拡張子を含む文字列を返します。
	 * 拡張子がないときは、空文字列を返します。
	 */
	public function getExtension () {}

	/**
	 * ファイルのベース名を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getbasename.php
	 * @param suffix string[optional] <p>
	 * 返されるベース名から取り除きたい、オプションのサフィックス。
	 * </p>
	 * @return string パス情報を含まないベース名を返します。
	 */
	public function getBasename ($suffix = null) {}

	/**
	 * ファイルへのパスを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getpathname.php
	 * @return string ファイルへのパスを返します。
	 */
	public function getPathname () {}

	/**
	 * ファイルのパーミッションを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getperms.php
	 * @return int ファイルのパーミッションを返します。
	 */
	public function getPerms () {}

	/**
	 * ファイルの inode を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getinode.php
	 * @return int ファイルシステムオブジェクトの inode 番号を返します。
	 */
	public function getInode () {}

	/**
	 * ファイルサイズを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getsize.php
	 * @return int ファイルサイズをバイト数で返します。
	 */
	public function getSize () {}

	/**
	 * ファイルの所有者を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getowner.php
	 * @return int オーナー ID を数値形式で返します。
	 */
	public function getOwner () {}

	/**
	 * ファイルのグループを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getgroup.php
	 * @return int グループ ID を数値形式で返します。
	 */
	public function getGroup () {}

	/**
	 * ファイルの最終アクセス時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getatime.php
	 * @return int ファイルに最後にアクセスがあった時刻を返します。
	 */
	public function getATime () {}

	/**
	 * 最終変更時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getmtime.php
	 * @return int ファイルの最終変更時刻を Unix タイムスタンプで返します。
	 */
	public function getMTime () {}

	/**
	 * inode 変更時刻を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getctime.php
	 * @return int 最終変更時刻を Unix タイムスタンプで返します。
	 */
	public function getCTime () {}

	/**
	 * ファイルタイプを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.gettype.php
	 * @return string このエントリの型を文字列で返します。file、link
	 * あるいは dir のいずれかとなります。
	 */
	public function getType () {}

	/**
	 * エントリが書き込み可能であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.iswritable.php
	 * @return bool 書き込み可能な場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isWritable () {}

	/**
	 * ファイルが読み込み可能か調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isreadable.php
	 * @return bool 読み込み可能である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isReadable () {}

	/**
	 * ファイルが実行可能かどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isexecutable.php
	 * @return bool 実行可能である場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isExecutable () {}

	/**
	 * オブジェクトの参照先が通常のファイルであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isfile.php
	 * @return bool ファイルが存在してかつ (リンクではない) 通常のファイルである場合に TRUE、
	 * そうでない場合に FALSE を返します。
	 */
	public function isFile () {}

	/**
	 * ファイルがディレクトリかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.isdir.php
	 * @return bool ディレクトリである場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isDir () {}

	/**
	 * ファイルがリンクであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/splfileinfo.islink.php
	 * @return bool ファイルがリンクである場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function isLink () {}

	/**
	 * リンク先を取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getlinktarget.php
	 * @return string ファイルシステムのリンク先を返します。
	 */
	public function getLinkTarget () {}

	/**
	 * ファイルへの絶対パスを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getrealpath.php
	 * @return string ファイルへのパスを返します。
	 */
	public function getRealPath () {}

	/**
	 * ファイルの SplFileInfo オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getfileinfo.php
	 * @param class_name string[optional] <p>
	 * 使用したい SplFileInfo 派生クラスの名前。
	 * </p>
	 * @return SplFileInfo そのファイル用に作成した SplFileInfo オブジェクトを返します。
	 */
	public function getFileInfo ($class_name = null) {}

	/**
	 * パスの SplFileInfo オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.getpathinfo.php
	 * @param class_name string[optional] <p>
	 * 使用したい SplFileInfo 派生クラスの名前。
	 * </p>
	 * @return SplFileInfo ファイルの親のパスの SplFileInfo オブジェクトを返します。
	 */
	public function getPathInfo ($class_name = null) {}

	/**
	 * ファイルの SplFileObject オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/splfileinfo.openfile.php
	 * @param open_mode string[optional] <p>
	 * ファイルを開く際のモード。使用できるモードについての説明は
	 * fopen のドキュメントを参照ください。
	 * デフォルトは読み込み専用となります。
	 * </p>
	 * @param use_include_path bool[optional] <p>
	 * TRUE に設定すると、このファイル名を
	 * include_path の中からも探します。
	 * </p>
	 * @param context resource[optional] <p>
	 * コンテキスト についての説明は、
	 * マニュアルの コンテキスト の節を参照ください。
	 * </p>
	 * @return SplFileObject オープンしたファイルを SplFileObject オブジェクトで返します。
	 */
	public function openFile ($open_mode = null, $use_include_path = null, $context = null) {}

	/**
	 * <methodname>SplFileInfo::openFile</methodname> で使用するクラス名を設定する
	 * @link http://www.php.net/manual/ja/splfileinfo.setfileclass.php
	 * @param class_name string[optional] <p>
	 * openFile() がコールされた際に使用するクラス名。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setFileClass ($class_name = null) {}

	/**
	 * getFileInfo および getPathInfo で使用するクラスを設定する
	 * @link http://www.php.net/manual/ja/splfileinfo.setinfoclass.php
	 * @param class_name string[optional] <p>
	 * 使用するクラス名。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setInfoClass ($class_name = null) {}

	final public function _bad_state_ex () {}

	/**
	 * ファイルへのパスを文字列で返す
	 * @link http://www.php.net/manual/ja/splfileinfo.tostring.php
	 * @return void ファイルへのパスを返します。
	 */
	public function __toString () {}

}
// End of Phar v.2.0.1
?>
