<?php

// Start of imap v.

/**
 * メールボックスへの <acronym>IMAP</acronym> ストリームをオープンする
 * @link http://www.php.net/manual/ja/function.imap-open.php
 * @param mailbox string <p>
 * メールボックス名(mailbox)は、サーバー名の部分と使用するサーバーにおける
 * メールボックスへのパスから構成されます。特別な名前 INBOX は、
 * カレントユーザーの個人メールボックスを意味します。
 * ASCII 空間で出力可能な文字以外の外国文字を含むメールボックス名は
 * imap_utf7_encode でエンコードする必要があります。
 * </p>
 * <p>
 * サーバー部は '{'
 * および '}' で括られ、サーバー名または IP アドレス、オプションの ':'
 * から始まるポート指定子、('/' で始まる)オプションのプロトコル指定子
 * から構成されます。
 * </p>
 * <p>
 * サーバー部は、全ての mailbox パラメータで必須です。
 * </p>
 * <p>
 * { で始まる名前はすべてリモート名で、
 * "{" remote_system_name [":" port] [flags] "}"
 * [mailbox_name] のような形式となります。
 * remote_system_name - Internet ドメイン名
 * あるいは括弧でかこまれたサーバーの IP アドレス。
 * @param username string <p>
 * ユーザー名。
 * </p>
 * @param password string <p>
 * username のパスワード。
 * </p>
 * @param options int[optional] <p>
 * options はビットマスクであり、以下の組み合わせとなります。
 * OP_READONLY - メールボックスを読み込み専用でオープンします。
 * @param n_retries int[optional] <p>
 * 接続試行の最大数。
 * </p>
 * @param params array[optional] <p>
 * 接続パラメータ。次の (文字列の) キーを使って接続パラメータを設定することができます。
 * DISABLE_AUTHENTICATOR - 認証プロパティを無効にする
 * @return resource 成功した場合は IMAP ストリームを、失敗した場合は FALSE を返します。
 */
function imap_open ($mailbox, $username, $password, $options = null, $n_retries = null, array $params = null) {}

/**
 * 新規メールボックスへの <acronym>IMAP</acronym> ストリームを再度オープンする
 * @link http://www.php.net/manual/ja/function.imap-reopen.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @param options int[optional] <p>
 * options はビットマスクであり、以下の組み合わせとなります。
 * OP_READONLY - メールボックスを読み込み専用でオープンします。
 * @param n_retries int[optional] <p>
 * 接続試行の最大数。
 * </p>
 * @return bool ストリームを再度オープンした場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function imap_reopen ($imap_stream, $mailbox, $options = null, $n_retries = null) {}

/**
 * IMAP ストリームをクローズする
 * @link http://www.php.net/manual/ja/function.imap-close.php
 * @param imap_stream resource 
 * @param flag int[optional] <p>
 * CL_EXPUNGE
 * を指定した場合、メールボックスを閉じる前に暗黙のうちに
 * 削除マークがついた全てのメッセージを削除します。
 * imap_expunge を使用して、同じことを行うこともできます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_close ($imap_stream, $flag = null) {}

/**
 * 現在のメールボックスのメッセージ数を取得する
 * @link http://www.php.net/manual/ja/function.imap-num-msg.php
 * @param imap_stream resource 
 * @return int 現在のメールボックスのメッセージ数を返します。
 */
function imap_num_msg ($imap_stream) {}

/**
 * 現在のメールボックスにある新規メッセージ数を取得する
 * @link http://www.php.net/manual/ja/function.imap-num-recent.php
 * @param imap_stream resource 
 * @return int 現在のメールボックスにある新しいメッセージの数を返します。
 */
function imap_num_recent ($imap_stream) {}

/**
 * メールボックス内のすべてのメッセージのヘッダを返す
 * @link http://www.php.net/manual/ja/function.imap-headers.php
 * @param imap_stream resource 
 * @return array ヘッダ情報でフォーマットされた文字列の配列を返します。1 つの
 * メールメッセージ毎に 1 つの要素が格納されます。
 */
function imap_headers ($imap_stream) {}

/**
 * メッセージヘッダを読み込む
 * @link http://www.php.net/manual/ja/function.imap-headerinfo.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param fromlength int[optional] <p>
 * fetchfrom プロパティの文字数。
 * ゼロ以上でなければなりません。
 * </p>
 * @param subjectlength int[optional] <p>
 * fetchsubject プロパティの文字数。
 * ゼロ以上でなければなりません。
 * </p>
 * @param defaulthost string[optional] <p>
 * </p>
 * @return object 以下のプロパティをもつオブジェクトを返します。
 * toaddress - 完全な to: 行。最大 1024 文字。
 * to - To: 行から、次のプロパティを含むオブジェクトの配列を返します。
 * personal、adl、
 * mailbox および host
 * fromaddress - 完全な from: 行。最大 1024 文字。
 * from - From: 行から、次のプロパティを含むオブジェクトの配列を返します。
 * personal、adl、
 * mailbox および host
 * ccaddress - 完全な cc: 行。最大 1024 文字。
 * cc - Cc: 行から、次のプロパティを含むオブジェクトの配列を返します。
 * personal、adl、
 * mailbox および host
 * bccaddress - 完全な bcc: 行。最大 1024 文字。
 * bcc - Bcc: 行から、次のプロパティを含むオブジェクトの配列を返します。
 * personal、adl、
 * mailbox および host
 * reply_toaddress - 完全な Reply-To: 行。最大 1024 文字。
 * reply_to - Reply-To: 行から、次のプロパティを含むオブジェクトの配列を返します。
 * personal、adl、
 * mailbox および host
 * senderaddress - 完全な sender: 行。最大 1024 文字。
 * sender - Sender: 行から、次のプロパティを含むオブジェクトの配列を返します。
 * personal、adl、
 * mailbox および host
 * return_pathaddress - 完全な Return-Path: 行。最大 1024 文字。
 * return_path - Return-Path: 行から、次のプロパティを含むオブジェクトの配列を返します。
 * personal、
 * adl、mailbox および
 * host
 * remail - 
 * date - ヘッダにあるメッセージの日付。
 * Date - date と同じ。
 * subject - メッセージの件名。
 * Subject - subject と同じ。
 * in_reply_to - 
 * message_id - 
 * newsgroups - 
 * followup_to - 
 * references - 
 * Recent - 最近の既読メッセージは R、
 * 最新の未読メッセージは N、
 * 最新でないメッセージは ' '。
 * Unseen - 最新でない未読メッセージは U、
 * 既読、あるいは最新の未読メッセージは ' '。
 * Flagged - フラグがたっている場合は F、
 * そうでない場合は ' '。
 * Answered - 返信した場合は A、
 * していない場合は ' '。
 * Deleted - 削除された場合は D、
 * されていない場合は ' '。
 * Draft - 草稿である場合は X、
 * そうでない場合は ' '。
 * Msgno - メッセージ番号。
 * MailDate - 
 * Size - メッセージのサイズ。
 * udate - メールメッセージの日付を Unix time で表したもの。
 * fetchfrom - from 行を fromlength 文字に適合させたもの。
 * fetchsubject - subject 行を
 * subjectlength 文字に適合させたもの。
 */
function imap_headerinfo ($imap_stream, $msg_number, $fromlength = null, $subjectlength = null, $defaulthost = null) {}

/**
 * 文字列からメールヘッダを解釈する
 * @link http://www.php.net/manual/ja/function.imap-rfc822-parse-headers.php
 * @param headers string <p>
 * パースされたヘッダデータ。
 * </p>
 * @param defaulthost string[optional] <p>
 * デフォルトのホスト名。
 * </p>
 * @return object imap_header が返すオブジェクトと似たものを返します。
 * フラグおよび他の要素は IMAP サーバーから取得するいう点が異なります。
 */
function imap_rfc822_parse_headers ($headers, $defaulthost = null) {}

/**
 * 指定したメールボックス、ホスト、個人情報を、
   電子メールアドレスとして適当な形式にして返す
 * @link http://www.php.net/manual/ja/function.imap-rfc822-write-address.php
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @param host string <p>
 * email のホスト部分。
 * </p>
 * @param personal string <p>
 * アカウント所有者の名前。
 * </p>
 * @return string RFC822 の定義に基づき
 * 適切にフォーマットされた電子メールアドレスを返します。
 */
function imap_rfc822_write_address ($mailbox, $host, $personal) {}

/**
 * アドレス文字列を解釈します
 * @link http://www.php.net/manual/ja/function.imap-rfc822-parse-adrlist.php
 * @param address string <p>
 * アドレスを含む文字列。
 * </p>
 * @param default_host string <p>
 * デフォルトのホスト名。
 * </p>
 * @return array オブジェクトの配列を返します。オブジェクトのプロパティは以下のとおりです。
 * </p>
 * <p>
 * mailbox - メールボックス名（ユーザー名）。
 * host - ホスト名。
 * personal - 個人名。
 * adl - ドメインソースルート。
 */
function imap_rfc822_parse_adrlist ($address, $default_host) {}

/**
 * メッセージ本文を読む
 * @link http://www.php.net/manual/ja/function.imap-body.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param options int[optional] <p>
 * オプションの options はビットマスクであり、
 * 以下の要素の組み合わせとなります。
 * FT_UID - msg_number は UID です
 * @return string 指定したメッセージの本文を文字列で返します。
 */
function imap_body ($imap_stream, $msg_number, $options = null) {}

/**
 * 指定したメッセージの指定した body セクションの構造を読み込む
 * @link http://www.php.net/manual/ja/function.imap-bodystruct.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param section string <p>
 * 読み込む body セクション。
 * </p>
 * @return object オブジェクトの情報を返します。オブジェクトの構造やプロパティについての詳細は
 * imap_fetchstructure を参照ください。
 */
function imap_bodystruct ($imap_stream, $msg_number, $section) {}

/**
 * メッセージ本文中の特定のセクションを取り出す
 * @link http://www.php.net/manual/ja/function.imap-fetchbody.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param section string <p>
 * パート番号。ピリオドで区切られた整数文字列を指定します。
 * これは、IMAP4 仕様における本文パートのリストへのインデックスとなります。
 * </p>
 * @param options int[optional] <p>
 * ビットマスクであり、以下の組合わせとなります。
 * FT_UID - msg_numberは UID である
 * @return string 指定されたメッセージ本文中の特定のセクションをテキスト文字列で返します。
 */
function imap_fetchbody ($imap_stream, $msg_number, $section, $options = null) {}

/**
 * メッセージの特定のセクションに対する MIME ヘッダを取り出します
 * @link http://www.php.net/manual/ja/function.imap-fetchmime.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号
 * </p>
 * @param section string <p>
 * パート番号。ピリオドで区切られた整数文字列を指定します。
 * これは、IMAP4 の仕様に従って本文パートのリストにインデックスを付けます。
 * </p>
 * @param options int[optional] <p>
 * ビットマスク。以下の組合わせとなります。
 * FT_UID - msg_number は UID です
 * @return string 指定したメッセージの本文の特定のセクションの MIME ヘッダを文字列として返します。
 */
function imap_fetchmime ($imap_stream, $msg_number, $section, $options = null) {}

/**
 * 指定した本文部をファイルに保存する
 * @link http://www.php.net/manual/ja/function.imap-savebody.php
 * @param imap_stream resource 
 * @param file mixed <p>
 * 保存先ファイルへのパスを表す文字列、あるいは
 * fopen が返すファイル記述子。
 * </p>
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param part_number string[optional] <p>
 * パート番号。ピリオドで区切られた整数文字列を指定します。
 * これは、IMAP4 仕様における本文パートのリストへのインデックスとなります。
 * </p>
 * @param options int[optional] <p>
 * ビットマスクであり、以下の組合わせとなります。
 * FT_UID - msg_numberは UID である
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_savebody ($imap_stream, $file, $msg_number, $part_number = null, $options = null) {}

/**
 * メッセージのヘッダを返す
 * @link http://www.php.net/manual/ja/function.imap-fetchheader.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param options int[optional] <p>
 * オプション options は次のようになります。
 * FT_UID - 引数 msgno
 * は UID です。
 * @return string 指定したメッセージのヘッダをテキスト文字列で返します。
 */
function imap_fetchheader ($imap_stream, $msg_number, $options = null) {}

/**
 * 特定のメッセージの構造を読み込む
 * @link http://www.php.net/manual/ja/function.imap-fetchstructure.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param options int[optional] <p>
 * オプションのパラメータで、FT_UID のみが指定可能です。
 * これは、msg_number を UID
 * として処理することを関数に指定するためのものです。
 * </p>
 * @return object オブジェクトを返します。このオブジェクトには、
 * MIME の添付の各要素に類似のオブジェクトとしてエンベロープ、
 * 内部の日付、サイズ、フラグそして本体が含まれます。
 * 返されるオブジェクトの構造は次のようになります。
 * </p>
 * <p>
 * <table>
 * imap_fetchstructure が返すオブジェクト
 * <tr valign="top">
 * <td>type</td>
 * <td>最初の body 部の型</td>
 * </tr>
 * <tr valign="top">
 * <td>encoding</td>
 * <td>body 部を転送する際のエンコード法</td>
 * </tr>
 * <tr valign="top">
 * <td>ifsubtype</td>
 * <td>subtype 文字列がある場合に TRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>subtype</td>
 * <td>MIME の subtype</td>
 * </tr>
 * <tr valign="top">
 * <td>ifdescription</td>
 * <td>description 文字列がある場合に TRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>description</td>
 * <td>内容を記述する文字列</td>
 * </tr>
 * <tr valign="top">
 * <td>ifid</td>
 * <td>identification 文字列がある場合に TRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>id</td>
 * <td>Identification 文字列</td>
 * </tr>
 * <tr valign="top">
 * <td>lines</td>
 * <td>行数</td>
 * </tr>
 * <tr valign="top">
 * <td>bytes</td>
 * <td>バイト数</td>
 * </tr>
 * <tr valign="top">
 * <td>ifdisposition</td>
 * <td>disposition 文字列がある場合に TRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>disposition</td>
 * <td>Disposition 文字列</td>
 * </tr>
 * <tr valign="top">
 * <td>ifdparameters</td>
 * <td>dparameters 配列が存在する場合に TRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>dparameters</td>
 * <td>オブジェクトの配列。各オブジェクトは "attribute"
 * および "value"
 * というプロパティを保持し、それぞれ
 * Content-disposition MIME ヘッダの
 * 対応するパラメータを表す。</td>
 * </tr>
 * <tr valign="top">
 * <td>ifparameters</td>
 * <td>配列 parameters が存在する場合に TRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>parameters</td>
 * <td>オブジェクトの配列。各オブジェクトは "attribute"
 * および "value"
 * というプロパティを保持する。</td>
 * </tr>
 * <tr valign="top">
 * <td>parts</td>
 * <td>オブジェクトの配列であり、その構造はトップレベルオブジェクトと
 * 同じです。それぞれが MIME body 部に対応しています。
 * </td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * <table>
 * 最初の body 部の型 (使用するライブラリによって異なります)
 * <tr valign="top"><td>0</td><td>text</td></tr>
 * <tr valign="top"><td>1</td><td>multipart</td></tr>
 * <tr valign="top"><td>2</td><td>message</td></tr>
 * <tr valign="top"><td>3</td><td>application</td></tr>
 * <tr valign="top"><td>4</td><td>audio</td></tr>
 * <tr valign="top"><td>5</td><td>image</td></tr>
 * <tr valign="top"><td>6</td><td>video</td></tr>
 * <tr valign="top"><td>7</td><td>other</td></tr>
 * </table>
 * </p>
 * <p>
 * <table>
 * 転送時のエンコーディング (使用するライブラリによって異なります)
 * <tr valign="top"><td>0</td><td>7BIT</td></tr>
 * <tr valign="top"><td>1</td><td>8BIT</td></tr>
 * <tr valign="top"><td>2</td><td>BINARY</td></tr>
 * <tr valign="top"><td>3</td><td>BASE64</td></tr>
 * <tr valign="top"><td>4</td><td>QUOTED-PRINTABLE</td></tr>
 * <tr valign="top"><td>5</td><td>OTHER</td></tr>
 * </table>
 */
function imap_fetchstructure ($imap_stream, $msg_number, $options = null) {}

/**
 * IMAP キャッシュをクリアする
 * @link http://www.php.net/manual/ja/function.imap-gc.php
 * @param imap_stream resource 
 * @param caches int <p>
 * 破棄したいキャッシュを指定します。以下の定数
 * IMAP_GC_ELT (メッセージキャッシュ要素)、
 * IMAP_GC_ENV (エンベロープおよびボディ)、
 * IMAP_GC_TEXTS (テキスト)
 * の組み合わせとなります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_gc ($imap_stream, $caches) {}

/**
 * 削除用にマークされたすべてのメッセージを削除する
 * @link http://www.php.net/manual/ja/function.imap-expunge.php
 * @param imap_stream resource 
 * @return bool TRUE を返します。
 */
function imap_expunge ($imap_stream) {}

/**
 * 現在のメールボックスから削除するメッセージに印を付ける
 * @link http://www.php.net/manual/ja/function.imap-delete.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param options int[optional] <p>
 * FT_UID を指定すると、
 * 引数 msg_number を
 * UID として処理することを関数に指示できます。
 * </p>
 * @return bool TRUE.
 */
function imap_delete ($imap_stream, $msg_number, $options = null) {}

/**
 * 削除マークがついているメッセージのマークをはずす
 * @link http://www.php.net/manual/ja/function.imap-undelete.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @param flags int[optional] <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_undelete ($imap_stream, $msg_number, $flags = null) {}

/**
 * 現在のメールボックスをチェックする
 * @link http://www.php.net/manual/ja/function.imap-check.php
 * @param imap_stream resource 
 * @return object 以下のプロパティをもつオブジェクトの情報を返します。
 * Date - 現在のシステム時刻を RFC2822 にしたがってフォーマットしたもの。
 * Driver - メールボックスにアクセスする際に使用するプロトコル:
 * POP3、IMAP、NNTP
 * Mailbox - メールボックスの名前。
 * Nmsgs - メールボックス内のメッセージの数。
 * Recent - メールボックス内の新規メッセージの数。
 * </p>
 * <p>
 * 失敗した場合には FALSE を返します。
 */
function imap_check ($imap_stream) {}

/**
 * 指定したテキストにマッチするメールボックスの一覧を返す
 * @link http://www.php.net/manual/ja/function.imap-listscan.php
 * @param imap_stream resource 
 * @param ref string <p>
 * 通常、ref は
 * imap_open で述べられているサーバー定義です。
 * </p>
 * @param pattern string 検索を開始するメールボックスの階層を指定します。</p>
 * pattern の中で使用できる特別な文字として
 * &apos;*&apos; および &apos;&#37;&apos; があります。
 * &apos;*&apos; は、すべてのメールボックスを意味します。
 * pattern に &apos;*&apos; を指定すると、
 * メールボックス階層全体のリストが得られます。
 * &apos;&#37;&apos; は現在のレベルのみを意味します。
 * &apos;&#37;&apos; を pattern に指定すると、
 * トップレベルのメールボックスのみを返します。UW_IMAPD の場合、
 * &apos;~/mail/&#37;&apos; は
 * ~/mail ディレクトリ内のすべてのメールボックスを返しますが、
 * そのディレクトリのサブフォルダにあるメールボックスは返しません。</p>
 * @param content string <p>
 * 検索する文字列。
 * </p>
 * @return array content をテキストに持つメールボックスの名前を
 * 配列で返します。
 */
function imap_listscan ($imap_stream, $ref, $pattern, $content) {}

/**
 * 指定されたメッセージをメールボックスにコピーする
 * @link http://www.php.net/manual/ja/function.imap-mail-copy.php
 * @param imap_stream resource 
 * @param msglist string <p>
 * msglist は、
 * (RFC2060 に記述されたように)
 * ただのメッセージ番号ではなく、範囲を示します。
 * </p>
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @param options int[optional] <p>
 * options はビットマスクであり、以下の組み合わせです。
 * CP_UID - UIDS を含む処理の数
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_mail_copy ($imap_stream, $msglist, $mailbox, $options = null) {}

/**
 * 指定されたメッセージをメールボックスに移動する
 * @link http://www.php.net/manual/ja/function.imap-mail-move.php
 * @param imap_stream resource 
 * @param msglist string <p>
 * msglist は、
 * (RFC2060 に記述されたように)
 * ただのメッセージ番号ではなく、範囲を示します。
 * </p>
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @param options int[optional] <p>
 * options はビットマスクであり、ひとつのオプションをとります。
 * CP_UID - UIDS を含む処理の数
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_mail_move ($imap_stream, $msglist, $mailbox, $options = null) {}

/**
 * 指定したエンベロープおよびボディセクションに基づいて
   MIME メッセージを作成する
 * @link http://www.php.net/manual/ja/function.imap-mail-compose.php
 * @param envelope array <p>
 * ヘッダフィールドの連想配列。使えるキーは "remail",
 * "return_path", "date", "from", "reply_to", "in_reply_to", "subject",
 * "to", "cc", "bcc", "message_id" および "custom_headers"
 * (その他のヘッダの連想配列) です。
 * </p>
 * @param body array <p>
 * 本文の配列。
 * </p>
 * <p>
 * 本文は、以下のキーからなる連想配列です。
 * "type", "encoding", "charset", "type.parameters", "subtype", "id",
 * "description", "disposition.type", "disposition", "contents.data",
 * "lines", "bytes" および "md5"。
 * </p>
 * @return string MIME メッセージを返します。
 */
function imap_mail_compose (array $envelope, array $body) {}

/**
 * 新しいメールボックスを作る
 * @link http://www.php.net/manual/ja/function.imap-createmailbox.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open を参照ください。
 * この名前に国際化文字を含む場合には、
 * imap_utf7_encode でエンコードする必要があります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_createmailbox ($imap_stream, $mailbox) {}

/**
 * メールボックスの名前を変更する
 * @link http://www.php.net/manual/ja/function.imap-renamemailbox.php
 * @param imap_stream resource 
 * @param old_mbox string <p>
 * 古いメールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @param new_mbox string <p>
 * 新しいメールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_renamemailbox ($imap_stream, $old_mbox, $new_mbox) {}

/**
 * メールボックスを削除する
 * @link http://www.php.net/manual/ja/function.imap-deletemailbox.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は
 * imap_open を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_deletemailbox ($imap_stream, $mailbox) {}

/**
 * メールボックスを購読する
 * @link http://www.php.net/manual/ja/function.imap-subscribe.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_subscribe ($imap_stream, $mailbox) {}

/**
 * メールボックスの購読をやめる
 * @link http://www.php.net/manual/ja/function.imap-unsubscribe.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_unsubscribe ($imap_stream, $mailbox) {}

/**
 * 指定されたメールボックスに文字列メッセージを追加する
 * @link http://www.php.net/manual/ja/function.imap-append.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックスの名前。詳細は imap_open
 * を参照ください。
 * </p>
 * @param message string <p>
 * 追加したいメッセージを表す文字列。
 * </p>
 * <p>
 * Cyrus IMAP サーバーと通信する際には、改行コードとして "\n" のかわりに
 * "\r\n" を使用する必要があります。さもなくば、操作は失敗します。
 * </p>
 * @param options string[optional] <p>
 * 指定した場合は、
 * options もそのメールボックスに書きこまれます。
 * </p>
 * @param internal_date string[optional] <p>
 * このパラメータが設定されていると、追加したメッセージに INTERNALDATE を設定します。
 * このパラメータは、rfc2060 の日付時刻値の仕様を満たす文字列でなければなりません。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_append ($imap_stream, $mailbox, $message, $options = null, $internal_date = null) {}

/**
 * IMAP ストリームがアクティブかどうかを調べる
 * @link http://www.php.net/manual/ja/function.imap-ping.php
 * @param imap_stream resource 
 * @return bool ストリームがまだ有効であれば TRUE を、そうでなければ FALSE を返します。
 */
function imap_ping ($imap_stream) {}

/**
 * BASE64 でエンコードされたテキストをデコードする
 * @link http://www.php.net/manual/ja/function.imap-base64.php
 * @param text string <p>
 * エンコードされたテキスト。
 * </p>
 * @return string デコードしたメッセージを文字列で返します。
 */
function imap_base64 ($text) {}

/**
 * quoted-printable 文字列を 8 ビット文字列に変換する
 * @link http://www.php.net/manual/ja/function.imap-qprint.php
 * @param string string <p>
 * quoted-printable 文字列。
 * </p>
 * @return string 8 ビット文字列を返します。
 */
function imap_qprint ($string) {}

/**
 * 8 ビット文字列を quoted-printable 文字列に変換する
 * @link http://www.php.net/manual/ja/function.imap-8bit.php
 * @param string string <p>
 * 変換する 8 ビット文字列。
 * </p>
 * @return string quoted-printable 文字列を返します。
 */
function imap_8bit ($string) {}

/**
 * 8 ビット文字列を base64 文字列に変換する
 * @link http://www.php.net/manual/ja/function.imap-binary.php
 * @param string string <p>
 * 8 ビット文字列。
 * </p>
 * @return string base64 エンコードされた文字列を返します。
 */
function imap_binary ($string) {}

/**
 * MIME エンコードされたテキストを UTF-8 に変換する
 * @link http://www.php.net/manual/ja/function.imap-utf8.php
 * @param mime_encoded_text string <p>
 * MIME エンコードされた文字列。
 * MIME エンコーディング方法および UTF-8 の仕様については、それぞれ
 * RFC2047 および
 * RFC2044 を参照ください。
 * </p>
 * @return string UTF-8 エンコードされた文字列を返します。
 */
function imap_utf8 ($mime_encoded_text) {}

/**
 * 現在のメールボックス以外のメールボックスのステータス情報を返す
 * @link http://www.php.net/manual/ja/function.imap-status.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @param options int <p>
 * 以下のフラグが使用できます。
 * SA_MESSAGES -
 * $status->messages にメールボックスのメッセージ数を設定する
 * @return object この関数は、ステータス情報を含むオブジェクトを返します。このオブジェクトには
 * messages、
 * recent、unseen、
 * uidnext および uidvalidity
 * というプロパティが含まれます。
 * </p>
 * <p>
 * flags にも、
 * 上の各定数に対応するビットマスクを設定することができます。
 */
function imap_status ($imap_stream, $mailbox, $options) {}

/**
 * 現在のメールボックスに関する情報を得る
 * @link http://www.php.net/manual/ja/function.imap-mailboxmsginfo.php
 * @param imap_stream resource 
 * @return object 以下のプロパティを有するオブジェクトを返します。
 * <table>
 * Mailbox のプロパティ
 * <tr valign="top">
 * <td>Date</td>
 * <td>最終変更日 (現在の日付時刻)</td>
 * </tr>
 * <tr valign="top">
 * <td>Driver</td>
 * <td>ドライバ</td>
 * </tr>
 * <tr valign="top">
 * <td>Mailbox</td>
 * <td>メールボックスの名前</td>
 * </tr>
 * <tr valign="top">
 * <td>Nmsgs</td>
 * <td>メッセージ数</td>
 * </tr>
 * <tr valign="top">
 * <td>Recent</td>
 * <td>最近のメッセージの数</td>
 * </tr>
 * <tr valign="top">
 * <td>Unread</td>
 * <td>未読のメッセージの数</td>
 * </tr>
 * <tr valign="top">
 * <td>Deleted</td>
 * <td>削除されたメッセージの数</td>
 * </tr>
 * <tr valign="top">
 * <td>Size</td>
 * <td>メールボックスのサイズ</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * Returns FALSE on failure.
 */
function imap_mailboxmsginfo ($imap_stream) {}

/**
 * メッセージにフラグをセットする
 * @link http://www.php.net/manual/ja/function.imap-setflag-full.php
 * @param imap_stream resource 
 * @param sequence string <p>
 * メッセージ番号のシーケンス。
 * X,Y 形式でメッセージを列挙したり、
 * X:Y 形式で範囲内のすべてのメッセージを指定したりすることができます。
 * </p>
 * @param flag string <p>
 * 設定可能なフラグは、(RFC2060
 * で定義された) \Seen、
 * \Answered、\Flagged、
 * \Deleted および \Draft です。
 * </p>
 * @param options int[optional] <p>
 * options はビットマスクであり、以下の組み合わせとなります。
 * ST_UID - シーケンス引数はシーケンス番号の代わりに
 * UID を含みます。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_setflag_full ($imap_stream, $sequence, $flag, $options = null) {}

/**
 * メッセージのフラグをクリアする
 * @link http://www.php.net/manual/ja/function.imap-clearflag-full.php
 * @param imap_stream resource 
 * @param sequence string <p>
 * メッセージ番号のシーケンス。
 * X,Y のようにメッセージを列挙したり、
 * X:Y のようにしてその間のすべてのメッセージを指定したりできます。
 * </p>
 * @param flag string <p>
 * 設定可能なフラグは "\\Seen"、
 * "\\Answered"、"\\Flagged"、"\\Deleted" および "\\Draft" です
 * (RFC2060 で定義されています)。
 * </p>
 * @param options int[optional] <p>
 * オプション options はビットマスクであり、
 * 以下の組み合わせとなります。
 * ST_UID - シーケンス引数はシーケンス番号の代わりに
 * UID を含みます。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_clearflag_full ($imap_stream, $sequence, $flag, $options = null) {}

/**
 * メッセージヘッダの配列をソートする
 * @link http://www.php.net/manual/ja/function.imap-sort.php
 * @param imap_stream resource 
 * @param criteria int <p>
 * criteria は、次のどれかとします (ひとつのみ)。
 * SORTDATE - メッセージの日付
 * @param reverse int <p>
 * これを 1 にすると、逆順にソートします。
 * </p>
 * @param options int[optional] <p>
 * options はビットマスクで、以下の組み合わせとなります。
 * SE_UID - シーケンス番号の代わりに UID を返す
 * @param search_criteria string[optional] <p>
 * </p>
 * @param charset string[optional] <p>
 * </p>
 * @return array 指定したパラメータでソートしたメッセージ番号の配列を返します。
 */
function imap_sort ($imap_stream, $criteria, $reverse, $options = null, $search_criteria = null, $charset = null) {}

/**
 * 指定したメッセージシーケンス番号の UID を返す
 * @link http://www.php.net/manual/ja/function.imap-uid.php
 * @param imap_stream resource 
 * @param msg_number int <p>
 * メッセージ番号。
 * </p>
 * @return int 指定したメッセージの UID を返します。
 */
function imap_uid ($imap_stream, $msg_number) {}

/**
 * 指定した UID のメッセージ番号を返す
 * @link http://www.php.net/manual/ja/function.imap-msgno.php
 * @param imap_stream resource 
 * @param uid int <p>
 * メッセージの UID。
 * </p>
 * @return int 指定した uid のメッセージ番号を返します。
 */
function imap_msgno ($imap_stream, $uid) {}

/**
 * メールボックスのリストを読み込む
 * @link http://www.php.net/manual/ja/function.imap-list.php
 * @param imap_stream resource 
 * @param ref string <p>
 * 通常、ref は
 * imap_open で述べられているサーバー定義です。
 * </p>
 * @param pattern string 検索を開始するメールボックスの階層を指定します。</p>
 * pattern の中で使用できる特別な文字として
 * &apos;*&apos; および &apos;&#37;&apos; があります。
 * &apos;*&apos; は、すべてのメールボックスを意味します。
 * pattern に &apos;*&apos; を指定すると、
 * メールボックス階層全体のリストが得られます。
 * &apos;&#37;&apos; は現在のレベルのみを意味します。
 * &apos;&#37;&apos; を pattern に指定すると、
 * トップレベルのメールボックスのみを返します。UW_IMAPD の場合、
 * &apos;~/mail/&#37;&apos; は
 * ~/mail ディレクトリ内のすべてのメールボックスを返しますが、
 * そのディレクトリのサブフォルダにあるメールボックスは返しません。</p>
 * @return array メールボックスの名前を含む配列を返します。
 */
function imap_list ($imap_stream, $ref, $pattern) {}

/**
 * 購読しているすべてのメールボックスの一覧を得る
 * @link http://www.php.net/manual/ja/function.imap-lsub.php
 * @param imap_stream resource 
 * @param ref string <p>
 * 通常、ref は
 * imap_open で述べられているサーバー定義です。
 * </p>
 * @param pattern string 検索を開始するメールボックスの階層を指定します。</p>
 * pattern の中で使用できる特別な文字として
 * &apos;*&apos; および &apos;&#37;&apos; があります。
 * &apos;*&apos; は、すべてのメールボックスを意味します。
 * pattern に &apos;*&apos; を指定すると、
 * メールボックス階層全体のリストが得られます。
 * &apos;&#37;&apos; は現在のレベルのみを意味します。
 * &apos;&#37;&apos; を pattern に指定すると、
 * トップレベルのメールボックスのみを返します。UW_IMAPD の場合、
 * &apos;~/mail/&#37;&apos; は
 * ~/mail ディレクトリ内のすべてのメールボックスを返しますが、
 * そのディレクトリのサブフォルダにあるメールボックスは返しません。</p>
 * @return array 購読しているすべてのメールボックスの配列を返します。
 */
function imap_lsub ($imap_stream, $ref, $pattern) {}

/**
 * 指定したメッセージのヘッダ情報の概要を読む
 * @link http://www.php.net/manual/ja/function.imap-fetch-overview.php
 * @param imap_stream resource 
 * @param sequence string <p>
 * メッセージのシーケンスを指定します。
 * X,Y 形式で列挙したり、
 * X:Y 形式でその範囲内のすべてのメッセージを取得したりできます。
 * </p>
 * @param options int[optional] <p>
 * sequence
 * には、メッセージのインデックスか、もし flags に
 * FT_UID が含まれている場合は UID が含まれます。
 * </p>
 * @return array オブジェクトの配列を返します。各要素が、
 * それぞれひとつのメッセージのヘッダを表します。
 * オブジェクトで定義されるのは、存在するプロパティのみです。
 * 以下のプロパティがあります。
 * subject - メッセージの題名(subject)
 * from - 送信者
 * to - 受信者
 * date - 送信日
 * message_id - Message-ID 
 * references - このメッセージ ID への参照です
 * in_reply_to - このメッセージ ID への返信です
 * size - サイズ（バイト数）
 * uid - メールボックスにおけるこのメッセージの UID
 * msgno - メールボックスにおけるこのメッセージのシーケンス番号
 * recent - このメッセージには recent フラグが立てられています
 * flagged - フラグが立てられています
 * answered - 返信済みフラグが立てられています
 * deleted - 削除フラグが立てられています
 * seen - 既読フラグが立てられています
 * draft - 草稿フラグが立てられています
 */
function imap_fetch_overview ($imap_stream, $sequence, $options = null) {}

/**
 * 発生した IMAP 警告メッセージを返す
 * @link http://www.php.net/manual/ja/function.imap-alerts.php
 * @return array 全ての IMAP 警告メッセージの配列、あるいは警告メッセージが発生していない場合は
 * FALSE を返します。
 */
function imap_alerts () {}

/**
 * 発生したすべての IMAP エラーを返す
 * @link http://www.php.net/manual/ja/function.imap-errors.php
 * @return array この関数は、最後に imap_errors
 * コールを行ってから、またはそのページの処理を開始してから
 * 発生した全ての IMAP エラーメッセージの配列を返します。
 * エラーメッセージが存在しない場合には FALSE を返します。
 */
function imap_errors () {}

/**
 * ページリクエスト時に生じた直近の IMAP エラーを返す
 * @link http://www.php.net/manual/ja/function.imap-last-error.php
 * @return string 現在のページに生じた直近の IMAP エラーメッセージの全文を返します。
 * エラーメッセージが存在しない場合は FALSE を返します。
 */
function imap_last_error () {}

/**
 * 指定した検索条件にマッチするメッセージを配列として返す
 * @link http://www.php.net/manual/ja/function.imap-search.php
 * @param imap_stream resource 
 * @param criteria string <p>
 * 空白で区切られた文字列で、以下のキーワードが使用可能です。
 * 複数の単語からなるキーワード（例 FROM "joey smith"）
 * は全て引用符で括る必要があります。
 * 結果は、すべての criteria エントリにマッチすることになります。
 * ALL - 他の検索条件にマッチする全メッセージを返す
 * @param options int[optional] <p>
 * options に指定できる値は
 * SE_UID です。これを指定すると、
 * メッセージ番号ではなく UID を含む配列を返します。
 * </p>
 * @param charset string[optional] <p>
 * </p>
 * @return array メッセージ番号あるいは UID の配列を返します。
 * </p>
 * <p>
 * 検索条件 criteria を処理できなかった場合や
 * 結果が見つからなかった場合は、FALSE を返します。
 */
function imap_search ($imap_stream, $criteria, $options = null, $charset = null) {}

/**
 * 修正版 UTF-7 エンコードされた文字列をデコードする
 * @link http://www.php.net/manual/ja/function.imap-utf7-decode.php
 * @param text string <p>
 * 修正版 UTF-7 エンコーディングの文字列。このエンコーディングについては
 * RFC 2060,
 * section 5.1.3 で定義されています
 * (元の UTF-7 は RFC1642
 * で定義されています)。
 * </p>
 * @return string text と同じ内容の文字を ISO-8859-1 でエンコード
 * した文字列を返します。text に修正版 UTF-7 として
 * 不正な文字が含まれていた場合、あるいは text に
 * ISO-8859-1 文字セットの範囲外の文字が含まれていた場合には FALSE を返します。
 */
function imap_utf7_decode ($text) {}

/**
 * ISO-8859-1 文字列を修正版 UTF-7 テキストに変換する
 * @link http://www.php.net/manual/ja/function.imap-utf7-encode.php
 * @param data string <p>
 * ISO-8859-1 文字列。
 * </p>
 * @return string data を修正版 UTF-7 でエンコードした文字列を返します。
 * このエンコーディングについては
 * RFC 2060,
 * section 5.1.3 で定義されています
 * (元の UTF-7 は RFC1642
 * で定義されています)。
 */
function imap_utf7_encode ($data) {}

/**
 * @param in
 */
function imap_utf8_to_mutf7 ($in) {}

/**
 * @param in
 */
function imap_mutf7_to_utf8 ($in) {}

/**
 * MIME ヘッダ要素をデコードする
 * @link http://www.php.net/manual/ja/function.imap-mime-header-decode.php
 * @param text string <p>
 * MIME テキスト。
 * </p>
 * @return array デコードされた要素は、オブジェクトの配列で返されます。
 * 各オブジェクトは、二つのプロパティ charset
 * と text を有しています。
 * </p>
 * <p>
 * 要素がエンコードされていない場合、言い替えるとプレーンな US-ASCII の場合は
 * この要素の charset プロパティは
 * default に設定されます。
 */
function imap_mime_header_decode ($text) {}

/**
 * スレッド化したメッセージのツリーを返す
 * @link http://www.php.net/manual/ja/function.imap-thread.php
 * @param imap_stream resource 
 * @param options int[optional] <p>
 * </p>
 * @return array imap_thread は、REFERENCES
 * でスレッド化したメッセージのツリーを含む連想配列を返します。
 * エラー時には FALSE を返します。
 * </p>
 * <p>
 * 現在のメールボックス内のすべてのメッセージが、結果の配列の 3 つの
 * エントリで表されます。
 * <p>
 * $thread["XX.num"] - 現在のメッセージ番号。
 * </p>
 * <p>
 * $thread["XX.next"]
 * </p>
 * <p>
 * $thread["XX.branch"]
 * </p>
 */
function imap_thread ($imap_stream, $options = null) {}

/**
 * imap タイムアウトを設定あるいは取得する
 * @link http://www.php.net/manual/ja/function.imap-timeout.php
 * @param timeout_type int <p>
 * IMAP_OPENTIMEOUT、
 * IMAP_READTIMEOUT、
 * IMAP_WRITETIMEOUT あるいは
 * IMAP_CLOSETIMEOUT のいずれか。
 * </p>
 * @param timeout int[optional] <p>
 * タイムアウト秒数。
 * </p>
 * @return mixed timeout が設定されている場合は、
 * この関数は成功した場合に TRUE、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * timeout が省略されていたり、-1
 * と評価される値が設定されている場合は、
 * 現在のタイムアウト値 timeout_type
 * を整数で返します。
 */
function imap_timeout ($timeout_type, $timeout = null) {}

/**
 * クオータレベルの設定、メールボックス毎の使用状況を取得する
 * @link http://www.php.net/manual/ja/function.imap-get-quota.php
 * @param imap_stream resource 
 * @param quota_root string <p>
 * quota_root は、通常
 * user.name という形式にする必要があります。
 * name は、情報を取得したいメールボックスの名前です。
 * </p>
 * @return array 指定したメールボックスの limit と usage をキーとした整数値を配列として返します。
 * limit の値は、このメールボックスで最大使用可能な大きさを表します。
 * usage の値は、このメールボックスの現在の使用状況を示します。
 * 失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * PHP 4.3 では、この関数は RFC2087
 * で述べられている機能をより適切に反映するようになっています。
 * 返り値の配列からは、サポートするリソース
 * （例:メッセージ、あるいはサブフォルダ）数の制限をなくし、
 * 名前つきリソースを独立した配列のキーとして受信するようにしました。
 * 各キーの値は配列となっており、その中に usage と values
 * の値が格納されています。
 * </p>
 * <p>
 * 過去との互換性を保つため、旧来のアクセス方法も使用可能です。
 * しかし新しい方法に変更することを推奨します。
 */
function imap_get_quota ($imap_stream, $quota_root) {}

/**
 * ユーザー単位のクォータ設定を取得する
 * @link http://www.php.net/manual/ja/function.imap-get-quotaroot.php
 * @param imap_stream resource 
 * @param quota_root string <p>
 * quota_root はどのメールボックスを調べるかを
 * 指定します（例: INBOX）。
 * </p>
 * @return array 指定したユーザーのメールボックスに関連する整数値を配列で返します。
 * すべての値にはリソース名に基づいたキーがつけられており、
 * usage および limit 値を保持する配列が関連付けられています。
 * </p>
 * <p>
 * コールが失敗した場合、およびサーバーからの応答内容をパースできなかった場合には
 * この関数は FALSE を返します。
 */
function imap_get_quotaroot ($imap_stream, $quota_root) {}

/**
 * 指定したメールボックスにクォータを設定する
 * @link http://www.php.net/manual/ja/function.imap-set-quota.php
 * @param imap_stream resource 
 * @param quota_root string <p>
 * クォータを設定するメールボックス。
 * これは、メールボックスの IMAP 標準フォーマット
 * 'user.name' に基づき指定する必要があります。
 * </p>
 * @param quota_limit int <p>
 * quota_root の最大サイズ (KB 単位)。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_set_quota ($imap_stream, $quota_root, $quota_limit) {}

/**
 * 指定したメールボックスの ACL を設定する
 * @link http://www.php.net/manual/ja/function.imap-setacl.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @param id string <p>
 * 権限を付与するユーザー。
 * </p>
 * @param rights string <p>
 * そのユーザーに付与する権限。空文字列を渡すと、acl を削除します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_setacl ($imap_stream, $mailbox, $id, $rights) {}

/**
 * 与えられたメールボックスの ACL を取得する
 * @link http://www.php.net/manual/ja/function.imap-getacl.php
 * @param imap_stream resource 
 * @param mailbox string <p>
 * メールボックス名。詳細は imap_open
 * を参照ください。
 * </p>
 * @return array "folder" => "acl" 形式の連想配列を返します。
 */
function imap_getacl ($imap_stream, $mailbox) {}

/**
 * e-mail メッセージを送信する
 * @link http://www.php.net/manual/ja/function.imap-mail.php
 * @param to string <p>
 * 受信者。
 * </p>
 * @param subject string <p>
 * メールの件名。
 * </p>
 * @param message string <p>
 * メールの本文。
 * </p>
 * @param additional_headers string[optional] <p>
 * メールに設定する追加ヘッダ文字列。
 * </p>
 * @param cc string[optional] <p>
 * </p>
 * @param bcc string[optional] <p>
 * bcc で指定した受信者は mail を受信しますが、
 * ヘッダからは除外されます。
 * </p>
 * @param rpath string[optional] <p>
 * リターンパスを指定するために rpath
 * パラメータを使用してください。この関数は、
 * 複数のユーザー用のメールクライアントとして PHP を使用する際に有用です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imap_mail ($to, $subject, $message, $additional_headers = null, $cc = null, $bcc = null, $rpath = null) {}

/**
 * <function>imap_headerinfo</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-header.php
 * @param stream_id
 * @param msg_no
 * @param from_length[optional]
 * @param subject_length[optional]
 * @param default_host[optional]
 */
function imap_header ($stream_id, $msg_no, $from_length, $subject_length, $default_host) {}

/**
 * <function>imap_list</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-listmailbox.php
 * @param stream_id
 * @param ref
 * @param pattern
 */
function imap_listmailbox ($stream_id, $ref, $pattern) {}

/**
 * メールボックスのリストを読み込み、各ボックスに関する詳細な情報を返す
 * @link http://www.php.net/manual/ja/function.imap-getmailboxes.php
 * @param imap_stream resource 
 * @param ref string <p>
 * 通常、ref は
 * imap_open で述べられているサーバー定義です。
 * </p>
 * @param pattern string 検索を開始するメールボックスの階層を指定します。</p>
 * pattern の中で使用できる特別な文字として
 * &apos;*&apos; および &apos;&#37;&apos; があります。
 * &apos;*&apos; は、すべてのメールボックスを意味します。
 * pattern に &apos;*&apos; を指定すると、
 * メールボックス階層全体のリストが得られます。
 * &apos;&#37;&apos; は現在のレベルのみを意味します。
 * &apos;&#37;&apos; を pattern に指定すると、
 * トップレベルのメールボックスのみを返します。UW_IMAPD の場合、
 * &apos;~/mail/&#37;&apos; は
 * ~/mail ディレクトリ内のすべてのメールボックスを返しますが、
 * そのディレクトリのサブフォルダにあるメールボックスは返しません。</p>
 * @return array メールボックス情報を有するオブジェクトの配列を返します。各オブジェクトには、
 * メールボックスの完全な名前である name、
 * このメールボックスの階層の区切りを示す属性 delimiter、
 * そして attributes が存在します。
 * attributes はビットマスクであり、
 * 次のものについて調べることができます。
 * <p>
 * LATT_NOINFERIORS - このメールボックスには
 * 「子供」がいるかいないかはわかりません（このボックスの中にメールボックスはありません）。
 * このメールボックスに対して imap_createmailbox
 * をコールしても動作しません。
 * </p>
 * <p>
 * LATT_NOSELECT - 単なるコンテナであり、
 * メールボックスではありません - これをオープンすることはできません。
 * </p>
 * <p>
 * LATT_MARKED - このメールボックスにはマークがつけられています。
 * これは、最後に確認したとき以降に新たなメッセージが到着しているかもしれないということを意味します。
 * すべての IMAP サーバーがこの機能を提供しているとは限りません。
 * </p>
 * <p>
 * LATT_UNMARKED - このメールボックスにはマークがつけられておらず、
 * 新たなメッセージを含んでいません。
 * MARKED あるいは UNMARKED
 * が提供されている場合は、
 * その IMAP サーバーがこのメールボックスに対してマーク機能を提供しているとみなせます。
 * </p>
 */
function imap_getmailboxes ($imap_stream, $ref, $pattern) {}

/**
 * <function>imap_listscan</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-scanmailbox.php
 * @param stream_id
 * @param ref
 * @param pattern
 * @param content
 */
function imap_scanmailbox ($stream_id, $ref, $pattern, $content) {}

/**
 * <function>imap_lsub</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-listsubscribed.php
 * @param stream_id
 * @param ref
 * @param pattern
 */
function imap_listsubscribed ($stream_id, $ref, $pattern) {}

/**
 * 購読中の全メールボックスの一覧を取得する
 * @link http://www.php.net/manual/ja/function.imap-getsubscribed.php
 * @param imap_stream resource 
 * @param ref string <p>
 * ref は、通常は
 * imap_open で指定したサーバー情報です。
 * </p>
 * @param pattern string 検索を開始するメールボックスの階層を指定します。</p>
 * pattern の中で使用できる特別な文字として
 * &apos;*&apos; および &apos;&#37;&apos; があります。
 * &apos;*&apos; は、すべてのメールボックスを意味します。
 * pattern に &apos;*&apos; を指定すると、
 * メールボックス階層全体のリストが得られます。
 * &apos;&#37;&apos; は現在のレベルのみを意味します。
 * &apos;&#37;&apos; を pattern に指定すると、
 * トップレベルのメールボックスのみを返します。UW_IMAPD の場合、
 * &apos;~/mail/&#37;&apos; は
 * ~/mail ディレクトリ内のすべてのメールボックスを返しますが、
 * そのディレクトリのサブフォルダにあるメールボックスは返しません。</p>
 * @return array メールボックス情報を有するオブジェクトの配列を返します。各オブジェクトには、
 * メールボックスの完全な名前である name、
 * このメールボックスの階層の区切りを示す属性 delimiter、
 * そして attributes が存在します。
 * attributes はビットマスクであり、
 * 次のものについて調べることができます。
 * LATT_NOINFERIORS - このメールボックスには
 * 「子供」はいません（このボックスの中にメールボックスはありません）。
 * LATT_NOSELECT - 単なるコンテナであり、
 * メールボックスではありません - これをオープンすることはできません。
 * LATT_MARKED - このメールボックスにはマークが
 * つけられています。UW-IMAPD でのみ使用されます。
 * LATT_UNMARKED - このメールボックスにはマークが
 * つけられていません。UW-IMAPD でのみ使用されます。
 */
function imap_getsubscribed ($imap_stream, $ref, $pattern) {}

/**
 * <function>imap_body</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-fetchtext.php
 * @param stream_id
 * @param msg_no
 * @param options[optional]
 */
function imap_fetchtext ($stream_id, $msg_no, $options) {}

/**
 * <function>imap_listscan</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-scan.php
 * @param stream_id
 * @param ref
 * @param pattern
 * @param content
 */
function imap_scan ($stream_id, $ref, $pattern, $content) {}

/**
 * <function>imap_createmailbox</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-create.php
 * @param stream_id
 * @param mailbox
 */
function imap_create ($stream_id, $mailbox) {}

/**
 * <function>imap_renamemailbox</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.imap-rename.php
 * @param stream_id
 * @param old_name
 * @param new_name
 */
function imap_rename ($stream_id, $old_name, $new_name) {}

define ('NIL', 0);
define ('IMAP_OPENTIMEOUT', 1);
define ('IMAP_READTIMEOUT', 2);
define ('IMAP_WRITETIMEOUT', 3);
define ('IMAP_CLOSETIMEOUT', 4);
define ('OP_DEBUG', 1);

/**
 * メールボックスを読み込み専用で開きます。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('OP_READONLY', 2);

/**
 * ニュースで .newsrc を使用せず、更新も行いません
 * （NNTP のみ）。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('OP_ANONYMOUS', 4);
define ('OP_SHORTCACHE', 8);
define ('OP_SILENT', 16);
define ('OP_PROTOTYPE', 32);

/**
 * IMAP や NNTP
 * において、接続はオープンするがメールボックスを開きません。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('OP_HALFOPEN', 64);
define ('OP_EXPUNGE', 128);
define ('OP_SECURE', 256);

/**
 * imap_close のコール時に、メールボックスを
 * 閉じる前に中身を削除します。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('CL_EXPUNGE', 32768);

/**
 * パラメータは UID です。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('FT_UID', 1);

/**
 * まだ設定されていない場合に \Seen フラグを設定しません。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('FT_PEEK', 2);
define ('FT_NOT', 4);

/**
 * 返される文字列は内部フォーマットであり、CRLF に正規化しません。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('FT_INTERNAL', 8);
define ('FT_PREFETCHTEXT', 32);

/**
 * シーケンスの引数に、番号ではなく UID を含んでいます。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('ST_UID', 1);
define ('ST_SILENT', 2);
define ('ST_SET', 4);

/**
 * シーケンス番号が UID を含んでいます。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('CP_UID', 1);

/**
 * imap_mail_copy でコピーを行った後に
 * 現在のメールボックスからメッセージを削除します。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('CP_MOVE', 2);

/**
 * シーケンス番号のかわりに UID を返します。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SE_UID', 1);
define ('SE_FREE', 2);

/**
 * 検索されたメッセージを事前にフェッチすることはありません。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SE_NOPREFETCH', 4);
define ('SO_FREE', 8);
define ('SO_NOSERVER', 16);
define ('SA_MESSAGES', 1);
define ('SA_RECENT', 2);
define ('SA_UNSEEN', 4);
define ('SA_UIDNEXT', 8);
define ('SA_UIDVALIDITY', 16);
define ('SA_ALL', 31);

/**
 * このメールボックスには「子供」はいません（このメールボックスの配下には
 * メールボックスはありません）。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('LATT_NOINFERIORS', 1);

/**
 * これは単なるコンテナであり、メールボックスではありません。
 * オープンすることはできません。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('LATT_NOSELECT', 2);

/**
 * このメールボックスはマークされています。UW-IMAPD でのみ使用されます。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('LATT_MARKED', 4);

/**
 * このメールボックスはマークされていません。UW-IMAPD でのみ使用されます。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('LATT_UNMARKED', 8);
define ('LATT_REFERRAL', 16);
define ('LATT_HASCHILDREN', 32);
define ('LATT_HASNOCHILDREN', 64);

/**
 * imap_sort のソート条件。
 * メッセージの日付でソートします。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SORTDATE', 0);

/**
 * imap_sort のソート条件。
 * 到着日でソートします。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SORTARRIVAL', 1);

/**
 * imap_sort のソート条件。
 * メールボックスの最初の From アドレスでソートします。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SORTFROM', 2);

/**
 * imap_sort のソート条件。
 * メッセージの表題でソートします。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SORTSUBJECT', 3);

/**
 * imap_sort のソート条件。
 * メールボックスの最初の To アドレスでソートします。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SORTTO', 4);

/**
 * imap_sort のソート条件。
 * メールボックスの最初の Co アドレスでソートします。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SORTCC', 5);

/**
 * imap_sort のソート条件。
 * メッセージのサイズ（バイト単位）でソートします。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('SORTSIZE', 6);
define ('TYPETEXT', 0);
define ('TYPEMULTIPART', 1);
define ('TYPEMESSAGE', 2);
define ('TYPEAPPLICATION', 3);
define ('TYPEAUDIO', 4);
define ('TYPEIMAGE', 5);
define ('TYPEVIDEO', 6);
define ('TYPEMODEL', 7);
define ('TYPEOTHER', 8);
define ('ENC7BIT', 0);
define ('ENC8BIT', 1);
define ('ENCBINARY', 2);
define ('ENCBASE64', 3);
define ('ENCQUOTEDPRINTABLE', 4);
define ('ENCOTHER', 5);

/**
 * ガベージコレクタでメッセージキャッシュ要素を消去します。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('IMAP_GC_ELT', 1);

/**
 * ガベージコレクタでエンベロープおよびボディを消去します。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('IMAP_GC_ENV', 2);

/**
 * ガベージコレクタでテキストを消去します。
 * @link http://www.php.net/manual/ja/imap.constants.php
 */
define ('IMAP_GC_TEXTS', 4);

// End of imap v.
?>
