<?php

// Start of session v.

interface SessionHandlerInterface  {

	/**
	 * セッションを開始する
	 * @link http://www.php.net/manual/ja/sessionhandlerinterface.open.php
	 * @param save_path string <p>
	 * セッションを格納/取得するパス。
	 * </p>
	 * @param name string <p>
	 * セッション名。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	abstract public function open ($save_path, $name) {}

	/**
	 * セッションを閉じる
	 * @link http://www.php.net/manual/ja/sessionhandlerinterface.close.php
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	abstract public function close () {}

	/**
	 * セッションのデータを読み込む
	 * @link http://www.php.net/manual/ja/sessionhandlerinterface.read.php
	 * @param session_id string <p>
	 * セッション id。
	 * </p>
	 * @return string 読み込んだデータをエンコードした文字列を返します。
	 * 何も読まなかった場合は空文字列を返さなければなりません。
	 * この値は、PHP が内部的に使うためだけのものであることに注意しましょう。
	 */
	abstract public function read ($session_id) {}

	/**
	 * セッションのデータを書き込む
	 * @link http://www.php.net/manual/ja/sessionhandlerinterface.write.php
	 * @param session_id string <p>
	 * セッション id。
	 * </p>
	 * @param session_data string <p>
	 * エンコードされたセッションデータ。
	 * これは、PHP がスーパーグローバル $_SESSION
	 * の内容を内部的にシリアライズした結果の文字列で、それがこのパラメータに渡されます。
	 * セッションのシリアライズには通常とは別の方式を使っていることに注意しましょう。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	abstract public function write ($session_id, $session_data) {}

	/**
	 * セッションを破棄する
	 * @link http://www.php.net/manual/ja/sessionhandlerinterface.destroy.php
	 * @param session_id string <p>
	 * 破棄するセッション ID。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	abstract public function destroy ($session_id) {}

	/**
	 * 古いセッションを削除する
	 * @link http://www.php.net/manual/ja/sessionhandlerinterface.gc.php
	 * @param maxlifetime string <p>
	 * 直近の maxlifetime 秒の間に更新されていないセッションを削除します。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	abstract public function gc ($maxlifetime) {}

}

class SessionHandler implements SessionHandlerInterface {

	/**
	 * セッションを開始する
	 * @link http://www.php.net/manual/ja/sessionhandler.open.php
	 * @param save_path string <p>
	 * セッションを格納/取得するパス。
	 * </p>
	 * @param session_id string <p>
	 * セッションの id。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	public function open ($save_path, $session_id) {}

	/**
	 * セッションを閉じる
	 * @link http://www.php.net/manual/ja/sessionhandler.close.php
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	public function close () {}

	/**
	 * セッションのデータを読み込む
	 * @link http://www.php.net/manual/ja/sessionhandler.read.php
	 * @param session_id string <p>
	 * データを読み込むセッションの id。
	 * </p>
	 * @return string 読み込んだデータを常に文字列で返します。何も読まなかった場合は空文字列を返さなければなりません。
	 * この値は、PHP の内部で処理されるものであることに注意しましょう。
	 */
	public function read ($session_id) {}

	/**
	 * セッションのデータを書き込む
	 * @link http://www.php.net/manual/ja/sessionhandler.write.php
	 * @param session_id string <p>
	 * セッション id。
	 * </p>
	 * @param session_data string <p>
	 * エンコードされたセッションのデータ。
	 * これは、PHP が内部的にスーパーグローバル $_SESSION
	 * をエンコードしてシリアライズし、それを渡したものです。
	 * セッションが使うシリアライズ方式は、通常のシリアライズとは別のものであることに注意しましょう。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	public function write ($session_id, $session_data) {}

	/**
	 * セッションを破棄する
	 * @link http://www.php.net/manual/ja/sessionhandler.destroy.php
	 * @param session_id string <p>
	 * 破棄するセッション ID。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	public function destroy ($session_id) {}

	/**
	 * 古いセッションを削除する
	 * @link http://www.php.net/manual/ja/sessionhandler.gc.php
	 * @param maxlifetime int <p>
	 * 直近の maxlifetime 秒の間に更新されていないセッションを削除します。
	 * </p>
	 * @return bool 返り値 (通常は、TRUE が成功そして FALSE が失敗を表します)。この値は PHP で内部的に処理されるものであることに注意しましょう。
	 */
	public function gc ($maxlifetime) {}

}

/**
 * 現在のセッション名を取得または設定する
 * @link http://www.php.net/manual/ja/function.session-name.php
 * @param name string[optional] <p>
 * セッションの名前を参照します。これは、クッキーや URL
 * (例: PHPSESSID) で使われます。
 * セッション名は英数字のみで構成されている必要があり、また、
 * 短く、その内容が分かるようなものである必要があります
 * (これは、クッキー警告を有効にしているユーザー用です)。
 * </p>
 * <p>
 * <p>
 * セッション名は数字だけで構成することはできません。
 * 少なくとも文字がひとつ以上現れる必要があります。そうでない場合、
 * 新規セッション ID が毎回生成されます。
 * </p>
 * </p>
 * @return string 現在のセッションの名前を返します。
 */
function session_name ($name = null) {}

/**
 * 現在のセッションモジュールを取得または設定する
 * @link http://www.php.net/manual/ja/function.session-module-name.php
 * @param module string[optional] <p>
 * module が指定された場合、
 * そのモジュールを代わりに使用します。
 * </p>
 * @return string 現在のセッションモジュールの名前を返します。
 */
function session_module_name ($module = null) {}

/**
 * 現在のセッションデータ保存パスを取得または設定する
 * @link http://www.php.net/manual/ja/function.session-save-path.php
 * @param path string[optional] <p>
 * セッションデータのパス。これを指定すると、
 * データを保存するパスが変更されます。ただしそのためには
 * session_start がコールされる前に
 * session_save_path がコールされている必要があります。
 * </p>
 * <p>
 * <p>
 * いくつかのオペレーションシステムでは、多くの小さなファイルを効率的に
 * 処理するファイルシステム上にパスを指定することが望ましいです。
 * 例えば、Linux では ext2fs よりも reiserfs の方が性能面でより
 * 優れています。
 * </p>
 * </p>
 * @return string 現在のデータ保存先ディレクトリのパスを返します。
 */
function session_save_path ($path = null) {}

/**
 * 現在のセッション ID を取得または設定する
 * @link http://www.php.net/manual/ja/function.session-id.php
 * @param id string[optional] <p>
 * id が指定された場合、現在の
 * セッション ID を置換します。その際、
 * この関数は session_start
 * より前にコールされている必要があります。
 * セッションハンドラによっては、セッション ID として使用できる文字に
 * 制限がある場合があります。例えば、ファイルによるセッションハンドラでは
 * セッション ID として使える文字は
 * a-z A-Z 0-9 , (カンマ) そして - (マイナス)
 * に限られます!
 * </p>
 * セッション保持にクッキーを使用している場合、
 * session_id において
 * id 引数を指定すると、
 * 現在のセッション ID がセットされるものと
 * まったく同一であるかどうかに関わらず、
 * session_start
 * が呼び出される際に常に新しいクッキーが送信されます。
 * @return string session_id は現在のセッションのセッション ID を返します。
 * 現在のセッションが存在しない (現在のセッション ID が存在しない)
 * 場合は空文字列 ("") を返します。
 */
function session_id ($id = null) {}

/**
 * 現在のセッションIDを新しく生成したものと置き換える
 * @link http://www.php.net/manual/ja/function.session-regenerate-id.php
 * @param delete_old_session bool[optional] <p>
 * 関連付けられた古いセッションを削除するかどうか。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_regenerate_id ($delete_old_session = null) {}

/**
 * セッションエンコードされた文字列からセッションデータをデコードする
 * @link http://www.php.net/manual/ja/function.session-decode.php
 * @param data string <p>
 * エンコードされたデータ。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_decode ($data) {}

/**
 * 現在のセッションデータを、セッションエンコードされた文字列に変換する
 * @link http://www.php.net/manual/ja/function.session-encode.php
 * @return string 現在のセッションの内容をエンコードしたものを返します。
 */
function session_encode () {}

/**
 * 新しいセッションを開始、あるいは既存のセッションを再開する
 * @link http://www.php.net/manual/ja/function.session-start.php
 * @return bool この関数は、セッションが正常に開始した場合に TRUE、それ以外の場合に FALSE
 * を返します。
 */
function session_start () {}

/**
 * セッションに登録されたデータを全て破棄する
 * @link http://www.php.net/manual/ja/function.session-destroy.php
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_destroy () {}

/**
 * 全てのセッション変数を開放する
 * @link http://www.php.net/manual/ja/function.session-unset.php
 * @return void 値を返しません。
 */
function session_unset () {}

/**
 * ユーザー定義のセッション保存関数を設定する
 * @link http://www.php.net/manual/ja/function.session-set-save-handler.php
 * @param open callable 
 * @param close callable 
 * @param read callable 
 * @param write callable 
 * @param destroy callable 
 * @param gc callable 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_set_save_handler ($open, $close, $read, $write, $destroy, $gc) {}

/**
 * 現在のキャッシュリミッタを取得または設定する
 * @link http://www.php.net/manual/ja/function.session-cache-limiter.php
 * @param cache_limiter string[optional] <p>
 * cache_limiter
 * が指定された場合、現在のキャッシュリミッタは新しい値に変更されます。
 * </p>
 * <table>
 * 取り得る値
 * <tr valign="top">
 * <td>値</td>
 * <td>送信されるヘッダ</td>
 * </tr>
 * <tr valign="top">
 * <td>public</td>
 * <td>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>private_no_expire</td>
 * <td>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>private</td>
 * <td>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>nocache</td>
 * <td>
 * </td>
 * </tr>
 * </table>
 * @return string 現在のキャッシュリミッタの名前を返します。
 */
function session_cache_limiter ($cache_limiter = null) {}

/**
 * 現在のキャッシュの有効期限を返す
 * @link http://www.php.net/manual/ja/function.session-cache-expire.php
 * @param new_cache_expire string[optional] <p>
 * new_cache_expire が指定された場合、
 * 現在のキャッシュの有効期限は、
 * new_cache_expire で置換されます。
 * </p>
 * <p>
 * session.cache_limiterが
 * nocache以外の値にセットされている場合にのみ
 * new_cache_expireが有効となります。
 * </p>
 * @return int session.cache_expire の現在の設定を返します。
 * 返り値は分単位で、デフォルトは 180 です。
 */
function session_cache_expire ($new_cache_expire = null) {}

/**
 * セッションクッキーパラメータを設定する
 * @link http://www.php.net/manual/ja/function.session-set-cookie-params.php
 * @param lifetime int <p>
 * セッションクッキーの 有効期限。秒数で定義します。
 * </p>
 * @param path string[optional] <p>
 * クッキーが動作するドメイン上の
 * パス。単一のスラッシュ ('/')
 * を指定すると、ドメイン上のすべてのパスで動作します。
 * </p>
 * @param domain string[optional] <p>
 * クッキーの ドメイン。たとえば 'www.php.net'。
 * すべてのサブドメインでクッキーを有効にしたい場合は、先頭にドットをつけて
 * '.php.net' のようにします。
 * </p>
 * @param secure bool[optional] <p>
 * TRUE の場合は、セキュア
 * な接続の場合にのみクッキーを送信します。
 * </p>
 * @param httponly bool[optional] <p>
 * TRUE の場合は、PHP でセッションクッキーを設定する際に
 * httponly フラグの送信を試みます。
 * </p>
 * @return void 値を返しません。
 */
function session_set_cookie_params ($lifetime, $path = null, $domain = null, $secure = null, $httponly = null) {}

/**
 * セッションクッキーのパラメータを得る
 * @link http://www.php.net/manual/ja/function.session-get-cookie-params.php
 * @return array 現在のセッションクッキーの情報を配列として返します。
 * この配列には次のような項目が含まれています。
 * "lifetime" - クッキーの生存期間(lifetime)
 * "path" - 情報が保存されている場所のパス
 * "domain" - クッキーのドメイン
 * "secure" - クッキーはセキュアな接続でのみ送信されます。
 * "httponly" - クッキーは HTTP を通してのみアクセス可能となります。
 */
function session_get_cookie_params () {}

/**
 * セッションデータを書き込んでセッションを終了する
 * @link http://www.php.net/manual/ja/function.session-write-close.php
 * @return void 値を返しません。
 */
function session_write_close () {}

/**
 * 現在のセッションの状態を返す
 * @link http://www.php.net/manual/ja/function.session-status.php
 */
function session_status () {}

/**
 * セッションのシャットダウン関数
 * @link http://www.php.net/manual/ja/function.session-register-shutdown.php
 * @return void 値を返しません。
 */
function session_register_shutdown () {}

/**
 * <function>session_write_close</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.session-commit.php
 */
function session_commit () {}


/**
 * PHP 5.4.0 以降で導入。セッションが無効な場合の session_status の返り値。
 * @link http://www.php.net/manual/ja/session.constants.php
 */
define ('PHP_SESSION_DISABLED', 0);

/**
 * PHP 5.4.0 以降で導入。セッションが有効だけれどもセッションが存在しない場合の session_status の返り値。
 * @link http://www.php.net/manual/ja/session.constants.php
 */
define ('PHP_SESSION_NONE', 1);

/**
 * PHP 5.4.0 以降で導入。セッションが有効で、かつセッションが存在する場合の session_status の返り値。
 * @link http://www.php.net/manual/ja/session.constants.php
 */
define ('PHP_SESSION_ACTIVE', 2);

// End of session v.
?>
