package jp.sourceforge.pdt_tools.js_beautify.handlers;

import java.util.LinkedList;
import java.util.List;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import jp.sourceforge.pdt_tools.js_beautify.Activator;
import jp.sourceforge.pdt_tools.js_beautify.BeautifyOptions;
import jp.sourceforge.pdt_tools.js_beautify.preferences.PreferenceConstants;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommandHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IEditorPart editor = HandlerUtil.getActiveEditor(event);
		if (editor == null) {
			return null;
		}
		Object obj = editor.getAdapter(IDocument.class);
		if (obj == null) {
			if (editor instanceof ITextEditor) {
				obj = ((ITextEditor) editor).getDocumentProvider().getDocument(
						editor.getEditorInput());
			}
		}
		if (!(obj instanceof IDocument)) {
			Activator.log(new RuntimeException("Could not get IDocument"));
			return null;
		}
		IDocument document = (IDocument) obj;
		ISelectionProvider provider = editor.getEditorSite()
				.getSelectionProvider();
		if (provider == null) {
			Activator.log(new RuntimeException(
					"Could not get ISelectionProvider"));
			return null;
		}
		ISelection selection = provider.getSelection();
		if (selection instanceof ITextSelection) {
			int offset = ((ITextSelection) selection).getOffset();
			int length = ((ITextSelection) selection).getLength();
			if (length > 0) {
				IProject project = null;
				Object resource = editor.getEditorInput().getAdapter(
						IResource.class);
				if (resource instanceof IResource) {
					project = ((IResource) resource).getProject();
				}
				String options = getOptions(project);
				try {
					String string = document.get(offset, length);
					String formatted = js_beautify(string, options);
					if (!"".equals(formatted)) {
						String delimiter = document.getLineDelimiter(document
								.getLineOfOffset(offset));
						if (string.endsWith(delimiter)) {
							formatted += delimiter;
						}
						if (!formatted.equals(string)) {
							document.replace(offset, length, formatted);
						}
					}
				} catch (BadLocationException e) {
					Activator.log(e);
				}
			}
		}
		return null;
	}

	private String js_beautify(String text, String options) {
		String string = null;
		String beautify_js = Activator.getDefault().getScript();
		if (beautify_js != null) {
			try {
				ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
				ScriptEngine scriptEngine = scriptEngineManager
						.getEngineByName("JavaScript");
				scriptEngine.eval(beautify_js);
				String script = "function js_beautify_bridge(text) {"
						+ "var arg=" + options + ";"
						+ "return js_beautify(text, arg);" + "}";
				scriptEngine.eval(script);
				Invocable inv = (Invocable) scriptEngine;
				Object result = inv.invokeFunction("js_beautify_bridge", text);
				if (result instanceof String) {
					string = (String) result;
				}
			} catch (ScriptException e) {
				Activator.log(e);
			} catch (NoSuchMethodException e) {
				Activator.log(e);
			}
		}
		return string;
	}

	private String getOptions(IProject project) {
		BeautifyOptions options = new BeautifyOptions();
		IPreferencesService preference = Platform.getPreferencesService();
		List<IScopeContext> contextList = new LinkedList<IScopeContext>();
		if (project != null) {
			contextList.add(new ProjectScope(project));
		}
		contextList.add(InstanceScope.INSTANCE);
		IScopeContext[] contexts = contextList
				.toArray(new IScopeContext[contextList.size()]);

		List<String> list = new LinkedList<String>();
		int indent_size = preference.getInt(Activator.PLUGIN_ID,
				PreferenceConstants.INDENT_SIZE, options.indent_size, contexts);
		String indent_char = preference.getString(Activator.PLUGIN_ID,
				PreferenceConstants.INDENT_CHAR, options.indent_char, contexts);
		if (indent_char.equals("\t")) {
			list.add("'indent_char': '\\t'");
			list.add("indent_size: 1");
		} else {
			list.add("'indent_char': '" + indent_char + "'");
			list.add("indent_size: " + indent_size);
		}
		int brace_style = preference.getInt(Activator.PLUGIN_ID,
				PreferenceConstants.BRACE_STYLE, options.brace_style, contexts);
		if (brace_style != options.brace_style) {
			String[] name = { "collapse", "expand", "expand-strict",
					"end-expand" };
			list.add("'brace_style': '" + name[brace_style] + "'");
		}
		boolean preserve_newlines = preference.getBoolean(Activator.PLUGIN_ID,
				PreferenceConstants.PRESERVE_NEWLINES,
				options.preserve_newlines, contexts);
		if (preserve_newlines != options.preserve_newlines) {
			list.add("'preserve_newlines': " + preserve_newlines);
		}
		boolean break_chained_methods = preference.getBoolean(
				Activator.PLUGIN_ID, PreferenceConstants.BREAK_CHAINED_METHODS,
				options.break_chained_methods, contexts);
		if (break_chained_methods != options.break_chained_methods) {
			list.add("'break_chained_methods': " + break_chained_methods);
		}
		int max_preserve_newlines = preference.getInt(Activator.PLUGIN_ID,
				PreferenceConstants.MAX_PRESERVE_NEWLINES,
				options.max_preserve_newlines, contexts);
		if (max_preserve_newlines != options.max_preserve_newlines) {
			list.add("'max_preserve_newlines': " + max_preserve_newlines);
		}
		boolean jslint_happy = preference.getBoolean(Activator.PLUGIN_ID,
				PreferenceConstants.JSLINT_HAPPY, options.jslint_happy,
				contexts);
		if (jslint_happy != options.jslint_happy) {
			list.add("'jslint_happy': " + jslint_happy);
		}
		boolean keep_array_indentation = preference.getBoolean(
				Activator.PLUGIN_ID,
				PreferenceConstants.KEEP_ARRAY_INDENTATION,
				options.keep_array_indentation, contexts);
		if (keep_array_indentation != options.keep_array_indentation) {
			list.add("'keep_array_indentation': " + keep_array_indentation);
		}
		boolean space_before_conditional = preference.getBoolean(
				Activator.PLUGIN_ID,
				PreferenceConstants.SPACE_BEFORE_CONDITIONAL,
				options.space_before_conditional, contexts);
		if (space_before_conditional != options.space_before_conditional) {
			list.add("'space_before_conditional': " + space_before_conditional);
		}
		boolean unescape_strings = preference.getBoolean(Activator.PLUGIN_ID,
				PreferenceConstants.UNESCAPE_STRINGS, options.unescape_strings,
				contexts);
		if (unescape_strings != options.unescape_strings) {
			list.add("'unescape_strings': " + unescape_strings);
		}

		StringBuffer buf = new StringBuffer();
		for (String element : list) {
			buf.append(element).append(",");
		}
		return "{" + buf.toString() + "}";
	}
}
