package jp.sourceforge.pdt_tools.jsbeautifier.preferences;

import jp.sourceforge.pdt_tools.jsbeautifier.Activator;
import jp.sourceforge.pdt_tools.jsbeautifier.JSBeautifierOptions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JSBeautifierPreferencePage extends FieldEditorPreferencePage
		implements IWorkbenchPreferencePage, IWorkbenchPropertyPage {

	private IAdaptable element = null;

	public JSBeautifierPreferencePage() {
		super(GRID);
		setDescription(Messages.PreferencePage_description);
	}

	@Override
	protected Control createContents(Composite parent) {
		IScopeContext context = null;
		if (element != null) {
			Object resource = element.getAdapter(IProject.class);
			if (resource instanceof IProject) {
				IProject project = (IProject) resource;
				context = new ProjectScope(project);
			}
		} else {
			context = InstanceScope.INSTANCE;
		}
		setPreferenceStore(new ScopedPreferenceStore(context,
				Activator.PLUGIN_ID));

		Group group = new Group(parent, SWT.NONE);
		group.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		group.setLayout(new GridLayout());
		group.setText(Messages.PreferencePage_group_title);
		Composite filler = new Composite(parent, SWT.NONE);
		filler.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		return super.createContents(group);
	}

	@Override
	public void createFieldEditors() {
		Composite fields = getFieldEditorParent();
		String[][] styles = {
				{ Messages.OptionBraceStyle_collapse,
						Integer.toString(JSBeautifierOptions.BS_COLLAPSE) },
				{ Messages.OptionBraceStyle_expand,
						Integer.toString(JSBeautifierOptions.BS_EXPAND) },
				{ Messages.OptionBraceStyle_expand_strict,
						Integer.toString(JSBeautifierOptions.BS_EXPAND_STRICT) },
				{ Messages.OptionBraceStyle_end_expand,
						Integer.toString(JSBeautifierOptions.BS_END_EXPAND) } };
		addField(new ComboFieldEditor(PreferenceConstants.BRACE_STYLE,
				Messages.OptionBraceStyle_label, styles, fields));
		addField(new IntegerFieldEditor(PreferenceConstants.INDENT_SIZE,
				Messages.OptionIndentSize_label, fields, 3));
		addField(new RadioGroupFieldEditor(PreferenceConstants.INDENT_CHAR,
				Messages.OptionIndentChar_label, 1, new String[][] {
						{ Messages.OptionIndentChar_space_label, " " },
						{ Messages.OptionIndentChar_tab_label, "\t" } }, fields));
		addField(new BooleanFieldEditor(PreferenceConstants.PRESERVE_NEWLINES,
				Messages.OptionPreserveNewlines_label, fields));
		addField(new IntegerFieldEditor(
				PreferenceConstants.MAX_PRESERVE_NEWLINES,
				Messages.OptionMaxPreserveNewlines_label, fields, 3));
		addField(new BooleanFieldEditor(PreferenceConstants.JSLINT_HAPPY,
				Messages.OptionJslintHappy_label, fields));
		addField(new BooleanFieldEditor(
				PreferenceConstants.BREAK_CHAINED_METHODS,
				Messages.OptionBreakChainedMethods_label, fields));
		addField(new BooleanFieldEditor(
				PreferenceConstants.KEEP_ARRAY_INDENTATION,
				Messages.OptionKeepArrayIndentation_label, fields));
		addField(new BooleanFieldEditor(
				PreferenceConstants.SPACE_BEFORE_CONDITIONAL,
				Messages.OptionSpaceBeforeConditional_label, fields));
		addField(new BooleanFieldEditor(PreferenceConstants.UNESCAPE_STRINGS,
				Messages.OptionUnescapeStrings_label, fields));
	}

	@Override
	public void init(IWorkbench workbench) {
	}

	@Override
	public IAdaptable getElement() {
		return element;
	}

	@Override
	public void setElement(IAdaptable element) {
		this.element = element;
	}

}
