﻿using System;
using System.Linq;
using System.Text.RegularExpressions;
using System.Xml.Linq;

namespace Azyobuzi.HatenaDiaryClient.Models.Hatena
{
    public class FotolifeEntry
    {
        public string Title { set; get; }
        public string PageUri { set; get; }
        public string Id { set; get; }
        public DateTime Issued { set; get; }
        public string Folder { set; get; }
        public string ImageUri { set; get; }
        public string ThumbnailUri { set; get; }
        public string HatenaSyntax { set; get; }

        public FotolifeEntry() { }
        public FotolifeEntry(XElement xml)
        {
            Console.WriteLine(xml.ToString());
            this.Title = xml.Element(XmlNamespaces.Atom02Spec + "title").Value;
            this.PageUri = xml.Elements(XmlNamespaces.Atom02Spec + "link")
                .Where(_ => _.Attribute("rel").Value == "alternate")
                .Select(_ => _.Attribute("href").Value)
                .FirstOrDefault();
            this.Id = Regex.Match(this.PageUri, @"\d+$").ToString();
            var issuedXml = xml.Element(XmlNamespaces.Atom02Spec + "issued").Value;
            if (!string.IsNullOrWhiteSpace(issuedXml))
                this.Issued = DateTime.Parse(issuedXml);
            var folderXml = xml.Element(XmlNamespaces.DublinCore + "subject");
            if (folderXml != null)
                this.Folder = folderXml.Value;
            this.ImageUri = xml.Element(XmlNamespaces.HatenaNs + "imageurl").Value;
            this.ThumbnailUri = xml.Element(XmlNamespaces.HatenaNs + "imageurlsmall").Value;
            this.HatenaSyntax = string.Format(
                "f:id:{0}:{1}j:image",
                xml.Element(XmlNamespaces.Atom02Spec + "author")
                    .Element(XmlNamespaces.Atom02Spec + "name").Value,
                this.Id);
        }
    }
}
