﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: IBookMgr.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

namespace Bis5Products.SharpWebBrowser {
    /// <summary>SharpWebBrowserが利用するBookmarkManagerモジュールに必要な機能を実装します。</summary>
    public interface IBookMgr : ISWBModules {
        /// <summary>ブックマークに項目を追加します。</summary>
        /// <param name="name">追加する項目の名称</param>
        /// <param name="uri">追加する項目のURI</param>
        [System.Obsolete("メソッド名変更の可能性", false)]
        void addBookmarkMenu_Click(string name, string uri);
        /// <summary>ブックマークに項目を追加します。</summary>
        /// <param name="item">追加する項目を表す<see cref="BookmarkItem"/>オブジェクト。</param>
        void Add(IBookmarkItem item);
        /// <summary>ブックマークに項目を追加します。</summary>
        /// <param name="name">追加する項目の名称</param>
        /// <param name="uri">追加する項目のURI</param>
        void Add(string name, string uri);
        /// <summary>ブックマークに項目を追加します。　</summary>
        /// <param name="name">追加する項目の名称</param>
        /// <param name="type">追加する項目の種類を表す<see cref="BookmarkItemType"/>値。</param>
        void Add(string name, BookmarkItemType type);
        /// <summary>ブックマーク項目を変更します。</summary>
        /// <param name="item">変更されたブックマーク項目を表す<see cref="BookmarkItem"/>オブジェクト。</param>
        void Set(IBookmarkItem item);
        /// <summary>ブックマーク項目を変更します。</summary>
        /// <param name="id">変更するブックマーク項目固有の番号</param>
        /// <param name="newName">ブックマーク項目の新しい名称。</param>
        /// <param name="uri">ブックマーク項目のURI</param>
        /// <param name="parent">ブックマークの親ディレクトリを表す固有の番号</param>
        void Set(int id, string newName, string uri, int parent);
        /// <summary>ブックマークから項目を削除します。</summary>
        /// <param name="item">削除する項目を表す<see cref="BookmarkItem"/>オブジェクト。</param>
        void RemoveItem(IBookmarkItem item);
        /// <summary>ブックマークから項目を削除します。・</summary>
        /// <param name="id">削除する項目固有の番号</param>
        void RemoveItem(int id);
        /// <summary>ブックマークからディレクトリを削除します。</summary>
        /// <param name="item">削除するディレクトリを表す<see cref="BookmarkItem"/オブジェクト></param>
        void RemoveDirectory(IBookmarkItem item);
        /// <summary>ブックマークからディレクトリを削除します。</summary>
        /// <param name="id">削除するディレクトリ固有の番号</param>
        void RemoveDirectory(int id);
        /// <summary>ブックマークに項目が存在するか確認します。</summary>
        /// <param name="id">存在しているか確認する項目固有の番号</param>
        /// <returns>確認結果</returns>
        bool IsContains(int id);
        /// <summary>ブックマークを設定ファイルに保存ます。</summary>
        void Save();
        /// <summary>Windowsフォームで利用するブックマークメニューを取得します。</summary>
        /// <param name="owner">取得したメニューを所有する<see cref="ToolStrip"/>コントロール</param>
        /// <returns>ブックマークメニュー</returns>
        System.Windows.Forms.ToolStripItemCollection GetMenu(System.Windows.Forms.ToolStrip owner);
    }
}