﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of PluginManager.
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2009-2010 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
// PluginManager is one of modules for SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licene (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: ISWBPlugin.cs
// Author: bis5
// Module: PluginManager
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Bis5Products.SharpWebBrowser {
    public interface ISWBPlugin {
        /// <summary>
        /// プラグイン固有のフォームが存在するかどうかを示す
        /// </summary>
        bool HasWindowsForm { get; }
        /// <summary>
        /// プラグイン固有のWPFウィンドウが存在するかどうかを示す。
        /// </summary>
        /// <remarks>
        /// HasWindowsFormがtrueの場合、WinFormsを優先する
        /// </remarks>
        bool HasWPFWindow { get; }
        /// <summary>
        /// プラグイン情報を格納した配列を取得する
        /// </summary>
        /// <remarks>
        /// プラグイン名称、バージョン、作者、クラスライブラリファイル名の順に格納すること
        /// </remarks>
        string[] PluginVersion { get; }
        /// <summary>
        /// ConfigurationManagerを利用するかどうかを示す
        /// </summary>
        /// <remarks>
        /// 実装未定
        /// </remarks>
        bool UseConfigurationManager { get; }
        /// <summary>
        /// LanguageManagerを利用するかどうかを示す
        /// </summary>
        bool UseLanguageManager { get; }
        /// <summary>
        /// BookmarkManagerを利用するかどうかを示す
        /// </summary>
        bool UseBookmarmManager { get; }
        /// <summary>
        /// HasWindowsFormまたはHasWPFWindowのいずれかがtrueのとき、Coreからの呼び出しを行うデリゲートを取得する
        /// </summary>
        EventHandler CallMainWindow { get; }
        /// <summary>
        /// 設定ウィンドウに表示するプロパティシートを取得する
        /// </summary>
        //ISWBPropertySheet Property { get; }

        /// <summary>
        /// プラグインを初期化する。PluginManagerから一度だけ呼び出される
        /// </summary>
        void Init();
        /// <summary>
        /// Coreから呼び出されるWindowsフォームまたはWPFウィンドウを取得する
        /// </summary>
        IPluginForm PluginForm{ get; }
    }
}
