/*
 * $Id: Hashtable.h,v 1.4 2007-08-18 08:52:18 maya Exp $
 */

#ifndef _YCL_HASHTABLE_H_
#define _YCL_HASHTABLE_H_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <YCL/common.h>

#include <YCL/HASHCODE.h>
#include <YCL/ValueCtrl.h>
#include <YCL/Enumeration.h>
#include <YCL/Pointer.h>

namespace yebisuya {

// nbVe[uǗNXB
template<class TYPE_KEY, class TYPE_VALUE, class KEYCTRL = ValueCtrl<TYPE_KEY>, class VALCTRL = ValueCtrl<TYPE_VALUE> >
class Hashtable {
	// TYPE_KEY, TYPE_VALUEɂƂ^:
	// EftHgRXgN^
	// ERs[RXgN^
	// E==Zq
	// E=Zq(̏̂ߎQƂ͎włȂ)
	// KEYCTRLAVALCTRLɃftHĝ̂gpꍇ
	// EftHgRXgN^ŐꂽCX^XNULLrƐ^ɂȂ
	// ENULLCX^XNULLrƐ^ɂȂ
	// ETYPE_KEY̓nbVl𐶐hashCode\bh
	// ɉB
public:
	typedef Enumeration<TYPE_KEY> KeyEnumeration;
	typedef Enumeration<TYPE_VALUE> ElementEnumeration;
private:
	// Rs[RXgN^͎gp֎~
	Hashtable(Hashtable&);
	// Zq͎gp֎~
	void operator=(Hashtable&);

	// nbVe[ũGgB
	struct Entry {
		TYPE_KEY key;
		TYPE_VALUE value;
		Entry() {
			KEYCTRL::initialize(key);
			VALCTRL::initialize(value);
		}
	};
	// nbVe[ũGg񋓂邽߂̃NXB
	class EnumEntries {
	private:
		const Hashtable& table;
		mutable int index;
		void skip()const {
			while (index < table.backetSize && VALCTRL::isEmpty(table.backet[index].value))
				index++;
		}
	public:
		EnumEntries(const Hashtable& table)
		:table(table), index(0) {
			skip();
		}
		bool hasMoreEntries()const {
			return index < table.backetSize;
		}
		const Entry& nextEntry()const {
			const Entry& entry = table.backet[index++];
			skip();
			return entry;
		}
	};
	friend class EnumEntries;
	// nbVe[ũL[񋓂邽߂̃NXB
	class EnumKeys : public KeyEnumeration {
	private:
		EnumEntries entries;
	public:
		EnumKeys(const Hashtable& table)
		:entries(table) {
		}
		virtual bool hasMoreElements()const {
			return entries.hasMoreEntries();
		}
		virtual TYPE_KEY nextElement()const {
			return entries.nextEntry().key;
		}
	};
	// nbVe[u̒l񋓂邽߂̃NXB
	class EnumValues : public ElementEnumeration {
	private:
		EnumEntries entries;
	public:
		EnumValues(const Hashtable& table)
		:entries(table) {
		}
		virtual bool hasMoreElements()const {
			return entries.hasMoreEntries();
		}
		virtual TYPE_VALUE nextElement()const {
			return entries.nextEntry().value;
		}
	};

	// Gg̔zB
	Entry* backet;
	// Gg̔z̃TCY
	int backetSize;
	// LȃGg̐
	int count;
	enum {
		// Gg̔z傫ƂɎgpTCY
		BOUNDARY = 8,
	};
	// keyƓL[Gg̃CfbNXԂB
	// :
	//	key	L[
	// Ԓl:
	//	keyƓL[A܂ݒ肳ĂȂGg̃CfbNXB
	//	SẴGgݒς݂keyƓ̂Ȃ-1ԂB
	int find(const TYPE_KEY& key)const {
		int found = -1;
		int h = HASHCODE(key);
		for (int i = 0; i < backetSize; i++) {
			int index = ((unsigned) h + i) % backetSize;
			const TYPE_KEY& bkey = backet[index].key;
			if (KEYCTRL::isEmpty(bkey) || bkey == key) {
				found = index;
				break;
			}
		}
		return found;
	}
	// Gg̔zw̃TCYɕςAxe[u蒼B
	// :
	//	newSize	Vz̃TCYB
	//			LȃGg̐ȂĂ͂ȂB
	void rehash(int newSize) {
		Entry* oldBacket = backet;
		int oldSize = backetSize;
		backet = new Entry[newSize];
		backetSize = newSize;
		for (int i = 0; i < oldSize; i++) {
			if (!VALCTRL::isEmpty(oldBacket[i].value)) {
				backet[find(oldBacket[i].key)] = oldBacket[i];
			}
		}
		delete[] oldBacket;
	}
public:
	// ftHgRXgN^B
	// ̃nbVe[uB
	Hashtable()
	:backet(NULL), backetSize(0), count(0) {
	}
	// Gg̔z̏TCYw肷RXgN^B
	// :
	//	backetSize	Gg̔z̑傫B
	Hashtable(int backetSize)
	:backet(new Entry[backetSize]), backetSize(backetSize), count(0) {
	}
	// fXgN^B
	// Gg̔z폜B
	~Hashtable() {
		delete[] backet;
	}
	// w̃L[ɑΉl擾B
	// :
	//	key	L[
	// Ԓl:
	//	L[ɑΉlBȂNULLƓlԂB
	TYPE_VALUE get(const TYPE_KEY& key)const {
		TYPE_VALUE value;
		VALCTRL::initialize(value);
		int index = find(key);
		if (index != -1)
			value = backet[index].value;
		return value;
	}
	// w̃L[ɑΉlݒ肷B
	// :
	//	key	ݒ肷L[
	//	value ݒ肷l
	// Ԓl:
	//	OɃL[ɐݒ肳ĂlBݒ肾ꍇNULLƓlԂB
	TYPE_VALUE put(const TYPE_KEY& key, const TYPE_VALUE& value) {
		int index = find(key);
		if (index == -1) {
			rehash(backetSize + BOUNDARY);
			index = find(key);
		}
		TYPE_VALUE old = backet[index].value;
		if (VALCTRL::isEmpty(old)) {
			count++;
			backet[index].key = key;
		}
		backet[index].value = value;
		return old;
	}
	// w̃L[ɑΉl폜B
	// :
	//	key	폜L[
	// Ԓl:
	//	L[ɐݒ肳ĂlBݒ肾ꍇNULLƓlԂB
	TYPE_VALUE remove(const TYPE_KEY& key) {
		TYPE_VALUE old;
		VALCTRL::initialize(old);
		int index = find(key);
		if (index != -1) {
			old = backet[index].value;
			if (!VALCTRL::isEmpty(old)) {
				count--;
				VALCTRL::initialize(backet[index].value);
				if (backetSize - count > BOUNDARY)
					rehash(count);
			}
		}
		return old;
	}
	// L[񋓂邽߂̃CX^X𐶐B
	// gpdeleteYȂ悤ɒӁB
	// Ԓl:
	//	L[񋓂邽߂̃CX^XB
	Pointer<KeyEnumeration> keys()const {
		return new EnumKeys(*this);
	}
	// l񋓂邽߂̃CX^X𐶐B
	// gpdeleteYȂ悤ɒӁB
	// Ԓl:
	//	l񋓂邽߂̃CX^XB
	Pointer<ElementEnumeration> elements()const {
		return new EnumValues(*this);
	}
	// LȒlL[̐擾B
	// Ԓl:
	//	LȒlL[̐B
	int size()const {
		return count;
	}
	// w̃L[LȒlĂ邩ǂ𔻒肷B
	// :
	//	肷L[B
	// Ԓl:
	//	LȒlĂΐ^B
	bool contains(const TYPE_KEY& key)const {
		int index = find(key);
		return index != -1 && !VALCTRL::isEmpty(backet[index].value);
	}
	// LȒlĂȂǂ𔻒肷B
	// Ԓl:
	//	LȒlĂȂΐ^B
	bool isEmpty()const {
		return count == 0;
	}
	// LȒlĂȂԂɖ߂B
	void empty() {
		delete[] backet;
		backet = NULL;
		backetSize = 0;
		count = 0;
	}
};

}

#endif//_YCL_HASHTABLE_H_
