/*
 * Copyright (c) 2015 IWAMOTO Kouichi
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "teraterm.h"
#include "tttypes.h"
#include "ttplugin.h"
#include "tt_res.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "compat_w95.h"

#define REGKEY "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\TeraPad"

#define ORDER 5900

#define ID_MENUID 57000

static HANDLE hInst; /* Instance handle of TTX*.DLL */

typedef struct {
	HMENU ControlMenu;
	char TeraPadPath[MAX_PATH];
} TInstVar;

static TInstVar FAR * pvar;

/* WIN32 allows multiple instances of a DLL */
static TInstVar InstVar;

#define GetControlMenu(menu) GetSubMenuByChildID(menu, ID_CONTROL_RESETTERMINAL)

HMENU GetSubMenuByChildID(HMENU menu, UINT id) {
	int i, j, items, subitems, cur_id;
	HMENU m;

	items = GetMenuItemCount(menu);

	for (i=0; i<items; i++) {
		if (m = GetSubMenu(menu, i)) {
			subitems = GetMenuItemCount(m);
			for (j=0; j<subitems; j++) {
				cur_id = GetMenuItemID(m, j);
				if (cur_id == id) {
					return m;
				}
			}
		}
	}
	return NULL;
}

static void PASCAL FAR TTXInit(PTTSet ts, PComVar cv) {
	HKEY key;
	char buff[MAX_PATH];
	DWORD type;
	DWORD size = sizeof(buff);

	pvar->TeraPadPath[0] = 0;

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, REGKEY, 0, KEY_READ, &key) == ERROR_SUCCESS) {
		if (RegQueryValueEx(key, "InstallLocation", NULL, &type, buff, &size) == ERROR_SUCCESS
		    && type == REG_SZ && size > 0) {
			if (strcat_s(buff, sizeof(buff), "\\TeraPad.exe") == 0) {
				if (GetFileAttributes(buff) != -1) {
					strcpy_s(pvar->TeraPadPath, sizeof(pvar->TeraPadPath), buff);
				}
			}
		}
		RegCloseKey(key);
	}
}

static void PASCAL FAR TTXModifyMenu(HMENU menu) {
	pvar->ControlMenu = GetControlMenu(menu);

	if (pvar->TeraPadPath[0]) {
		InsertMenu(pvar->ControlMenu, ID_CONTROL_MACRO, MF_BYCOMMAND, ID_MENUID, "Open TeraPad");
		InsertMenu(pvar->ControlMenu, ID_CONTROL_MACRO, MF_BYCOMMAND | MF_SEPARATOR, 0, NULL);
	}
}

static int PASCAL FAR TTXProcessCommand(HWND HWin, WORD cmd) {
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	if (cmd == ID_MENUID && pvar->TeraPadPath[0]) {
		memset(&si, 0, sizeof(si));
		GetStartupInfo(&si);
		memset(&pi, 0, sizeof(pi));

		CreateProcess(pvar->TeraPadPath, NULL, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
		return 1;
	}
	return 0;
}

static TTXExports Exports = {
  sizeof(TTXExports),
  ORDER,

  TTXInit,
  NULL, // TTXGetUIHooks,
  NULL, // TTXGetSetupHooks,
  NULL, // TTXOpenTCP,
  NULL, // TTXCloseTCP,
  NULL, // TTXSetWinSize,
  TTXModifyMenu,
  NULL, // TTXModifyPopupMenu,
  TTXProcessCommand,
  NULL, // TTXEnd
};

BOOL __declspec(dllexport) PASCAL FAR TTXBind(WORD Version, TTXExports FAR * exports) {
  int size = sizeof(Exports) - sizeof(exports->size);

  if (size > exports->size) {
    size = exports->size;
  }
  memcpy((char FAR *)exports + sizeof(exports->size),
         (char FAR *)&Exports + sizeof(exports->size),
         size);
  return TRUE;
}

BOOL WINAPI DllMain(HANDLE hInstance, ULONG ul_reason, LPVOID lpReserved)
{
  switch (ul_reason) {
    case DLL_THREAD_ATTACH:
      /* do thread initialization */
      break;
    case DLL_THREAD_DETACH:
      /* do thread cleanup */
      break;
    case DLL_PROCESS_ATTACH:
      /* do process initialization */
      DoCover_IsDebuggerPresent();
      hInst = hInstance;
      pvar = &InstVar;
      break;
    case DLL_PROCESS_DETACH:
      /* do process cleanup */
      break;
  }
  return TRUE;
}
