package jp.co.dolinc.composer;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import org.zkoss.zul.Include;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;

public class Main03Composer extends GenericForwardComposer<Component> {
	Listbox itemList;	//<listbox id="itemList"
	Include xcontents;	//<include id="xcontents" />
	/**
	 * 初期化処理
	 * Composer Implementation
	 */
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);
	}


	/**
	 * 一覧選択
	 * <listbox id="itemList"
	 * @param event
	 *
	 * listboxイベント
	 * 	onSelect
	 * 	onFocus
	 * 	onBlur
	 * 	onAfterRender
	 * 	onPageSize
	 *
	 */
	public void onSelect$itemList(SelectEvent<?, ?> event) {
		Listitem item = itemList.getSelectedItem();
		if (item != null) {
			// sometimes the item is unloaded.
			if (!item.isLoaded()) {
				itemList.renderItem(item);
			}
			if("item01".equals(item.getId())){
//				//<include id="xcontents" />のSrcを変更して画面を切り替える
				xcontents.setSrc("/screen0301.zul");	//<include id="xcontents" />
			}else if("item02".equals(item.getId())){
//				//<include id="xcontents" />のSrcを変更して画面を切り替える
				xcontents.setSrc("/screen0302.zul");	//<include id="xcontents" />
			}else if("item03".equals(item.getId())){
//				//<include id="xcontents" />のSrcを変更して画面を切り替える
				xcontents.setSrc("/screen0303.zul");	//<include id="xcontents" />
			}
		}
	}

	/**
	 *デフォルトID
	 */
	private static final long serialVersionUID = 1L;

}
