﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Windows.Controls;
using FooEditor;
using FooEditor.Plugin;
using System.Windows;
using Outline.Properties;

namespace Outline
{
    struct OutlineInfo
    {
        public int StartRow;
        public int Count;
        public int Level;
        public OutlineInfo(int startRow, int count,int level)
        {
            this.StartRow = startRow;
            this.Count = count;
            this.Level = level;
        }
    }
    [Export(typeof(IPlugin))]
    public class Outlline : IPlugin
    {
        MainWindow editor;
        ExplorerBar<OutlineWindow> outlineWindow;

        public void Initalize(MainWindow e)
        {
            this.editor = e;
            this.editor.ActiveDocumentChanged += new EventHandler(editor_ActiveDocumentChanged);

            this.outlineWindow = new ExplorerBar<OutlineWindow>();
            this.outlineWindow.Content = new OutlineWindow();
            this.editor.RegisterExploereBar<OutlineWindow>(this.outlineWindow);
            this.outlineWindow.IsVisible = false;

            MenuItem item = new MenuItem();
            item.Header = Resources.OutLineMenuName;
            item.Click += new RoutedEventHandler(item_Click);
            MenuItem toolMenuItem = (MenuItem)this.editor.FindName(FooEditorMenuItemName.LookMenuName);
            toolMenuItem.Items.Insert(0, item);
        }

        void editor_ActiveDocumentChanged(object sender, EventArgs e)
        {
            if (this.editor.ActiveDocument == null)
                return;
            this.outlineWindow.Content.Target = this.editor.ActiveDocument;
        }

        void item_Click(object sender, RoutedEventArgs e)
        {
            if (this.editor.ActiveDocument == null)
                return;
            this.outlineWindow.Content.Target = this.editor.ActiveDocument;
            this.outlineWindow.IsVisible = true;
        }

        public void ClosedApp()
        {
            this.outlineWindow.Content.Save();
        }

        public void ShowConfigForm()
        {
            ConfigWindow config = new ConfigWindow(this.outlineWindow.Content.AnalyzeTypeCollection);
            config.ShowDialog();
        }
    }
}
