#ifndef GGAFDXCORE_GGAFDXBOARDMODEL_H_
#define GGAFDXCORE_GGAFDXBOARDMODEL_H_
#include "jp/ggaf/dxcore/model/GgafDxModel.h"

namespace GgafDxCore {

/**
 * GgafDxBoardActorpfNX.
 * @version 1.00
 * @since 2009/03/10
 * @author Masatoshi Tsuge
 */
class GgafDxBoardModel : public GgafDxModel {
    friend class GgafDxModelManager;
    friend class GgafDxBoardActor;

public:
    struct VERTEX {
        float x, y, z; // _W
        float tu, tv; // eNX`W
    };

    /** _FVF */
    static DWORD FVF;
    /** _obt@ */
    LPDIRECT3DVERTEXBUFFER9 _pIDirect3DVertexBuffer9;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;

    float _fSize_BoardModelWidthPx;
    float _fSize_BoardModelHeightPx;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    GgafDxBoardModel(char* prm_model_name);

    virtual HRESULT draw(GgafDxDrawableActor* prm_pActor_Target, int prm_draw_set_num = 1) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     * deletêGgafDxBoardModelManagerł<BR>
     */
    virtual ~GgafDxBoardModel(); //fXgN^

};

}
#endif /*GGAFDXCORE_GGAFDXBOARDMODEL_H_*/
