#include "stdafx.h"
#include "jp/ggaf/dxcore/actor/ex/GgafDxSpriteMeshSetActor.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxUvFlipper.h"
#include "jp/ggaf/dxcore/effect/GgafDxMeshSetEffect.h"
#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/GgafDxProperties.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureConnection.h"
#include "jp/ggaf/dxcore/model/GgafDxMeshSetModel.h"
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxSpriteMeshSetActor::GgafDxSpriteMeshSetActor(const char* prm_name,
                                                   const char* prm_model,
                                                   GgafStatus* prm_pStat,
                                                   GgafDxChecker* prm_pChecker) :

                                                    GgafDxMeshSetActor(prm_name,
                                                                       prm_model,
                                                                       "SpriteMeshSetEffect",
                                                                       "SpriteMeshSetTechnique",
                                                                       prm_pStat,
                                                                       prm_pChecker) {

    _obj_class |= Obj_GgafDxSpriteMeshSetActor;
    _class_name = "GgafDxSpriteMeshSetActor";

    GgafDxTexture* pTexture = _pMeshSetModel->_papTextureConnection[0]->peek();
    _pUvFlipper = NEW GgafDxUvFlipper(pTexture);
    _pUvFlipper->setRotation(1, 1);
    _pUvFlipper->setActivePtn(0);
    _pUvFlipper->exec(NOT_ANIMATED, 1);
}


void GgafDxSpriteMeshSetActor::processDraw() {

    int draw_set_num = 0; //GgafDxSpriteMeshSetActor̓fœeNjbN
                       //AĂJEgB`[x͈xɕ`悷B
    ID3DXEffect* pID3DXEffect = _pMeshSetEffect->_pID3DXEffect;
    HRESULT hr;
    GgafDxDrawableActor* pDrawActor = this;
    GgafDxSpriteMeshSetActor* pSpriteMeshSetActor = nullptr;
    int model_set_num = _pMeshSetModel->_set_num;
    float u = 0;
    float v = 0;
    while (pDrawActor) {
        if (pDrawActor->getModel() == _pMeshSetModel && pDrawActor->_hash_technique == _hash_technique) {
            pSpriteMeshSetActor = (GgafDxSpriteMeshSetActor*)pDrawActor;

            hr = pID3DXEffect->SetMatrix(_pMeshSetEffect->_ah_matWorld[draw_set_num], &(pSpriteMeshSetActor->_matWorld));
            checkDxException(hr, D3D_OK, "GgafDxSpriteMeshSetActor::processDraw() SetMatrix(g_matWorld) Ɏs܂B");
            hr = pID3DXEffect->SetValue(_pMeshSetEffect->_ah_materialDiffuse[draw_set_num], &(pSpriteMeshSetActor->_paMaterial[0].Diffuse), sizeof(D3DCOLORVALUE) );
            checkDxException(hr, D3D_OK, "GgafDxSpriteMeshSetActor::processDraw() SetValue(g_colMaterialDiffuse) Ɏs܂B");
#ifdef MY_DEBUG
            if (pDrawActor->instanceOf(Obj_GgafDxSpriteMeshSetActor)) {
                //OK
            } else {
                throwGgafCriticalException("GgafDxSpriteMeshSetActor::processDraw() pDrawActor["<<pDrawActor->getName()<<"] GgafDxSpriteMeshSetActorł͂܂B");
            }
#endif
            //[MEMO]
            //GgafDxSpriteMeshSetActor ́AGgafDxMeshSetActor hĂ邽߁AfNX͓GgafDxMeshSetModelłB
            //GgafDxSpriteMeshSetActorgp郂f("x/10/Flora")ƁAGgafDxMeshSetActorgp郂f
            //݂̂ꍇApDrawActor ́AGgafDxMeshSetActor ̉\B
            //́Adraw_set_num ߂郍WbN͓[xŘA̓(AhX)fłBƂ肵sĂȂ߁B
            //͂ŁAGgafDxSpriteMeshSetActor  GgafDxMeshSetActor œꃂfgp邱Ƃ͋֎~ɂ̂łB
            //{ Actor ̎ނɊ֌WȂA Model ŘAȂ΁AXe[g؂ւ邱ƂEł̂A
            //GgafDxSpriteMeshSetActor ́AGgafDxMeshSetActor hĂɂ炸AGtFNĝύXĂB
            //ɎȂ΁AʕƂĂꂼʂ Model NX쐬ׂȂAModelNXƂĂ̏̂
            //GgafDxSpriteMeshSetActorAGgafDxMeshSetActor ɑSŗǂB
            //Y񂾌ʁAModel NX𕪂ĎA댯ȃLXgsƂƂB
            //Ƃ肠GgafDxSpriteMeshSetActor ƁAGgafDxMeshSetActor ̃fdȂ悤Ђӎ邱ƂɂB
            //fobN[hŏ\eXgB
            //Actor ͔hĂ̂ɁAModelEffect́AeActorƈႤASetnBȊ֌WɒӂBi[U[`bvƂEEEj
            //TODO:dȂ悤ɂdg݂ȂƂ

            //UVItZbgݒ
            pSpriteMeshSetActor->_pUvFlipper->getUV(u, v);
            hr = pID3DXEffect->SetFloat(_pMeshSetEffect->_ah_offset_u[draw_set_num], u);
            checkDxException(hr, D3D_OK, "GgafDxSpriteMeshSetActor::processDraw() SetMatrix(_h_offset_u) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(_pMeshSetEffect->_ah_offset_v[draw_set_num], v);
            checkDxException(hr, D3D_OK, "GgafDxSpriteMeshSetActor::processDraw() SetMatrix(_h_offset_v) Ɏs܂B");


            draw_set_num++;
            if (draw_set_num >= model_set_num) {
                break;
            }
            pDrawActor = pDrawActor->_pNext_TheSameDrawDepthLevel;
        } else {
            break;
        }
    }
    GgafDxUniverse::_pActor_DrawActive = pSpriteMeshSetActor; //`Zbg̍ŌAN^[Zbg
    _pMeshSetModel->GgafDxMeshSetModel::draw(this, draw_set_num);
}


GgafDxSpriteMeshSetActor::~GgafDxSpriteMeshSetActor() {
    GGAF_DELETE(_pUvFlipper);
}
