#ifndef GGAFLIB_WALLEDSCENE_H_
#define GGAFLIB_WALLEDSCENE_H_
#include "jp/ggaf/lib/scene/DefaultScene.h"

#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/lib/scene/WalledSectionScene.h"

namespace GgafLib {

/**
 * ǃubNV[ .
 *  WalledScene ́A WalledSectionScene q킹̂łB
 * @version 1.00
 * @since 2010/11/05
 * @author Masatoshi Tsuge
 */
class WalledScene : public DefaultScene {

public:
    /** ZNVV[̕ێXg */
    GgafCore::GgafLinkedListRing<GgafLib::WalledSectionScene> _ringHoldSection;
    /** ZNVV[̕ێXg */
    GgafCore::GgafLinkedListRing<GgafLib::WalledSectionScene> _ringLoopEndSection;
    /** ǃubNf|Wg(buildWalledScene()Őݒ肳) */
    GgafCore::GgafActorDepository* _pDepo_WallAAB;
    GgafCore::GgafActorDepository* _pDepo_WallAAPrism;
    WalledSectionScene* _pLastSectionScene;
    bool _is_all_active_section_scenes;
    bool _is_finished;

public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    WalledScene(const char* prm_name);

    /**
     * WalledScene\zB
     * {NX new  initialize() ܂łɁAKPsKv܂B
     * yӁz
     * prm_pDepo_WallAABox y prm_pDepo_WallAAPrism ͏Ŗ{V[initialize() 
     * zɋړ܂BāA}l[WǗ̋ʃf|Wg̏ꍇ́A
     * }l[W̕s|C^̌ɂȂ܂B
     * @param prm_wall_dep      ǃubNPX̕
     * @param prm_wall_width    ǃubNPZ̕
     * @param prm_wall_height   ǃubNPY̕
     * @param prm_wall_start_x  OǏoXWʒu
     * @param prm_papSection    ZNVV[zւ̃|C^
     * @param prm_section_num   ZNVV[
     * @param prm_pDepo_WallAABox ǃubN(WallAABActor)f|Wgiinitialize()Azɋړj
     * @param prm_pDepo_WallAAPrism ǃvY(WallAAPrismActor)f|Wgiinitialize()AzɋځBvY͏ȗj
     */
    void buildWalledScene(
            coord prm_wall_dep, coord prm_wall_width, coord prm_wall_height,
            coord prm_wall_start_x,
            WalledSectionScene** prm_papSection, int prm_section_num,
            GgafCore::GgafActorDepository* prm_pDepo_WallAABox,
            GgafCore::GgafActorDepository* prm_pDepo_WallAAPrism = nullptr
         );

    /**
     * ς݁BʂŃI[o[Chꍇ́Ainitialize()ĂяoĉB
     */
    virtual void initialize() override;

    /**
     * ς݁BʂŃI[o[Chꍇ́AonActive()ĂяoĉB
     */
    virtual void onActive() override;

    /**
     * Ō̃ZNVV[̍Ō̕ǃubN񊈓ɖꍇA
     * R[obNB
     * sayonara() ȂǂĉB
     */
    virtual void onFinishedAllSection() = 0;

    /**
     * ς݁BʂŃI[o[Chꍇ́AprocessBehavior()ĂяoĉB
     */
    virtual void processBehavior() override;

    virtual void processFinal() override;

    /**
     * X̕̕ɃXN[֐ .
     * @param pThat AN^[
     * @param p1 XN[Xs[h(_scroll_speedւ̃|C^)
     * @param p2 CӁi͓ɖj
     */
    static void scrollX(GgafObject* pThat, void* p1, void* p2);


    virtual ~WalledScene();
};

}
#endif /*GGAFLIB_WALLEDSCENE_H_*/
