#ifndef VVVCAMERA_H_
#define VVVCAMERA_H_
#include "jp/ggaf/lib/actor/DefaultCamera.h"

namespace VVViewer {

/**
 * VVViewer̃J .
 * @version 1.00
 * @since 2012/06/05
 * @author Masatoshi Tsuge
 */
class VvvCamera : public GgafLib::DefaultCamera {
public:
    coord tx_, ty_, tz_;
    int vcv_face_;
    int vcv_face_prev_;
    static int cnvVec2FaceNo(float vx, float vy, float vz);
    static void cnvFaceNo2Vec(int face_no, float& out_vx, float& out_vy, float& out_vz);

    int up_face_;
    /** sړx */
    GgafDxCore::GgafDxAxesMover* pAxsMver_;

    /** JUPxNgpAN^[ */
    GgafLib::DefaultGeometricActor* pUp_;
    /** pUp_ ̕sړx */
    GgafDxCore::GgafDxAxesMover* pAxsMver_Up_;

public:


    VvvCamera(const char* prm_name);
    GgafDxCore::GgafDxCameraViewPoint* createViewPoint() override;

    virtual void initialize() override;
    void processBehavior() override;


    /**
     * J_xNg̖ʔԍ擾܂ .
     * @return J_xNg̖ʔԍ(1`6)
     */
    int getCamToVpFaceNo();

    /**
     * JUPʔԍA̖ʔԍɃZbgAUPxNgXChړJn܂B
     * @param prm_face_no JUPʔԍ
     */
    void slideUpCamTo(int prm_face_no);

    /**
     * JwʒuɊ炩ړ܂B .
     * @param tx
     * @param ty
     * @param tz
     * @param t vt[
     */
    void slideMvTo(coord tx, coord ty, coord tz, frame t);

    /**
     * Jw̃AN^[̈ʒuɊ炩ړ܂B .
     * @param pTarget
     * @param t vt[
     */
    void slideMvTo(GgafDxCore::GgafDxGeometricActor* pTarget, frame t);


    virtual ~VvvCamera();
};

}
#endif /*VVVCAMERAH_*/
