﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
#pragma once

#define MAXCONN     FD_SETSIZE

/// クライアント側セッションのコントロールブロック。
typedef struct tagClientCB {
    SessionRes res;
    unsigned sessionID;
    char hostName[NI_MAXHOST];
    char serviceName[NI_MAXSERV];
    struct addrinfo to;
    unsigned (__stdcall *startAddress)(void* exinf);
    void* exinf2;
} ClientCB;

//
//  Client用
//

/// クライアント機能を初期化します。
extern void cli_init_sockutil(void);

/// クライアント機能を後始末します。
extern void cli_term_sockutil(void);

/// 接続手段を列挙します。
extern int cli_enum_means(PCSTR pNodeName, PCSTR pServiceName, ClientCB cb[], int n);
/*= Return value:
 *      Negative value: Error
 *      Otherwise: Number of connecting means
 *                 (Always it <= n. Exceeded means are ignored.)
 */

/// 接続します。
extern BOOL cli_connect(
    ClientCB* p_cb,
    unsigned (__stdcall *startAddress)(void* exinf),
    BOOL bBlocking
    );
/*= Return value:
 *      TRUE:   Succeeded (Connected)
 *      FALSE:  Failed
 */

/// 接続します。(タイムアウト指定可能)
extern int cli_connect_ex(
    ClientCB* p_cb,
    DWORD TCTmoIn_ms,
    unsigned (__stdcall *startAddress)(void* exinf),
    BOOL bBlocking
    );
/*= Return value:
 *      0:  Timeout
 *      1:  Connected (Succeeded)
 */

/// セッション完了を待ちます。
extern BOOL cli_wai_cmpl(ClientCB* p_cb);
/*= Return value:
 *      TRUE:   Succeeded
 *      FALSE:  Failed
 */
