//
//  debug.c
//  chncpu
//
//  Created by 西田　耀 on 2014/07/07.
//  Copyright (c) 2014年 CHNOSProject. All rights reserved.
//

#include "chncpu.h"

void CHNCPU_DumpAppBin(CHNCPU_RuntimeEnvironment *env)
{
    int i;
    
    for(i = 0; i < env->appbinsize; i++){
        printf("%02X ", env->appbin0[i]);
        if((i & 0xf) == 0xf){
            putchar('\n');
        }
    }
    if(((i - 1) & 0xf) != 0xf){
        putchar('\n');
    }
}

void CHNCPU_DumpIReg(CHNCPU_RuntimeEnvironment *env)
{
    int i, regs = 0;
    
    puts(">>> Integer registers");
    
    for(i = 0; i < CHNCPU_NUMBER_OF_IREG; i++){
        if(env->iRegBits[i]){
            printf("R%02X = %10d = 0x%08X(%2d) ", i, env->iReg[i], env->iReg[i], env->iRegBits[i]);
			putchar('\n');
            regs++;
        }
    }
    if(((regs - 1) & 0xF) != 0xF){
        putchar('\n');
    }
}

void CHNCPU_DumpPReg(CHNCPU_RuntimeEnvironment *env)
{
    int i, regs = 0;
    
    puts(">>> Pointer registers");
    
    for(i = 0; i < CHNCPU_NUMBER_OF_PREG; i++){
        if(env->pReg[i].type != CHNCPU_PType_Undefined){
			if(env->pReg[i].mindex != CHNCPU_MemoryIndex_INVALID){
				printf("P%02X: Type:%2X  mem[%d][%d]", i, env->pReg[i].type, env->pReg[i].mindex, env->pReg[i].pindex);
			} else{
				printf("P%02X: Type:%2X  %s[%d]", i, env->pReg[i].type, env->pReg[i].data->filePath, env->pReg[i].pindex);
			}
			putchar('\n');
            regs++;
        }
    }
    if(((regs - 1) & 0xF) != 0xF){
        putchar('\n');
    }
}

void CHNCPU_PrintErrorMessage(CHNCPU_RuntimeEnvironment *env)
{
	printf(">>> Error in label:%d\n\t", env->currentLabel);
	if(env->errFlags & CHNCPU_ERR_INTERNAL){
		puts("Internal error.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_BITS){
		puts("Invalid bits.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_OPCODE){
		puts("Invalid opCode.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_REGNUM){
		puts("Invalid regNum.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_PTYPE){
		puts("Invalid pType.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_BINARY){
		puts("Invalid Binary.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_PREFIX){
		puts("Invalid prefix.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_EXPRESSION){
		puts("Invalid expression.");
	}
	if(env->errFlags & CHNCPU_ERR_INVALID_EXPRESSION){
		puts("Invalid BIOSFuncID.");
	}
	if(env->errFlags & CHNCPU_ERR_DUPLICATED_LABEL_ID){
		puts("LabelID duplicated.");
	}
	if(env->errFlags & CHNCPU_ERR_NOT_FOUND_LABEL){
		puts("LabelID not found.");
	}
	if(env->errFlags & CHNCPU_ERR_NOT_MATCHED_PTYPE){
		puts("PType not matched.");
	}
	if(env->errFlags & CHNCPU_ERR_TRUNCATED_VALUE){
		puts("Value truncated without prefix 2F-0.");
	}
	if(env->errFlags & CHNCPU_ERR_BAD_ACCESS){
		puts("Bad access on memory.");
	}
	return;
}
