/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.util.Map;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class MapFormatter
implements Formatter {
    public static final MapFormatter INSTANCE = new MapFormatter();

    MapFormatter() {
    }

    public boolean format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        Map map = (Map)o;
        JSONHint hint = context.getHint();
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        out.append('{');
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (key == null || (value = entry.getValue()) == src) continue;
            if (count != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                int indent = context.getInitialIndent() + context.getDepth() + 1;
                for (int j = 0; j < indent; ++j) {
                    out.append(context.getIndentText());
                }
            }
            StringFormatter.serialize(context, key.toString(), out);
            out.append(':');
            if (context.isPrettyPrint()) {
                out.append(' ');
            }
            context.enter(key, hint);
            value = context.preformatInternal(value);
            if (value == null) {
                NullFormatter.INSTANCE.format(context, src, value, out);
            } else if (hint == null) {
                if (value.getClass().equals(lastClass)) {
                    lastFormatter.format(context, src, value, out);
                } else {
                    lastFormatter = context.formatInternal(value, out);
                    lastClass = value.getClass();
                }
            } else {
                context.formatInternal(value, out);
            }
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            int indent = context.getInitialIndent() + context.getDepth();
            for (int j = 0; j < indent; ++j) {
                out.append(context.getIndentText());
            }
        }
        out.append('}');
        return true;
    }
}

