/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectFormatter
implements Formatter {
    private Class<?> cls;
    private transient List<PropertyInfo> props;

    public ObjectFormatter(Class<?> cls) {
        this.cls = cls;
    }

    @Override
    public boolean format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        if (this.props == null) {
            this.props = ObjectFormatter.getGetProperties(context, this.cls);
        }
        out.append('{');
        int count = 0;
        int length = this.props.size();
        for (int p = 0; p < length; ++p) {
            PropertyInfo prop = this.props.get(p);
            Object value = null;
            Exception cause = null;
            try {
                value = prop.get(o);
                if (value == src || context.isSuppressNull() && value == null) continue;
                if (count != 0) {
                    out.append(',');
                }
                if (context.isPrettyPrint()) {
                    out.append('\n');
                    int indent = context.getInitialIndent() + context.getDepth() + 1;
                    for (int j = 0; j < indent; ++j) {
                        out.append(context.getIndentText());
                    }
                }
            }
            catch (Exception e) {
                cause = e;
            }
            StringFormatter.serialize(context, prop.getName(), out);
            out.append(':');
            if (context.isPrettyPrint()) {
                out.append(' ');
            }
            context.enter(prop.getName(), prop.getReadAnnotation(JSONHint.class));
            if (cause != null) {
                throw cause;
            }
            value = context.preformatInternal(value);
            context.formatInternal(value, out);
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            int indent = context.getInitialIndent() + context.getDepth();
            for (int j = 0; j < indent; ++j) {
                out.append(context.getIndentText());
            }
        }
        out.append('}');
        return true;
    }

    static List<PropertyInfo> getGetProperties(JSON.Context context, Class<?> c) {
        int ordinal;
        String name;
        JSONHint hint;
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
            Field f = prop.getField();
            if (f == null || context.ignoreInternal(c, f)) continue;
            hint = f.getAnnotation(JSONHint.class);
            name = null;
            ordinal = prop.getOrdinal();
            if (hint != null) {
                if (hint.ignore()) continue;
                ordinal = hint.ordinal();
                if (hint.name().length() != 0) {
                    name = hint.name();
                }
            }
            if (name == null) {
                name = context.normalizeInternal(prop.getName());
                if (context.getPropertyStyle() != null) {
                    name = context.getPropertyStyle().to(name);
                }
            }
            if (!name.equals(prop.getName()) || ordinal != prop.getOrdinal() || f != prop.getReadMember()) {
                props.put(name, new PropertyInfo(prop.getBeanClass(), name, prop.getField(), null, null, prop.isStatic(), ordinal));
                continue;
            }
            props.put(name, prop);
        }
        for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
            Method m = prop.getReadMethod();
            if (m == null || context.ignoreInternal(c, m)) continue;
            hint = m.getAnnotation(JSONHint.class);
            name = null;
            ordinal = prop.getOrdinal();
            if (hint != null) {
                if (hint.ignore()) continue;
                ordinal = hint.ordinal();
                if (hint.name().length() != 0) {
                    name = hint.name();
                }
            }
            if (name == null) {
                name = context.normalizeInternal(prop.getName());
                if (context.getPropertyStyle() != null) {
                    name = context.getPropertyStyle().to(name);
                }
            }
            if (!name.equals(prop.getName()) || ordinal != prop.getOrdinal()) {
                props.put(name, new PropertyInfo(prop.getBeanClass(), name, null, prop.getReadMethod(), null, prop.isStatic(), ordinal));
                continue;
            }
            props.put(name, prop);
        }
        ArrayList<PropertyInfo> list = new ArrayList<PropertyInfo>(props.values());
        Collections.sort(list);
        return list;
    }
}

