/**
 * APIs
 */

var api = exports;
var database = require('../models/database');

/**
 * トピック一覧をJSON形式で返す
 */
api.topicsList = function (req, res) {
  // Topicsクラスのインスタンスを作成
  var topics = database.getTopics();
  // 最新10件のトピックを取得する
  topics.getLatest(0, 10, function (err, items) {
    if (err) {
      // エラーが発生したら500エラーを返す
      res.status(500);
      return;
    }
    topics.close();
    res.json(200, items);
    return;
  });
};

