
// キャッシュを識別する名前を定義
const CACHE_NAME = "knowledge_serviceworker_example";

// キャッシュ対象を指定する
// 今回は index.html、index.js、sample.jpeg の3つ
const TARGET_URLS = [
  "index.html",
  "index.js",
  "sample.jpeg",
];

// installイベントハンドラを登録
self.addEventListener("install", event => {
  // 引数で指定したPromiseが解決されるまで待機
  event.waitUntil(
    // キャッシュを開く
    self.caches.open(CACHE_NAME)
      .then(cache => {
        // 指定したURLをすべてキャッシュする
        return cache.addAll(TARGET_URLS);
      })
  );
});

// fetchイベントハンドラを登録
self.addEventListener("fetch", event => {
  // オンラインかどうかをチェック
  if (self.navigator.onLine) {
    // オンラインならネットワークリクエストを行う
    event.respondWith(fetch(event.request));
    return;
  }

  // リクエストURLをチェック
  const url = new URL(event.request.url);

  // data.jsonへのアクセスの場合、特別なレスポンスを返す
  if (url.pathname == "/data.json") {
    event.respondWith(async function() {
      // JSON形式のレスポンスボディを含むレスポンスを作成する
      const data = `{"data":"offline (${Math.floor(Math.random() * 100)})"}`;
      const headers = new Headers();
      headers.append("Content-Type", "application/json");
      const resp = new Response(data,
                                { status: 200,
                                  statusText: "OK",
                                  headers: headers });
      return resp;
    }());
    return;
  }

  // ルートへのアクセスの場合、index.htmlを返す
  let targetRequest = event.request;
  if (url.pathname == "/") {
    url.pathname = "/index.html";
    targetRequest = url.toString();
  }

  // リクエストに対するレスポンスを設定する
  event.respondWith(
    // リクエストに該当するキャッシュを探す
    self.caches.match(targetRequest, {cacheName: CACHE_NAME})
      .then(response => {
        if (response) {
          // キャッシュが存在したのでそれを返す
          return response;
        }
        // キャッシュが存在しないのでネットワークリクエストを行う
        return fetch(event.request);
      })
  );
});

