// client.js

var OAuth = require('oauth');
var Twitter = require('twitter');
var path = require('path');
var fs = require('fs');
var Client = function () {};

var CONFIG_FILE = path.join(process.env.HOME, '.sprnkr');

Client.prototype.loadTokens = function loadTokens () {
  var jsonData;
  try {
    jsonData = fs.readFileSync(CONFIG_FILE, 'utf8');
  } catch (e) {
    return false;
  }
  var data = JSON.parse(jsonData);
  this.accessToken = data.tokens.access_token;
  this.accessTokenSecret = data.tokens.access_token_secret;
  this.createTwitterClient();
  return true;
};

Client.prototype.saveTokens = function saveTokens () {
  var jsonData = JSON.stringify({
    tokens: {
      access_token: this.accessToken,
      access_token_secret: this.accessTokenSecret
    }
  });
  fs.writeFileSync(CONFIG_FILE, jsonData, 'utf8');
};

Client.prototype.getCallbackUrl = function getCallbackUrl (callback) {
  var client = this;
  function sendCallback(err, token, secret, results) {
    client.requestToken = token;
    client.requestSecret = secret; 

    var authUrl = 'https://twitter.com/oauth/authenticate?oauth_token=' + token;
    callback(err, authUrl);
  };
  this.oauth.getOAuthRequestToken(sendCallback);
};

Client.prototype.createTwitterClient = function createTwitterClient() {
  this.twitter = new Twitter({
    consumer_key: this.consumerKey,
    consumer_secret: this.consumerSecret,
    access_token_key: this.accessToken,
    access_token_secret: this.accessTokenSecret
  });
}

Client.prototype.authorize = function authorize(token, verifier, callback) {
  var client = this;
  function createTwitterClient(err, token, secret, results) {
    if (err) {
      callback(err);
    }
    client.accessToken = token;
    client.accessTokenSecret = secret;
    client.saveTokens();
    client.createTwitterClient();
    callback(false);
  };
  client.oauth.getOAuthAccessToken(token, client.requestSecret, verifier, createTwitterClient);
}

Client.prototype.getHomeTimeline = function getHomeTimeline(callback) {
  client.twitter.get('statuses/home_timeline', callback);
};

Client.prototype.stream = function stream(callback) {
  client.twitter.stream('user', {}, function (stream) {
    stream.on('data', callback);
    stream.on('error', function(error) {
      throw error;
    });
  });
}

function createClient(consumerKey, consumerSecret) {
  if (consumerSecret === undefined) {
    consumerSecret = consumerKey.consumer_secret;
    consumerKey = consumerKey.consumer_key;
  }
  client = new Client();
  client.consumerKey = consumerKey;
  client.consumerSecret = consumerSecret;
  client.oauth = new OAuth.OAuth(
    'https://api.twitter.com/oauth/request_token',
    'https://api.twitter.com/oauth/access_token',
    consumerKey,
    consumerSecret,
    '1.0A',
    'sprnkr://token',
    'HMAC-SHA1'
  );
  return client;
};

exports.createClient = createClient;
