var util = require('util');
var $ = require('jquery');
var ejs = require('ejs');
var moment = require('moment');

function sprnkrViewMain () {
  var tweetWriter = {};
  tweetWriter.put = function write(tweet) {
    if (tweet.user === undefined) {
      return;
    }
    var tweetData = {
      name:  tweet.user.name + ' (@' + tweet.user.screen_name + ')',
      timestamp: moment(tweet.created_at).format('YYYY-MM-DD hh:mm:ss'),
      text: tweet.text,
      iconUrl: tweet.user.profile_image_url
    }
    var templ = '';
    templ += '<div class="icon"><img src="<%= iconUrl %>"/></div>';
    templ += '<div class="header"><span class="username"><%= name %></span><span class="timestamp"><%= timestamp %></span></div>';
    templ += '<div class="body"><%= text %></div>';
    var content = ejs.render(templ, tweetData);
    var elem = $("<li>" + content + "</li>");
    $("#sprnkr-items").prepend(elem);
  }
  tweetWriter.write = function (tweet) {
    if (util.isArray(tweet)) {
      tweet.reverse();
      tweet.forEach(this.put);
    } else {
      this.put(tweet);
    }
  };

  const remote = require('electron').remote;
  const app = remote.app;
  var client = app._clients[0];
  client.getHomeTimeline(initTimeline);

  function initTimeline(err, tweets, resp) {
    if (err) throw err;
    tweetWriter.write(tweets);
    client.stream(function(tweets) {
      tweetWriter.write(tweets);
    });
  };

}

sprnkrViewMain();
