# 
# -*- codeing: utf-8 -*-
'ctable.py'

import re

table_rows = []
table_attrs = {}

def tableRow(context, args):
    line = args[0]
    cells = line.split("\t")
    table_rows.append(cells)
    return []

def tableHeaderRow(context, args):
    tableRow(context, args)
    row_count = len(table_rows)
    for i in range(0, len(table_rows[-1])):
        table_attrs[(row_count-1, i)] = {"header": True}
    return []

def start_tag(tag, attrs={}):
    if len(attrs) > 0:
        attr = " " + " ".join([x + "=" + '"' + str(attrs[x]) + '"' for x in attrs.keys()])
    else:
        attr = ""
    return "<" + tag + attr + ">"

def end_tag(tag):
    return "</" + tag + ">"

def renderTable(context, args):
    buf = ""
    height = len(table_rows)
    for i in range(0, height):
        buf += "<tr>\n  "
        width = len(table_rows[i])
        for j in range(0, width):
            if table_rows[i][j] == "":
                continue
            attrs = {}
            # check: cell is header?
            if table_attrs.get((i, j), False):
                tag = "th"
            else:
                tag = "td"
            # check: 
            if j == 0:
                rowspan = 0
                for x in range(i+1, height):
                    if table_rows[x][j] != "":
                        break;
                    rowspan += 1;
                if rowspan > 0:
                    attrs["rowspan"] = rowspan + 1
            colspan = 0
            for y in range(j+1, width):
                if table_rows[i][y] != "":
                    break;
                colspan += 1;
            if colspan > 0:
                attrs["colspan"] = colspan + 1

            buf += start_tag(tag, attrs) + table_rows[i][j] + end_tag(tag)
        buf += "\n</tr>"
        
    return [('ctable', buf)]

def flushTable(context, args):
    ret = renderTable(context, args)
    table_rows[:] = []
    table_attrs.clear()
    return ret

