package com.torn.game;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import com.torn.enemy.AtomMoveManager;
import com.torn.player.PlayerManager;

@SuppressWarnings("serial")
public class MyCanvas extends Canvas implements Runnable, MouseListener {

	private AtomMoveManager atomController;
	private PlayerManager playerController;
	private Thread drawThread; // `Xbh

	public MyCanvas(int width, int height) {
		setSize(width, height);
		setBackground(Color.WHITE);
		initialize();
	}

	private void initialize() {
		/* Atom */
		atomController = AtomMoveManager.getInstance();
		/* Player */
		playerController = PlayerManager.getInstance();
		
		/* `Xbh */
		drawThread = new Thread(this);
		drawThread.start();
		
		/* pXi[o^ */
		addMouseListener(this);
	}

	public void paint(Graphics g) {
		super.paint(g);
		/* Atom */
		atomController.paint();
		/* Player */
		playerController.paint();
	}
	public void run() {
		while (true) {
			repaint();
		}
	}
	
	/********/
	/*  */
	/********/
	@Override
	public void mouseClicked(MouseEvent e) {
	}
	@Override
	public void mousePressed(MouseEvent e) {
		Point mp = e.getPoint();
		
		/* S(0,0)Ƃēŕێ */
		Point p = new Point(mp.x - this.getWidth()/2, mp.y - this.getHeight()/2);
		PlayerManager.getInstance().addAtom(p.x, p.y);
	}
	@Override
	public void mouseReleased(MouseEvent e) {
	}
	@Override
	public void mouseEntered(MouseEvent e) {
	}
	@Override
	public void mouseExited(MouseEvent e) {
	}
}
