package game.net.player2;


import game.player1.one.GameThread;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import com.haru.component.GameField;
import com.haru.component.NextNextField;
import com.haru.component.gui.MainPanel;
import com.haru.input.KeyBuffer;
import com.haru.net.NetConstant;
import com.haru.net.OutData2;



public class GameClientThread_port extends GameThread implements NetConstant {

    static Object client_lock = new Object();


	private KeyBuffer keyBuffer;
	// Socket socket
	private ObjectInputStream in;
	private PrintWriter out;

	private MainPanel mainPanel2;


	public GameClientThread_port(MainPanel mainPanel1, KeyBuffer keyBuffer, MainPanel mainPanel2) {
		super(mainPanel1);
		this.keyBuffer = keyBuffer;

		this.mainPanel2 = mainPanel2;
	}

	//--------------------------------------------------------------------------//
	// T[o֐ڑ
	//--------------------------------------------------------------------------//
	public boolean connect(int port) {

		Socket sock;
		try {
			sock = new Socket(HOST, port);
		} catch (UnknownHostException e1) {
			System.out.println("zXgłȂ");
			e1.printStackTrace();
			return false;
		} catch (IOException e1) {
			System.out.println("ڑs");
			e1.printStackTrace();
			return false;
		}

		try {
			in = new ObjectInputStream(sock.getInputStream());
			out = new PrintWriter(sock.getOutputStream(), true);

		} catch (IOException e1) {
			e1.printStackTrace();
			System.out.println("Xg[쐬s");
			return false;
		}
		return true;
	}
	//--------------------------------------------------------------------------//
	// N[Y
	//--------------------------------------------------------------------------//
	private void close() {
		System.out.println("Xg[N[Y");
		try {
			in.close();
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}


	@Override
	protected void gameinit() {

		try {
			if (in.read() == M_READY) {
				out.write(M_START);
				out.flush();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}

		{
			// tB[h̏
			GameField gameField = new GameField();
			NextNextField nextField = new NextNextField();
			getMainPanel().init(gameField, nextField);

		}
		{
			// tB[h̏
			GameField gameField = new GameField();
			NextNextField nextField = new NextNextField();
			mainPanel2.init(gameField, nextField);
		}
	}



	@Override
	protected boolean gameloop(int loop) {

		//--------------------------------------------------------------------------//
		// OUT : ͏̏o (socket֏o)
		//--------------------------------------------------------------------------//
		int ret[] = keyBuffer.read(); // mubNI

		synchronized (client_lock) {

			//--------------------------------------------------------------------------//
			out.println(ret.length);
			for (int x : ret) {
				out.println(x);
			}


			//--------------------------------------------------------------------------//
			// IN :
			//--------------------------------------------------------------------------//
			readObject();
			readObject();
		}
		System.out.println("xe");

		return true;
	}


	@Override
	protected void gameend() {
		// {́Aʕ\



		int m;
		try {
			m = in.read();
			if (m == M_GAME_END) {

			} else {
	//			close();	// T[ocloseFāAċN
			}
		} catch (IOException e) {
			e.printStackTrace();
		}



	}



	private boolean readObject() {

		OutData2 data;
		try {
			data = (OutData2)in.readObject();
		} catch (IOException e1) {
			e1.printStackTrace();

			return false;
		} catch (ClassNotFoundException e1) {
			e1.printStackTrace();
			return false;
		}

		switch(data.getNo()) {
		case P_1:
			getMainPanel().getBoardPanel().setField(data.getGameField());
			getMainPanel().getNextPanel().setField(data.getNextNextField());
			getMainPanel().repaint();

			System.out.println("1Pɓ͂");
			break;
		case P_2:
			mainPanel2.getBoardPanel().setField(data.getGameField());
			mainPanel2.getNextPanel().setField(data.getNextNextField());
			mainPanel2.repaint();
			System.out.println("2Pɓ͂");
			break;
		case 0:
			System.out.println("_~[͂");
			break;
		}

		return true;
	}
}
