package com.haru.tetoru.parts;

import static com.haru.tetoru.parts.MINO_PARAM_TABLE.ROTATE_MINO_TYPE.*;

/**
 * MinoNX̃p[^e[u
 *EROTATE_MINO_TYPE : ]Ԃ܂ރ~m̎
 *  ȉ2̓
 *  EMINO_TYPE : ~m̎
 *  EROTATE_STATE : ]̏
 *EROTATE_MINO_INFO : SȊO3_̏]̌ɒ`A3_̏̎擾IF̒
 */
public class MINO_PARAM_TABLE {

	/* ]Ԃ܂ރ~m̎ */
	enum ROTATE_MINO_TYPE {
		/* KʂԍɂĂ */
		ZERO( 0, ROTATE_STATE.r0),   /* TODO:ROTATE_STATE.r0Ŏb` */
		I0(   1, ROTATE_STATE.r0)    /* (1-1)*4 + 1 */
		{
			/* ]̈ړʒu擾 */
			@Override
			Point moveCenterByRotate(int dr) {
				int dx = 0;
				int dy = 0;

				if (ROTATE_MINO_TYPE.DR_RIGHT == dr) {
					dx = 1; /* E */
				} else if (ROTATE_MINO_TYPE.DR_LEFT == dr) {
					dy = -1; /*  */
				}
				return new Point(dx, dy);
			}
		},
		I90(  2, ROTATE_STATE.r90)   /* (1-1)*4 + 2 */
		{
			@Override
			Point moveCenterByRotate(int dr) {
				int dx = 0;
				int dy = 0;

				if (ROTATE_MINO_TYPE.DR_RIGHT == dr) {
					dy = 1; /*  */
				} else if (ROTATE_MINO_TYPE.DR_LEFT == dr) {
					dx = 1; /* E */
				}
				return new Point(dx, dy);
			}
		},
		I180( 3, ROTATE_STATE.r180)  /* (1-1)*4 + 3 */
		{
			@Override
			Point moveCenterByRotate(int dr) {
				int dx = 0;
				int dy = 0;

				if (ROTATE_MINO_TYPE.DR_RIGHT == dr) {
					dx = -1; /*  */
				} else if (ROTATE_MINO_TYPE.DR_LEFT == dr) {
					dy = 1; /*  */
				}
				return new Point(dx, dy);
			}
		},
		I270( 4, ROTATE_STATE.r270)  /* (1-1)*4 + 4 */
		{
			@Override
			Point moveCenterByRotate(int dr) {
				int dx = 0;
				int dy = 0;

				if (ROTATE_MINO_TYPE.DR_RIGHT == dr) {
					dy = -1; /*  */
				} else if (ROTATE_MINO_TYPE.DR_LEFT == dr) {
					dx = -1; /*  */
				}
				return new Point(dx, dy);
			}
		},
		O0(   5, ROTATE_STATE.r0),   /* (2-1)*4 + 1 */
		O90(  6, ROTATE_STATE.r90),  /* (2-1)*4 + 2 */
		O180( 7, ROTATE_STATE.r180), /* (2-1)*4 + 3 */
		O270( 8, ROTATE_STATE.r270), /* (2-1)*4 + 4 */ 
		T0(   9, ROTATE_STATE.r0),   /* (3-1)*4 + 1 */
		T90( 10, ROTATE_STATE.r90),  /* (3-1)*4 + 2 */
		T180(11, ROTATE_STATE.r180), /* (3-1)*4 + 3 */
		T270(12, ROTATE_STATE.r270), /* (3-1)*4 + 4 */
		S0(  13, ROTATE_STATE.r0),
		S90( 14, ROTATE_STATE.r90),
		S180(15, ROTATE_STATE.r180),
		S270(16, ROTATE_STATE.r270),
		Z0(  17, ROTATE_STATE.r0),
		Z90( 18, ROTATE_STATE.r90),
		Z180(19, ROTATE_STATE.r180),
		Z270(20, ROTATE_STATE.r270),
		J0(  21, ROTATE_STATE.r0),
		J90( 22, ROTATE_STATE.r90),
		J180(23, ROTATE_STATE.r180),
		J270(24, ROTATE_STATE.r270),
		L0(  25, ROTATE_STATE.r0),
		L90( 26, ROTATE_STATE.r90),
		L180(27, ROTATE_STATE.r180),
		L270(28, ROTATE_STATE.r270);

		private final int type;
		private final ROTATE_STATE state; /* ](state)͓ł̂ݎgp\ */
									/*  statẽCX^XvɃ\bhǉ */
									/* TODO:ϐstate̕KvČ */

		private ROTATE_MINO_TYPE(int type, ROTATE_STATE state) {
			this.type = type;
			this.state = state;
		}

		/**
		 * 
		 * @return
		 */
		public int getType() {
			return type;
		}

		/**
		 * u~m̎ށv+u]̏ԁvu]Ԃ܂ރ~m̎ށv
		 * @param minoType ~m̎
		 * @param state ]̏
		 * @return ]Ԃ܂ރ~m̎
		 */
		public static ROTATE_MINO_TYPE toRotateMinoType(MINO_TYPE minoType, ROTATE_STATE state) {
			ROTATE_MINO_TYPE rotateMinoType = ROTATE_MINO_TYPE.ZERO;

			/* ʂԍ͋KɊÂZĎ擾 */
			final int NUM = (minoType.get() - 1) * ROTATE_STATE.STATE_NUM + (state.get() + 1); /* state.get()0`4 */

			for (ROTATE_MINO_TYPE x  : ROTATE_MINO_TYPE.values()) {
				if (x.type == NUM) {
					rotateMinoType = x;
					break;
				}
			}
			return rotateMinoType;
		}

		/**
		 * u]Ԃ܂ރ~m̎ށvu~m̎ށv(]̏Ԃ͎̂Ă)
		 * @return ]Ȃu~m̎ށv
		 */
		public MINO_TYPE toMinoType() {
			/* u~m̎ށv̔ԍKɊÂZĎ擾 */
			final int NUM = (int)Math.ceil(this.type / (double)ROTATE_STATE.STATE_NUM);
			return MINO_TYPE.valueOf(NUM);
		}

		/**
		 * ]Ԃς
		 * @param rotateMinoType
		 * @param dr
		 * @return
		 */
		public static ROTATE_MINO_TYPE getRotatedMinoType(ROTATE_MINO_TYPE rotateMinoType, int dr) {
			MINO_TYPE minoType = rotateMinoType.toMinoType();
			ROTATE_STATE state = ROTATE_STATE.getRotatedState(rotateMinoType.state.get(), dr);
			return toRotateMinoType(minoType, state);
		}

		/**
		 * ]Ԃ̈v
		 * TODO:stateOɌJĂȂ߁AROTATE_MINO_TYPENXv菈JĂ
		 * @param target
		 * @return
		 */
		public boolean compareRotateState(ROTATE_STATE target) {
			return (this.state.get()) == (target.get()) ? true : false;
		}

		/* I~m̒S̈ړp */
		/* I~m̓I[o[ChĈړʒu` */
		Point moveCenterByRotate(int dr) {
			Debug.println("moveCenterByRotate() : default implement");
			return new Point();
		};

		static ROTATE_MINO_TYPE valueOf(int rotateMinoType) {
			ROTATE_MINO_TYPE ret = ROTATE_MINO_TYPE.ZERO;
			for (ROTATE_MINO_TYPE t : ROTATE_MINO_TYPE.values()) {
				if (rotateMinoType == t.type) {
					ret = t;
					break;
				}
			}
			return ret;
		}

		/************************************************************/
		/* ~m̎ */
		/************************************************************/
		enum MINO_TYPE {
			_(0),
			I(1),
			O(2),
			T(3),
			S(4),
			Z(5),
			J(6),
			L(7);

			private final int type;

			private MINO_TYPE(int type) {
				this.type = type;
			}

			int get() {
				return type;
			}

			static MINO_TYPE valueOf(int minoType) {
				MINO_TYPE ret = MINO_TYPE._;
				for (MINO_TYPE t : MINO_TYPE.values()) {
					if (minoType == t.type) {
						ret = t;
						break;
					}
				}
				return ret;
			}
		};

		/************************************************************/
		/* ]̏ */
		/************************************************************/
		/* 0`3bvr0,r90,r180,r270ŃANZXł悤ɂ */
		public static final int DR_NO = 0;
		public static final int DR_RIGHT = 1;
		public static final int DR_LEFT = -1;

		enum ROTATE_STATE {
			r0(0),
			r90(1),
			r180(2),
			r270(3);

			static final int STATE_NUM = 4;

			private final int state;

			private ROTATE_STATE(int state) {
				this.state = state;
			}

			private static ROTATE_STATE valueOf(int rotateState) {
				ROTATE_STATE ret = ROTATE_STATE.r0;
				for (ROTATE_STATE s : ROTATE_STATE.values()) {
					if (rotateState == s.state) {
						ret = s;
						break;
					}
				}
				return ret;
			}

			/**
			 * ]Ԃ̎擾(pbP[WJ)
			 * @return
			 */
			int get() {
				return state;
			}

			/**
			 * ]̉]Ԃ擾
			 * @param curentState
			 * @param dr ](DR_RIGHT | DR_LEFT)
			 * @return
			 */
			static ROTATE_STATE getRotatedState(int curentState, int dr) {
				/* Ԃς */
				if (DR_RIGHT == dr) {
					curentState = (curentState + 1) % 4;
				} else {
					curentState = (curentState - 1 + 4) % 4;
				}
				return valueOf(curentState);
			}

		}
		/************************************************************/
	};

	/* 3_e[u(g) */
	/* 3_̏]̌ɒ` */
	enum ROTATE_MINO_INFO {
		NON(  ZERO, new int[][]{{ 0, 0},{ 0, 0},{ 0, 0}}),
		I_0(    I0, new int[][]{{ 1, 0},{-2, 0},{-1, 0}}),
		I_90(  I90, new int[][]{{ 0, 1},{ 0,-2},{ 0,-1}}),
		I_180(I180, new int[][]{{-1, 0},{ 2, 0},{ 1, 0}}),
		I_270(I270, new int[][]{{ 0,-1},{ 0, 2},{ 0, 1}}),
		O_0(    O0, new int[][]{{ 0,-1},{-1,-1},{-1, 0}}),
		O_90(  O90, new int[][]{{ 0,-1},{-1,-1},{-1, 0}}),
		O_180(O180, new int[][]{{ 0,-1},{-1,-1},{-1, 0}}),
		O_270(O270, new int[][]{{ 0,-1},{-1,-1},{-1, 0}}),
		T_0(    T0, new int[][]{{ 0,-1},{ 1, 0},{-1, 0}}),
		T_90(  T90, new int[][]{{ 1, 0},{ 0, 1},{ 0,-1}}),
		T_180(T180, new int[][]{{ 0, 1},{-1, 0},{ 1, 0}}),
		T_270(T270, new int[][]{{-1, 0},{ 0,-1},{ 0, 1}}),
		S_0(    S0, new int[][]{{ 0,-1},{ 1,-1},{-1, 0}}),
		S_90(  S90, new int[][]{{ 1, 0},{ 1, 1},{ 0,-1}}),
		S_180(S180, new int[][]{{ 0, 1},{-1, 1},{ 1, 0}}),
		S_270(S270, new int[][]{{-1, 0},{-1,-1},{ 0, 1}}),
		Z_0(    Z0, new int[][]{{ 0,-1},{ 1, 0},{-1,-1}}),
		Z_90(  Z90, new int[][]{{ 1, 0},{ 0, 1},{ 1,-1}}),
		Z_180(Z180, new int[][]{{ 0, 1},{-1, 0},{ 1, 1}}),
		Z_270(Z270, new int[][]{{-1, 0},{ 0,-1},{-1, 1}}),
		J_0(    J0, new int[][]{{ 1, 0},{-1, 0},{-1,-1}}),
		J_90(  J90, new int[][]{{ 0, 1},{ 0,-1},{ 1,-1}}),
		J_180(J180, new int[][]{{-1, 0},{ 1, 0},{ 1, 1}}),
		J_270(J270, new int[][]{{ 0,-1},{ 0, 1},{-1, 1}}),
		L_0(    L0, new int[][]{{ 1, 0},{-1, 0},{ 1,-1}}),
		L_90(  L90, new int[][]{{ 0, 1},{ 0,-1},{ 1, 1}}),
		L_180(L180, new int[][]{{-1, 0},{ 1, 0},{-1, 1}}),
		L_270(L270, new int[][]{{ 0,-1},{ 0, 1},{-1,-1}});

		private final ROTATE_MINO_TYPE type; /* key */
		private final int pos[][];           /* value */

		private ROTATE_MINO_INFO(ROTATE_MINO_TYPE type, int pos[][]) {
			this.type = type;
			this.pos = pos; /* QƃRs[ */
		}

		/**
		 * 3_̑Έʒu擾
		 * @param paramType ]Ԃ܂ރ~m̎
		 * @return 3_̑Έʒu
		 */
		public static int[][] getPos(ROTATE_MINO_TYPE paramType) {
			ROTATE_MINO_INFO blockType = ROTATE_MINO_INFO.NON;

			for (ROTATE_MINO_INFO i : ROTATE_MINO_INFO.values()) {
				if (paramType == i.type) {
					blockType = i;
					break;
				}
			}
			return blockType.pos;
		}
	};
}