package com.haru.tetoru.parts;

import com.haru.tetoru.parts.MINO_PARAM_TABLE.ROTATE_MINO_INFO;
import com.haru.tetoru.parts.MINO_PARAM_TABLE.ROTATE_MINO_TYPE;
import com.haru.tetoru.parts.MINO_PARAM_TABLE.ROTATE_MINO_TYPE.MINO_TYPE;
import com.haru.tetoru.parts.MINO_PARAM_TABLE.ROTATE_MINO_TYPE.ROTATE_STATE;

/**
@MinoNX̊Ǘ\̂̊Ǘ@ύX
@@ES͉
@@E3_͌Œ4(0,90,180,270)
@@(Œ̂ߕĕێėǂ)
@@E~m̎ނƂ1̌`4
@@
@@E]Ԃ0`3
@(j)
@ʐMprlɂāAMinoNXǗŏƂȂ悤ɂ
*/

public class Mino extends Block implements Cloneable {

	/****************************/
	/* Constant                 */
	/****************************/
	/* ]̌ */
	public static final int R_NO = ROTATE_MINO_TYPE.DR_NO;
	public static final int R_RIGHT = ROTATE_MINO_TYPE.DR_RIGHT;;
	public static final int R_LEFT =  ROTATE_MINO_TYPE.DR_LEFT;

	private static final int MINO_NUM = 4;
	private static final int RELATIVE_MINO_NUM = MINO_NUM - 1; /* ~m - S(1) */

	/****************************/
	/* Member variable          */
	/****************************/
	/* S(x, y) */
	/* eNXBlockɒ`Ă */

	/* ]Ԃ܂ރ~m̎(0`28) */
	private ROTATE_MINO_TYPE rotateMinoType;

	/****************************/
	/* Constructor              */
	/****************************/
	/**
	 * 
	 * @param minoType ~m̎ނ\萔(0`7)
	 * 萔com.haru.tetoru.Mino.ROTATE_MINO_TYPE.MINO_TYPEɒ`Ă
	 * @param x
	 * @param y
	 */
	public Mino(int minoType, int x, int y) {
		this(MINO_TYPE.valueOf(minoType), x, y);
	}
	Mino(int type) {
		this(type, 0, 0);
	}
	Mino(MINO_TYPE minoType, int x, int y) {
		this(ROTATE_MINO_TYPE.toRotateMinoType(minoType, ROTATE_STATE.r0), x, y);
	}

	Mino(ROTATE_MINO_TYPE rotateMinoType, int x, int y) {
		/* ubN̎ނ擾AubN̎ނƒS̐ݒ */
		super(rotateMinoType.toMinoType().get(), x, y);

		/* ]Ԃ܂ރ~m̎(~m̎+]̏)ݒ */
		this.rotateMinoType = rotateMinoType;
	}
	Mino(ROTATE_MINO_TYPE rotateMinoType) {
		this(rotateMinoType, 0, 0);
	}

	/****************************/
	/* Member method            */
	/****************************/
	/**
	 * S̐ݒ
	 * @param x
	 * @param y
	 */
	public void setCenter(int x, int y) {
		setX(x);
		setY(y);
	}

	/**
	 * ~m̎ނ擾
	 * ӁFeNXgetType()Ƃ͒lقȂ(ˑ͎ĂȂ)
	 * TODO:Block#getType()̗p̖ړI𖾊mɂAp@mF
	 *      Block̎ނ́AROTATE_MINO_TYPE.MINO_TYPEƂ͋ʂ
	 *      Block#getType()͕`̐F̋ʗpɂH
	 * @return ]Ԃ܂ރ~m̎(0`28)
	 */
	int getType_Mino() {
		return rotateMinoType.getType();
	}

	ROTATE_MINO_TYPE getRotateMinoType() {
		return rotateMinoType;
	}

	/**
	 * ]Ԃ擾
	 * @return
	 */
//	int getState() {
//		return state;
//	}

	/**
	 * ʒu]
	 * E]ԂXV
	 * EI~ḿASړ
	 * E]~m̐ݒu۔͎{A]{
	 * @param dr
	 * @return ]Ȃ~mAȏ̏ꍇfalse
	 */
	public boolean rotateMinoType(int dr) {
		/* `FbN */
		if (R_RIGHT != dr && R_LEFT != dr) {
			return false;
		}

		/* O~m͉]Ȃ */
		switch(rotateMinoType) {
			case O0:
			case O90:
			case O180:
			case O270:
				return false;
			default:
				break;
		}

		/* ]ԂXV(]Ԃ܂ރ~m̎ނXV) */
		rotateMinoType = ROTATE_MINO_TYPE.getRotatedMinoType(rotateMinoType, dr);

		/* I~m̏ꍇAS̈ړ(S̍lႤ) */
		switch(rotateMinoType) {
			case I0:
			case I90:
			case I180:
			case I270:
				/* ]ɒS̈ړʒu̕ϕ擾 */
				Point diff = rotateMinoType.moveCenterByRotate(dr);
				setCenter(getX() + diff.x, getY() + diff.y);
				break;
			default:
				break;
		}

		return true;
	}

	/**
	 * 3_̑Έʒu̎擾
	 * @return
	 */
	public int[][] getRelativePos() {
		/* e[u3_̈ʒu擾Ă */
		return ROTATE_MINO_INFO.getPos(rotateMinoType);
	}

	/**
	 * 
	 * @param rotateMinoType
	 */
//	void setRotateMinoType(int rotateMinoType) {
//		this.rotateMinoType = ROTATE_MINO_TYPE.valueOf(rotateMinoType);
//	}

	/**
	 * ~m\4̃ubN擾
	 * @return
	 */
	public Block[] getBlocks() {
		Block[] blocks = new Block[RELATIVE_MINO_NUM  + 1];
		int[][] pos = ROTATE_MINO_INFO.getPos(rotateMinoType);

		blocks[0] = new Block(getType(), getX(), getY());

		for (int i = 0; i < RELATIVE_MINO_NUM; i++) {
			int x = getX() + pos[i][0];
			int y = getY() + pos[i][1];
			blocks[1 + i] = new Block(getType(), x, y);
		}

		return blocks;
		
	}

	/* N[̐ */
	/* TODO:AIPlayerŗpĂ邽߁A`cĂ */
	public Mino clone() {
		try {
			Mino cloned = (Mino) super.clone();
//			cloned.rotateMinoType = ROTATE_MINO_TYPE.valueOf(this.rotateMinoType.type);
			/* MinoNXrotateMinoType̓VOg̃CX^XێĂ邽߁A
			 * Lsuper.cloned()̎QƂ̃Rs[݂̂ł悢B
			 * MinoNXɑ΂ĉ]̑sꍇ́ArotateMinoTypeɉ]
			 * CX^X邱Ƃŉ]ƌȂ
			 */
			return cloned;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

	/**************************************************************************/
	/* 																  */
	/**************************************************************************/
	public boolean equals(Mino m) {
		return this.getX() == m.getX()
				&& this.getY() == m.getY()
				&& this.getType() == m.getType()
				&& this.getType_Mino() == m.getType_Mino();
	}
	/**************************************************************************/
	/* nbVl															  */
	/**************************************************************************/
	/* equals()I[o[ChꍇhashCode()I[o[ChKvB*/
	/*uȃIuWFNg͓ȃnbVR[hێKvv */
	public int hashCode() {
		int result = 17;
		result = 31 * result + getType();
		result = 31 * result + getX();
		result = 31 * result + getY();
		result = 31 * result + getType_Mino();
		return result;
	}
	/**************************************************************************/
	/* 																  */
	/**************************************************************************/
	public String toString() {
		return "(" + getX() +"," + getY() + "," + getType() + "," + getType_Mino() + ")";
	}
}
