# AnyKernel3 Ramdisk Mod Script
# osm0sis @ xda-developers

## AnyKernel setup
# begin properties
properties() { '
kernel.string=
do.devicecheck=1
do.modules=0
do.cleanup=1
do.cleanuponabort=0
device.name1=joan
supported.versions=8.0.0, 9
supported.patchlevels=
'; } # end properties

# shell variables
block=/dev/block/bootdevice/by-name/boot;
is_slot_device=0;
ramdisk_compression=auto;


## AnyKernel methods (DO NOT CHANGE)
# import patching functions/variables - see for reference
. tools/ak3-core.sh;


## AnyKernel file attributes
# set permissions/ownership for included ramdisk files
set_perm_recursive 0 0 755 644 $ramdisk/*;
set_perm_recursive 0 0 750 750 $ramdisk/init* $ramdisk/sbin;

android_ver=$(file_getprop /system/build.prop ro.build.version.release);
## AnyKernel install
dump_boot;

# begin ramdisk changes
if [ $android_ver == 8.0.0 ]; then
  if [ -d sbin/rctd ]; then
    ui_print " Removing LG root checker rctd service for Oreo... "
    rm -f sbin/rctd
  else
    ui_print " RCTD deamon is already removed... "
  fi
  if grep "rctd" init.lge.rc; then
    ui_print " Removing rct entries in init.lge.rc... "
    remove_section init.lge.rc "# LG RCT(Rooting Check Tool)" "seclabel u:r:rctd:s0"
  else
    ui_print " RCT entries already removed from init.lge.rc... "
  fi
  if [ -d sbin/rctd ]; then
    ui_print " [!] sbin/rctd Still Exists [!] "
  fi
  if grep "rctd" init.lge.rc; then
    ui_print " [!] RCTD Still Found Inisde init.lge.rc [!] "
  fi        
  if [ ! -d sbin/rctd ] && ! grep "rctd" init.lge.rc; then
    ui_print " RCTD Removed Successfully... "
  else
    ui_print " [!] RCTD Not Removed Successfully [!] "
  fi
fi

if [ $android_ver == 9 ]; then
  ui_print " Removing LG root checker rctd service for Pie from ramdisk... "
  rm -f sbin/rctd
  if [ -d sbin/rctd ]; then
    ui_print " [!] sbin/rctd Still Exists [!] "
  else
    ui_print " RCTD Removed Successfully... "
  fi
fi
# end ramdisk changes

write_boot;
## end install
umount /system
umount /persist-lg

mount -o rw -t auto /system 2>/dev/null
mount -o rw -t auto /persist-lg 2>/dev/null
if [ $android_ver == 9 ]; then
  ui_print " Checking for RCTD... "
  ui_print " Deleting /persist-lg/rct... "
  rm -rf /persist-lg/rct
  ui_print " Removing RCT entries from /system/product/etc/init/init.lge.product.on_post_fs_data.rc... "
  remove_section /system/product/etc/init/init.lge.product.on_post_fs_data.rc "# RCT" "mkdir /mnt/product/persist-lg/rct 0771 root root"
  ui_print " Removing RCT entries from /system/vendor/etc/init/init.lge.product.on_post_fs_data.rc... "
  remove_section /system/vendor/etc/init/init.lge.vendor.on_post_fs_data.rc "#RCT" "mkdir /mnt/vendor/persist-lg/rct 0771 root root"
  ui_print " Removing RCT entries from /system/etc/init/init.lge.system.services.rc... "
  remove_section /system/etc/init/init.lge.system.services.rc "# LG RCT(Rooting Check Tool)" "seclabel u:r:rctd:s0"
  if [ -d /persist-lg/rct ]; then
    ui_print " [!] /persist-lg/rct still exists [!] "
  else
    ui_print " /persist-lg/rct removed successfully... "
  fi
  if grep "rct" /system/product/etc/init/init.lge.product.on_post_fs_data.rc; then
    ui_print " RCT entries still exist in /system/product/etc/init/init.lge.product.on_post_fs_data.rc... "
  else
    ui_print " RCT entries removed from /system/product/etc/init/init.lge.product.on_post_fs_data.rc successfully... "
  fi
  if grep "rct" /system/vendor/etc/init/init.lge.vendor.on_post_fs_data.rc; then  
    ui_print " RCT entries still exist in /system/vendor/etc/init/init.lge.product.on_post_fs_data.rc... "
  else
    ui_print " RCT entries removed from /system/vendor/etc/init/init.lge.product.on_post_fs_data.rc successfully... "
  fi
  if grep "rct" /system/etc/init/init.lge.system.services.rc; then
    ui_print " RCT entries still exist in /system/etc/init/init.lge.system.services.rc... "
  else
    ui_print " RCT entries removed from /system/etc/init/init.lge.system.services.rc... "
  fi
  if [ ! -d /persist-lg/rct ]; then
    if ! grep "rct" /system/product/etc/init/init.lge.product.on_post_fs_data.rc; then
      if ! grep "rct" /system/vendor/etc/init/init.lge.vendor.on_post_fs_data.rc; then
        if ! grep "rct" /system/etc/init/init.lge.system.services.rc; then
          ui_print " RCTD removed successfully... "
        else
          ui_print " [!] RCTD not removed [!] "
        fi
      else
          ui_print " [!] RCTD not removed [!] "
      fi
    else
          ui_print " [!] RCTD not removed [!] "
    fi
  else
          ui_print " [!] RCTD not removed [!] "
  fi
fi
