package pcc.chemicraft.base;

import java.util.ArrayList;
import java.util.HashMap;

import pcc.chemicraft.base.gen.EnumOreSpawnFrequency;
import pcc.chemicraft.base.gen.WorldGenAtomsOre;
import pcc.chemicraft.util.Formula;
import pcc.chemicraft.util.ListHash;

/**
 * ChemiCraftBaseのAPIを提供するクラスです。<br>
 * ChemiCraftBaseを使用したAPIを作成する場合、このクラスを使用します。
 * @author mozipi,ponkotate
 */
public class ChemiCraftBaseAPI {

	/**
	 * APIのインスタンス
	 */
	private static ChemiCraftBaseAPI instance = new ChemiCraftBaseAPI();


	/**
	 * APIのインスタンスを返します。
	 * @return APIのインスタンス
	 */
	public static ChemiCraftBaseAPI instance(){
		return instance;
	}

	/**
	 * 鉱石別元素数リスト
	 */
	private HashMap<String, Formula> atomOresFormulasHash = new HashMap<String, Formula>();


	/**
	 * 鉱石リスト
	 */
	private ArrayList<WorldGenAtomsOre> atomOresList = new ArrayList<WorldGenAtomsOre>();


	/**
	 * 鉱石名リスト
	 */
	private ListHash<String, String> atomOresNameListHash = new ListHash<String, String>();


	/**
	 * 鉱石の英語名リスト
	 */
	private ArrayList<String> atomOresAtomList = new ArrayList<String>();

	/**
	 * 鉱石を追加します。
	 * @param par1Name 鉱石名(Oreは自動で語尾につけられます)
	 * @param par2Formula 化学式
	 * @param par3Id 鉱石のID
	 * @param par4Size 鉱石の塊の大きさ
	 * @param par5Frequency 生成率(frequency/Chunk)
	 * @param par6PosY 鉱石が生成される高度(nowY < PosY == Generate)
	 */
	public void addAtomOres(String par1Name, Formula par2Formula, int par3Id, int par4Size, int par5Frequency, int par6PosY){
		atomOresList.add(
				new WorldGenAtomsOre(
						par3Id,
						getAtomOresMetaOfLastIndex(),
						par4Size,
						par5Frequency,
						par6PosY));

		atomOresAtomList.add(par1Name);
		atomOresFormulasHash.put(par1Name, par2Formula);

		String var7 = par1Name;
		if (!var7.contains(" Ore")) {
			var7 = var7.concat(" Ore");
		}

		addAtomOresLanguage(var7, "en_US");
	}



	/**
	 * 鉱石を追加します。
	 * @param par1Name 鉱石名(Oreは自動で語尾につけられます)
	 * @param par2Formula 化学式
	 * @param par3Id 鉱石のID
	 * @param par4Enum 鉱石生成の情報が入ったEnum
	 */
	public void addAtomOres(String par1Name, Formula par2Formula, int par3Id, EnumOreSpawnFrequency par4Enum){
		addAtomOres(
				par1Name,
				par2Formula,
				par3Id,
				par4Enum.getSize(),
				par4Enum.getFrequency(),
				par4Enum.getPosY()
				);
	}



	/**
	 * 既に登録した鉱石の新しい名前・言語を追加します
	 * @param par1Name 英語名
	 * @param par2NewName 新しい名前
	 * @param par3Language 言語
	 */
	public void addAtomOresLanguage(String par1Name, String par2Language){
		atomOresNameListHash.add(
				par2Language,
				par1Name
				);
	}



	//以下システム関連//////////////////////////////////////////////////////

	public ArrayList<WorldGenAtomsOre> getAtomOres(){
		return atomOresList;
	}

	public HashMap<String, Formula> getAtomOresFormulas(){
		return atomOresFormulasHash;
	}



	public int getAtomOresLastIndex(){
		return atomOresAtomList.size() / 16;
	}



	public int getAtomOresMetaOfLastIndex(){
		return atomOresAtomList.size() - getAtomOresLastIndex() * 16;
	}



	public ListHash<String, String> getAtomOresName(){
		return atomOresNameListHash;
	}



	public ArrayList<String> getAtomOresAtomName() {
		return this.atomOresAtomList;
	}

}
