/*
 * Copyright (C) 2011 Kouichi Machida (k01-dev@live.jp)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.gr.java_conf.k01.android.widgetpack.preference;

import jp.gr.java_conf.k01.android.widgetpack.R;
import jp.gr.java_conf.k01.android.widgetpack.widget.ColorPickerView;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;

/**
 * J[sbJ[p DialogPreference B
 * 
 * @author Kouichi Machida
 */
public class ColorPickerDialogPreference extends DialogPreference {

	/**
	 * ^O\܂B
	 */
	private static final String TAG = "ColorPickerDialogPreference";

	/**
	 * IꂽFێ܂B
	 */
	private int color = Color.WHITE;

	/**
	 * J[sbJ[̑Iێ܂B
	 */
	private ColorModel colorModel;

	/**
	 * J[pbg̒lێ܂B
	 */
	private int[] colorPallets = null;

	/**
	 * Ώۂ̃r[ێ܂B
	 */
	private View view = null;

	/**
	 * ColorPickerDialogPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 */
	public ColorPickerDialogPreference(Context context, AttributeSet attrs) {
		super(context, attrs);

		// LOG:
		Log.v(ColorPickerDialogPreference.TAG, "ColorPickerDialogPreference(Context, AttributeSet)");

		this.init(context, attrs);
	}

	/**
	 * ColorPickerDialogPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 * @param defStyle
	 */
	public ColorPickerDialogPreference(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);

		// LOG:
		Log.v(ColorPickerDialogPreference.TAG, "ColorPickerDialogPreference(Context, AttributeSet, int)");

		this.init(context, attrs);
	}

	/**
	 * F擾܂B
	 * 
	 * @return 擾ꂽF\lB
	 */
	public int getColor() {
		return this.color;
	}

	/**
	 * CX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 */
	private void init(Context context, AttributeSet attrs) {
		// LOG:
		Log.v(TAG, "void init(Context, AttributeSet)");

		// TypedArray ܂B
		TypedArray colorPickerPreference = context.obtainStyledAttributes(attrs, R.styleable.ColorPickerPreference);

		// type ̒l擾܂B
		this.colorModel = ColorModel.values()[colorPickerPreference.getInt(R.styleable.ColorPickerPreference_colorModel, ColorModel.RGB.ordinal())];

		// ColorPickerPreference_colorPallets ̒l擾܂B
		TypedValue colorPickerPreference_colorPallets = new TypedValue();

		if (colorPickerPreference.getValue(R.styleable.ColorPickerPreference_colorPallets, colorPickerPreference_colorPallets)) {
			// colorPallets Ɏw肳ꂽJ[pbg擾܂B
			TypedArray tmp = context.getResources().obtainTypedArray(colorPickerPreference_colorPallets.resourceId);

			this.colorPallets = new int[tmp.length()];

			for (int index = 0; index < tmp.length(); index++) {
				this.colorPallets[index] = tmp.getColor(index, 0);

				// LOG:
				Log.d(TAG, String.format("index = %d, color = %x", index, this.colorPallets[index]));
			}

			tmp.recycle();
		} else {
			this.colorPallets = new int[] {};
		}

		colorPickerPreference.recycle();
	}

	/**
	 * HSV lw̃J[sbJ[Ƃď܂B
	 */
	private void initHSV() {
		// LayoutInflater 擾܂B
		LayoutInflater layoutInflater = (LayoutInflater) this.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		// dialog_preference_color_picker_hsv ̃CAEgŃr[܂B
		this.view = layoutInflater.inflate(R.layout.dialog_preference_color_picker_hsv, null);

		// eBWFbg擾܂B
		ColorPickerView dialog_preference_color_picker_hsv_color_picker = (ColorPickerView) this.view.findViewById(R.id.dialog_preference_color_picker_hsv_color_picker);

		// ColorPickerView ̕\F ImageView ɕ\悤ɂ܂B
		dialog_preference_color_picker_hsv_color_picker.setOnColorChangedListener(new ColorPickerView.OnColorChangedListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see jp.whitewing.android.widget.ColorPickerView.OnColorChangedListener#colorChanged(int)
			 */
			@Override
			public void colorChanged(int color) {
				ColorPickerDialogPreference.this.updateColor(color);
			}

		});
	}

	/**
	 * RGB lw̃J[sbJ[Ƃď܂B
	 */
	private void initRGB() {
		// LayoutInflater 擾܂B
		final LayoutInflater layoutInflater = (LayoutInflater) this.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		// dialog_preference_color_picker_rgb ̃CAEgŃr[܂B
		this.view = layoutInflater.inflate(R.layout.dialog_preference_color_picker_rgb, null);

		GridView dialog_preference_color_picker_rgb_pallets = (GridView) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_pallets);

		dialog_preference_color_picker_rgb_pallets.setAdapter(new BaseAdapter() {

			@Override
			public int getCount() {
				return colorPallets.length;
			}

			@Override
			public Object getItem(int index) {
				return colorPallets[index];
			}

			@Override
			public long getItemId(int position) {
				return position;
			}

			@Override
			public View getView(int position, View convertView, ViewGroup parent) {
				View view = null;

				if (convertView != null) {
					view = convertView;
				} else {
					view = layoutInflater.inflate(R.layout.dialog_preference_color_picker_pallet, null);
				}

				final int color = colorPallets[position];
				View imageView = view.findViewById(R.id.pallet);

				imageView.setBackgroundColor(color);
				imageView.setOnClickListener(new View.OnClickListener() {

					@Override
					public void onClick(View v) {
						ColorPickerDialogPreference.this.updateColor(color);
					}

				});

				return view;
			}

		});

		SeekBar dialog_preference_color_picker_rgb_red_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_red_seekbar);
		SeekBar dialog_preference_color_picker_rgb_green_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_green_seekbar);
		SeekBar dialog_preference_color_picker_rgb_blue_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_blue_seekbar);
		SeekBar dialog_preference_color_picker_rgb_alpha_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_alpha_seekbar);

		dialog_preference_color_picker_rgb_red_seekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onProgressChanged(android.widget.SeekBar, int, boolean)
			 */
			@Override
			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
				int red = progress;
				int green = Color.green(ColorPickerDialogPreference.this.color);
				int blue = Color.blue(ColorPickerDialogPreference.this.color);
				int alpha = Color.alpha(ColorPickerDialogPreference.this.color);

				ColorPickerDialogPreference.this.updateColor(Color.argb(alpha, red, green, blue));
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStartTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStopTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {

			}

		});

		dialog_preference_color_picker_rgb_green_seekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onProgressChanged(android.widget.SeekBar, int, boolean)
			 */
			@Override
			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
				int red = Color.red(ColorPickerDialogPreference.this.color);
				int green = progress;
				int blue = Color.blue(ColorPickerDialogPreference.this.color);
				int alpha = Color.alpha(ColorPickerDialogPreference.this.color);

				ColorPickerDialogPreference.this.updateColor(Color.argb(alpha, red, green, blue));
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStartTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStopTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {

			}

		});

		dialog_preference_color_picker_rgb_blue_seekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onProgressChanged(android.widget.SeekBar, int, boolean)
			 */
			@Override
			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
				int red = Color.red(ColorPickerDialogPreference.this.color);
				int green = Color.green(ColorPickerDialogPreference.this.color);
				int blue = progress;
				int alpha = Color.alpha(ColorPickerDialogPreference.this.color);

				ColorPickerDialogPreference.this.updateColor(Color.argb(alpha, red, green, blue));
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStartTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStopTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {

			}

		});

		dialog_preference_color_picker_rgb_alpha_seekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onProgressChanged(android.widget.SeekBar, int, boolean)
			 */
			@Override
			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
				int red = Color.red(ColorPickerDialogPreference.this.color);
				int green = Color.green(ColorPickerDialogPreference.this.color);
				int blue = Color.blue(ColorPickerDialogPreference.this.color);
				int alpha = progress;

				ColorPickerDialogPreference.this.updateColor(Color.argb(alpha, red, green, blue));
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStartTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStopTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {

			}

		});
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.DialogPreference#onCreateDialogView()
	 */
	@Override
	protected View onCreateDialogView() {
		// LOG:
		Log.v(TAG, "View onCreateDialogView()");

		switch (this.colorModel) {
		case RGB:
			this.initRGB();
			break;
		case HSV:
			this.initHSV();
			break;
		}

		this.updateColor();

		return this.view;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.DialogPreference#onDialogClosed(boolean)
	 */
	@Override
	protected void onDialogClosed(boolean positiveResult) {
		// LOG:
		Log.v(ColorPickerDialogPreference.TAG, "void onDialogClosed(boolean)");

		if (positiveResult) {
			// lۑ܂B
			this.persistInt(this.color);
		}

		super.onDialogClosed(positiveResult);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.Preference#onGetDefaultValue(android.content.res.TypedArray, int)
	 */
	@Override
	protected Object onGetDefaultValue(TypedArray a, int index) {
		// LOG:
		Log.v(ColorPickerDialogPreference.TAG, "Object onGetDefaultValue(TypedArray, int)");

		return a.getInteger(index, Color.BLACK);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.Preference#onSetInitialValue(boolean, java.lang.Object)
	 */
	@Override
	protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
		// LOG:
		Log.v(ColorPickerDialogPreference.TAG, "void onSetInitialValue(boolean, Object)");

		if (restorePersistedValue) {
			this.color = this.getPersistedInt(Color.BLACK);
		} else {
			this.color = (Integer) defaultValue;
		}
	}

	/**
	 * Fݒ肵܂B
	 * 
	 * @param color
	 *            ݒ肷FB
	 */
	public void setColor(int color) {
		// LOG:
		Log.v(TAG, "void setColor(int)");

		this.updateColor(color);
	}

	/**
	 * FXV܂B
	 */
	private void updateColor() {
		// LOG:
		Log.v(TAG, "void updateColor()");

		GradientDrawable round_rectangle = null;

		switch (this.colorModel) {
		case RGB:
			ImageView dialog_preference_color_picker_rgb_preview = (ImageView) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_preview);
			TextView dialog_preference_color_picker_rgb_red_text = (TextView) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_red_text);
			TextView dialog_preference_color_picker_rgb_green_text = (TextView) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_green_text);
			TextView dialog_preference_color_picker_rgb_blue_text = (TextView) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_blue_text);
			TextView dialog_preference_color_picker_rgb_alpha_text = (TextView) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_alpha_text);
			SeekBar dialog_preference_color_picker_rgb_red_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_red_seekbar);
			SeekBar dialog_preference_color_picker_rgb_green_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_green_seekbar);
			SeekBar dialog_preference_color_picker_rgb_blue_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_blue_seekbar);
			SeekBar dialog_preference_color_picker_rgb_alpha_seekbar = (SeekBar) this.view.findViewById(R.id.dialog_preference_color_picker_rgb_alpha_seekbar);

			round_rectangle = (GradientDrawable) this.getContext().getResources().getDrawable(R.drawable.round_rectangle);
			round_rectangle.setColor(this.color);

			dialog_preference_color_picker_rgb_preview.setBackgroundDrawable(round_rectangle);
			dialog_preference_color_picker_rgb_red_text.setText(String.valueOf(Color.red(this.color)));
			dialog_preference_color_picker_rgb_red_seekbar.setProgress(Color.red(this.color));
			dialog_preference_color_picker_rgb_green_text.setText(String.valueOf(Color.green(this.color)));
			dialog_preference_color_picker_rgb_green_seekbar.setProgress(Color.green(this.color));
			dialog_preference_color_picker_rgb_blue_text.setText(String.valueOf(Color.blue(this.color)));
			dialog_preference_color_picker_rgb_blue_seekbar.setProgress(Color.blue(this.color));
			dialog_preference_color_picker_rgb_alpha_text.setText(String.valueOf(Color.alpha(this.color)));
			dialog_preference_color_picker_rgb_alpha_seekbar.setProgress(Color.alpha(this.color));

			break;
		case HSV:
			ImageView dialog_preference_color_picker_hsv_preview = (ImageView) this.view.findViewById(R.id.dialog_preference_color_picker_hsv_preview);
			ColorPickerView dialog_preference_color_picker_hsv_color_picker = (ColorPickerView) this.view.findViewById(R.id.dialog_preference_color_picker_hsv_color_picker);

			round_rectangle = (GradientDrawable) this.getContext().getResources().getDrawable(R.drawable.round_rectangle);
			round_rectangle.setColor(this.color);

			dialog_preference_color_picker_hsv_preview.setBackgroundDrawable(round_rectangle);
			dialog_preference_color_picker_hsv_color_picker.setColor(this.color);

			break;
		}
	}

	/**
	 * FXV܂B
	 * 
	 * @param color
	 *            XVFB
	 */
	private void updateColor(int color) {
		// LOG:
		Log.v(TAG, "void updateColor(int)");

		if (this.color != color) {
			this.color = color;

			this.updateColor();
		}
	}

}
