/*
 * Copyright (C) 2011 Kouichi Machida (k01-dev@live.jp)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.gr.java_conf.k01.android.widgetpack.preference;

import jp.gr.java_conf.k01.android.widgetpack.R;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.preference.Preference;
import android.util.AttributeSet;
import android.util.Log;

/**
 * ^bvƃANeBreBN Preference B
 * 
 * @author Kouichi Machida
 */
public class LaunchActivityPreference extends Preference {

	/**
	 * ANeBreBێ܂B
	 */
	private String activityName;

	/**
	 * LaunchActivityPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 */
	public LaunchActivityPreference(Context context) {
		super(context);
	}

	/**
	 * LaunchActivityPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 */
	public LaunchActivityPreference(Context context, AttributeSet attrs) {
		super(context, attrs);

		this.init(context, attrs);
	}

	/**
	 * LaunchActivityPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 * @param defStyle
	 */
	public LaunchActivityPreference(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);

		this.init(context, attrs);
	}

	/**
	 * CX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 */
	private void init(Context context, AttributeSet attrs) {
		// TypedArray ܂B
		TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LaunchActivityPreference);

		this.activityName = typedArray.getString(R.styleable.LaunchActivityPreference_activityName);

		typedArray.recycle();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.Preference#onClick()
	 */
	@Override
	protected void onClick() {
		super.onClick();

		try {
			// NX擾܂B
			Class<?> clazz = Class.forName(this.activityName);

			// Intent ܂B
			Intent intent = new Intent(this.getContext(), clazz);

			// ANeBreBJn܂B
			this.getContext().startActivity(intent);
		} catch (ClassNotFoundException e) {
			// LOG:
			Log.e("LaunchActivityPreference", e.getMessage());
		}
	}

}
