/*
MachiKania SD card bootloader for PIC32MX150F128B with Color Text Video out system.
Rev.3
 vOtbVTCYFAŏIAhXŔf
 PIC32MX170F256BɂΉ

CS:RA0
CD:Not Connected (always 0)
WE:Not Connected (always 0)
DO:RPA4(SDI2)
DI:RPB5(SDO2)
SCLK:RB15(SCK2)
*/

#include <plib.h>
#include "FSIO.h"
#include "NVMem.h"
#include "sd_bootloader.h"
#include "Bootloader170f.h"
#include <string.h>
#include "HardwareProfile.h"

#include "colortext32.h"

//OtNX^ with PLL (16{)
#pragma config PMDL1WAY = OFF, IOL1WAY = OFF
#pragma config FPLLIDIV = DIV_1, FPLLMUL = MUL_16, FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL, FSOSCEN = OFF, POSCMOD = XT, OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1, FWDTEN = OFF, JTAGEN = OFF, ICESEL = ICS_PGx1

// ̓{^̃|[gArbg`
#define KEYPORT PORTB
#define KEYUP 0x0400
#define KEYDOWN 0x0080
#define KEYLEFT 0x0100
#define KEYRIGHT 0x0200
#define KEYSTART 0x0800
#define KEYFIRE 0x4000

#define MAXFILENUM 75

/******************************************************************************
Macros used in this file
*******************************************************************************/
#define DEV_CONFIG_REG_BASE_ADDRESS 0x9FC02FF0
#define DEV_CONFIG_REG_END_ADDRESS   0x9FC02FFF
#define FILENAME_FLASH_ADDRESS 0x9D005800

// PIC32MX1xx/2xx̃tbṼy[W1KBP
#define FLASH_PAGE_SIZE 0x400
#define FILENAME_AREA_SIZE 0x400

/******************************************************************************
Global Variables
*******************************************************************************/
FSFILE * myFile;
BYTE myData[512];
size_t numBytes;
UINT pointer = 0;
UINT readBytes;

UINT8 asciiBuffer[1024];
UINT8 asciiRec[200];
UINT8 hexRec[100];
UINT8 filenames[MAXFILENUM][13];
T_REC record;
SearchRec sr;

UINT16 oldkey=0;
UINT8 workram[FILENAME_AREA_SIZE] __attribute__ ((aligned (4)));

void *app_flash_end_address;
unsigned char *cursor;
unsigned char cursorcolor;

/****************************************************************************
Function prototypes
*****************************************************************************/
void JumpToApp(void);
BOOL ValidAppPresent(void);
BOOL loadApp(UINT8 *imagefile);

UINT16 keycheck(void){
	//{^ԓǂݍ
	//ĂΊe{^ɊYbit1ɂ
	//x{^𗣂ȂƁAƂɂ͂ȂȂ
	UINT16 k1,k2;
	k1=~KEYPORT & (KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT);
	k2=k1 & ~oldkey;
	oldkey=k1;
	return k2;
}
void setcursor(unsigned char x,unsigned char y,unsigned char c){
	//J[\W(x,y)ɃJ[ԍcɐݒ
	cursor=TVRAM+y*WIDTH_X+x;
	cursorcolor=c;
}
void setcursorcolor(unsigned char c){
	//J[\ʒû܂܂ŃJ[ԍcɐݒ
	cursorcolor=c;
}
void printchar(unsigned char n){
	//J[\ʒuɃeLXgR[hn1\AJ[\1i߂
	if(n=='\n'){
		//s
		cursor+=WIDTH_X-((cursor-TVRAM)%WIDTH_X);
		return;
	}
	// 0x20`0x7f̂ݗLBtHgf[^0x00`0x5fƂĕۗL
	if(n<0x20 || n>=0x80) n='?'-0x20;
	else n-=0x20;
	*cursor=n;
	*(cursor+ATTROFFSET)=cursorcolor;
	cursor++;
}
void printstr(unsigned char *s){
	//J[\ʒuɕs\
	while(*s){
		printchar(*s++);
	}
}
void waitanykey(void){
	//ǂꂩ̃{^܂ő҂
	printstr("Push Any Button\n");
	while(keycheck()==0) ;
}
void writefilenameflash(UINT8 *s){
	//t@C̈Ƀt@C
	UINT d;
	UINT *sp,*dp;
	UINT8 *p;

	//t@C̈RAMɑޔ
	sp=(UINT *)(FILENAME_FLASH_ADDRESS+16);
	dp=(UINT *)(workram+16);
	while(sp<(UINT *)(FILENAME_FLASH_ADDRESS+FILENAME_AREA_SIZE)) *dp++=*sp++;

	//ޔ̈擪Ƀt@CRs[
	p=workram;
	while(*s!=0) *p++=*s++;
	while(p<workram+16) *p++=0;

	//tbṼy[W
	//t@C̈TCYƃy[WTCŶ͓1y[Ŵݏ
	NVMemErasePage((void *)FILENAME_FLASH_ADDRESS);

	//tbV
	sp=(UINT *)workram;
	dp=(UINT *)FILENAME_FLASH_ADDRESS;
	while(dp<(UINT *)(FILENAME_FLASH_ADDRESS+FILENAME_AREA_SIZE)){
		d=*sp++;
		NVMemWriteWord(dp,d); //32bittbV
		dp++;
	}
}

int main(void)
{
	int filenum,i;
	UINT8 *p1,*p2;
	UINT16 k;
	unsigned char x,y;
        
	/* |[g̏ݒ */
	TRISA = 0x0010; // RA4
	TRISB = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// {^ڑ|[g͐ݒ
	ODCB = 0x0300;	//RB8,RB9̓I[vhC
	ANSELA = 0x0000; // SăfW^
	ANSELB = 0x0000; // SăfW^
	CNPUASET=0x0010;//RA4vAbv
	CNPUBSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// vAbvݒ
	LATACLR=2;//RA1Iti{^[hj

	for(i=0;i<100;i++) asm volatile("nop"); // {^ڑ|[g̃vAbvLɂȂ̂҂
	if(keycheck()==0) JumpToApp(); // {^ĂȂ΁Â܂܃AvɃWv

    // Ӌ@\s蓖
	SDI2R=2; //RPA4:SDI2
	RPB5R=4; //RPB5:SDO2

	if(BMXPFMSZ<0x40000) app_flash_end_address=(void *)(PROGRAM_FLASH_START_ADRESS+BMXPFMSZ-1); //Program Flash̍ŏIAhX
	else app_flash_end_address=(void *)(PROGRAM_FLASH_START_ADRESS+0x40000-1); //`bṽoOΉ
	init_composite(); // rfINAA荞ݏAJ[rfIo͊Jn

	while(1){
		clearscreen();//ʏ
		setcursor(0,0,7);
		printstr("Init File System...");
		// Initialize the File System
	   	if(!FSInit())
	   	{
		   	//G[̏ꍇ
		   	setcursorcolor(4);
		   	printstr("Error\n");
			printstr("Insert Correct Card and\n");
			waitanykey();
			continue;
		}
		printstr("OK\n");

	   	//HEXt@C̈ꗗSDJ[hǂݏo
	   	filenum=0;
		if(FindFirst("*.hex",ATTR_MASK,&sr)){
			setcursorcolor(4);
			printstr("No HEX File Found\n");
			printstr("Insert Correct Card and\n");
			waitanykey();
			continue;
		}
		do{
			//filenames[]HEXt@C̈ꗗǂݍ
			p1=sr.filename;
			p2=filenames[filenum];
			while(*p1!=0) *p2++=*p1++;
			*p2=0;
			filenum++;
		}
		while(!FindNext(&sr) && filenum<MAXFILENUM);
		
		//HEXt@Cꗗʂɕ\
		clearscreen();
		setcursor(0,0,4);
		printstr("MachiKania Boot:Mov");
		setcursorcolor(5);
		printchar('>');
		setcursorcolor(4);
		if(BMXPFMSZ>=0x40000) printchar('-');
		else if(BMXPFMSZ>=0x20000) printchar('/');
		else printchar('+');
		printstr("Push FIRE");
		if(ValidAppPresent()){
			setcursorcolor(6);
			printstr(" Not Load & Jump to [");
			//݃tbVɏ܂ĂAv\
			p1=(UINT8 *)FILENAME_FLASH_ADDRESS;
			while(*p1!='.') printchar(*p1++);
			printchar(']');
		}
		for(i=0;i<filenum;i++){
			//t@Cꗗ̕\i".HEX"͏ȗj
			x=(i%3)*10+1;
			y=i/3+2;
			setcursor(x,y,7);
			p1=filenames[i];
			while(*p1!='.') printchar(*p1++);
		}

		//HEXt@C̑I
		if(ValidAppPresent()){
			i=-1;
			setcursor(0,1,5);
		}
		else{
			i=0;
			setcursor(0,2,5);
		}
		printchar('>');
		cursor--;
		while(1){
			drawcount=0;
			while(drawcount==0) asm("wait"); //601bEFCg
			k=keycheck();
			if(k &(KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT)){
				printchar(' ');
				switch(k){
					case KEYUP:
						if(i>=3) i-=3;
						else if(ValidAppPresent()) i=-1;
						break;
					case KEYDOWN:
						if(i==-1) i=0;
						else if(i+3<filenum) i+=3;
						break;
					case KEYLEFT:
						if(i>0) i--;
						break;
					case KEYRIGHT:
						if(i+1<filenum) i++;
				}
				if(i>=0) setcursor((i%3)*10,i/3+2,5);
				else setcursor(0,1,5);
				printchar('>');
				cursor--;
			}
			else if(k==KEYFIRE) break;
		}
		clearscreen();
		setcursor(0,0,4);
		if(i>=0){
			stop_composite();//[h͕\~
			if(loadApp(filenames[i])==FALSE){
				//[hɉ炩̃G[
				printstr("Load Error\n");
				start_composite();//\ĊJ
				waitanykey();
				continue;
			}
			//t@CL^̈HEXt@C
			writefilenameflash(filenames[i]);
		}
		JumpToApp();//[U[AvɃWvBAv݂Ȃꍇ̂ݖ߂Ă
		printstr("Application Not Found\n");
		start_composite();//\ĊJ
		waitanykey();
	}
}
BOOL loadApp(UINT8 *imagefile){
	int i,result;
	myFile = FSfopen(imagefile,"r");
	if(myFile == NULL)// Make sure the file is present.
	{
		return FALSE;
	}

	// Erase Flash (Block Erase the program Flash)
	EraseFlash();
	// Initialize the state-machine to read the records.
	record.status = REC_NOT_FOUND;
	while(1){
		// For a faster read, read 512 bytes at a time and buffer it.
		readBytes = FSfread((void *)&asciiBuffer[pointer],1,512,myFile);
		if(readBytes == 0){
			// Nothing to read. Come out of this loop
			// Something fishy. The hex file has ended abruptly, looks like there was no "end of hex record".
			FSfclose(myFile);
			EraseFlash();//r܂ŏ񂾉\̂ŏ
			return FALSE;
		}
		for(i = 0; i < (readBytes + pointer); i ++){
			// This state machine seperates-out the valid hex records from the read 512 bytes.
			switch(record.status){
				case REC_FLASHED:
				case REC_NOT_FOUND:
					if(asciiBuffer[i] == ':'){
						// We have a record found in the 512 bytes of data in the buffer.
						record.start = &asciiBuffer[i];
						record.len = 0;
						record.status = REC_FOUND_BUT_NOT_FLASHED;
					}
					break;
				case REC_FOUND_BUT_NOT_FLASHED:
					if((asciiBuffer[i] == 0x0A) || (asciiBuffer[i] == 0xFF)){
						// We have got a complete record. (0x0A is new line feed and 0xFF is End of file)
						// Start the hex conversion from element
						// 1. This will discard the ':' which is
						// the start of the hex record.
						ConvertAsciiToHex(&record.start[1],hexRec);
						result=WriteHexRecord2Flash(hexRec);
						if(result==WRITEHEXEND){
							FSfclose(myFile);
							return TRUE;//[h
						}
						else if(result==WRITEHEXERROR){
							FSfclose(myFile);
							EraseFlash();//r܂ŏ񂾉\̂ŏ
							return FALSE;//G[I
						}
						record.status = REC_FLASHED;
					}
					break;
			}
			// Move to next byte in the buffer.
			record.len ++;
		}

		if(record.status == REC_FOUND_BUT_NOT_FLASHED){
			// We still have a half read record in the buffer. The next half part of the record is read 
			// when we read 512 bytes of data from the next file read. 
			memcpy(asciiBuffer, record.start, record.len);
			pointer = record.len;
			record.status = REC_NOT_FOUND;
		}
		else{
			pointer = 0;
		}
	}
}

/********************************************************************
* Function: 	JumpToApp()
*
* Precondition: 
*
* Input: 		None.
*
* Output:		
*
* Side Effects:	No return from here.
*
* Overview: 	Jumps to application.
*
*			
* Note:		 	None.
********************************************************************/
void JumpToApp(void)
{	
	void (*fptr)(void);
	if(!ValidAppPresent()) return;
	stop_composite();//ʏo͒~
	while((~KEYPORT & KEYFIRE)) ; //FIRE{^𗣂܂ő҂
	fptr = (void (*)(void))USER_APP_RESET_ADDRESS;
	fptr();
}



/********************************************************************
* Function: 	ConvertAsciiToHex()
*
* Precondition: 
*
* Input: 		Ascii buffer and hex buffer.
*
* Output:		
*
* Side Effects:	No return from here.
*
* Overview: 	Converts ASCII to Hex.
*
*			
* Note:		 	None.
********************************************************************/
void ConvertAsciiToHex(UINT8* asciiRec, UINT8* hexRec)
{
	UINT8 i = 0;
	UINT8 k = 0;
	UINT8 hex;
	
	
	while((asciiRec[i] >= 0x30) && (asciiRec[i] <= 0x66))
	{
		// Check if the ascci values are in alpha numeric range.
		
		if(asciiRec[i] < 0x3A)
		{
			// Numerical reperesentation in ASCII found.
			hex = asciiRec[i] & 0x0F;
		}
		else
		{
			// Alphabetical value.
			hex = 0x09 + (asciiRec[i] & 0x0F);						
		}
	
		// Following logic converts 2 bytes of ASCII to 1 byte of hex.
		k = i%2;
		
		if(k)
		{
			hexRec[i/2] |= hex;
			
		}
		else
		{
			hexRec[i/2] = (hex << 4) & 0xF0;
		}	
		i++;		
	}		
	
}
/********************************************************************
* Function: 	EraseFlash()
*
* Precondition: 
*
* Input: 		None.
*
* Output:		
*
* Side Effects:	No return from here.
*
* Overview: 	Erases Flash (Block Erase).
*
*			
* Note:		 	None.
********************************************************************/
void EraseFlash(void)
{
	void * pFlash;
    UINT result;
    INT i;

    pFlash = (void*)APP_FLASH_BASE_ADDRESS;									
    for( i = 0; i < (((UINT)app_flash_end_address - APP_FLASH_BASE_ADDRESS + 1)/FLASH_PAGE_SIZE); i++ )
    {
	     result = NVMemErasePage( pFlash + (i*FLASH_PAGE_SIZE) );
        // Assert on NV error. This must be caught during debug phase.

        if(result != 0)
        {
           // We have a problem. This must be caught during the debug phase.
           printstr("Flash Erase Error");
           start_composite();
           while(1) asm("wait");
        }
    }		           	     
}

int WriteHexRecord2Flash(UINT8* HexRecord)
{
/*
	HEXR[h1stbVɏ
	߂l
		WRITEHEXNOTEND:IAŏIsł͂Ȃ
		WRITEHEXEND:IAŏIs
		WRITEHEXERROR:G[
*/
	static T_HEX_RECORD HexRecordSt;
	UINT8 Checksum = 0;
	UINT8 i;
	UINT WrData;
	UINT RdData;
	void* ProgAddress;
	UINT result;
		
	HexRecordSt.RecDataLen = HexRecord[0];
	HexRecordSt.RecType = HexRecord[3];	
	HexRecordSt.Data = &HexRecord[4];	
	
	// Hex Record checksum check.
	for(i = 0; i < HexRecordSt.RecDataLen + 5; i++)
	{
		Checksum += HexRecord[i];
	}	
	
    if(Checksum != 0)
    {
	    //Error. Hex record Checksum mismatch.
	    printstr("Checksum Error\n");
	    return WRITEHEXERROR;
	} 
	else
	{
		// Hex record checksum OK.
		switch(HexRecordSt.RecType)
		{
			case DATA_RECORD:  //Record Type 00, data record.
				HexRecordSt.Address.byte.MB = 0;
				HexRecordSt.Address.byte.UB = 0;
				HexRecordSt.Address.byte.HB = HexRecord[1];
				HexRecordSt.Address.byte.LB = HexRecord[2];
				
				// Derive the address.
				HexRecordSt.Address.Val = HexRecordSt.Address.Val + HexRecordSt.ExtLinAddress.Val + HexRecordSt.ExtSegAddress.Val;
						
				while(HexRecordSt.RecDataLen) // Loop till all bytes are done.
				{
										
					// Convert the Physical address to Virtual address. 
					ProgAddress = (void *)PA_TO_KVA0(HexRecordSt.Address.Val);
					
					// Make sure we are not writing boot area and device configuration bits.
					if(((ProgAddress >= (void *)APP_FLASH_BASE_ADDRESS) && (ProgAddress <= app_flash_end_address))
					   && ((ProgAddress < (void*)DEV_CONFIG_REG_BASE_ADDRESS) || (ProgAddress > (void*)DEV_CONFIG_REG_END_ADDRESS)))
					{
						if(HexRecordSt.RecDataLen < 4)
						{
							
							// Sometimes record data length will not be in multiples of 4. Appending 0xFF will make sure that..
							// we don't write junk data in such cases.
							WrData = 0xFFFFFFFF;
							memcpy(&WrData, HexRecordSt.Data, HexRecordSt.RecDataLen);	
						}
						else
						{	
							memcpy(&WrData, HexRecordSt.Data, 4);
						}		
						// Write the data into flash.	
						result = NVMemWriteWord(ProgAddress, WrData);	
						// Assert on error. This must be caught during debug phase.		
						if(result != 0)
						{
							printstr("Write Error");
							start_composite();
   							while(1) asm("wait");
   						}									
					}	
					
					// Increment the address.
					HexRecordSt.Address.Val += 4;
					// Increment the data pointer.
					HexRecordSt.Data += 4;
					// Decrement data len.
					if(HexRecordSt.RecDataLen > 3)
					{
						HexRecordSt.RecDataLen -= 4;
					}	
					else
					{
						HexRecordSt.RecDataLen = 0;
					}	
				}
				break;
			
			case EXT_SEG_ADRS_RECORD:  // Record Type 02, defines 4th to 19th bits of the data address.
			    HexRecordSt.ExtSegAddress.byte.MB = 0;
				HexRecordSt.ExtSegAddress.byte.UB = HexRecordSt.Data[0];
				HexRecordSt.ExtSegAddress.byte.HB = HexRecordSt.Data[1];
				HexRecordSt.ExtSegAddress.byte.LB = 0;
				// Reset linear address.
				HexRecordSt.ExtLinAddress.Val = 0;
				break;
				
			case EXT_LIN_ADRS_RECORD:   // Record Type 04, defines 16th to 31st bits of the data address. 
				HexRecordSt.ExtLinAddress.byte.MB = HexRecordSt.Data[0];
				HexRecordSt.ExtLinAddress.byte.UB = HexRecordSt.Data[1];
				HexRecordSt.ExtLinAddress.byte.HB = 0;
				HexRecordSt.ExtLinAddress.byte.LB = 0;
				// Reset segment address.
				HexRecordSt.ExtSegAddress.Val = 0;
				break;
				
			case END_OF_FILE_RECORD:  //Record Type 01, defines the end of file record.
				HexRecordSt.ExtSegAddress.Val = 0;
				HexRecordSt.ExtLinAddress.Val = 0;
				// Disable any interrupts here before jumping to the application.
				return WRITEHEXEND; //ŏIs
				// JumpToApp();
				break;

			default: 
				HexRecordSt.ExtSegAddress.Val = 0;
				HexRecordSt.ExtLinAddress.Val = 0;
				break;
		}
	}
	return WRITEHEXNOTEND; //ŏIsł͂Ȃ
}


/********************************************************************
* Function: 	ValidAppPresent()
*
* Precondition: 
*
* Input: 		None.
*
* Output:		TRUE: If application is valid.
*
* Side Effects:	None.
*
* Overview: 	Logic: Check application vector has 
				some value other than "0xFFFFFF"
*
*			
* Note:		 	None.
********************************************************************/
BOOL ValidAppPresent(void)
{
	volatile UINT32 *AppPtr;
	
	AppPtr = (UINT32*)USER_APP_RESET_ADDRESS;

	if(*AppPtr == 0xFFFFFFFF)
	{
		return FALSE;
	}
	else
	{
		return TRUE;
	}
}			

/*********************End of File************************************/
