// PS/2L[{[hǂݍ݃vO for PIC32MX by K.Tanaka@Rev1.5@2017.5.6
//  Rev 1.2 104pL[{[hT|[gAPause/BreakL[T|[g
//  Rev 1.3 ɓ{/pL[{[hށALockL[ԎwɑΉ
//  Rev 1.4 R}h^CAEg
//  Rev 1.5 f[^MDMApAPIC32MX370Fł̃|[gύX
//
// PIC32MX1xx/2xx  DAT:RB8ACLK:RB9
// PIC32MX370F512H DAT:RF0ACLK:RF1
//

#include "ps2keyboard.h"
#include <plib.h>

// PIC32MX1xx/2xxŗpꍇ́Aȉ̍sRgAEg
#define PIC32MX370F

#ifdef PIC32MX370F
#define PS2PORT PORTF
#define PS2DATBIT  0x01 // RF0
#define PS2CLKBIT  0x02 // RF1
#define PORTPS2DAT PORTFbits.RF0
#define PORTPS2CLK PORTFbits.RF1
#define mPS2DATSET() (LATFSET=PS2DATBIT)
#define mPS2DATCLR() (LATFCLR=PS2DATBIT)
#define mPS2CLKSET()  (LATFSET=PS2CLKBIT)
#define mPS2CLKCLR()  (LATFCLR=PS2CLKBIT)
#define mTRISPS2DATIN()  (TRISFSET=PS2DATBIT)
#define mTRISPS2DATOUT() (TRISFCLR=PS2DATBIT)
#define mTRISPS2CLKIN()  (TRISFSET=PS2CLKBIT)
#define mTRISPS2CLKOUT() (TRISFCLR=PS2CLKBIT)
#define mPS2CLKIntEnable(ie) (mCNFIntEnable(ie))
#define TIMER5_100us 597

#else
#define PS2PORT PORTB
#define PS2DATBIT  0x100 // RB8
#define PS2CLKBIT  0x200 // RB9
#define PORTPS2DAT PORTBbits.RB8
#define PORTPS2CLK PORTBbits.RB9
#define mPS2DATSET() (LATBSET=PS2DATBIT)
#define mPS2DATCLR() (LATBCLR=PS2DATBIT)
#define mPS2CLKSET()  (LATBSET=PS2CLKBIT)
#define mPS2CLKCLR()  (LATBCLR=PS2CLKBIT)
#define mTRISPS2DATIN()  (TRISBSET=PS2DATBIT)
#define mTRISPS2DATOUT() (TRISBCLR=PS2DATBIT)
#define mTRISPS2CLKIN()  (TRISBSET=PS2CLKBIT)
#define mTRISPS2CLKOUT() (TRISBCLR=PS2CLKBIT)
#define mPS2CLKIntEnable(ie) (mCNBIntEnable(ie))
#define TIMER5_100us 358

#endif

#define SCANCODEBUFSIZE 16 //XLR[hobt@̃TCY
#define KEYCODEBUFSIZE 16 //L[R[hobt@̃TCY

// MG[R[h
#define PS2ERROR_PARITY 1
#define PS2ERROR_STARTBIT 2
#define PS2ERROR_STOPBIT 3
#define PS2ERROR_BUFFERFUL 4
#define PS2ERROR_TIMEOUT 5
#define PS2ERROR_TOOMANYRESENDREQ 6
#define PS2ERROR_NOACK 7
#define PS2ERROR_NOBAT 8

//R}hM󋵂\ps2status̒l
#define PS2STATUS_SENDSTART 1
#define PS2STATUS_WAIT100us 2
#define PS2STATUS_SENDING 3
#define PS2STATUS_WAITACK 4
#define PS2STATUS_WAITBAT 5
#define PS2STATUS_INIT 6

#define PS2TIME_CLKDOWN 2     //R}hMCLKLɂ鎞ԁA200us(PS2STATUS_WAIT100us̎)
#define PS2TIME_PRESEND 2     //R}hMȎ҂ԁA200us
#define PS2TIME_CMDTIMEOUT 110 //R}hM^CAEgԁA11ms
#define PS2TIME_ACKTIMEOUT 50 //ACK^CAEgԁA5000us
#define PS2TIME_BATTIMEOUT 5000 //BAT^CAEgԁA500ms
#define PS2TIME_INIT 5000    //dI̋NԁA500ms
#define PS2TIME_RECEIVETIMEOUT 20 //f[^M^CAEgԁA2000us

// PS/2R}h
#define PS2CMD_RESET 0xff //L[{[hZbg
#define PS2CMD_SETLED 0xed //bNLEDݒ
#define PS2CMD_RESEND 0xfe //đv
#define PS2CMD_ACK 0xfa //ACK
#define PS2CMD_BAT 0xaa //eXgI
#define PS2CMD_ECHO 0xee //GR[
#define PS2CMD_OVERRUN 0x00 //obt@I[o[
#define PS2CMD_BREAK 0xf0 //uCNvtBbNX

#define PS2DMABUFSIZE 16 // DMAobt@TCY
#define mPS2DMAEnable() (DCH3CONSET=0x80) // DMAL
#define mPS2DMADisable() (DCH3CONCLR=0x80) // DMA

// O[oϐ`
volatile unsigned char keyboard_rcvdata[PS2DMABUFSIZE];//DMAMpobt@
volatile unsigned int dma_readpt;//DMAMobt@̓ǂݍݍς݂̈ʒu

unsigned int ps2sendcomdata;//MR}hobt@iő4oCgAʂ珇Ɂj
unsigned char ps2sendcombyte;//MR}h̖MoCg
unsigned char volatile ps2status;//MAM̃tF[Y
unsigned int volatile ps2statuscount;//ps2status̃JE^[BTimer5荞݂ƂɃJEg_E
unsigned int volatile ps2receivetime;//M̃^C}[
unsigned char receivecount;//MrbgJE^
unsigned char receivedata;//Mf[^
unsigned char sendcount;//MrbgJE^
unsigned short senddata;//Mf[^
unsigned char volatile ps2sending; //PICKBɑM
unsigned char volatile ps2receiveError; //ǂݍݎG[
unsigned char volatile ps2sendError; //R}hMG[
unsigned char volatile ps2receivecommand;//MR}h
unsigned char volatile ps2receivecommandflag;//R}hM
unsigned short volatile ps2shiftkey_a; //VtgARg[L[̏ԁiEL[ʁj
unsigned char volatile ps2shiftkey; //VtgARg[L[̏ԁiEL[ʂȂj

unsigned char scancodebuf[SCANCODEBUFSIZE]; //XLR[hobt@
unsigned char * volatile scancodebufp1; //XLR[hݐ擪|C^
unsigned char * volatile scancodebufp2; //XLR[hǂݏo擪|C^
unsigned short keycodebuf[KEYCODEBUFSIZE]; //L[R[hobt@
unsigned short * volatile keycodebufp1; //L[R[hݐ擪|C^
unsigned short * volatile keycodebufp2; //L[R[hǂݏo擪|C^

//Jϐ
unsigned volatile char ps2keystatus[256]; // zR[hɑL[̏ԁiOn̎1j
unsigned volatile short vkey; // ps2readkey()֐ŃZbgL[R[hA8rbg̓Vtg֘AL[
unsigned char lockkey; // LockL[̏ԎwB3rbg<CAPSLK><NUMLK><SCRLK>
unsigned char keytype; // L[{[h̎ށB0F{109L[A1Fp104L[

// {109keyz
const unsigned char ps2scan2vktable1_jp[]={
	// PS/2XLR[h牼zL[R[hւ̕ϊe[u
	// 0x00-0x83܂
	0,VK_F9,0,VK_F5,VK_F3,VK_F1,VK_F2,VK_F12,0,VK_F10,VK_F8,VK_F6,VK_F4,VK_TAB,VK_KANJI,0,
	0,VK_LMENU,VK_LSHIFT,VK_KANA,VK_LCONTROL,'Q','1',0,0,0,'Z','S','A','W','2',0,
	0,'C','X','D','E','4','3',0,0,VK_SPACE,'V','F','T','R','5',0,
	0,'N','B','H','G','Y','6',0,0,0,'M','J','U','7','8',0,
	0,VK_OEM_COMMA,'K','I','O','0','9',0,0,VK_OEM_PERIOD,VK_OEM_2,'L',VK_OEM_PLUS,'P',VK_OEM_MINUS,0,
	0,VK_OEM_102,VK_OEM_1,0,VK_OEM_3,VK_OEM_7,0,0,VK_CAPITAL,VK_RSHIFT,VK_RETURN,VK_OEM_4,0,VK_OEM_6,0,0,
	0,0,0,0,VK_CONVERT,0,VK_BACK,VK_NONCONVERT,0,VK_NUMPAD1,VK_OEM_5,VK_NUMPAD4,VK_NUMPAD7,0,0,0,
	VK_NUMPAD0,VK_DECIMAL,VK_NUMPAD2,VK_NUMPAD5,VK_NUMPAD6,VK_NUMPAD8,VK_ESCAPE,VK_NUMLOCK,VK_F11,VK_ADD,VK_NUMPAD3,VK_SUBTRACT,VK_MULTIPLY,VK_NUMPAD9,VK_SCROLL,0,
	0,0,0,VK_F7
};
const unsigned char ps2scan2vktable2_jp[]={
	// PS/2XLR[h牼zL[R[hւ̕ϊe[u(E0vtBbNX)
	// 0x00-0x83܂
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,VK_RMENU,/*VK_LSHIFT*/ 0,0,VK_RCONTROL,0,0,0,0,0,0,0,0,0,0,VK_LWIN,
	0,0,0,0,0,0,0,VK_RWIN,0,0,0,0,0,0,0,VK_APPS,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,VK_DIVIDE,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,VK_SEPARATOR,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,VK_END,0,VK_LEFT,VK_HOME,0,0,0,
	VK_INSERT,VK_DELETE,VK_DOWN,0,VK_RIGHT,VK_UP,0,0,0,0,VK_NEXT,0,VK_SNAPSHOT,VK_PRIOR,VK_CANCEL,0,
	0,0,0,0
};
const unsigned char vk2asc1_jp[]={
	// zL[R[hASCIIR[hւ̕ϊe[uiSHIFTȂj
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	' ' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	'0' ,'1' ,'2' ,'3' ,'4' ,'5' ,'6' ,'7' ,'8' ,'9' ,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,'a' ,'b' ,'c' ,'d' ,'e' ,'f' ,'g' ,'h' ,'i' ,'j' ,'k' ,'l' ,'m' ,'n' ,'o' ,
	'p' ,'q' ,'r' ,'s' ,'t' ,'u' ,'v' ,'w' ,'x' ,'y' ,'z' ,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'*' ,'+' ,0x00,'-' ,0x00,'/' ,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,':' ,';' ,',' ,'-', '.' ,'/' ,
	'@' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'[' ,'\\',']' ,'^' ,0x00,
	0x00,0x00,'\\',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char vk2asc2_jp[]={
	// zL[R[hASCIIR[hւ̕ϊe[uiSHIFTj
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	' ' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,'!' ,0x22,'#' ,'$' ,'%' ,'&' ,0x27,'(' ,')' ,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,'H' ,'I' ,'J' ,'K' ,'L' ,'M' ,'N' ,'O' ,
	'P' ,'Q' ,'R' ,'S' ,'T' ,'U' ,'V' ,'W' ,'X' ,'Y' ,'Z' ,0x00,0x00,0x00,0x00,0x00,
	'0' ,'1' ,'2' ,'3' ,'4' ,'5' ,'6' ,'7' ,'8' ,'9' ,'*' ,'+' ,0x00,'-' ,'.' ,'/' ,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'*' ,'+' ,'<' ,'=' ,'>' ,'?' ,
	'`' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'{' ,'|' ,'}' ,'~' ,0x00,
	0x00,0x00,'_' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char vk2kana1[]={
	// zL[R[hJiR[hւ̕ϊe[uiSHIFTȂj
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	' ' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xdc,0xc7,0xcc,0xb1,0xb3,0xb4,0xb5,0xd4,0xd5,0xd6,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc1,0xba,0xbf,0xbc,0xb2,0xca,0xb7,0xb8,0xc6,0xcf,0xc9,0xd8,0xd3,0xd0,0xd7,
	0xbe,0xc0,0xbd,0xc4,0xb6,0xc5,0xcb,0xc3,0xbb,0xdd,0xc2,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'*' ,'+' ,0x00,'-' ,0x00,'/' ,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb9,0xda,0xc8,0xce,0xd9,0xd2,
	0xde,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xdf,0xb0,0xd1,0xcd,0x00,
	0x00,0x00,0xdb,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char vk2kana2[]={
	// zL[R[hJiR[hւ̕ϊe[uiSHIFTj
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	' ' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xa6,0xc7,0xcc,0xa7,0xa9,0xaa,0xab,0xac,0xad,0xae,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc1,0xba,0xbf,0xbc,0xa8,0xca,0xb7,0xb8,0xc6,0xcf,0xc9,0xd8,0xd3,0xd0,0xd7,
	0xbe,0xc0,0xbd,0xc4,0xb6,0xc5,0xcb,0xc3,0xbb,0xdd,0xaf,0x00,0x00,0x00,0x00,0x00,
	'0', '1' ,'2' ,'3' ,'4' ,'5' ,'6' ,'7' ,'8' ,'9' ,'*' ,'+' ,0x00,'-' ,'.' ,'/' ,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb9,0xda,0xa4,0xce,0xa1,0xa5,
	0xde,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa2,0xb0,0xa3,0xcd,0x00,
	0x00,0x00,0xdb,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

// p104keyz
const unsigned char ps2scan2vktable1_en[]={
	// PS/2XLR[h牼zL[R[hւ̕ϊe[u
	// 0x00-0x83܂
	0,VK_F9,0,VK_F5,VK_F3,VK_F1,VK_F2,VK_F12,0,VK_F10,VK_F8,VK_F6,VK_F4,VK_TAB,VK_OEM_3,0,
	0,VK_LMENU,VK_LSHIFT,0,VK_LCONTROL,'Q','1',0,0,0,'Z','S','A','W','2',0,
	0,'C','X','D','E','4','3',0,0,VK_SPACE,'V','F','T','R','5',0,
	0,'N','B','H','G','Y','6',0,0,0,'M','J','U','7','8',0,
	0,VK_OEM_COMMA,'K','I','O','0','9',0,0,VK_OEM_PERIOD,VK_OEM_2,'L',VK_OEM_1,'P',VK_OEM_MINUS,0,
	0,0,VK_OEM_7,0,VK_OEM_4,VK_OEM_PLUS,0,0,VK_CAPITAL,VK_RSHIFT,VK_RETURN,VK_OEM_6,0,VK_OEM_5,0,0,
	0,0,0,0,0,0,VK_BACK,0,0,VK_NUMPAD1,0,VK_NUMPAD4,VK_NUMPAD7,0,0,0,
	VK_NUMPAD0,VK_DECIMAL,VK_NUMPAD2,VK_NUMPAD5,VK_NUMPAD6,VK_NUMPAD8,VK_ESCAPE,VK_NUMLOCK,VK_F11,VK_ADD,VK_NUMPAD3,VK_SUBTRACT,VK_MULTIPLY,VK_NUMPAD9,VK_SCROLL,0,
	0,0,0,VK_F7
};
const unsigned char ps2scan2vktable2_en[]={
	// PS/2XLR[h牼zL[R[hւ̕ϊe[u(E0vtBbNX)
	// 0x00-0x83܂
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,VK_RMENU,/*VK_LSHIFT*/ 0,0,VK_RCONTROL,0,0,0,0,0,0,0,0,0,0,VK_LWIN,
	0,0,0,0,0,0,0,VK_RWIN,0,0,0,0,0,0,0,VK_APPS,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,VK_DIVIDE,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,VK_SEPARATOR,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,VK_END,0,VK_LEFT,VK_HOME,0,0,0,
	VK_INSERT,VK_DELETE,VK_DOWN,0,VK_RIGHT,VK_UP,0,0,0,0,VK_NEXT,0,VK_SNAPSHOT,VK_PRIOR,VK_CANCEL,0,
	0,0,0,0
};
const unsigned char vk2asc1_en[]={
	// zL[R[hASCIIR[hւ̕ϊe[uiSHIFTȂj
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	' ' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	'0' ,'1' ,'2' ,'3' ,'4' ,'5' ,'6' ,'7' ,'8' ,'9' ,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,'a' ,'b' ,'c' ,'d' ,'e' ,'f' ,'g' ,'h' ,'i' ,'j' ,'k' ,'l' ,'m' ,'n' ,'o' ,
	'p' ,'q' ,'r' ,'s' ,'t' ,'u' ,'v' ,'w' ,'x' ,'y' ,'z' ,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'*' ,'+' ,0x00,'-' ,0x00,'/' ,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,';' ,'=' ,',' ,'-' ,'.' ,'/' ,
	'`' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'[' ,'\\',']' ,0x27,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char vk2asc2_en[]={
	// zL[R[hASCIIR[hւ̕ϊe[uiSHIFTj
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	' ' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	')' ,'!' ,'@' ,'#' ,'$' ,'%' ,'^' ,'&' ,'*' ,'(' ,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,'H' ,'I' ,'J' ,'K' ,'L' ,'M' ,'N' ,'O' ,
	'P' ,'Q' ,'R' ,'S' ,'T' ,'U' ,'V' ,'W' ,'X' ,'Y' ,'Z' ,0x00,0x00,0x00,0x00,0x00,
	'0' ,'1' ,'2' ,'3' ,'4' ,'5' ,'6' ,'7' ,'8' ,'9' ,'*' ,'+' ,0x00,'-' ,'.' ,'/' ,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,':' ,'+' ,'<' ,'_' ,'>' ,'?' ,
	'~' ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,'{' ,'|' ,'}' ,0x22,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

void ps2receive(unsigned int data)
{
	unsigned char d;
	unsigned char c;

	if(ps2receiveError) return; // G[͎crbg
#ifdef PIC32MX370F
	if(data & PS2CLKBIT) return; //CLKオ͖
	d=data & PS2DATBIT;
#else
	if(data & (PS2CLKBIT>>8)) return; //CLKオ͖
	d=data & (PS2DATBIT>>8);
#endif
	if(receivecount==0){
		//X^[grbg
		if(d){
			//X^[grbgG[
			ps2receiveError=PS2ERROR_STARTBIT;
			return;
		}
		else{
			//oCgMJn
			receivecount++;
			ps2receivetime=0;//M^C}[JEgJn
		}
	}
	else if(receivecount<=8){
		//f[^
		receivedata=(receivedata>>1)+(d<<7);
		receivecount++;
	}
	else if(receivecount==9){
		//peB
		c=receivedata;
		while(c){
			d^=c;
			c>>=1;
		}
		if((d&1)==0){
			//peBG[
			ps2receiveError=PS2ERROR_PARITY;
			return;
		}
		else receivecount++;
	}
	else{
		//Xgbvrbg
		if(d==0){
			//XgbvrbgG[
			ps2receiveError=PS2ERROR_STOPBIT;
			return;
		}
		//ǂݍ݊
		receivecount=0;
		if(receivedata==0 || receivedata==PS2CMD_BAT ||
			receivedata==PS2CMD_ECHO || receivedata>=PS2CMD_ACK){
			//L[{[h̃R}hM̏ꍇ
			ps2receivecommand=receivedata;
			ps2receivecommandflag=1;
		}
		else{
			//f[^M̏ꍇ
			if((scancodebufp1+1==scancodebufp2) ||
				(scancodebufp1==scancodebuf+SCANCODEBUFSIZE-1)&&(scancodebufp2==scancodebuf)){
				//obt@t
				ps2receiveError=PS2ERROR_BUFFERFUL;
				return;
			}
			*scancodebufp1++=receivedata;
			if(scancodebufp1>=scancodebuf+SCANCODEBUFSIZE) scancodebufp1=scancodebuf;
		}
	}
}
void ps2send()
{
	if(PORTPS2CLK){
		//CLKオ莞
		if(sendcount==10){
			mTRISPS2DATIN(); //DAT͂ɐݒ
		}
		else if(sendcount==11){
			ps2sending=0;
			mPS2CLKIntEnable(0); //CLKɂ銄荞ݖ
			mPS2DMAEnable(); //DMAL
		}
		return;
	}
// ȉCLK莞
	sendcount++;
	if(sendcount<=10){
		//f[^o
		if(senddata & 1) mPS2DATSET();
		else mPS2DATCLR();
		senddata>>=1;
	}
/*
	else{
		//DAT=LiACKjƂȂĂ͂
		//ă`FbN͂Ȃ
	}
*/
}

#ifdef PIC32MX370F
void __ISR(33, ipl6) CNHandler(void)
{
	//CN荞݃nh
	unsigned int cnstat;
	unsigned int volatile port; //dummy

	cnstat=CNSTATF;
	if(cnstat){
		port=PS2PORT; //dummy read
		if(cnstat & PS2CLKBIT){
			// CLKω
			ps2send(); //R}hMCLKω
		}
		mCNFClearIntFlag(); // CNF荞݃tONA
	}
}
#else
void __ISR(34, ipl6) CNHandler(void)
{
	//CN荞݃nh
	unsigned int cnstat;
	unsigned int volatile port; //dummy

	cnstat=CNSTATB;
	if(cnstat){
		port=PS2PORT; //dummy read
		if(cnstat & PS2CLKBIT){
			// CLKω
			ps2send(); //R}hMCLKω
		}
		mCNBClearIntFlag(); // CNB荞݃tONA
	}
}
#endif

void getps2DMABUFdata(void) {
	// DMAœ]ꂽf[^1rbgǂݍ
	while (dma_readpt != DCH3DPTR) {
		ps2receive(keyboard_rcvdata[dma_readpt]); //1rbg
		dma_readpt++;
		if (dma_readpt == PS2DMABUFSIZE) dma_readpt = 0;
	}
}


void ps2statusprogress(){
	//R}hMԂ100}CNbƂɌĂяo
	//ps2statusőM󋵂\
	unsigned int parity;
	unsigned char c;
	unsigned int volatile dummy;

	ps2statuscount--;
	switch(ps2status){
		case PS2STATUS_INIT:
			//VXeN̈҂
			if(ps2statuscount==0) ps2status=0;
			return;

		case PS2STATUS_SENDSTART:
			//R}hMX^[g
			if(ps2statuscount) return;//R}hMO҂
			mPS2CLKIntEnable(0); //CLKɂ銄荞ݖ
			mPS2DMADisable(); //DMA
			mTRISPS2CLKOUT();//CLKo͂ɐݒ
			asm volatile ("nop");
			mPS2CLKCLR(); //CLK=LA100usȏp
			//peB
			c=ps2sendcomdata;
			parity=1;
			while(c){
				parity^=c;
				c>>=1;
			}
			//Mf[^idata,parity,stop bitj
			senddata=0x200+((parity&1)<<8)+(ps2sendcomdata & 0xff);
			receivecount=0;//MrȂ狭I
			ps2sending=1;//MtO
			sendcount=0;//MJE^
			ps2status=PS2STATUS_WAIT100us;
			ps2statuscount=PS2TIME_CLKDOWN;
			return;

		case PS2STATUS_WAIT100us:
			//CLK=Lɂ100us҂
			if(ps2statuscount) return;//100uso߂ĂȂꍇ
			mTRISPS2DATOUT();//DATo͂ɐݒ
			asm volatile ("nop");
			mPS2DATCLR(); //start bit:0
			mTRISPS2CLKIN();//CLK͂ɐݒ
			asm volatile ("nop"); //1NbNȏ̃EFCgKv
			dummy=PS2PORT;//荞ݖ̃|[gωz
			mPS2CLKIntEnable(1); //CLKωɂ銄荞ݗL
			ps2status=PS2STATUS_SENDING; //͑M܂ő҂
			ps2statuscount=PS2TIME_CMDTIMEOUT; //^CAEgG[̐ݒ
			return;

		case PS2STATUS_SENDING:
			if(ps2sending==0){
				//M
				c=ps2sendcomdata;
				if(c==PS2CMD_RESEND){
					//đvR}hM̏ꍇ͒ʏMԂɖ߂
					ps2status=0;
				}
				else{
					ps2status=PS2STATUS_WAITACK;//ACK҂
					ps2statuscount=PS2TIME_ACKTIMEOUT;
					ps2receiveError=0;
				}
			}
			else if(ps2statuscount==0){
				//^CAEg
				ps2sendError=PS2ERROR_TIMEOUT;
				ps2sending=0; //ʏMԂɖ߂
				mTRISPS2DATIN(); //DAT͂ɐݒ
				ps2status=0;
				mPS2CLKIntEnable(0); //CLKɂ銄荞ݖ
				mPS2DMAEnable(); //DMAL
			}
			return;

		case PS2STATUS_WAITACK:
			//ACK҂
			if(ps2receivecommandflag){
				//R}hM
				ps2receivecommandflag=0;
				if(ps2receivecommand==PS2CMD_RESEND){
					//đvꍇAŏđ
					ps2status=PS2STATUS_SENDSTART;
					ps2statuscount=PS2TIME_PRESEND;
					ps2sending=1;
					return;
				}
				else if(ps2receivecommand==PS2CMD_ACK){
					//ACKM
					c=ps2sendcomdata;
					if(c==PS2CMD_RESET){
						//ZbgR}h̏ꍇABATԐM҂
						ps2sendcombyte=0;//R}hMobt@NA
						ps2status=PS2STATUS_WAITBAT;
						ps2statuscount=PS2TIME_BATTIMEOUT;
						ps2receiveError=0;
						return;
					}
				}
				else {
					//ACKł͂Ȃꍇ
					//ECHOȂǂ̏͂ɋLq
				}
				if(--ps2sendcombyte){
					//R}hcĂꍇÃoCgM
					ps2sendcomdata>>=8;
					ps2status=PS2STATUS_SENDSTART;
					ps2statuscount=PS2TIME_PRESEND;
					ps2sending=1;
					return;
				}
				//SẴR}hM
				ps2status=0;
				ps2sendcombyte=0;
				return;
			}
			else if(ps2statuscount==0){
				//ȂA^CAEg
				ps2sendError=PS2ERROR_NOACK;
				ps2status=0;
				ps2sendcombyte=0;
			}
			return;

		case PS2STATUS_WAITBAT:
			if(ps2receivecommandflag){
				//R}hM
				ps2receivecommandflag=0;
				if(ps2receivecommand!=PS2CMD_BAT){
					//BATiZteXgjs̏ꍇ
					ps2sendError=PS2ERROR_NOBAT;
				}
				ps2status=0;
			}
			else if(ps2statuscount==0){
				//BAT^CAEg
				ps2sendError=PS2ERROR_NOBAT;
				ps2status=0;
			}
			return;
	}
}
void ps2command(unsigned int d,unsigned char n){
// PS/2L[{[hɑ΂ăR}hM
// d:R}h
// n:R}h̃oCgid͉ʂ8rbgj

	if(ps2status) return; //R}hM̏ꍇA߂

	mPS2CLKIntEnable(0); //CLKɂ銄荞ݖ
	mPS2DMADisable(); //DMA
	getps2DMABUFdata(); //M̃f[^j
	ps2receivecommandflag=0; //R}hMtONA
	ps2sendcomdata=d;
	ps2sendcombyte=n;
	ps2sendError=0;
	ps2status=PS2STATUS_SENDSTART; //Timer5荞݂őMJn
	ps2statuscount=PS2TIME_PRESEND;
}

void shiftkeycheck(unsigned char vk,unsigned char breakflag){
// SHIFT,ALT,CTRL,WinL[̉ԂXV
	unsigned short k;
	k=0;
	switch(vk){
		case VK_SHIFT:
		case VK_LSHIFT:
			k=CHK_SHIFT_L;
			break;
		case VK_RSHIFT:
			k=CHK_SHIFT_R;
			break;
		case VK_CONTROL:
		case VK_LCONTROL:
			k=CHK_CTRL_L;
			break;
		case VK_RCONTROL:
			k=CHK_CTRL_R;
			break;
		case VK_MENU:
		case VK_LMENU:
			k=CHK_ALT_L;
			break;
		case VK_RMENU:
			k=CHK_ALT_R;
			break;
		case VK_LWIN:
			k=CHK_WIN_L;
			break;
		case VK_RWIN:
			k=CHK_WIN_R;
			break;
	}
	if(breakflag) ps2shiftkey_a &= ~k;
	else ps2shiftkey_a |= k;

	ps2shiftkey &= CHK_SCRLK | CHK_NUMLK | CHK_CAPSLK;
	if(ps2shiftkey_a & (CHK_SHIFT_L | CHK_SHIFT_R)) ps2shiftkey|=CHK_SHIFT;
	if(ps2shiftkey_a & (CHK_CTRL_L | CHK_CTRL_R)) ps2shiftkey|=CHK_CTRL;
	if(ps2shiftkey_a & (CHK_ALT_L | CHK_ALT_R)) ps2shiftkey|=CHK_ALT;
	if(ps2shiftkey_a & (CHK_WIN_L | CHK_WIN_R)) ps2shiftkey|=CHK_WIN;
}
void lockkeycheck(unsigned char vk){
// NumLock,CapsLock,ScrollLock̏ԍXVACWP[^R}hs
	switch(vk){
		case VK_SCROLL:
		case VK_KANA:
			ps2shiftkey_a^=CHK_SCRLK_A;
			ps2shiftkey  ^=CHK_SCRLK;
			break;
		case VK_NUMLOCK:
			ps2shiftkey_a^=CHK_NUMLK_A;
			ps2shiftkey  ^=CHK_NUMLK;
			break;
		case VK_CAPITAL:
			if((ps2shiftkey & CHK_SHIFT)==0) return;
			ps2shiftkey_a^=CHK_CAPSLK_A;
			ps2shiftkey  ^=CHK_CAPSLK;
			break;
		default:
			return;
	}
	ps2command(PS2CMD_SETLED+(ps2shiftkey_a & 0xff00),2); // L[{[h̃CWP[^ݒ
}
int isShiftkey(unsigned char vk){
// SHIFT,ALT,WIN,CTRLꂽ̃`FbNiꂽꍇ-1Ԃj
	switch(vk){
		case VK_SHIFT:
		case VK_LSHIFT:
		case VK_RSHIFT:
		case VK_CONTROL:
		case VK_LCONTROL:
		case VK_RCONTROL:
		case VK_MENU:
		case VK_LMENU:
		case VK_RMENU:
		case VK_LWIN:
		case VK_RWIN:
			return -1;
		default:
			return 0;
	}
}
int isLockkey(unsigned char vk){
// NumLock,SCRLock,CapsLockꂽ̃`FbNiꂽꍇ-1Ԃj
	switch(vk){
		case VK_SCROLL:
		case VK_NUMLOCK:
		case VK_CAPITAL:
		case VK_KANA:
			return -1;
		default:
			return 0;
	}
}
void readscancode(){
// scancodebufXLR[hǂݏoAL[R[hɕϊ
// keycodebufɂ߂
	int e0flag,breakflag;
	unsigned char d;
	unsigned char vk;
	unsigned char *p;

	e0flag=0;
	breakflag=0;
	p=scancodebufp2;
	while(1){
		//vtBbNXiE0AE1AuCNjI܂Ń[v
		if(p==scancodebufp1) return;//܂sSɂobt@ɂĂȂ
		d=*p++;
		if(p==scancodebuf+SCANCODEBUFSIZE) p=scancodebuf;
		if(d==PS2CMD_BREAK) breakflag=1;
		else if(d==0xe0) e0flag=1;
		else if(d!=0xe1) break; //E1͖
	}
	scancodebufp2=p;
	if(d>0x83) return; //ΉXLR[h
	if(e0flag){
		if(keytype==1) vk=ps2scan2vktable2_en[d];
		else vk=ps2scan2vktable2_jp[d];
	}
	else{
		if(keytype==1) vk=ps2scan2vktable1_en[d];
		else vk=ps2scan2vktable1_jp[d];
	}
	if(vk==0) return; //ΉXLR[h

	if(isShiftkey(vk)){
		if(breakflag==0 && ps2keystatus[vk]) return; //L[s[g̏ꍇA
		shiftkeycheck(vk,breakflag); //SHIFTnL[̃tO
	}
	else if(breakflag==0 && isLockkey(vk)){
		if(ps2keystatus[vk]) return; //L[s[g̏ꍇA
		if((ps2shiftkey & CHK_CTRL)==0) lockkeycheck(vk); //NumLockACapsLockAScrollLock]
	}
	//L[R[hɑ΂鉟ԔzXV
	if(breakflag){
		ps2keystatus[vk]=0;
		return;
	}
	ps2keystatus[vk]=1;

	if((keycodebufp1+1==keycodebufp2) ||
			(keycodebufp1==keycodebuf+KEYCODEBUFSIZE-1)&&(keycodebufp2==keycodebuf)){
		return; //obt@ς̏ꍇ
	}
	*keycodebufp1++=((unsigned short)ps2shiftkey<<8)+vk;
	if(keycodebufp1==keycodebuf+KEYCODEBUFSIZE) keycodebufp1=keycodebuf;
}
void __ISR(20, ipl4) T5Handler(void)
{
        getps2DMABUFdata(); //DMAɂǂݍ݃f[^̎荞

	if(ps2status!=0) ps2statusprogress();
	if(receivecount){
		//f[^M̃^CAEg`FbN
		//莞ԃf[^ȂꍇA߂
		ps2receivetime++;
		if(ps2receivetime>PS2TIME_RECEIVETIMEOUT) receivecount=0;
	}
	if(ps2receiveError){
		// MG[͍đvR}hs
		ps2receiveError=0;
		ps2command(PS2CMD_RESEND,1); //đvR}h
	}

	//XLR[hobt@ǂݏoAL[R[hɕϊăL[R[hobt@Ɋi[
	if(scancodebufp1!=scancodebufp2) readscancode();
	mT5ClearIntFlag(); // T5荞݃tONA
}

int ps2init()
{
// PS/2L[{[hVXe
// I0Ԃ
// G[I-1Ԃ

	int i;

	receivecount=0;
	scancodebufp1=scancodebuf;
	scancodebufp2=scancodebuf;
	keycodebufp1=keycodebuf;
	keycodebufp2=keycodebuf;
	ps2status=0;
	ps2sending=0;
	ps2receiveError=0;
	ps2sendError=0;
	ps2receivecommandflag=0;
	ps2shiftkey_a=lockkey<<8; //Lock֘AL[ϐlockkeyŏ
	ps2shiftkey=lockkey<<4; //Lock֘AL[ϐlockkeyŏ
	for(i=0;i<256;i++) ps2keystatus[i]=0; //SL[

	mTRISPS2CLKOUT();//CLKo͂ɐݒ
	asm volatile ("nop");
	mPS2CLKCLR(); //CLK=L

	// Timer5荞ݗL
	T5CON=0x0040; //Timer5 1:16 prescale
	PR5=TIMER5_100us;//100us
	TMR5=0;
	mT5SetIntPriority(4); // 荞݃x4
	mT5ClearIntFlag();
	mT5IntEnable(1); // T5荞ݗL
	T5CONSET=0x8000; //Timer5 Start

	// dI̋N҂
	ps2status=PS2STATUS_INIT;
	ps2statuscount=PS2TIME_INIT;
	while(ps2status) ;

	// CN荞ݐݒ
	// ʏ펞FDMÂݗpAR}hMF荞ݗL
#ifdef PIC32MX370F
	mCNSetIntPriority(6); // 荞݃x6
	mCNFClearIntFlag();
	CNENFSET=PS2CLKBIT; // CLK̕ωCN荞
	CNCONF=0x8000; // PORTFɑ΂CN荞݃I
#else
	mCNSetIntPriority(6); // 荞݃x6
	mCNBClearIntFlag();
	CNENBSET=PS2CLKBIT; // CLK̕ωCN荞
	CNCONB=0x8000; // PORTBɑ΂CN荞݃I
#endif

	//DMA
#ifdef PIC32MX370F
	DCH3ECON=(_CHANGE_NOTICE_F_IRQ<<8)+0x10; // start by CNF interrupt
	DCH3SSA=(unsigned int)(&PORTF) & 0x1fffffff; // source start address
#else
	DCH3ECON=(_CHANGE_NOTICE_B_IRQ<<8)+0x10; // start by CNB interrupt
	DCH3SSA=((unsigned int)(&PORTB) & 0x1fffffff) +1; // source start address
#endif
	DCH3DSA=(unsigned int)keyboard_rcvdata & 0x1fffffff; // distination start address
	DCH3SSIZ=1;// source size
	DCH3DSIZ=PS2DMABUFSIZE;// destination size
	DCH3CSIZ=1;// cell size
	DCH3CON=0x10;//auto enabled
        dma_readpt = 0;
	DMACONSET=0x00008000;// enable the DMA controller
	//DCH3CONSET=0x80; //ch3 enabled --- PS/2ZbgR}h̓rŗL邽߂ł͂Ȃ

	ps2command(PS2CMD_RESET,1); // PS/2ZbgR}hsA҂
	while(ps2status) ; //M҂
	if(ps2sendError) return -1; //G[
	ps2command(PS2CMD_SETLED+(ps2shiftkey_a & 0xff00),2); // L[{[h̃CWP[^ݒ
	while(ps2status) ; //M҂
	if(ps2sendError) return -1; //G[

	return 0;
}
unsigned char ps2readkey(){
// ͂ꂽ1̃L[̃L[R[hO[oϐvkeyɊi[iĂȂ0Ԃj
// 8rbgFL[R[h
// 8rbgFVtg
// pEL̏ꍇA߂lƂASCIIR[hiȊO0Ԃj

	unsigned short k;
	unsigned char sh;

	vkey=0;
	if(keycodebufp1==keycodebufp2) return 0;
	vkey=*keycodebufp2++;
	if(keycodebufp2==keycodebuf+KEYCODEBUFSIZE) keycodebufp2=keycodebuf;
	sh=vkey>>8;
	if(sh & (CHK_CTRL | CHK_ALT | CHK_WIN)) return 0;
	k=vkey & 0xff;
	if(keytype==1){
	//pL[{[h
		if(k>='A' && k<='Z'){
			//SHIFT܂CapsLockił͂Ȃj
			if((sh & (CHK_SHIFT | CHK_CAPSLK))==CHK_SHIFT || (sh & (CHK_SHIFT | CHK_CAPSLK))==CHK_CAPSLK)
				return vk2asc2_en[k];
			else return vk2asc1_en[k];
		}
		if(k>=VK_NUMPAD0 && k<=VK_DIVIDE){ //eL[
			if((sh & (CHK_SHIFT | CHK_NUMLK))==CHK_NUMLK) //NumLockiSHIFT{NumLock͖j
				return vk2asc2_en[k];
			else return vk2asc1_en[k];
		}
		if(sh & CHK_SHIFT) return vk2asc2_en[k];
		else return vk2asc1_en[k];
	}

	if(sh & CHK_SCRLK){
	//{L[{[hiJi[hj
		if(k>=VK_NUMPAD0 && k<=VK_DIVIDE){ //eL[
			if((sh & (CHK_SHIFT | CHK_NUMLK))==CHK_NUMLK) //NumLockiSHIFT{NumLock͖j
				return vk2kana2[k];
			else return vk2kana1[k];
		}
		if(sh & CHK_SHIFT) return vk2kana2[k];
		else return vk2kana1[k];
	}

	//{L[{[hip[hj
	if(k>='A' && k<='Z'){
		//SHIFT܂CapsLockił͂Ȃj
		if((sh & (CHK_SHIFT | CHK_CAPSLK))==CHK_SHIFT || (sh & (CHK_SHIFT | CHK_CAPSLK))==CHK_CAPSLK)
			return vk2asc2_jp[k];
		else return vk2asc1_jp[k];
	}
	if(k>=VK_NUMPAD0 && k<=VK_DIVIDE){ //eL[
		if((sh & (CHK_SHIFT | CHK_NUMLK))==CHK_NUMLK) //NumLockiSHIFT{NumLock͖j
			return vk2asc2_jp[k];
		else return vk2asc1_jp[k];
	}
	if(sh & CHK_SHIFT) return vk2asc2_jp[k];
	else return vk2asc1_jp[k];
}
unsigned char shiftkeys(){
// SHIFT֘AL[̉ԂԂ
// ʂ<0><CAPSLK><NUMLK><SCRLK><Wiin><ALT><CTRL><SHIFT>
	return ps2shiftkey;
}
#ifndef PIC32MX370F
void ps2mode(){
	LATASET=2; //RA1IiPS/2[hj
	T5CONSET=0x8000; //Timer5ĊJ
	CNENBSET=PS2CLKBIT; //CLK荞ݍĊJ
}
void buttonmode(){
	CNENBCLR=PS2CLKBIT; //CLK荞ݒ~
	T5CONCLR=0x8000; //Timer5~
	LATACLR=2; //RA1Iti{^[hj
}
#endif
