﻿Imports System.Net

Public Class FrmLogionDisp

    Dim sBinding As New SoapCliantControl
    Const SOAP_STR As String = "services/Soap/u/31.0"

    'ログを表示します
    Public Sub LogDisplay(ArgStr As String)
        ListBoxLog.Items.Add("[" & Now & "]" & ArgStr)
        Application.DoEvents()
    End Sub

    Public Function login() As Boolean
        LogDisplay("ログイン情報から設定中...")
        '基本はFrmLoginInfoクラスの値を使う
        sBinding.username = My.Settings.ID
        sBinding.password = My.Settings.PWD
        sBinding.proxyid = My.Settings.PROXYID
        sBinding.proxypwd = My.Settings.PROXYPWD

        ShowFrmProginfo()
        Application.UseWaitCursor = True
        '一番最後に/があればそのまま、なければつける
        'If My.Settings.URL.LastIndexOf("/") = My.Settings.URL.Length - 1 Then
        '    sBinding.host = My.Settings.URL & SOAP_STR
        'Else
        '    sBinding.host = My.Settings.URL & "/" & SOAP_STR
        'End If

        'LogDisplay("プロキシ確認中...")
        'Dim MyProxy As IWebProxy
        'MyProxy = sBinding.proxy
        'Try
        '    MyProxy.Credentials = New NetworkCredential(My.Settings.PROXYID, My.Settings.PROXYPWD)
        '    LogDisplay("プロキシ認証...OK")
        'Catch ex As Exception
        '    'ログ表示
        '    LogDisplay("プロキシ認証に失敗しました : " & ex.Message)
        '    LogDisplay("ログイン情報からPROXYを確認して再ログインを行ってください。")
        '    Return False
        '    Exit Function
        'End Try


        'プロキシの有無を確認すると同時に設定を行う
        ''Dim SOAPWebrequest As HttpWebRequest
        ' ''SOAPWebrequest = HttpWebRequest.Create(sBinding.host)
        ''SOAPWebrequest = HttpWebRequest.Create(My.Settings.URL & "/" & SOAP_STR)
        ''Dim MyProxy As IWebProxy
        ''MyProxy = SOAPWebrequest.Proxy
        ''Dim newUri As Uri
        ''If MyProxy Is Nothing Then
        ''Else
        ''    LogDisplay("プロキシ反応【あり】")
        ''    'プロキシがある場合、そのプロキシに認証させる
        ''    newUri = MyProxy.GetProxy(SOAPWebrequest.RequestUri)
        ''    Try
        ''        MyProxy.Credentials = New NetworkCredential(My.Settings.PROXYID, My.Settings.PROXYPWD)
        ''        LogDisplay("プロキシ認証...OK")
        ''    Catch ex As Exception
        ''        'ログ表示
        ''        LogDisplay("プロキシ認証に失敗しました : " & ex.Message)
        ''        LogDisplay("ログイン情報からPROXYを確認して再ログインを行ってください。")
        ''        Return False
        ''        Exit Function
        ''    End Try
        ''End If
        LogDisplay("ログイン中...")
        Try
            sBinding.Login()
        Catch ex As Exception
            LogDisplay("認証に失敗しました : " & ex.Message)
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            Return False
            Exit Function
        End Try

        If sBinding.isConnected Then
            'ログイン成功
            'LogDisplay("ログイン先:" & sBinding.host)
            LogDisplay("接続先:" & sBinding.serverURL)
            LogDisplay("ログイン...OK")
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            Return True
        Else
            'ログイン失敗
            LogDisplay("ログイン失敗！")
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            Return False
        End If
    End Function

    Private Sub BtnLogin_Click(sender As System.Object, e As System.EventArgs) Handles BtnLogin.Click
        '初回起動の場合、プロキシのID、PWDの設定を行う
        If My.Settings.PROXYUse = True And (My.Settings.PROXYID = "" Or My.Settings.PROXYPWD = "") Then
            If MessageBox.Show("プロキシIDとパスワードを設定してください", "プロキシ設定", MessageBoxButtons.OK, MessageBoxIcon.Information) = Windows.Forms.DialogResult.OK Then
                BtnLoginInfo.PerformClick()
                Exit Sub
            End If
        End If
        If login() Then
            FrmMain.sBinding = sBinding
            FrmMain.Show()
            BtnCancel.Text = "キャンセル"
            Me.ShowInTaskbar = False    'ログインしたらタスクバーに表示しない
            Me.Hide()
            'Me.Close()
        End If
    End Sub

    Private Sub BtnCancel_Click(sender As System.Object, e As System.EventArgs) Handles BtnCancel.Click
        'ラベル内容によって処理を切り替える
        If BtnCancel.Text = "終了" Then
            Me.Close()
        Else
            Me.Hide()
        End If
    End Sub

    Private Sub FrmLogionDisp_Load(sender As Object, e As System.EventArgs) Handles Me.Load

        LogDisplay("WEBサービスインスタンス起動中...OK")
        ' LogDisplay("【ログインボタン】を押してログインしましょう！！")
        BtnCancel.Text = "終了"
    End Sub

    Private Sub BtnLoginInfo_Click(sender As System.Object, e As System.EventArgs) Handles BtnLoginInfo.Click
        FrmLoginInfo.Show()
    End Sub

    Private Sub BtnLogOutPut_Click(sender As System.Object, e As System.EventArgs) Handles BtnLogOutPut.Click
        SaveDialogDefault()
    End Sub

    Private Sub SaveDialogDefault()
        Dim sfd As New SaveFileDialog

        '初期ファイル名指定
        sfd.FileName = Now.Year.ToString & Now.Month.ToString & Now.Day.ToString & Now.Hour.ToString & Now.Minute.ToString & Now.Second.ToString & "log.txt"
        '初期フォルダ(デスクトップ）
        sfd.InitialDirectory = System.Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory)
        'ファイルフィルタ
        sfd.Filter = "すべてのファイル(*.*)|*.*|テキストファイル(*.txt)|*.txt"
        'タイトルを設定する
        sfd.Title = "保存先のファイルを選択してください"
        'ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
        sfd.RestoreDirectory = True

        Try

            If Not sfd.ShowDialog = Windows.Forms.DialogResult.OK Then
                Exit Sub
            End If
            Application.UseWaitCursor = True

            Dim stream As System.IO.Stream
            stream = sfd.OpenFile()
            If Not (stream Is Nothing) Then
                'ファイルに書き込む
                Dim sw As New System.IO.StreamWriter(stream)
                'リストを取り出す（ループ）
                For Each outline As Object In ListBoxLog.Items
                    sw.Write(outline.ToString())
                    sw.WriteLine()
                Next
                sw.Close()
                stream.Close()
            End If
            MessageBox.Show("ログを出力しました", "ログ", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Me.Enabled = True
        Catch ex As Exception
            Me.Enabled = True
            MessageBox.Show(ex.Message)
        End Try
    End Sub
End Class