package org.pulpdust.da.aozora.em;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.Spinner;
import android.widget.TextView;

public class AozoraEmDaActivity extends FragmentActivity {
	final static String TAG = "AozoraEmDA Main";
	final static String DA_EX_TEXT = "org.pulpdust.da.extra.TEXT";
	final static String DA_EX_THEME = "org.pulpdust.da.extra.THEME";
	final static String DA_EX_RETURN = "org.pulpdust.da.extra.RETURN";
	String sbj;
	TextView obj;
	Spinner type;
	CheckBox enclose;
	CheckBox left;
	Button ok;
	String[] types;
	
	@Override
	public void onCreate(Bundle savedInstanceState){
		int cs = getIntent().getIntExtra(DA_EX_THEME, 0);
		if (cs >= 1){
			setTheme(R.style.AppTheme_Dark);
		} else {
			setTheme(R.style.AppTheme);
		}
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_aozoraem);
 		if (getIntent().getStringExtra(DA_EX_TEXT) != null){
 			sbj = getIntent().getStringExtra(DA_EX_TEXT);
 		} else {
 			sbj = "";
 		}
 		obj = (TextView) findViewById(R.id.textView2);
 		type = (Spinner) findViewById(R.id.spinner1);
 		enclose = (CheckBox) findViewById(R.id.checkBox1);
 		left = (CheckBox) findViewById(R.id.checkBox2);
 		ok = (Button) findViewById(R.id.button1);
 		obj.setText(sbj);
 		ArrayAdapter<CharSequence> aa = ArrayAdapter.createFromResource(this, R.array.type_select, 
 				android.R.layout.simple_spinner_item);
 		aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
 		type.setAdapter(aa);
 		readPrefs();
 		ok.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				String retstr;
				if (enclose.isChecked()){
					if (left.isChecked()){
						retstr = getString(R.string.notate_open) + getString(R.string.notate_left) + 
								getString(R.string.notate_at) + type.getSelectedItem() + 
								getString(R.string.notate_close) + sbj + getString(R.string.notate_open) + 
								getString(R.string.notate_left) + getString(R.string.notate_at) + 
								type.getSelectedItem() + getString(R.string.notate_end) + 
								getString(R.string.notate_close);
					} else {
						retstr = getString(R.string.notate_open) + type.getSelectedItem() + 
								getString(R.string.notate_close) + sbj + getString(R.string.notate_open) + 
								type.getSelectedItem() + getString(R.string.notate_end) + 
								getString(R.string.notate_close);
					}
				} else {
					if (left.isChecked()){
						retstr = sbj + getString(R.string.notate_open) + getString(R.string.object_open) + 
								sbj + getString(R.string.object_close) + getString(R.string.notate_of) + 
								getString(R.string.notate_left) + getString(R.string.notate_at) + 
								type.getSelectedItem() + getString(R.string.notate_close);
					} else {
						retstr = sbj + getString(R.string.notate_open) + getString(R.string.object_open) + 
								sbj + getString(R.string.object_close) + getString(R.string.notate_at) + 
								type.getSelectedItem() + getString(R.string.notate_close);
					}
				}
				Intent ret = new Intent();
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
 			
 		});
	}
	@Override
	protected void onStop(){
		super.onStop();
		writePrefs();
	}

	void readPrefs(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		type.setSelection(sp.getInt("type", 0));
		enclose.setChecked(sp.getBoolean("enclose", false));
		left.setChecked(sp.getBoolean("left", false));
	}
	void writePrefs(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		SharedPreferences.Editor pe = sp.edit();
		pe.putInt("type", type.getSelectedItemPosition());
		pe.putBoolean("enclose", enclose.isChecked());
		pe.putBoolean("left", left.isChecked());
		pe.commit();
	}

}
