package org.pulpdust.da.aozora.ruby;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;

public class AozoraRubyDaActivity extends FragmentActivity {
	final static String TAG = "AozoraRubyDA Main";
	final static String DA_EX_TEXT = "org.pulpdust.da.extra.TEXT";
	final static String DA_EX_THEME = "org.pulpdust.da.extra.THEME";
	final static String DA_EX_RETURN = "org.pulpdust.da.extra.RETURN";
	String sbj;
	TextView obj;
	EditText ruby;
	CheckBox delimit;
	Button ok;
	
	@Override
	public void onCreate(Bundle savedInstanceState){
		int cs = getIntent().getIntExtra(DA_EX_THEME, 0);
		if (cs >= 1){
			setTheme(R.style.AppTheme_Dark);
		} else {
			setTheme(R.style.AppTheme);
		}
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_aozoraruby);
		obj = (TextView) findViewById(R.id.textView2);
		ruby = (EditText) findViewById(R.id.editText1);
		delimit = (CheckBox) findViewById(R.id.checkBox1);
		ok = (Button) findViewById(R.id.button1);
		readPrefs();
 		if (getIntent().getStringExtra(DA_EX_TEXT) != null){
 			sbj = getIntent().getStringExtra(DA_EX_TEXT);
 		} else {
 			sbj = "";
 		}
 		obj.setText(sbj);
 		ok.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				String retstr;
				retstr = sbj + getString(R.string.tag_open) + 
						ruby.getText().toString() + getString(R.string.tag_close);
				if (delimit.isChecked()) retstr = getString(R.string.delimiter) + retstr;
				Intent ret = new Intent();
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
 			
 		});

	}
	@Override
	protected void onStop(){
		super.onStop();
		writePrefs();
	}

	void readPrefs(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		delimit.setChecked(sp.getBoolean("delimit", false));
	}
	void writePrefs(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		SharedPreferences.Editor pe = sp.edit();
		pe.putBoolean("delimit", delimit.isChecked());
		pe.commit();
	}

}
