package org.pulpdust.da.braces;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.view.View;
import android.view.View.OnClickListener;

public class BracesDaActivity extends FragmentActivity {
	final static String TAG = "BracesDA Main";
	final static String DA_EX_TEXT = "org.pulpdust.da.extra.TEXT";
	final static String DA_EX_THEME = "org.pulpdust.da.extra.THEME";
	final static String DA_EX_RETURN = "org.pulpdust.da.extra.RETURN";
	String sbj;
	Button brackets;
	Button asterisks;
	Button braces;
	Button quotations;
	Button parentheses;
	Button angles;
	Button hyphens;
	Button apostrophes;
	RadioGroup convert;
	RadioButton upper;
	RadioButton lower;
	RadioButton caps;
	RadioButton none;

	@Override
    public void onCreate(Bundle savedInstanceState) {
		int cs = getIntent().getIntExtra(DA_EX_THEME, 0);
		if (cs >= 1){
			setTheme(R.style.AppTheme_Dark);
		} else {
			setTheme(R.style.AppTheme);
		}
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_bracesda);
		brackets = (Button) findViewById(R.id.button1);
		asterisks = (Button) findViewById(R.id.button2);
		braces = (Button) findViewById(R.id.button3);
		quotations = (Button) findViewById(R.id.button4);
		parentheses = (Button) findViewById(R.id.button5);
		angles = (Button) findViewById(R.id.button6);
		hyphens = (Button) findViewById(R.id.button7);
		apostrophes = (Button) findViewById(R.id.button8);
		upper = (RadioButton) findViewById(R.id.radio0);
		lower = (RadioButton) findViewById(R.id.radio1);
		caps = (RadioButton) findViewById(R.id.radio2);
		none = (RadioButton) findViewById(R.id.radio3);
		convert = (RadioGroup) findViewById(R.id.radioGroup1);
		readPrefs();
 		if (getIntent().getStringExtra(DA_EX_TEXT) != null){
 			sbj = getIntent().getStringExtra(DA_EX_TEXT);
 		} else {
 			sbj = "";
 		}
 		
		brackets.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.bracket_left) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.bracket_right);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
		asterisks.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.asterisk) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.asterisk);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
		braces.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.brace_left) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.brace_right);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
		quotations.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.quotation) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.quotation);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
		parentheses.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.parenthesis_left) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.parenthesis_right);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
		angles.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.angle_left) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.angle_right);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
		hyphens.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.hyphen) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.hyphen);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
		apostrophes.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				Intent ret = new Intent();
				String retstr = getString(R.string.apostrophe) + 
						doConvert(sbj, convert.getCheckedRadioButtonId()) + 
						getString(R.string.apostrophe);
				ret.putExtra(DA_EX_RETURN, retstr);
				setResult(RESULT_OK, ret);
				finish();
			}
			
		});
    }
	@Override
	protected void onStop(){
		super.onStop();
		writePrefs();
	}
	
	@SuppressLint("DefaultLocale")
	String doConvert(String obj, int mode){
		String result = "";
		switch (mode){
		case R.id.radio0:
			result = obj.toUpperCase();
			break;
		case R.id.radio1:
			result = obj.toLowerCase();
			break;
		case R.id.radio2:
			if (obj.length() == 0){
				result = "";
			} else if (obj.length() == 1){
				result = obj.toUpperCase();
			} else {
				result = obj.substring(0,1).toUpperCase() + obj.substring(1).toLowerCase();
			}
			break;
		case R.id.radio3:
			result = obj;
			break;
		}
		return result;
	}
	
	void readPrefs(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		convert.check(sp.getInt("checked", R.id.radio3));
	}
	
	void writePrefs(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		SharedPreferences.Editor pe = sp.edit();
		pe.putInt("checked", convert.getCheckedRadioButtonId());
		pe.commit();
	}

}
