package com.tryjava.net;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

import com.tryjava.AppConfig;
import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Apache Commons HttpClient 3.x）
 *
 * プロキシを使ってみる。Basic認証あり。
 *
 * 参考<br>
 * HttpClient - HttpClient Tutorial
 * http://hc.apache.org/httpclient-3.x/tutorial.html<br>
 *
 * @since 2016/5/26
 */
public class ApacheHttpClient02Proxy {
	private static final String PROXY_HOST = AppConfig.getString("proxy.host");
	private static final int PROXY_PORT = AppConfig.getInt("proxy.port");
	private static final String PROXY_USER = AppConfig.getString("proxy.user");
	private static final String PROXY_PASSWORD = AppConfig.getString("proxy.password");

	public void run() {
		doGet();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		// クライアント作成
		HttpClient client = new HttpClient();
		// プロキシ設定
		client.getHostConfiguration().setProxy(PROXY_HOST, PROXY_PORT);
		client.getState().setProxyCredentials( //
				new AuthScope(PROXY_HOST, PROXY_PORT), //
				new UsernamePasswordCredentials(PROXY_USER, PROXY_PASSWORD));

		// リクエスト作成
		HttpMethod method = new GetMethod("http://www.google.co.jp/");

		try {

			// 接続
			int statusCode = client.executeMethod(method);
			System.out.println("statusCode=" + statusCode);
			if (statusCode != HttpStatus.SC_OK) {
				throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
			}

			// レスポンスボディ取得
			byte[] responseBody = method.getResponseBody();
			System.out.println(new String(responseBody, "UTF-8"));

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		} finally {
			method.releaseConnection();
		}
	}
}
